﻿Imports System.Windows.Forms

Public Class SaveLogPopup

    Private graphed_signal_group As Graphed_Signal_Group
    Private graph As System.Windows.Forms.DataVisualization.Charting.Chart
    Private panel As System.Windows.Forms.SplitterPanel

    ' todo - kind of gross way to use this popup for both the GraphData and CapBoardPopul windows
    Public Sub Set_Graph_Objects(ByVal graphed_signal_group As Graphed_Signal_Group, _
                                 ByVal graph As System.Windows.Forms.DataVisualization.Charting.Chart, _
                                 ByVal panel As System.Windows.Forms.SplitterPanel)
        Me.graphed_signal_group = graphed_signal_group
        Me.graph = graph
        Me.panel = panel
    End Sub

    Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        If SaveSomeRB.Checked Then
            Dim x_range As Graphed_Signal_Group.Range = graphed_signal_group.Get_Min_and_Max_Time()
            RangeLow.Text = Math.Ceiling(x_range.min).ToString("0.0")
            RangeHigh.Text = Math.Floor(x_range.max).ToString("0.0")
        End If
    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        If saveFile(SaveLogTextBox.Text) Then
            Me.Close()
        End If
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub SaveLogTextBox_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles SaveLogTextBox.KeyPress
        If e.KeyChar = Convert.ToChar(Keys.Enter) AndAlso OK_Button.Enabled Then
            If saveFile(SaveLogTextBox.Text) Then
                Me.Close()
            End If
        End If
    End Sub

    Private Function saveFile(ByVal fileName As String) As Boolean

        Dim x_range As Graphed_Signal_Group.Range = graphed_signal_group.Get_Min_and_Max_Time()

        ' Check if they are saving a range of data that exists
        If SaveSomeRB.Checked Then
            Dim test_min As Single
            Dim test_max As Single

            Try
                test_min = CSng(RangeLow.Text)
                test_max = CSng(RangeHigh.Text)
            Catch ex As Exception
                D33001.Handle_Exception(ex)
                sendErrMsg("Invalid range values selected.")
                Return False
            End Try

            If (test_min < x_range.min) OrElse (test_max > x_range.max) Then
                sendErrMsg("Selected values out of range.")
                Return False
            End If

            x_range.min = test_min
            x_range.max = test_max

        End If

        ' Verify the specified directory exists
        Dim lastBSlashIndex As Integer = SaveLogTextBox.Text.IndexOf("\")
        If lastBSlashIndex >= 0 Then
            If System.IO.Directory.Exists(SaveLogTextBox.Text.Substring(0, lastBSlashIndex)) = False Then
                sendErrMsg("The file path does not exist.")
                Return False
            End If
        End If

        ' Append .csv or.bmp to filename
        If SaveLogTextBox.Text.Substring(SaveLogTextBox.Text.Length - ".csv".Length, ".csv".Length) <> ".csv" AndAlso _
        SaveLogTextBox.Text.Substring(SaveLogTextBox.Text.Length - ".bmp".Length, ".bmp".Length) <> ".bmp" Then
            If FileTypeBox.SelectedIndex = 0 Then
                SaveLogTextBox.Text += ".csv"
            Else
                SaveLogTextBox.Text += ".bmp"
            End If
        End If

        ' Write the .csv or.bmp
        Try
            If FileTypeBox.SelectedIndex = 0 Then
                graphed_signal_group.Output_CSV(SaveLogTextBox.Text, x_range)
            Else
                saveBitmap()
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            sendErrMsg("Error.")
        End Try

        Return True
    End Function

    Private Sub SaveSomeRB_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveSomeRB.CheckedChanged
        If SaveSomeRB.Checked Then
            RangeLow.Enabled = True
            RangeLow.BackColor = Drawing.Color.White
            RangeHigh.Enabled = True
            RangeHigh.BackColor = Drawing.Color.White

            Dim x_range As Graphed_Signal_Group.Range = graphed_signal_group.Get_Min_and_Max_Time()

            RangeLow.Text = Math.Ceiling(x_range.min).ToString("0.0")
            RangeHigh.Text = Math.Floor(x_range.max).ToString("0.0")
        Else
            RangeLow.Enabled = False
            RangeLow.BackColor = Drawing.Color.Silver
            RangeHigh.Enabled = False
            RangeHigh.BackColor = Drawing.Color.Silver
            RangeLow.Text = ""
            RangeHigh.Text = ""
        End If
    End Sub

    Private Sub SaveLogTextBox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveLogTextBox.TextChanged
        If SaveLogTextBox.Text.Length > 0 Then
            OK_Button.Enabled = True
        Else
            OK_Button.Enabled = False
        End If
    End Sub

    Public Sub sendErrMsg(ByVal errMsg As String)
        ErrorMsgPopup.ErrMsg.Text = errMsg
        ErrorMsgPopup.Width = ErrorMsgPopup.ErrMsg.Width + 22
        ErrorMsgPopup.Height = ErrorMsgPopup.ErrMsg.Height + 100
        ErrorMsgPopup.ShowDialog()
    End Sub

    Private Sub saveBitmap()
        Dim tempBM As New Drawing.Bitmap(graph.Width - 45, graph.Height - 14)
        panel.DrawToBitmap(tempBM, New Drawing.Rectangle(1, 1, graph.Width - 45, graph.Height - 14))
        tempBM.Save(SaveLogTextBox.Text, Drawing.Imaging.ImageFormat.Bmp)
    End Sub

    Private Sub BrowseBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BrowseBtn.Click
        Dim saveFileDialog1 As New SaveFileDialog()

        If FileTypeBox.SelectedIndex = 0 Then
            saveFileDialog1.Filter = "CSV Files (*.csv)|*.csv|Image Files (*.bmp)|*.bmp|All Files (*.*)|*.*"
        Else
            saveFileDialog1.Filter = "Image Files (*.bmp)|*.bmp|CSV Files (*.csv)|*.csv|All Files (*.*)|*.*"
        End If

        If saveFileDialog1.ShowDialog() = DialogResult.OK Then
            SaveLogTextBox.Text = saveFileDialog1.FileName
        Else
            Exit Sub
        End If

        If SaveLogTextBox.Text.Substring(SaveLogTextBox.Text.Length - ".csv".Length, ".csv".Length) = ".csv" Then
            FileTypeBox.SelectedIndex = 0
        ElseIf SaveLogTextBox.Text.Substring(SaveLogTextBox.Text.Length - ".bmp".Length, ".bmp".Length) = ".bmp" Then
            FileTypeBox.SelectedIndex = 1
        End If
    End Sub

    Private Sub FileTypeBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileTypeBox.SelectedIndexChanged
        If SaveLogTextBox.Text.Length > 3 AndAlso SaveLogTextBox.Text.Substring(SaveLogTextBox.Text.Length - 4, 1) = "." Then
            If FileTypeBox.SelectedIndex = 0 Then
                SaveLogTextBox.Text = SaveLogTextBox.Text.Substring(0, SaveLogTextBox.Text.Length - ".csv".Length) + ".csv"
            Else
                SaveLogTextBox.Text = SaveLogTextBox.Text.Substring(0, SaveLogTextBox.Text.Length - ".bmp".Length) + ".bmp"
            End If
        End If

        If FileTypeBox.SelectedIndex = 0 Then
            SaveSomeRB.Enabled = True
        Else
            SaveAllRB.Checked = True
            SaveSomeRB.Enabled = False
        End If


    End Sub

End Class
