﻿Imports System
Imports System.IO
Imports System.IO.Pipes
Imports System.Text
Imports System.Threading

Public Class PipeServer
    Private pipe_server As NamedPipeServerStream
    Private pipe_thread As Thread
    Private pipe_background_worker As System.ComponentModel.BackgroundWorker
    Private pipe_name As String
    Private pipe_connected As Boolean
    Private bobby_test As Integer
    Private Enum STATE
        PIPE_START
        PIPE_LISTEN
        PIPE_CLOSE
    End Enum
    Private pipe_state As STATE
    Private debug_text_box As System.Windows.Forms.TextBox

    Public Sub New(ByVal name_string As String)
        pipe_name = name_string
        pipe_connected = False
        bobby_test = 0
        pipe_state = STATE.PIPE_START
        pipe_thread = New Thread(AddressOf ServerThread)
        pipe_thread.Start()
    End Sub

    Public Sub Close()
        pipe_thread.Abort()
        pipe_server.Close()
    End Sub

    Const BUFFER_SIZE As Integer = 10
    Dim buffer(BUFFER_SIZE) As Byte

    Private Sub ServerThread(ByVal data As Object)

        ' State Machine for managing named pipe
        While True

            If (pipe_state = STATE.PIPE_START) Then
                ' Wait for a client to connect
                'SetText("Starting")
                pipe_server = New NamedPipeServerStream(pipe_name, PipeDirection.InOut, 1, IO.Pipes.PipeTransmissionMode.Message, IO.Pipes.PipeOptions.Asynchronous)
                pipe_server.BeginWaitForConnection(AddressOf PipeHandler, pipe_name)
                While pipe_server.IsConnected = False
                    Thread.Sleep(500)
                End While
                pipe_state = STATE.PIPE_LISTEN
                'SetText("Listening")
            ElseIf (pipe_state = STATE.PIPE_LISTEN) Then
                ' Check for the client to disconnect
                If pipe_server.IsConnected = False Then
                    pipe_state = STATE.PIPE_CLOSE
                    'SetText("Closing")
                Else
                    ' Listen for Messages from the client
                    pipe_server.BeginRead(buffer, 0, BUFFER_SIZE, AddressOf PipeReadHandler, pipe_name)
                End If
                Thread.Sleep(500)
            ElseIf (pipe_state = STATE.PIPE_CLOSE) Then
                ' Wait for a client to connect
                pipe_server.Close()
                pipe_state = STATE.PIPE_START
            End If

        End While

    End Sub

    Private Sub PipeHandler(ByVal ar As System.IAsyncResult)
        bobby_test = 2
        pipe_connected = True
        pipe_server.EndWaitForConnection(ar)
    End Sub

    Private Sub PipeReadHandler(ByVal ar As System.IAsyncResult)
        Dim bytes_read As Integer
        bytes_read = pipe_server.EndRead(ar)
        If bytes_read <> 0 Then
            bobby_test = 20
        End If
    End Sub

    ' This method demonstrates a pattern for making thread-safe
    ' calls on a Windows Forms control. 
    '
    ' If the calling thread is different from the thread that
    ' created the TextBox control, this method creates a
    ' SetTextCallback and calls itself asynchronously using the
    ' Invoke method.
    '
    ' If the calling thread is the same as the thread that created
    ' the TextBox control, the Text property is set directly. 

    Delegate Sub SetTextCallback(ByVal [text] As String)

    Private Sub SetText(ByVal [text] As String)

        ' InvokeRequired required compares the thread ID of the
        ' calling thread to the thread ID of the creating thread.
        ' If these threads are different, it returns true.
        If debug_text_box.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf SetText)
            debug_text_box.Invoke(d, New Object() {[text]})
        Else
            debug_text_box.Text = [text]
        End If
    End Sub

End Class

' Defines the data protocol for reading and writing strings on our stream 
Public Class StreamString
    Private ioStream As Stream
    Private streamEncoding As UnicodeEncoding

    Public Sub New(ByVal ioStream As Stream)
        Me.ioStream = ioStream
        streamEncoding = New UnicodeEncoding(False, False)
    End Sub

    Public Function ReadString() As String
        Dim len As Integer = 0
        len = CType(ioStream.ReadByte(), Integer) * 256
        len += CType(ioStream.ReadByte(), Integer)
        Dim inBuffer As Array = Array.CreateInstance(GetType(Byte), len)
        ioStream.Read(inBuffer, 0, len)

        Return streamEncoding.GetString(inBuffer)
    End Function

    Public Function WriteString(ByVal outString As String) As Integer
        Dim outBuffer() As Byte = streamEncoding.GetBytes(outString)
        Dim len As Integer = outBuffer.Length
        If len > UInt16.MaxValue Then
            len = CType(UInt16.MaxValue, Integer)
        End If
        ioStream.WriteByte(CType(len \ 256, Byte))
        ioStream.WriteByte(CType(len And 255, Byte))
        ioStream.Write(outBuffer, 0, outBuffer.Length)
        ioStream.Flush()

        Return outBuffer.Length + 2
    End Function
End Class

' Contains the method executed in the context of the impersonated user 
Public Class ReadFileToStream
    Private fn As String
    Private ss As StreamString

    Public Sub New(ByVal str As StreamString, ByVal filename As String)
        fn = filename
        ss = str
    End Sub

    Public Sub Start()
        Dim contents As String = File.ReadAllText(fn)
        ss.WriteString(contents)
    End Sub
End Class
