﻿Imports Microsoft.VisualBasic

Public Class Mfg_File

    Private filename As String
    Private location As Byte
    Private product As String
    Private max_count As UInteger               ' Highest board count currently used.
    Private current_count As UInteger           ' Board currently being mfg tested.
    Private Const INVALID_LOCATION As Byte = &HFF

    Public Sub New(ByVal filename As String)
        Dim reader As System.IO.StreamReader
        Dim textline As String

        reader = New System.IO.StreamReader(filename)
        textline = reader.ReadLine()
        reader.Close()

        ' Determine if file contains path to actual manufacturing data, or if it is the actual manufacturing data itself.
        If (textline.IndexOf(D33001.MFG_FILE_NAME) >= 0) Then
            Me.filename = textline
        Else
            Me.filename = filename
        End If
        reader = New System.IO.StreamReader(Me.filename)

        ' Search for product and save
        ' todo - dump out if not found
        Dim product_string As String = "Product:"
        Me.product = ""
        While (Not reader.EndOfStream) And (Me.product = "")
            textline = reader.ReadLine()
            If (textline.IndexOf(product_string) >= 0) Then
                textline = textline.Remove(textline.IndexOf(product_string), product_string.Length)
                Me.product = Microsoft.VisualBasic.LTrim(textline)
            End If
        End While

        ' Search for location and save
        ' todo - dump out if not found
        Dim location_string As String = "Location:"
        Me.location = INVALID_LOCATION
        While (Not reader.EndOfStream) And (Me.location = INVALID_LOCATION)
            textline = reader.ReadLine()
            If (textline.IndexOf(location_string) >= 0) Then
                textline = textline.Remove(textline.IndexOf(location_string), location_string.Length)
                textline = Microsoft.VisualBasic.LTrim(textline)
                textline = textline.Substring(0, textline.IndexOf(" "))
                Me.location = Byte.Parse(textline)
            End If
        End While
        reader.Close()

        ' Find the last serial number in the file
        Me.max_count = 0
        Me.Update_Max_Count()

    End Sub

    Public Function Is_Valid(ByVal product As String) As Boolean
        If Me.location = INVALID_LOCATION Then
            Return False
        ElseIf Me.product <> product Then
            Return False
        Else
            Return True
        End If
    End Function

    Public Sub Close()

        Dim writer As System.IO.StreamWriter
        Try
            writer = System.IO.File.AppendText(Me.filename)
            writer.Flush()
            writer.Close()
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    Public Function Start_New_Board(ByVal model As String, ByVal cap_demo As String) As String
        Dim writer As System.IO.StreamWriter
        Dim textline As String

        ' Increment serial number count
        Me.Update_Max_Count()
        Me.max_count = Me.max_count + 1UI
        Me.current_count = Me.max_count

        ' Write data to file
        Dim mfg_file_data As Mfg_File_Data
        Try
            mfg_file_data = New Mfg_File_Data(Me.max_count, Me.location)
            textline = mfg_file_data.Get_MfgData_String(model, cap_demo)
            writer = System.IO.File.AppendText(Me.filename)
            writer.Write(textline)
            writer.Flush()
            writer.Close()
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

        Return mfg_file_data.serial_number
    End Function

    Public Sub Restart_Old_Board(ByVal old_serial As String, ByVal model As String, ByVal cap_demo As String)
        Dim writer As System.IO.StreamWriter
        Dim reader As System.IO.StreamReader
        Dim mfg_file_data As Mfg_File_Data
        Dim textline As String = ""

        ' If valid serial number and manufactured in this location, search file for board's mfg data
        Dim serial_num As New Serial_Number(old_serial)
        Dim this_count As UInteger = 0
        Dim textline_for_count As String = ""
        If (serial_num.valid = False) Then
            ' If this isn't a valid serial number, no hope of finding what its mfg data originally was.  Just copy string to mfg data file.
            mfg_file_data = New Mfg_File_Data(0, old_serial)
        ElseIf (serial_num.location <> Me.location) Then
            ' If serial number valid but not manufactured in this location, no hope of finding what its mfg data originally was other than the serial number itself
            mfg_file_data = New Mfg_File_Data(serial_num.count, old_serial)
        Else
            ' Attempt to find the serial number in this file
            Dim end_of_count_index As Integer
            ' Close file for writing so that it can be read again
            reader = New System.IO.StreamReader(Me.filename)
            While (Not reader.EndOfStream)
                textline = reader.ReadLine()
                If (textline.Length > 0) AndAlso (textline(0) = mfg_file_data.start_of_record_delimiter) Then
                    end_of_count_index = textline.IndexOf(mfg_file_data.record_field_delimiter)
                    If (end_of_count_index > 0) Then
                        Try
                            ' If the count for this record is the count we are looking for, save this line.  Don't stop looking, however, as we want the last line.
                            this_count = UInteger.Parse(textline.Substring(1, end_of_count_index - 1))
                            If (this_count = serial_num.count) Then
                                textline_for_count = textline
                            End If
                        Catch ex As Exception
                            D33001.Handle_Exception(ex)

                        End Try
                    End If
                End If
            End While
            ' Close reader so that we can start appending to the file again.
            reader.Close()

            ' If board was found in this file, extract its manufacturing info from the line of text
            If (textline_for_count <> "") Then
                mfg_file_data = New Mfg_File_Data(textline_for_count, model, cap_demo)
            Else
                ' board wasn't found in this file, but we still know info about it from the valid serial number presented
                mfg_file_data = New Mfg_File_Data(serial_num.count, old_serial)
            End If
        End If

        ' Write the best manufacturing data we can offer to the file
        textline = mfg_file_data.Get_MfgData_String(model, cap_demo)
        writer = System.IO.File.AppendText(Me.filename)
        writer.Write(textline)
        writer.Flush()
        writer.Close()
    End Sub

    Public Sub Add_Cal_Data(ByVal charge_currents() As Single, ByVal discharge_currents() As Single)
        Dim writer As System.IO.StreamWriter
        Dim mfg_file_data As New Mfg_File_Data
        Dim textline As String

        Try
            writer = System.IO.File.AppendText(Me.filename)
            textline = mfg_file_data.Get_CalData_String(charge_currents, discharge_currents)
            writer.Write(textline)
            writer.Flush()
            writer.Close()
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    ' Start next line if calibration aborted for last board
    Public Sub New_Line()
        Dim writer As System.IO.StreamWriter

        Try
            writer = System.IO.File.AppendText(Me.filename)
            writer.WriteLine("")
            writer.Flush()
            writer.Close()
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub


    ' Linear already ran into the problem where two boards were being mfg tested at the same time.  Therefore, we need to get the max count as numbers are written, not upon startup.
    Private Sub Update_Max_Count()
        Dim textline As String
        Dim end_of_count_index As Integer
        Dim reader As System.IO.StreamReader

        Try
            reader = New System.IO.StreamReader(Me.filename)

            While (Not reader.EndOfStream)
                textline = reader.ReadLine()
                If (textline.Length > 0) AndAlso (textline(0) = Mfg_File_Data.start_of_record_delimiter) Then
                    end_of_count_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
                    If (end_of_count_index > 0) Then
                        Try
                            Dim this_count As UInteger = UInteger.Parse(textline.Substring(1, end_of_count_index - 1))
                            If this_count > Me.max_count Then
                                Me.max_count = this_count
                            End If
                        Catch ex As Exception
                            D33001.Handle_Exception(ex)
                        End Try
                    End If
                End If
            End While
            reader.Close()
        Catch ex As Exception
            D33001.Handle_Exception(ex)

        End Try

    End Sub

End Class

Public Class Mfg_File_Data
    Public Const start_of_record_delimiter As String = "#"
    Public Const record_field_delimiter As String = ","
    Public Const comment_delimiter As String = ";"

    Private count As UInteger
    Private test_date As String
    Private test_time As String
    Private model_number As String
    Public serial_number As String
    Private cap_demo As String
    Private last_cal_date As String
    Private last_cal_time As String
    Private charge_currents(D33001.MAX_CELLS - 1) As Single
    Private discharge_currents(D33001.MAX_CELLS - 1) As Single

    ' Generates empty object for appending the Get_CalData_String() data to an existing line
    Public Sub New()
    End Sub

    ' Generates mfg data for a new board
    Public Sub New(ByVal count As UInteger, ByVal location As Byte)
        Me.count = count
        Me.test_date = String.Format("{0:MM/dd/yyyy}", DateTime.Now)
        Me.test_time = String.Format("{0:HH:mm}", DateTime.Now)
        Dim serial_number As New Serial_Number(count, location)
        Me.serial_number = serial_number.Get_String()
    End Sub

    ' Extracts the mfg data from an existing line of formatted text
    Public Sub New(ByVal textline As String, ByVal model As String, ByVal cap_demo As String)
        Dim delimiter_index As Integer

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.count = UInteger.Parse(textline.Substring(1, delimiter_index - 1))
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.count = 0    ' Should never even attempt this constructor if count isn't parsable
        End Try

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.test_date = textline.Substring(1, delimiter_index - 1)
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.test_date = "Unknown"
        End Try

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.test_time = textline.Substring(1, delimiter_index - 1)
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.test_time = "Unknown"
        End Try

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.serial_number = textline.Substring(1, delimiter_index - 1)
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.serial_number = "Unknown"
        End Try

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.model_number = textline.Substring(1, delimiter_index - 1)
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.model_number = "Unknown"
        End Try

        Try
            delimiter_index = textline.IndexOf(Mfg_File_Data.record_field_delimiter)
            Me.cap_demo = textline.Substring(1, delimiter_index - 1)
            textline = textline.Remove(1, delimiter_index)
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Me.cap_demo = "Unknown"
        End Try

        ' If the model or cap_demo values were changed, then store a new date
        ' todo - is this needed?
        If (model <> Me.model_number) Or (cap_demo <> Me.cap_demo) Then
            Me.test_date = String.Format("{0:MM/dd/yyyy}", DateTime.Now)
            Me.test_time = String.Format("{0:HH:mm}", DateTime.Now)
        End If

    End Sub

    ' Generates mfg data for an old board that couldn't be found in the manufacturing file
    Public Sub New(ByVal count As UInteger, ByVal serial_num As String)
        Me.count = count
        Me.test_date = "Unknown"
        Me.test_time = "Unknown"
        Me.serial_number = serial_num
    End Sub

    Public Function Get_MfgData_String(ByVal model As String, ByVal cap_demo As String) As String
        Dim mfg_data_string As String

        mfg_data_string = start_of_record_delimiter + Me.count.ToString()
        mfg_data_string += record_field_delimiter + Me.test_date
        mfg_data_string += record_field_delimiter + Me.test_time
        mfg_data_string += record_field_delimiter + Me.serial_number

        Me.model_number = model
        Me.cap_demo = cap_demo
        mfg_data_string += record_field_delimiter + Me.model_number
        mfg_data_string += record_field_delimiter + Me.cap_demo
        mfg_data_string += record_field_delimiter

        Return mfg_data_string
    End Function

    Public Function Get_CalData_String(ByVal charge_currents() As Single, ByVal discharge_currents() As Single) As String
        Dim mfg_data_string As String

        Me.last_cal_date = String.Format("{0:MM/dd/yyyy}", DateTime.Now)
        Me.last_cal_time = String.Format("{0:HH:mm}", DateTime.Now)
        mfg_data_string = Me.last_cal_date
        mfg_data_string += record_field_delimiter + Me.last_cal_time

        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
            Me.charge_currents(cell_num) = charge_currents(cell_num)
            mfg_data_string += record_field_delimiter + Me.charge_currents(cell_num).ToString("0.000")
        Next cell_num

        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
            Me.discharge_currents(cell_num) = discharge_currents(cell_num)
            mfg_data_string += record_field_delimiter + Me.discharge_currents(cell_num).ToString("0.000")
        Next cell_num

        Return mfg_data_string

    End Function

End Class

Public Class Serial_Number
    Public company As String
    Public location As Byte
    Public month As Integer
    Public day As Integer
    Public year As Integer
    Public count As UInteger
    Public valid As Boolean

    Public Sub New(ByVal count As UInteger, ByVal location As Byte)
        Dim current_date As Date

        Me.company = "LT"
        Me.location = location
        current_date = Microsoft.VisualBasic.Now
        Me.month = Microsoft.VisualBasic.Month(current_date)
        Me.day = Microsoft.VisualBasic.Day(current_date)
        Me.year = Microsoft.VisualBasic.Year(current_date)
        Me.count = count

        Me.valid = True
    End Sub

    Public Sub New(ByVal sernum_string As String)

        ' Assume string is valid serial number, set to false if any fields are proven false
        Me.valid = True

        ' Try converting serial number into its components, and set valid to False is any copmonent is wrong.
        Try
            If sernum_string.Substring(0, 2) <> "LT" Then
                Me.valid = False
            End If

            Me.location = Byte.Parse(sernum_string.Substring(2, 2))

            Me.month = Integer.Parse(sernum_string.Substring(4, 2))
            If Me.month = 0 Or Me.month > 12 Then
                Me.valid = False
            End If

            ' todo - this obviously isn't perfect.  Each month obviously has a different amounts of days, and Feb obviously needs to account for leap years.
            Me.day = Integer.Parse(sernum_string.Substring(6, 2))
            If Me.day = 0 Or Me.day > 31 Then
                Me.valid = False
            End If

            Me.year = Integer.Parse(sernum_string.Substring(8, 4))
            If Me.year < 2014 Or Me.year > 2020 Then
                Me.valid = False
            End If

            Me.count = UInteger.Parse(sernum_string.Substring(12, 5))
        Catch ex As Exception
            Me.valid = False
        End Try

    End Sub

    Public Function Get_String() As String
        Dim sernum_string As String

        If Me.valid = True Then
            sernum_string = Me.company
            sernum_string += Me.location.ToString("D2")
            sernum_string += Me.month.ToString("D2")
            sernum_string += Me.day.ToString("D2")
            sernum_string += Me.year.ToString("D4")
            sernum_string += Me.count.ToString("D5")
        Else
            sernum_string = "N/A"
        End If

        Return sernum_string

    End Function

End Class
