﻿Imports System.Windows.Forms

Public Class GraphOptionPopup

    Public SCOPE_RANGE_DEFAULT As Integer = 30
    Public SCOPE_RANGE_FORMAT As String = "0"

    Public scopeRange As Integer = SCOPE_RANGE_DEFAULT
    Public scopeMode As Boolean = True
    Public snappedToFront As Boolean = True
    Public ShowZeroOnY As Boolean = True
    Public showBalLines As Boolean = True
    Public showLegend As Boolean = True

    Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Scope_Mode_CheckBox.Checked = scopeMode
        Show_Zero_On_Y_Axis_CheckBox.Checked = ShowZeroOnY
        Show_Balance_Lines_CheckBox.Checked = showBalLines
        Show_Legend_CheckBox.Checked = showLegend
        Visible_Range_TextBox.Text = scopeRange.ToString()
    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        scopeMode = Scope_Mode_CheckBox.Checked
        ShowZeroOnY = Show_Zero_On_Y_Axis_CheckBox.Checked
        showBalLines = Show_Balance_Lines_CheckBox.Checked
        showLegend = Show_Legend_CheckBox.Checked
        Visible_Range_TextBox_Leave(sender, e)
        If (Scope_Mode_CheckBox.Checked = True) Then
            scopeRange = CInt(Visible_Range_TextBox.Text)
        End If
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Scope_Mode_CheckBox.Checked = scopeMode
        Show_Zero_On_Y_Axis_CheckBox.Checked = ShowZeroOnY
        Show_Balance_Lines_CheckBox.Checked = showBalLines
        Show_Legend_CheckBox.Checked = showLegend
        Visible_Range_TextBox.Text = scopeRange.ToString(SCOPE_RANGE_FORMAT)
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub FixedBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Scope_Mode_CheckBox.CheckedChanged
        If Scope_Mode_CheckBox.Checked Then
            Visible_Range_Label.ForeColor = Drawing.Color.Black
            Visible_Range_TextBox.Enabled = True
            Visible_Range_TextBox.BackColor = Drawing.Color.White
            Visible_Range_TextBox.Text = CStr(scopeRange)
            snappedToFront = True
        Else
            Visible_Range_Label.ForeColor = Drawing.Color.DarkGray
            Visible_Range_TextBox.Enabled = False
            Visible_Range_TextBox.BackColor = Drawing.Color.Silver
            Visible_Range_TextBox.Text = ""
            snappedToFront = False
        End If
    End Sub

    Private Sub Visible_Range_TextBox_Leave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Visible_Range_TextBox.Leave
        Try
            If (Scope_Mode_CheckBox.Checked = True) AndAlso (CInt(Visible_Range_TextBox.Text) < 1) Then
                Visible_Range_TextBox.Text = "1"
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            Visible_Range_TextBox.Text = scopeRange.ToString(SCOPE_RANGE_FORMAT)
        End Try
    End Sub


End Class
