﻿Imports Microsoft.VisualBasic

Public Class GraphData

    Private Const MAX_SIGNALS As Integer = 15

    Private GraphData_Signal_Group As Graphed_Signal_Group

    Private Cell_Voltage_CheckBoxes(D33001.MAX_CELLS - 1) As CheckBox
    Private Temperature_CheckBoxes(D33001.NUM_TEMPS - 1) As CheckBox
    Private Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1) As CheckBox
    Private Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1) As CheckBox

    Public Opened As Boolean = False
    Public Loaded_From_File As Boolean = False

    Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Me.Init()
        Me.Opened = True
        Me.Loaded_From_File = False


        ' Enable graphing upon opening window
        Enable_CheckBox.Checked = True
    End Sub

    Private Sub frmMain_Closed(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Closed
        Me.Opened = False

        ' Disable graphing upon closing window
        Enable_CheckBox.Checked = False

    End Sub

    Public Sub Init()
        ' Connect the graph to the signals that are plotted on it
        GraphData_Signal_Group = New Graphed_Signal_Group(MAX_SIGNALS, Graph, HScrollBar, Debug_TextBox)

        ' Init the Scrollbar
        HScrollBar.Minimum = 0
        HScrollBar.Maximum = 0
        HScrollBar.Value = 0

        ' Create arrays for checkboxes that are changed with a Select All Checkbox
        Cell_Voltage_CheckBoxes(0) = Cell1_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(1) = Cell2_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(2) = Cell3_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(3) = Cell4_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(4) = Cell5_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(5) = Cell6_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(6) = Cell7_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(7) = Cell8_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(8) = Cell9_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(9) = Cell10_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(10) = Cell11_Voltage_CheckBox
        Cell_Voltage_CheckBoxes(11) = Cell12_Voltage_CheckBox

        Temperature_CheckBoxes(0) = Temp1_CheckBox
        Temperature_CheckBoxes(1) = Temp2_CheckBox
        Temperature_CheckBoxes(2) = Temp3_CheckBox
        Temperature_CheckBoxes(3) = Temp4_CheckBox
        Temperature_CheckBoxes(4) = Temp5_CheckBox
        Temperature_CheckBoxes(5) = Temp6_CheckBox
        Temperature_CheckBoxes(6) = Temp7_CheckBox
        Temperature_CheckBoxes(7) = Temp8_CheckBox
        Temperature_CheckBoxes(8) = Temp9_CheckBox
        Temperature_CheckBoxes(9) = Temp10_CheckBox
        Temperature_CheckBoxes(10) = Temp11_CheckBox
        Temperature_CheckBoxes(11) = Temp12_CheckBox

        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Sum) = Board_Summary_Sum_Cells_CheckBox
        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Ave) = Board_Summary_Average_CheckBox
        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Max_Cell) = Board_Summary_Max_Cell_Voltage_CheckBox
        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Min_Cell) = Board_Summary_Min_Cell_Voltage_CheckBox
        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Max_Temp) = Board_Summary_Max_Temperature_CheckBox
        Board_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Min_Temp) = Board_Summary_Min_Temperature_CheckBox

        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Sum) = Stack_Summary_Sum_Cells_CheckBox
        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Ave) = Stack_Summary_Average_CheckBox
        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Max_Cell) = Stack_Summary_Max_Cell_Voltage_CheckBox
        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Min_Cell) = Stack_Summary_Min_Cell_Voltage_CheckBox
        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Max_Temp) = Stack_Summary_Max_Temperature_CheckBox
        Stack_Summary_CheckBoxes(Graphed_Signal.Summary_Signal_SubType.Min_Temp) = Stack_Summary_Min_Temperature_CheckBox

        ' Show debug fields 
        Debug_TextBox.Visible = D33001.DEBUG

        ' Enable graphing upon opening window
        Enable_CheckBox.Checked = False

    End Sub

    Public Sub Reset()
        GraphData_Signal_Group.Reset()
        Update_GUI_CheckBoxes()

        ' Reset the Scrollbar
        HScrollBar.Minimum = 0
        HScrollBar.Maximum = 0
        HScrollBar.Value = 0
    End Sub

    Public Sub Update_GUI_Plot(ByVal controls_only As Boolean)

        ' Do nothing if GUI not opened
        If (Me.Opened = False) Then
            Exit Sub
        End If

        ' Update datapoints if still taking data
        If (Enable_CheckBox.Checked = True) Then
            GraphData_Signal_Group.Update_Data_Points()
        End If

        ' Update the graphs
        GraphData_Signal_Group.Update_GUI(controls_only)

        ' Set Legend
        If GraphOptionPopup.showLegend = True Then
            Graph.Legends(0).Enabled = True
        Else
            Graph.Legends(0).Enabled = False
        End If

        ' Invalidate chart
        ' todo - the Microsoft example code does this.  What's it for?
        Graph.Invalidate()

    End Sub

    ' This is used when the selected board is changed, or when a graph is loaded.
    Public Sub Update_GUI_CheckBoxes()

        ' Do nothing if GUI not opened
        If (Me.Opened = False) Then
            Exit Sub
        End If

        ' First turn off handlers, so that the box changing doesn't look like someone changed the checkbox to add/remove a signal
        ' next clear all checkboxes, so only the ones that need to be enabled will be done so after the signal list is searched
        For summary_num As Integer = 0 To Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1
            RemoveHandler Stack_Summary_CheckBoxes(summary_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
            Stack_Summary_CheckBoxes(summary_num).Checked = False
        Next summary_num

        For summary_num As Integer = 0 To Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1
            RemoveHandler Board_Summary_CheckBoxes(summary_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
            Board_Summary_CheckBoxes(summary_num).Checked = False
        Next summary_num

        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
            RemoveHandler Cell_Voltage_CheckBoxes(cell_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
            Cell_Voltage_CheckBoxes(cell_num).Checked = False
        Next cell_num

        For temp_num As Integer = 0 To D33001.NUM_TEMPS - 1
            RemoveHandler Temperature_CheckBoxes(temp_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
            Temperature_CheckBoxes(temp_num).Checked = False
        Next temp_num

        ' Look through all of the assigned signals, to see which checkboxes should be checked for this board
        Dim type As Graphed_Signal.Signal_Type
        Dim board_num As Integer
        Dim other_num As Integer

        For signal_num As Integer = 0 To MAX_SIGNALS - 1
            If GraphData_Signal_Group.Get_Signal_Type_From_Name(signal_num, type, board_num, other_num) = True Then
                ' If this signal is for stack, it doesn't matter which board is selected.
                If type = Graphed_Signal.Signal_Type.Stack_Summary Then
                    Stack_Summary_CheckBoxes(other_num).Checked = True
                Else
                    ' If this signal is assigned, check to see if it's a checkbox specific to this board.
                    If board_num = D33001.selectedBoard Then
                        ' Signal is for this board.  Turn on the appropriate checkbox
                        If type = Graphed_Signal.Signal_Type.Board_Summary Then
                            Board_Summary_CheckBoxes(other_num).Checked = True
                        ElseIf type = Graphed_Signal.Signal_Type.Cell_Voltage Then
                            Cell_Voltage_CheckBoxes(other_num).Checked = True
                        ElseIf type = Graphed_Signal.Signal_Type.Temperature Then
                            Temperature_CheckBoxes(other_num).Checked = True
                        End If
                    End If
                End If
            End If
        Next signal_num

        ' Update the "All" checkboxes
        Dim num_checkboxes_checked As Integer

        ' Count how many cell voltage checkboxes are checked
        num_checkboxes_checked = 0
        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
            If Cell_Voltage_CheckBoxes(cell_num).Checked = True Then
                num_checkboxes_checked += 1
            End If
        Next cell_num

        ' If all of the cell voltages are checked, then check the check all box, otherwise unchecked.
        ' Disable handler first, so that it doesn't actually add or remove a signal.
        RemoveHandler Cell_Voltages_All_CheckBox.CheckedChanged, AddressOf Cell_Voltages_All_CheckBox_CheckedChanged
        If num_checkboxes_checked = D33001.MAX_CELLS Then
            Cell_Voltages_All_CheckBox.Checked = True
        Else
            Cell_Voltages_All_CheckBox.Checked = False
        End If
        AddHandler Cell_Voltages_All_CheckBox.CheckedChanged, AddressOf Cell_Voltages_All_CheckBox_CheckedChanged

        ' Count how many temperature checkboxes are checked
        num_checkboxes_checked = 0
        For cell_num As Integer = 0 To D33001.NUM_TEMPS - 1
            If Temperature_CheckBoxes(cell_num).Checked = True Then
                num_checkboxes_checked += 1
            End If
        Next cell_num

        ' If all of the cell voltages are checked, then check the check all box, otherwise unchecked.
        ' Disable handler first, so that it doesn't actually add or remove a signal.
        RemoveHandler Temperatures_All_CheckBox.CheckedChanged, AddressOf Temperatures_All_CheckBox_CheckedChanged
        If num_checkboxes_checked = D33001.NUM_TEMPS Then
            Temperatures_All_CheckBox.Checked = True
        Else
            Temperatures_All_CheckBox.Checked = False
        End If
        AddHandler Temperatures_All_CheckBox.CheckedChanged, AddressOf Temperatures_All_CheckBox_CheckedChanged

        ' Now turn on handlers, so that new box changes will again add/remove a signal
        For temp_num As Integer = 0 To D33001.NUM_TEMPS - 1
            AddHandler Temperature_CheckBoxes(temp_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
        Next temp_num

        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
            AddHandler Cell_Voltage_CheckBoxes(cell_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
        Next cell_num

        For summary_num As Integer = 0 To Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1
            AddHandler Board_Summary_CheckBoxes(summary_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
        Next summary_num

        For summary_num As Integer = 0 To Graphed_Signal.Summary_Signal_SubType.Num_SubTypes - 1
            AddHandler Stack_Summary_CheckBoxes(summary_num).CheckedChanged, AddressOf CheckBox_CheckedChanged
        Next summary_num

    End Sub

    Private Sub Enable_CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Enable_CheckBox.CheckedChanged
        If Enable_CheckBox.Checked = True Then
            ' if re-enabling logging after loading a file, reset the data as it won't make sense with the timestamps for new data (but keep the signals that are being graphed)
            If (Me.Loaded_From_File = True) Then
                Loaded_From_File = False    ' Flag that this is no longer the loaded data.
                GraphData_Signal_Group.Reset(True)
            End If
        End If
    End Sub

    Private Sub Options_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Options_Button.Click
        If GraphOptionPopup.ShowDialog() = DialogResult.OK Then
            Update_GUI_Plot(True)
        End If
    End Sub

    Private Sub Clear_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Clear_Button.Click
        Me.Reset()
    End Sub

    Private Sub Save_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Save_Button.Click
        SaveLogPopup.Set_Graph_Objects(GraphData_Signal_Group, Graph, SplitContainer1.Panel1)
        SaveLogPopup.ShowDialog()
    End Sub

    Private Sub Load_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Load_Button.Click
        Dim open_file_dialog As New OpenFileDialog()
        Dim open_file_name As String

        Try
            open_file_dialog.Filter = "CSV Files (*.csv)|*.csv|All Files (*.*)|*.*"
            open_file_dialog.Title = "Choose File Location"
            If open_file_dialog.ShowDialog() = DialogResult.OK Then
                If open_file_dialog.FileName.Substring(open_file_dialog.FileName.Length - ".csv".Length, ".csv".Length) = ".csv" Then
                    open_file_name = open_file_dialog.FileName
                Else
                    open_file_name = open_file_dialog.FileName + ".csv"
                End If
            Else
                Exit Sub
            End If

            ' Mark data as having been loaded from a file
            Loaded_From_File = True

            ' Do not keep updating graph, as it'll make no sense with the old and new data together
            Enable_CheckBox.Checked = False

            ' Load the data from the input file
            GraphData_Signal_Group.Input_CSV(open_file_name)

            ' Display the loaded signals and data
            Update_GUI_CheckBoxes()

        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    Public Sub CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _
        Stack_Summary_Sum_Cells_CheckBox.CheckedChanged, _
        Stack_Summary_Average_CheckBox.CheckedChanged, _
        Stack_Summary_Max_Cell_Voltage_CheckBox.CheckedChanged, _
        Stack_Summary_Min_Cell_Voltage_CheckBox.CheckedChanged, _
        Stack_Summary_Max_Temperature_CheckBox.CheckedChanged, _
        Stack_Summary_Min_Temperature_CheckBox.CheckedChanged, _
        Board_Summary_Sum_Cells_CheckBox.CheckedChanged, _
        Board_Summary_Average_CheckBox.CheckedChanged, _
        Board_Summary_Max_Cell_Voltage_CheckBox.CheckedChanged, _
        Board_Summary_Min_Cell_Voltage_CheckBox.CheckedChanged, _
        Board_Summary_Max_Temperature_CheckBox.CheckedChanged, _
        Board_Summary_Min_Temperature_CheckBox.CheckedChanged, _
        Cell1_Voltage_CheckBox.CheckedChanged, _
        Cell2_Voltage_CheckBox.CheckedChanged, _
        Cell3_Voltage_CheckBox.CheckedChanged, _
        Cell4_Voltage_CheckBox.CheckedChanged, _
        Cell5_Voltage_CheckBox.CheckedChanged, _
        Cell6_Voltage_CheckBox.CheckedChanged, _
        Cell7_Voltage_CheckBox.CheckedChanged, _
        Cell8_Voltage_CheckBox.CheckedChanged, _
        Cell9_Voltage_CheckBox.CheckedChanged, _
        Cell10_Voltage_CheckBox.CheckedChanged, _
        Cell11_Voltage_CheckBox.CheckedChanged, _
        Cell12_Voltage_CheckBox.CheckedChanged, _
        Temp1_CheckBox.CheckedChanged, _
        Temp2_CheckBox.CheckedChanged, _
        Temp3_CheckBox.CheckedChanged, _
        Temp4_CheckBox.CheckedChanged, _
        Temp5_CheckBox.CheckedChanged, _
        Temp6_CheckBox.CheckedChanged, _
        Temp7_CheckBox.CheckedChanged, _
        Temp8_CheckBox.CheckedChanged, _
        Temp9_CheckBox.CheckedChanged, _
        Temp10_CheckBox.CheckedChanged, _
        Temp11_CheckBox.CheckedChanged, _
        Temp12_CheckBox.CheckedChanged

        Dim this_checkbox As CheckBox = DirectCast(sender, CheckBox)
        Dim type As Graphed_Signal.Signal_Type
        Dim board_num As Integer
        Dim other_num As Integer

        Try
            If GraphData_Signal_Group.Get_Signal_Type_From_Name(this_checkbox.Name, type, board_num, other_num) = True Then
                ' If checking a box, look to add the signal to the graphed signal group
                If this_checkbox.Checked = True Then

                    ' If we have already assigned too many signals, then notify user
                    If GraphData_Signal_Group.Get_Num_Unassigned() = 0 Then
                        MsgBox("Only " + MAX_SIGNALS.ToString() + " signals can be graphed at one time.")
                    Else
                        ' Attempt to add the signal
                        If GraphData_Signal_Group.Add_Signal(type, D33001.selectedBoard, other_num) = False Then
                            ' todo if this fails, we have a code bug in Get_Num_Unassigned()
                        End If
                    End If

                ElseIf this_checkbox.Checked = False Then
                    ' If unchecking a box, look to remove the signal to the graphed signal group

                    If GraphData_Signal_Group.Remove_Signal(type, D33001.selectedBoard, other_num) = False Then
                        ' todo if this fails, we have a code bug on this form()
                    End If
                End If
            Else
                ' todo if this fails, we named a control wrong
            End If

        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    Private Sub Cell_Voltages_All_CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cell_Voltages_All_CheckBox.CheckedChanged

        Try

            ' Count how many checkboxes are already checked
            Dim num_checkboxes_checked As Integer = 0
            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                If Cell_Voltage_CheckBoxes(cell_num).Checked = True Then
                    num_checkboxes_checked += 1
                End If
            Next cell_num

            ' If we have already assigned too many signals, then notify user
            If (Cell_Voltages_All_CheckBox.Checked = True) And
                (GraphData_Signal_Group.Get_Num_Unassigned() < (D33001.MAX_CELLS - num_checkboxes_checked)) Then
                MsgBox("Only " + MAX_SIGNALS.ToString() + " signals can be graphed at one time.")

                ' Uncheck the Voltages All CheckBox, but first disable hanlder so that individual Voltages that were previously checked will not become unchecked
                RemoveHandler Cell_Voltages_All_CheckBox.CheckedChanged, AddressOf Cell_Voltages_All_CheckBox_CheckedChanged
                Cell_Voltages_All_CheckBox.Checked = False
                AddHandler Cell_Voltages_All_CheckBox.CheckedChanged, AddressOf Cell_Voltages_All_CheckBox_CheckedChanged

            Else
                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    Cell_Voltage_CheckBoxes(cell_num).Checked = Cell_Voltages_All_CheckBox.Checked
                Next cell_num
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    Private Sub Temperatures_All_CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Temperatures_All_CheckBox.CheckedChanged

        Try

            ' Count how many checkboxes are already checked
            Dim num_checkboxes_checked As Integer = 0
            For temp_num As Integer = 0 To D33001.NUM_TEMPS - 1
                If Temperature_CheckBoxes(temp_num).Checked = True Then
                    num_checkboxes_checked += 1
                End If
            Next temp_num

            ' If we have already assigned too many signals, then notify user
            If (Temperatures_All_CheckBox.Checked = True) And
                (GraphData_Signal_Group.Get_Num_Unassigned() < (D33001.NUM_TEMPS - num_checkboxes_checked)) Then
                MsgBox("Only " + MAX_SIGNALS.ToString() + " signals can be graphed at one time.")

                ' Uncheck the Temperatures All CheckBox, but first disable hanlder so that individual Temperatures that were previously checked will not become unchecked
                RemoveHandler Temperatures_All_CheckBox.CheckedChanged, AddressOf Temperatures_All_CheckBox_CheckedChanged
                Temperatures_All_CheckBox.Checked = False
                AddHandler Temperatures_All_CheckBox.CheckedChanged, AddressOf Temperatures_All_CheckBox_CheckedChanged

            Else
                For temp_num As Integer = 0 To D33001.NUM_TEMPS - 1
                    Temperature_CheckBoxes(temp_num).Checked = Temperatures_All_CheckBox.Checked
                Next temp_num
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

    Private Sub Graph_MouseEnter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles scrollPanel.MouseEnter
        HScrollBar.Show()
    End Sub

    Private Sub Graph_MouseLeave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HScrollBar.MouseLeave
        HScrollBar.Hide()
    End Sub

    Private Sub ScrollBar_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar.Scroll
        Try
            GraphData_Signal_Group.ScrollBar_Scroll()

            If (Me.Enable_CheckBox.Checked = True) Then
                Update_GUI_Plot(True)
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

    End Sub

End Class
