﻿Imports Microsoft.VisualBasic

Public Class ErrLogPopup


    Private Sub ClearBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearBtn.Click
        D33001.Error_File.Clear()
    End Sub

    Private Sub ErrLogPopup_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Me.Hide()
        e.Cancel = True
    End Sub

    Private Sub ErrLogPopup_Resize(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Resize
        LogBox.Width = Me.Width - 34
        LogBox.Height = Me.Height - 102
    End Sub

    Private Sub ErrLogPopup_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown
        Me.LogBox.TopIndex = Me.LogBox.Items.Count - 1
    End Sub
End Class

Public Class Error_File

    Private Const logbox_limit As Integer = 100
    Private filename As String
    Private logbox As System.Windows.Forms.ListBox

    Private Const First_Debug_Error_Code As Error_Code = Error_Code.Exception
    Private Const Last_Debug_Error_Code As Error_Code = Error_Code.USB_Delayed
    Public Enum Error_Code
        Test
        Message
        Exception
        WinUSB_StartDeviceError
        WinUSB_WritePipeError
        WinUSB_WritePipeDelay
        WinUSB_ReadPipeError
        WinUSB_ReadPipeDelay
        USB_Delayed
        USB_Dropped
        USB_Parse
        OVUV
        LTC6804_CRC
        LTC6804_Failed_CFG_Write
        LTC6804_ADC_Clear
        LTC3300_CRC
        LTC3300_Status
        LTC3300_Failed_Write_Command
        USB_Parse_Unknown_Board
        USB_Parse_Unknown_EEPROM_Item
    End Enum

    Public Sub New(ByVal filename As String)

        ' Try reading from the file and closing to see if it is allowed
        Dim reader As System.IO.StreamReader
        Dim textline As String

        Me.logbox = ErrLogPopup.LogBox

        Try
            ' Try using this file for error logging.
            Me.filename = filename

            If My.Computer.FileSystem.FileExists(filename) Then
                ' Try loading error file
                reader = New System.IO.StreamReader(filename)

                If (reader.EndOfStream) Then
                    reader.Close()
                    ' If error file exists and it's empty, try writing to it to see if it's possible.
                    Me.Add(Error_Code.Message, "Event File Created")
                Else
                    ' If error file exists, attempt to write to it.
                    Me.Add(Error_Code.Message, "Event File Opened")

                    ' Load contents into the box
                    While (Not reader.EndOfStream)
                        textline = reader.ReadLine()
                        Me.logbox.Items.Add(textline)
                        If logbox.Items.Count > logbox_limit Then
                            Me.logbox.Items.RemoveAt(0)
                        End If
                    End While
                End If
                Me.logbox.TopIndex = Me.logbox.Items.Count - 1

                reader.Close()
            Else
                Try
                    ' If error file doesn't exist, try creating it 
                    Dim writer As New System.IO.StreamWriter(filename)
                    writer.WriteLine()
                    writer.Close()

                    Me.Add(Error_Code.Message, "Event File Created")

                Catch ex2 As Exception
                    ' Chicken and Egg...Can't Log Exceptions to Error File while creating the Error File 
                    'D33001.Handle_Exception(ex2)

                    ' Clear the error file name to flag that it is not valid file.
                    Me.filename = ""
                End Try
            End If
        Catch ex As Exception
            ' Chicken and Egg...Can't Log Exceptions to Error File while creating the Error File 
            'D33001.Handle_Exception(ex)

            ' Clear the error file name to flag that it is not valid file.
            Me.filename = ""
        End Try

    End Sub

    Public Sub Add(ByVal code As Error_Code, Optional ByVal error_string As String = "", Optional ByVal debug_string As String = "")

        ' Some errors are for development only, and should not be included in the event logs of customers
        If (code >= First_Debug_Error_Code) And (code <= Last_Debug_Error_Code) Then
            If (D33001.DEBUG_ERRORS = False) And (D33001.Mfg_Enabled = False) Then
                Exit Sub
            End If
        End If

        Dim textline As String

        If ErrLogPopup.Error_Log_Enable_CheckBox.Checked = True Then
            ' Build the Error Log Entry
            textline = CStr(System.DateTime.Now) + ", "
            textline += [Enum].GetName(GetType(Error_Code), code)

            ' Add the Error code data that is meaningful to customers
            If error_string <> "" Then
                textline += ", "
                Select Case code
                    Case Error_Code.USB_Dropped
                        For character As Integer = 0 To error_string.Length - 1
                            If (error_string(character) >= " ") And (error_string(character) <= "~") Then
                                textline += error_string(character)
                            Else
                                Dim number As Integer = Microsoft.VisualBasic.AscW(error_string(character))
                                textline += "0x" + number.ToString("X2")
                            End If
                        Next character
                    Case Else
                        textline += error_string
                End Select
            End If

            ' Add the Error code data that is only meaningful to Linear
            If ((D33001.DEBUG_ERRORS = True) Or D33001.Mfg_Enabled = True) AndAlso debug_string <> "" Then
                textline += ", "
                Select Case code
                    Case Error_Code.USB_Dropped
                        For character As Integer = 0 To debug_string.Length - 1
                            If (debug_string(character) >= " ") And (debug_string(character) <= "~") Then
                                textline += debug_string(character)
                            Else
                                Dim number As Integer = Microsoft.VisualBasic.AscW(debug_string(character))
                                textline += "0x" + number.ToString("X2")
                            End If
                        Next character
                    Case Else
                        textline += debug_string
                End Select
            End If

            ' Add Error Log Entry to GUI
            Me.logbox.Items.Add(textline + System.Environment.NewLine)
            If logbox.Items.Count > logbox_limit Then
                Me.logbox.Items.RemoveAt(0)
            End If
            Me.logbox.TopIndex = Me.logbox.Items.Count - 1

            ' Write Error Log Data to File if it exists and can be written
            If Me.filename <> "" Then
                Dim writer As System.IO.StreamWriter
                writer = System.IO.File.AppendText(Me.filename)
                writer.WriteLine(textline)
                writer.Flush()
                writer.Close()
            End If
        End If
    End Sub

    Public Sub Clear()
        ' Try writing to the file and closing to see if it is allowed
        logbox.Items.Clear()

        ' Clear Error Log Data to File if it exists and can be written
        If Me.filename <> "" Then
            My.Computer.FileSystem.WriteAllText(Me.filename, "", False)
        End If

        ' Start new log with the message that the last one was cleared
        Me.Add(Error_Code.Message, "Event Log Cleared")

    End Sub

    Public Sub Close()
        If Me.filename <> "" Then
            ' I don't think we really want to clear the error log each time we close the GUI
        End If
    End Sub
End Class
