﻿Imports Microsoft.VisualBasic
Imports LinearTechnology.DemoBoards.DC2100A

Public Class DataInputPopup

    Public Capacity_Changed As Boolean = False
    Public Currents_Changed As Boolean = False

    Public Sub Cal_Data_Init()

        RemoveHandler Me.DataGrid.CellValueChanged, AddressOf DataGrid_CellValueChanged

        Try
            If (DataGrid.Rows.Count < D33001.MAX_CELLS) Then
                DataGrid.Rows.Add(D33001.MAX_CELLS)
                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    DataGrid.Rows(cell_num).HeaderCell.Value = "   Cell " & (D33001.MAX_CELLS - cell_num)
                Next
            End If

        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

        AddHandler Me.DataGrid.CellValueChanged, AddressOf DataGrid_CellValueChanged

    End Sub

    ' Sends USB Command to firmware to store values on screen in EEPROM.
    Public Sub Cal_Data_Capacity_Write()
        Dim dataString As String

        Try
            dataString = D33001.USB_PARSER_EEPROM_COMMAND
            If D33001.Mfg_Enabled = True Then
                dataString += "w"
            Else
                dataString += "W"
            End If

            dataString += D33001.selectedBoard.ToString("X2") + CInt(D33001.EEPROM_Item_Type.Cap).ToString("X1")

            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                dataString += CInt((DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(D33001.Calibration_Column.Capacity).Value * _
                                    D33001.SOC_CAP_SCALE_FACTOR)).ToString("X4")
            Next cell_num

            D33001.USB_Comm_List_Out.Add(dataString)
        Catch ex As Exception
            D33001.Handle_Exception(ex)

        End Try

    End Sub

    ' Sends USB Command to firmware to load the nominal or mfg measured values
    Public Sub Cal_Data_Capacity_Default(ByVal nominal As Boolean, ByVal load_only As Boolean)

        Dim dataString As String

        ' todo - we all know these strings shouldn't be strung throughout the code like this...
        dataString = D33001.USB_PARSER_EEPROM_COMMAND
        If load_only = True Then
            dataString += If(nominal = True, "l", "L")
        Else
            dataString += If(nominal = True, "d", "D")
        End If
        dataString += D33001.selectedBoard.ToString("X2") + CInt(D33001.EEPROM_Item_Type.Cap).ToString("X1")

        D33001.USB_Comm_List_Out.Add(dataString)
    End Sub

    Public Sub Cal_Data_Currents_Write()
        Dim dataString As String

        Try
            dataString = D33001.USB_PARSER_EEPROM_COMMAND
            If D33001.Mfg_Enabled = True Then
                dataString += "w"
            Else
                dataString += "W"
            End If

            dataString += D33001.selectedBoard.ToString("X2") + CInt(D33001.EEPROM_Item_Type.Current).ToString("X1")

            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                dataString += calc_current_scale_factor(DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(D33001.Calibration_Column.Charge_Current).Value, _
                                                        D33001.Board_ID_Data(D33001.selectedBoard).Average_Charge_Current_6Cell)
                dataString += calc_current_scale_factor(DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(D33001.Calibration_Column.Discharge_Current).Value, _
                                                        D33001.Board_ID_Data(D33001.selectedBoard).Average_Discharge_Current_6Cell)
            Next cell_num

            D33001.USB_Comm_List_Out.Add(dataString)

            D33001.Cal_Pending = True
        Catch ex As Exception
            D33001.Handle_Exception(ex)

        End Try

    End Sub

    Public Sub Cal_Data_Current_Default(ByVal nominal As Boolean, ByVal load_only As Boolean)
        Dim dataString As String

        ' todo - we all know these strings shouldn't be strung throughout the code like this...
        dataString = D33001.USB_PARSER_EEPROM_COMMAND
        If load_only = True Then
            dataString += If(nominal = True, "l", "L")
        Else
            dataString += If(nominal = True, "d", "D")
        End If
        dataString += D33001.selectedBoard.ToString("X2") + CInt(D33001.EEPROM_Item_Type.Current).ToString("X1")

        D33001.USB_Comm_List_Out.Add(dataString)
    End Sub

    Public Sub DataGrid_CellValueChanged(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles DataGrid.CellValueChanged
        If DataGrid.Rows.Count > 0 Then
            Try
                If (e.ColumnIndex >= 0) And (e.RowIndex >= 0) Then

                    ' If not a cap demo or in mfg mode, format and bounds check new value written into table
                    If (D33001.Mfg_Enabled = True) Or (D33001.Board_ID_Data(D33001.DC2100A_PIC_BOARD_NUM).Cap_Demo = False) Then
                        Dim input As Single

                        ' Cleared values should be ignored when a board is detatched
                        If (DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value <> "") Then

                            input = CSng(DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value)

                            'check for all boxes filled in capacity column
                            If e.ColumnIndex = D33001.Calibration_Column.Capacity Then
                                ' Calculate the Max possible Capacity
                                Dim max_capacity As Single = CSng(D33001.CAP_MAX) / D33001.SOC_CAP_SCALE_FACTOR

                                If input > max_capacity Then
                                    input = max_capacity
                                ElseIf input < 0 Then
                                    input = 0
                                End If
                                Capacity_Changed = True
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Style.BackColor = D33001.CHANGED_COLOR
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = input.ToString(D33001.CAP_FORMAT)
                            ElseIf e.ColumnIndex = D33001.Calibration_Column.Charge_Current Then
                                ' Calculate the Min and Max possible Charge Currents
                                Dim max_charge_current As Single = D33001.Board_ID_Data(D33001.selectedBoard).Average_Charge_Current_6Cell + _
                                                                   D33001.Board_ID_Data(D33001.selectedBoard).Average_Charge_Current_6Cell * _
                                                                   D33001.CURRENT_SCALE_MAX / D33001.CURRENT_SCALE_FACTOR
                                Dim min_charge_current As Single = D33001.Board_ID_Data(D33001.selectedBoard).Average_Charge_Current_6Cell + _
                                                                   D33001.Board_ID_Data(D33001.selectedBoard).Average_Charge_Current_6Cell * _
                                                                   D33001.CURRENT_SCALE_MIN / D33001.CURRENT_SCALE_FACTOR
                                If input > max_charge_current Then
                                    input = max_charge_current
                                ElseIf input < min_charge_current Then
                                    input = min_charge_current
                                End If
                                Currents_Changed = True
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Style.BackColor = D33001.CHANGED_COLOR
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = input.ToString(D33001.CURRENT_FORMAT)
                            ElseIf e.ColumnIndex = D33001.Calibration_Column.Discharge_Current Then
                                ' Calculate the Min and Max possible Discharge Currents
                                Dim max_discharge_current As Single = D33001.Board_ID_Data(D33001.selectedBoard).Average_Discharge_Current_6Cell + _
                                                                      D33001.Board_ID_Data(D33001.selectedBoard).Average_Discharge_Current_6Cell * _
                                                                      D33001.CURRENT_SCALE_MAX / D33001.CURRENT_SCALE_FACTOR
                                Dim min_discharge_current As Single = D33001.Board_ID_Data(D33001.selectedBoard).Average_Discharge_Current_6Cell + _
                                                                      D33001.Board_ID_Data(D33001.selectedBoard).Average_Discharge_Current_6Cell * _
                                                                      D33001.CURRENT_SCALE_MIN / D33001.CURRENT_SCALE_FACTOR
                                If input > max_discharge_current Then
                                    input = max_discharge_current
                                ElseIf input < min_discharge_current Then
                                    input = min_discharge_current
                                End If
                                Currents_Changed = True
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Style.BackColor = D33001.CHANGED_COLOR
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = input.ToString(D33001.CURRENT_FORMAT)
                            End If
                        End If
                    Else
                        ' Cleared values should be ignored when a board is detatched
                        If (DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value <> "") Then

                            'do not allow cap demo to change values
                            If e.ColumnIndex = D33001.Calibration_Column.Capacity Then
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = D33001.EEPROM_Data(D33001.selectedBoard).Capacity(D33001.MAX_CELLS - 1 - e.RowIndex).ToString(D33001.CAP_FORMAT)
                            ElseIf e.ColumnIndex = D33001.Calibration_Column.Charge_Current Then
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = D33001.EEPROM_Data(D33001.selectedBoard).Charge_Currents(D33001.MAX_CELLS - 1 - e.RowIndex).ToString(D33001.CURRENT_FORMAT)
                            ElseIf e.ColumnIndex = D33001.Calibration_Column.Discharge_Current Then
                                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = D33001.EEPROM_Data(D33001.selectedBoard).Discharge_Currents(D33001.MAX_CELLS - 1 - e.RowIndex).ToString(D33001.CURRENT_FORMAT)
                            End If
                        End If
                    End If
                End If
            Catch ex As Exception
                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Style.BackColor = D33001.CHANGED_COLOR
                DataGrid.Rows(e.RowIndex).Cells(e.ColumnIndex).Value = 0
                D33001.Handle_Exception(ex)
            End Try
        End If
    End Sub

    'Send cap values from table to EEPROM
    Private Sub Calibration_Cap_Button_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Calibration_Cap_Button_1.Click
        If (D33001.Mfg_Enabled = True) Or (D33001.Board_ID_Data(D33001.DC2100A_PIC_BOARD_NUM).Cap_Demo = False) Then
            If popup_confirmation_message("cell capacity", False) = True Then
                Cal_Data_Capacity_Write()
            End If
        Else
            Cal_Data_Capacity_Default(True, True)
        End If
    End Sub

    'Reset cap values to defaultsfrom table to EEPROM
    Private Sub Calibration_Cap_Button_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Calibration_Cap_Button_2.Click
        If (D33001.Mfg_Enabled = True) Then
            If popup_confirmation_message("balance current", True) = True Then
                Cal_Data_Capacity_Default(True, False)
            End If
        Else

            If (D33001.Board_ID_Data(D33001.DC2100A_PIC_BOARD_NUM).Cap_Demo = False) Then
                If popup_confirmation_message("balance current", True) = True Then
                    Cal_Data_Capacity_Default(False, False)
                End If
            Else
                Cal_Data_Capacity_Default(False, True)
            End If
        End If
    End Sub

    'Send current values from table to EEPROM (done in 2 sends due to buffer size of 64)
    Private Sub Calibration_Current_Button_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Calibration_Current_Button_1.Click
        If (D33001.Mfg_Enabled = True) Or (D33001.Board_ID_Data(D33001.DC2100A_PIC_BOARD_NUM).Cap_Demo = False) Then
            If popup_confirmation_message("balance current", False) = True Then
                Cal_Data_Currents_Write()
            End If
        Else
            Cal_Data_Current_Default(True, True)
        End If
    End Sub

    'Populate table with values from EEPROM
    Private Sub Calibration_Current_Button_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Calibration_Current_Button_2.Click
        If (D33001.Mfg_Enabled = True) Then
            If popup_confirmation_message("balance current", True) = True Then
                Cal_Data_Current_Default(True, False)
            End If
        Else

            If (D33001.Board_ID_Data(D33001.DC2100A_PIC_BOARD_NUM).Cap_Demo = False) Then
                If popup_confirmation_message("balance current", True) = True Then
                    Cal_Data_Current_Default(False, False)
                End If
            Else
                Cal_Data_Current_Default(False, True)
            End If
        End If
    End Sub

    'Hide instead of closing form
    Private Sub DataInputPopup_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Me.Hide()
        e.Cancel = True
    End Sub

    Private Function calc_current_scale_factor(ByVal desired_current As Single, ByVal base_current As Single) As String
        Dim cal_factor As SByte
        Try
            cal_factor = CSByte(Math.Round(D33001.CURRENT_SCALE_FACTOR * (desired_current - base_current) / base_current))
        Catch ex As Exception
            D33001.Handle_Exception(ex)
        End Try

        Return cal_factor.ToString("X2")

    End Function

    Private Function popup_confirmation_message(ByVal datatype As String, ByVal datadefault As Boolean) As Boolean

        Dim popup_msg As String = "This will "
        If datadefault Then
            popup_msg += "reset the "
        Else
            popup_msg += "overwrite the "
        End If

        popup_msg += datatype
        popup_msg += " calibration data" & ChrW(13) & ChrW(10) & "in the DC2100A"

        If datadefault Then
            popup_msg += " to defaults."
        Else
            popup_msg += "."
        End If

        popup_msg += ChrW(13) & ChrW(10) & _
                     ChrW(13) & ChrW(10) & "Do you want to proceed?"

        ' todo - need to use consistent popups?
        If MsgBox(popup_msg, MsgBoxStyle.OkCancel) = MsgBoxResult.Ok Then
            Return True
        Else
            Return False
        End If

    End Function

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Capacity_Changed = False
        Currents_Changed = False
        D33001.GUI_Refresh_Calibration_Data()
    End Sub
End Class