Option Strict On
Option Explicit On

Imports System.ComponentModel
Imports System.Runtime.InteropServices
Imports System.Text
Imports System.Globalization
Imports WinUSBAccess.WinUSBAccess
Imports Microsoft.VisualBasic
Imports System.Collections.Generic

'''<summary>
''' Demonstrates how to use the WinUSBAccess library to catalog, communicate with, and manage the comings and
''' goings of devices that share a Device Interface GUID.
''' Catalogs all attached devices with a specific device interface GUID.
''' Enables sending and receiving data via bulk, interrupt, and control transfers.  Uses
''' RegisterDeviceNotification() and WM_DEVICE_CHANGE messages to detect when a device is attached or removed.
''' For bulk and interrupt transfers, the application uses background workers to read data back from the USB
''' channels.
''' </summary>

Friend Class D33001
    Inherits System.Windows.Forms.Form
#Region "Windows Form Designer generated code "
    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()
    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
        If Disposing Then
            If Not components Is Nothing Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(Disposing)
    End Sub
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer
    Public ToolTip1 As System.Windows.Forms.ToolTip
    Public WithEvents lstResults As System.Windows.Forms.ListBox
    Friend WithEvents BulkReadButton As System.Windows.Forms.Button
    Public WithEvents BulkWriteButton As System.Windows.Forms.Button
    Public WithEvents txtBulkDataWrite As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents ComboBox1 As System.Windows.Forms.ComboBox
    Friend WithEvents BulkInCheckBox As System.Windows.Forms.CheckBox
    Friend WithEvents BulkOutCheckBox As System.Windows.Forms.CheckBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents BulkInSizeTextBox As System.Windows.Forms.TextBox
    Friend WithEvents BulkOutSizeTextBox As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents DeviceProviderTextBox As System.Windows.Forms.TextBox
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents Label7 As System.Windows.Forms.Label
    Friend WithEvents USBRevTextBox As System.Windows.Forms.TextBox
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents DeviceRevTextBox As System.Windows.Forms.TextBox
    Friend WithEvents Label9 As System.Windows.Forms.Label
    Friend WithEvents DeviceSpeedTextBox As System.Windows.Forms.TextBox
    Friend WithEvents BulkReadWorker As System.ComponentModel.BackgroundWorker
    Friend WithEvents AutoBulkReadWorker As System.ComponentModel.BackgroundWorker
    Public WithEvents TxtBulkDataRead As System.Windows.Forms.TextBox
    Friend WithEvents Label10 As System.Windows.Forms.Label
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents RemovalTimer As System.Windows.Forms.Timer
    Friend WithEvents Data_Log_Timer As System.Windows.Forms.Timer
    Public WithEvents Balance_Control_Manual_Read_Status_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Manual_Read_Command_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Manual_Suspend_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Manual_Execute_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Manual_Write_Command_Button As System.Windows.Forms.Button
    '      Public WithEvents TreeView1 As System.Windows.Forms.TreeView '!!!-----------------------------------------------

    Friend WithEvents TreeView1 As System.Windows.Forms.TreeView
    Friend WithEvents SplitContainer1 As System.Windows.Forms.SplitContainer
    Friend WithEvents TabControl1 As System.Windows.Forms.TabControl
    Friend WithEvents TabPage1 As System.Windows.Forms.TabPage
    Public WithEvents groupBox9 As System.Windows.Forms.GroupBox

    Private WithEvents Balance_Action_Cell1_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell1_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell1_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell2_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell2_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell2_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell3_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell3_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell3_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell4_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell4_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell4_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell5_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell5_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell5_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell6_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell6_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell6_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell7_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell7_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell7_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell8_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell8_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell8_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell9_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell9_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell9_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell10_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell10_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell10_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell11_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell11_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell11_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell12_None_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell12_Discharge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents Balance_Action_Cell12_Charge_RadioButton As System.Windows.Forms.RadioButton
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell4_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell5_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell6_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell7_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell8_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell9_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell10_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell11_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Balance_Timer_Cell12_TextBox As System.Windows.Forms.TextBox

    Private WithEvents LTC3300_Command_Command_Label As System.Windows.Forms.Label
    Private WithEvents LTC3300_Command_Address_Label As System.Windows.Forms.Label
    Private WithEvents LTC3300_Command_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit4_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit5_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit6_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Bit7_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Command_Parity_Label As System.Windows.Forms.Label
    Private WithEvents LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox As System.Windows.Forms.TextBox

    Private WithEvents label74 As System.Windows.Forms.Label

    Private WithEvents cellpic1 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic2 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic3 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic4 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic5 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic6 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic7 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic8 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic9 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic10 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic11 As System.Windows.Forms.PictureBox
    Private WithEvents cellpic12 As System.Windows.Forms.PictureBox

    Private WithEvents LTC3300_Read_Status_IC1_CRC_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents label66 As System.Windows.Forms.Label
    Private WithEvents label71 As System.Windows.Forms.Label
    Private WithEvents label67 As System.Windows.Forms.Label
    Private WithEvents label70 As System.Windows.Forms.Label
    Private WithEvents label68 As System.Windows.Forms.Label
    Private WithEvents label69 As System.Windows.Forms.Label
    Private WithEvents groupBox10 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox11 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox12 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox13 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox14 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox15 As System.Windows.Forms.GroupBox
    Private WithEvents Label13 As System.Windows.Forms.Label
    Private WithEvents Label14 As System.Windows.Forms.Label
    Private WithEvents Label48 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC1_Unused_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label49 As System.Windows.Forms.Label
    Private WithEvents Label50 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC1_Unused_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Unused_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Temp_OK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label51 As System.Windows.Forms.Label
    Private WithEvents Label52 As System.Windows.Forms.Label
    Private WithEvents Label53 As System.Windows.Forms.Label
    Private WithEvents Label54 As System.Windows.Forms.Label
    Private WithEvents Label55 As System.Windows.Forms.Label
    Private WithEvents Label56 As System.Windows.Forms.Label
    Private WithEvents Label57 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label58 As System.Windows.Forms.Label
    Private WithEvents Label59 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label60 As System.Windows.Forms.Label
    Private WithEvents Label61 As System.Windows.Forms.Label
    Private WithEvents Label62 As System.Windows.Forms.Label
    Private WithEvents Label63 As System.Windows.Forms.Label
    Public WithEvents GroupBox5 As System.Windows.Forms.GroupBox
    Private WithEvents label73 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC2_CRC_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents label64 As System.Windows.Forms.Label
    Private WithEvents label65 As System.Windows.Forms.Label
    Private WithEvents Label72 As System.Windows.Forms.Label
    Private WithEvents Label75 As System.Windows.Forms.Label
    Private WithEvents Label76 As System.Windows.Forms.Label
    Private WithEvents Label77 As System.Windows.Forms.Label
    Private WithEvents groupBox8 As System.Windows.Forms.GroupBox
    Private WithEvents groupBox7 As System.Windows.Forms.GroupBox
    Private WithEvents GroupBox6 As System.Windows.Forms.GroupBox
    Private WithEvents GroupBox16 As System.Windows.Forms.GroupBox
    Private WithEvents GroupBox17 As System.Windows.Forms.GroupBox
    Private WithEvents GroupBox18 As System.Windows.Forms.GroupBox
    Private WithEvents Label78 As System.Windows.Forms.Label
    Private WithEvents Label79 As System.Windows.Forms.Label
    Private WithEvents Label80 As System.Windows.Forms.Label
    Private WithEvents Label81 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC2_Unused_Bit2_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Unused_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Unused_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Temp_OK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label82 As System.Windows.Forms.Label
    Private WithEvents Label83 As System.Windows.Forms.Label
    Private WithEvents Label84 As System.Windows.Forms.Label
    Private WithEvents Label85 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label86 As System.Windows.Forms.Label
    Private WithEvents Label87 As System.Windows.Forms.Label
    Private WithEvents Label88 As System.Windows.Forms.Label
    Private WithEvents Label89 As System.Windows.Forms.Label
    Private WithEvents Label90 As System.Windows.Forms.Label
    Private WithEvents Label91 As System.Windows.Forms.Label
    Private WithEvents Label92 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label93 As System.Windows.Forms.Label
    Private WithEvents Label94 As System.Windows.Forms.Label
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox As System.Windows.Forms.TextBox
    Private WithEvents LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Label95 As System.Windows.Forms.Label
    Friend WithEvents Panel1 As System.Windows.Forms.Panel
    Friend WithEvents Num_Boards_Label As System.Windows.Forms.Label
    Friend WithEvents TabPage2 As System.Windows.Forms.TabPage
    Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
    Friend WithEvents Label34 As System.Windows.Forms.Label
    Friend WithEvents Label33 As System.Windows.Forms.Label
    Friend WithEvents Label35 As System.Windows.Forms.Label
    Friend WithEvents Label36 As System.Windows.Forms.Label
    Friend WithEvents Label37 As System.Windows.Forms.Label
    Friend WithEvents Label38 As System.Windows.Forms.Label
    Friend WithEvents Label39 As System.Windows.Forms.Label
    Friend WithEvents Label40 As System.Windows.Forms.Label
    Friend WithEvents Label41 As System.Windows.Forms.Label
    Friend WithEvents Label42 As System.Windows.Forms.Label
    Friend WithEvents Label43 As System.Windows.Forms.Label
    Friend WithEvents Label44 As System.Windows.Forms.Label
    Friend WithEvents Label45 As System.Windows.Forms.Label
    Friend WithEvents Label46 As System.Windows.Forms.Label
    Friend WithEvents Label47 As System.Windows.Forms.Label
    Friend WithEvents Label11 As System.Windows.Forms.Label
    Friend WithEvents Label12 As System.Windows.Forms.Label
    Friend WithEvents Label15 As System.Windows.Forms.Label
    Friend WithEvents Label16 As System.Windows.Forms.Label
    Friend WithEvents Label17 As System.Windows.Forms.Label
    Friend WithEvents Label18 As System.Windows.Forms.Label
    Friend WithEvents Label19 As System.Windows.Forms.Label
    Friend WithEvents Label20 As System.Windows.Forms.Label
    Friend WithEvents Label21 As System.Windows.Forms.Label
    Friend WithEvents Label22 As System.Windows.Forms.Label
    Friend WithEvents Label23 As System.Windows.Forms.Label
    Friend WithEvents Label24 As System.Windows.Forms.Label
    Friend WithEvents Label26 As System.Windows.Forms.Label
    Friend WithEvents Label25 As System.Windows.Forms.Label
    Friend WithEvents Label32 As System.Windows.Forms.Label
    Friend WithEvents Label31 As System.Windows.Forms.Label
    Friend WithEvents Label30 As System.Windows.Forms.Label
    Friend WithEvents Label29 As System.Windows.Forms.Label
    Friend WithEvents Label28 As System.Windows.Forms.Label
    Friend WithEvents Label27 As System.Windows.Forms.Label
    Public WithEvents TextBox1 As System.Windows.Forms.TextBox
    Public WithEvents TextBox2 As System.Windows.Forms.TextBox
    Public WithEvents cmdBox2 As System.Windows.Forms.TextBox
    Public WithEvents cmdCRC2 As System.Windows.Forms.TextBox
    Public WithEvents cmdBox1 As System.Windows.Forms.TextBox
    Public WithEvents cmdCRC1 As System.Windows.Forms.TextBox
    Public WithEvents statBox2 As System.Windows.Forms.TextBox
    Public WithEvents statCRC2 As System.Windows.Forms.TextBox
    Public WithEvents statBox1 As System.Windows.Forms.TextBox
    Public WithEvents statCRC1 As System.Windows.Forms.TextBox
    Private WithEvents Balance_Control_Timed_GroupBox As System.Windows.Forms.GroupBox
    Public WithEvents Balance_Control_Time_Remaining_Label As System.Windows.Forms.Label
    Private WithEvents Balance_Control_Next_Stop_Label As System.Windows.Forms.Label
    Public WithEvents Balance_Control_Timed_CheckBox As System.Windows.Forms.CheckBox
    Public WithEvents Balance_Control_Timed_StartStop_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Timed_Reset_Button As System.Windows.Forms.Button
    Public WithEvents Balance_Control_Timed_Write_Button As System.Windows.Forms.Button
    Private WithEvents Balance_Control_Manual_GroupBox As System.Windows.Forms.GroupBox
    Private WithEvents GroupBox19 As System.Windows.Forms.GroupBox
    Public WithEvents pictureBox8 As System.Windows.Forms.PictureBox
    Public WithEvents pictureBox9 As System.Windows.Forms.PictureBox
    Public WithEvents pictureBox11 As System.Windows.Forms.PictureBox
    Public WithEvents pictureBox12 As System.Windows.Forms.PictureBox
    Public WithEvents pictureBox13 As System.Windows.Forms.PictureBox
    Private WithEvents Label101 As System.Windows.Forms.Label
    Private WithEvents Label102 As System.Windows.Forms.Label
    Private WithEvents Label104 As System.Windows.Forms.Label
    Private WithEvents Label105 As System.Windows.Forms.Label
    Private WithEvents Label106 As System.Windows.Forms.Label
    Private WithEvents Label107 As System.Windows.Forms.Label
    Private WithEvents Label108 As System.Windows.Forms.Label
    Private WithEvents Label109 As System.Windows.Forms.Label
    Private WithEvents Label110 As System.Windows.Forms.Label
    Private WithEvents Label112 As System.Windows.Forms.Label
    Private WithEvents pictureBox7 As System.Windows.Forms.PictureBox
    Friend WithEvents CellGrid As System.Windows.Forms.DataGridView
    Private WithEvents Label114 As System.Windows.Forms.Label
    Friend WithEvents vBox6 As System.Windows.Forms.TextBox
    Friend WithEvents vBox5 As System.Windows.Forms.TextBox
    Friend WithEvents vBox4 As System.Windows.Forms.TextBox
    Friend WithEvents vBox3 As System.Windows.Forms.TextBox
    Friend WithEvents vBox2 As System.Windows.Forms.TextBox
    Friend WithEvents vBox1 As System.Windows.Forms.TextBox
    Private WithEvents Label113 As System.Windows.Forms.Label
    Friend WithEvents vBox12 As System.Windows.Forms.TextBox
    Friend WithEvents vBox11 As System.Windows.Forms.TextBox
    Friend WithEvents vBox7 As System.Windows.Forms.TextBox
    Friend WithEvents vBox8 As System.Windows.Forms.TextBox
    Friend WithEvents vBox9 As System.Windows.Forms.TextBox
    Friend WithEvents vBox10 As System.Windows.Forms.TextBox
    Friend WithEvents ButtonRV As System.Windows.Forms.Button
    Friend WithEvents ImageList1 As System.Windows.Forms.ImageList
    Friend WithEvents Cell_Present_Context_Menu_Strip As System.Windows.Forms.ContextMenuStrip
    Friend WithEvents Cell4 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell5 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents vMinBox As System.Windows.Forms.TextBox
    Friend WithEvents vMaxBox As System.Windows.Forms.TextBox
    Friend WithEvents Under_Voltage_Label As System.Windows.Forms.Label
    Friend WithEvents Over_Voltage_Label As System.Windows.Forms.Label
    Friend WithEvents ShapeContainer2 As Microsoft.VisualBasic.PowerPacks.ShapeContainer
    Friend WithEvents RectangleShape12 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape11 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape10 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape9 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape8 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape7 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents ShapeContainer1 As Microsoft.VisualBasic.PowerPacks.ShapeContainer
    Friend WithEvents RectangleShape6 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape4 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape3 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape2 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape1 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents RectangleShape5 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Private WithEvents Max_Min_Cell_Voltage_GroupBox As System.Windows.Forms.GroupBox
    Friend WithEvents Advanced_Button As System.Windows.Forms.Button
    Friend WithEvents NoteLabel As System.Windows.Forms.Label
    Friend WithEvents Panel2 As System.Windows.Forms.Panel
    Friend WithEvents noteLabelTimer As System.Windows.Forms.Timer
    ' Friend WithEvents manualBalTimer As System.Windows.Forms.Timer
    Friend WithEvents CheckBox2 As System.Windows.Forms.CheckBox
    Friend WithEvents RectangleShape13 As Microsoft.VisualBasic.PowerPacks.RectangleShape
    Friend WithEvents Panel5 As System.Windows.Forms.Panel
    Friend WithEvents Panel4 As System.Windows.Forms.Panel
    Friend WithEvents Config_Demo_Button As System.Windows.Forms.Button
    Friend WithEvents USB_Communication_Timer As System.Windows.Forms.Timer
    Friend WithEvents Config_Save_Button As System.Windows.Forms.Button
    Friend WithEvents Config_Load_Button As System.Windows.Forms.Button
    Friend WithEvents Config_Load_NumericUpDown As System.Windows.Forms.NumericUpDown
    Friend WithEvents Config_Save_NumericUpDown As System.Windows.Forms.NumericUpDown
    Friend WithEvents CapBoardBtn As System.Windows.Forms.Button
    Public WithEvents autoReadBox As System.Windows.Forms.CheckBox
    Friend WithEvents ErrLogBtn As System.Windows.Forms.Button
    Friend WithEvents Data_Log_CheckBox As System.Windows.Forms.CheckBox
    Friend WithEvents ShapeContainer3 As Microsoft.VisualBasic.PowerPacks.ShapeContainer
    Friend WithEvents Data_Log_Length_ComboBox As System.Windows.Forms.ComboBox
    Friend WithEvents Data_Log_Interval_ComboBox As System.Windows.Forms.ComboBox
    Friend WithEvents Data_Log_Length_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Data_Log_Interval_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Data_Log_Interval_Label As System.Windows.Forms.Label
    Friend WithEvents Data_Log_Start_Button As System.Windows.Forms.Button
    Friend WithEvents Data_Log_Mem_Usage_Label As System.Windows.Forms.Label
    Friend WithEvents Data_Log_Stop_ComboBox As System.Windows.Forms.Button
    Friend WithEvents SN_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents SN_Label As System.Windows.Forms.Label
    Friend WithEvents FW_Rev_Label As System.Windows.Forms.Label
    Friend WithEvents FW_Rev_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents CapDemo_Label As System.Windows.Forms.Label
    Friend WithEvents CapDemo_ComboBox As System.Windows.Forms.ComboBox
    Friend WithEvents Model_Label As System.Windows.Forms.Label
    Friend WithEvents Model_ComboBox As System.Windows.Forms.ComboBox
    Friend WithEvents Write_MfgData_Button As System.Windows.Forms.Button
    Friend WithEvents Calibration_Data_Button As System.Windows.Forms.Button
    Friend WithEvents Temperature_IC1_Temp1_TextBox As System.Windows.Forms.TextBox
    Public WithEvents Passive_Balancer_Test_IC1_Checkbox As System.Windows.Forms.CheckBox
    Friend WithEvents Temperature_IC1_Temp1_Label As System.Windows.Forms.Label
    Friend WithEvents Board_Selected_Label As System.Windows.Forms.Label
    Friend WithEvents Board_Selected_Number_Label As System.Windows.Forms.Label
    Friend WithEvents Board_Count_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC1_Temp2_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC1_Temp2_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC1_Temp3_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC1_Temp3_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC1_Temp4_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC1_Temp4_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC1_Temp5_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC1_Temp5_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC1_Temp6_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC1_Temp6_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp12_TextBox As System.Windows.Forms.TextBox
    Public WithEvents Passive_Balancer_Test_IC2_Checkbox As System.Windows.Forms.CheckBox
    Friend WithEvents Temperature_IC2_Temp12_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp7_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp11_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC2_Temp7_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC2_Temp11_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp8_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp10_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC2_Temp8_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Temperature_IC2_Temp10_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp9_Label As System.Windows.Forms.Label
    Friend WithEvents Temperature_IC2_Temp9_TextBox As System.Windows.Forms.TextBox
    Private WithEvents Base_Balance_Current_GroupBox As System.Windows.Forms.GroupBox
    Friend WithEvents Average_Charge_Current_6Cell_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Average_Charge_Current_6Cell_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Charge_Current_12Cell_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Board_Selected_GroupBox As System.Windows.Forms.GroupBox
    Friend WithEvents Data_Logging_GroupBox As System.Windows.Forms.GroupBox
    Friend WithEvents Update_Firmware_Button As System.Windows.Forms.Button
    Friend WithEvents Reset_Mfg_Data_Button As System.Windows.Forms.Button
    Friend WithEvents Temperature_IC2_GroupBox As System.Windows.Forms.GroupBox
    Friend WithEvents Temperature_IC1_GroupBox As System.Windows.Forms.GroupBox
    Public WithEvents Temperature_ADC_Test_IC2_Checkbox As System.Windows.Forms.CheckBox
    Public WithEvents Temperature_ADC_Test_IC1_Checkbox As System.Windows.Forms.CheckBox
    Friend WithEvents Balance_Control_GroupBox As System.Windows.Forms.GroupBox
    Public WithEvents Balance_Control_Manual_CheckBox As System.Windows.Forms.CheckBox
    Private WithEvents Label100 As System.Windows.Forms.Label
    Private WithEvents Label97 As System.Windows.Forms.Label
    Private WithEvents Label96 As System.Windows.Forms.Label
    Private WithEvents Label99 As System.Windows.Forms.Label
    Private WithEvents Label98 As System.Windows.Forms.Label
    Private WithEvents Label103 As System.Windows.Forms.Label
    Friend WithEvents Average_Discharge_Current_12Cell_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Discharge_Current_6Cell_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Average_Discharge_Current_6Cell_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Discharge_Current_12Cell_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Over_Voltage_Units_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Discharge_Current_6Cell_Units_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Charge_Current_6Cell_Units_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Discharge_Current_12Cell_Units_Label As System.Windows.Forms.Label
    Friend WithEvents Average_Charge_Current_12Cell_Units_Label As System.Windows.Forms.Label
    Friend WithEvents Under_Voltage_Units_Label As System.Windows.Forms.Label
    Public WithEvents Balance_Control_Time_Remaining_Value_Label As System.Windows.Forms.Label
    Private WithEvents Balance_Control_Next_Stop_Value_Label As System.Windows.Forms.Label
    Friend WithEvents Mfg_PipeTimer As System.Windows.Forms.Timer
    Friend WithEvents Mfg_PipeWorker As System.ComponentModel.BackgroundWorker
    Friend WithEvents Cell6 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell7 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell8 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell9 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell10 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell11 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Cell12 As System.Windows.Forms.ToolStripMenuItem
    Friend WithEvents Debug_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents Data_Log_Length_Label As System.Windows.Forms.Label
    Public WithEvents PictureBox2 As System.Windows.Forms.PictureBox
    Private WithEvents Label111 As System.Windows.Forms.Label
    Private WithEvents Label115 As System.Windows.Forms.Label
    Private WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents Comm_LED_PictureBox As System.Windows.Forms.PictureBox
    Friend WithEvents Status_LED_PictureBox As System.Windows.Forms.PictureBox
    Friend WithEvents LED_Label As System.Windows.Forms.Label
    Friend WithEvents Debug2_TextBox As System.Windows.Forms.TextBox
    Friend WithEvents WritePipe_BackgroundWorker As System.ComponentModel.BackgroundWorker
    Friend WithEvents Average_Charge_Current_12Cell_Label As System.Windows.Forms.Label

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(D33001))
        Dim DataGridViewCellStyle2 As System.Windows.Forms.DataGridViewCellStyle = New System.Windows.Forms.DataGridViewCellStyle()
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.Balance_Control_Manual_Read_Status_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Manual_Read_Command_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Manual_Suspend_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Manual_Execute_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Manual_Write_Command_Button = New System.Windows.Forms.Button()
        Me.Config_Load_Button = New System.Windows.Forms.Button()
        Me.Config_Save_Button = New System.Windows.Forms.Button()
        Me.Config_Demo_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Timed_CheckBox = New System.Windows.Forms.CheckBox()
        Me.Advanced_Button = New System.Windows.Forms.Button()
        Me.vMinBox = New System.Windows.Forms.TextBox()
        Me.vMaxBox = New System.Windows.Forms.TextBox()
        Me.ButtonRV = New System.Windows.Forms.Button()
        Me.autoReadBox = New System.Windows.Forms.CheckBox()
        Me.Passive_Balancer_Test_IC1_Checkbox = New System.Windows.Forms.CheckBox()
        Me.Passive_Balancer_Test_IC2_Checkbox = New System.Windows.Forms.CheckBox()
        Me.Average_Charge_Current_6Cell_TextBox = New System.Windows.Forms.TextBox()
        Me.Average_Charge_Current_12Cell_TextBox = New System.Windows.Forms.TextBox()
        Me.Reset_Mfg_Data_Button = New System.Windows.Forms.Button()
        Me.Update_Firmware_Button = New System.Windows.Forms.Button()
        Me.Temperature_ADC_Test_IC2_Checkbox = New System.Windows.Forms.CheckBox()
        Me.Temperature_ADC_Test_IC1_Checkbox = New System.Windows.Forms.CheckBox()
        Me.Balance_Control_Manual_CheckBox = New System.Windows.Forms.CheckBox()
        Me.Average_Discharge_Current_12Cell_TextBox = New System.Windows.Forms.TextBox()
        Me.Average_Discharge_Current_6Cell_TextBox = New System.Windows.Forms.TextBox()
        Me.Comm_LED_PictureBox = New System.Windows.Forms.PictureBox()
        Me.Status_LED_PictureBox = New System.Windows.Forms.PictureBox()
        Me.Balance_Action_Cell1_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell1_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell1_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell2_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell2_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell2_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell3_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell3_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell3_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell4_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell4_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell4_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell5_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell5_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell5_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell6_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell6_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell6_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell7_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell7_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell7_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell8_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell8_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell8_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell9_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell9_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell9_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell10_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell10_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell10_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell11_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell11_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell11_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell12_None_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell12_Discharge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.Balance_Action_Cell12_Charge_RadioButton = New System.Windows.Forms.RadioButton()
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell1_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell2_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell3_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell4_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell5_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell6_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell7_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell8_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell9_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell10_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell11_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Timer_Cell12_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Command_Label = New System.Windows.Forms.Label()
        Me.LTC3300_Command_Address_Label = New System.Windows.Forms.Label()
        Me.LTC3300_Command_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit4_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit5_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit6_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Bit7_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Command_Parity_Label = New System.Windows.Forms.Label()
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.lstResults = New System.Windows.Forms.ListBox()
        Me.BulkReadButton = New System.Windows.Forms.Button()
        Me.BulkWriteButton = New System.Windows.Forms.Button()
        Me.txtBulkDataWrite = New System.Windows.Forms.TextBox()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.ComboBox1 = New System.Windows.Forms.ComboBox()
        Me.BulkInCheckBox = New System.Windows.Forms.CheckBox()
        Me.BulkOutCheckBox = New System.Windows.Forms.CheckBox()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.BulkInSizeTextBox = New System.Windows.Forms.TextBox()
        Me.BulkOutSizeTextBox = New System.Windows.Forms.TextBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.Label5 = New System.Windows.Forms.Label()
        Me.DeviceProviderTextBox = New System.Windows.Forms.TextBox()
        Me.Label6 = New System.Windows.Forms.Label()
        Me.Label7 = New System.Windows.Forms.Label()
        Me.USBRevTextBox = New System.Windows.Forms.TextBox()
        Me.Label8 = New System.Windows.Forms.Label()
        Me.DeviceRevTextBox = New System.Windows.Forms.TextBox()
        Me.Label9 = New System.Windows.Forms.Label()
        Me.DeviceSpeedTextBox = New System.Windows.Forms.TextBox()
        Me.BulkReadWorker = New System.ComponentModel.BackgroundWorker()
        Me.AutoBulkReadWorker = New System.ComponentModel.BackgroundWorker()
        Me.TxtBulkDataRead = New System.Windows.Forms.TextBox()
        Me.Label10 = New System.Windows.Forms.Label()
        Me.GroupBox1 = New System.Windows.Forms.GroupBox()
        Me.CheckBox2 = New System.Windows.Forms.CheckBox()
        Me.GroupBox2 = New System.Windows.Forms.GroupBox()
        Me.RemovalTimer = New System.Windows.Forms.Timer(Me.components)
        Me.Data_Log_Timer = New System.Windows.Forms.Timer(Me.components)
        Me.TreeView1 = New System.Windows.Forms.TreeView()
        Me.ImageList1 = New System.Windows.Forms.ImageList(Me.components)
        Me.SplitContainer1 = New System.Windows.Forms.SplitContainer()
        Me.TabControl1 = New System.Windows.Forms.TabControl()
        Me.TabPage1 = New System.Windows.Forms.TabPage()
        Me.Debug2_TextBox = New System.Windows.Forms.TextBox()
        Me.Balance_Control_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Balance_Control_Manual_GroupBox = New System.Windows.Forms.GroupBox()
        Me.GroupBox3 = New System.Windows.Forms.GroupBox()
        Me.Balance_Control_Timed_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Balance_Control_Time_Remaining_Value_Label = New System.Windows.Forms.Label()
        Me.Balance_Control_Next_Stop_Value_Label = New System.Windows.Forms.Label()
        Me.Balance_Control_Time_Remaining_Label = New System.Windows.Forms.Label()
        Me.Balance_Control_Next_Stop_Label = New System.Windows.Forms.Label()
        Me.Balance_Control_Timed_StartStop_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Timed_Reset_Button = New System.Windows.Forms.Button()
        Me.Balance_Control_Timed_Write_Button = New System.Windows.Forms.Button()
        Me.Panel5 = New System.Windows.Forms.Panel()
        Me.Config_Load_NumericUpDown = New System.Windows.Forms.NumericUpDown()
        Me.Config_Save_NumericUpDown = New System.Windows.Forms.NumericUpDown()
        Me.Panel4 = New System.Windows.Forms.Panel()
        Me.GroupBox5 = New System.Windows.Forms.GroupBox()
        Me.Label100 = New System.Windows.Forms.Label()
        Me.Label97 = New System.Windows.Forms.Label()
        Me.Label96 = New System.Windows.Forms.Label()
        Me.Temperature_IC2_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Temperature_IC2_Temp12_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC2_Temp9_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp9_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC2_Temp12_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp7_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC2_Temp11_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC2_Temp8_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp10_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp7_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp11_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC2_Temp8_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC2_Temp10_Label = New System.Windows.Forms.Label()
        Me.Label113 = New System.Windows.Forms.Label()
        Me.label73 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.label64 = New System.Windows.Forms.Label()
        Me.label65 = New System.Windows.Forms.Label()
        Me.Label72 = New System.Windows.Forms.Label()
        Me.Label75 = New System.Windows.Forms.Label()
        Me.Label76 = New System.Windows.Forms.Label()
        Me.Label77 = New System.Windows.Forms.Label()
        Me.Label78 = New System.Windows.Forms.Label()
        Me.Label79 = New System.Windows.Forms.Label()
        Me.Label80 = New System.Windows.Forms.Label()
        Me.Label81 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox = New System.Windows.Forms.TextBox()
        Me.Label82 = New System.Windows.Forms.Label()
        Me.Label83 = New System.Windows.Forms.Label()
        Me.Label84 = New System.Windows.Forms.Label()
        Me.Label85 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.Label86 = New System.Windows.Forms.Label()
        Me.Label87 = New System.Windows.Forms.Label()
        Me.Label88 = New System.Windows.Forms.Label()
        Me.Label89 = New System.Windows.Forms.Label()
        Me.Label90 = New System.Windows.Forms.Label()
        Me.Label91 = New System.Windows.Forms.Label()
        Me.Label92 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.Label93 = New System.Windows.Forms.Label()
        Me.Label94 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.Label95 = New System.Windows.Forms.Label()
        Me.ShapeContainer1 = New Microsoft.VisualBasic.PowerPacks.ShapeContainer()
        Me.RectangleShape6 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape5 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape4 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape3 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape2 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape1 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.groupBox8 = New System.Windows.Forms.GroupBox()
        Me.vBox12 = New System.Windows.Forms.TextBox()
        Me.cellpic12 = New System.Windows.Forms.PictureBox()
        Me.groupBox7 = New System.Windows.Forms.GroupBox()
        Me.vBox11 = New System.Windows.Forms.TextBox()
        Me.cellpic11 = New System.Windows.Forms.PictureBox()
        Me.GroupBox6 = New System.Windows.Forms.GroupBox()
        Me.vBox7 = New System.Windows.Forms.TextBox()
        Me.cellpic7 = New System.Windows.Forms.PictureBox()
        Me.GroupBox16 = New System.Windows.Forms.GroupBox()
        Me.vBox8 = New System.Windows.Forms.TextBox()
        Me.cellpic8 = New System.Windows.Forms.PictureBox()
        Me.GroupBox17 = New System.Windows.Forms.GroupBox()
        Me.vBox9 = New System.Windows.Forms.TextBox()
        Me.cellpic9 = New System.Windows.Forms.PictureBox()
        Me.GroupBox18 = New System.Windows.Forms.GroupBox()
        Me.vBox10 = New System.Windows.Forms.TextBox()
        Me.cellpic10 = New System.Windows.Forms.PictureBox()
        Me.GroupBox19 = New System.Windows.Forms.GroupBox()
        Me.PictureBox2 = New System.Windows.Forms.PictureBox()
        Me.Label111 = New System.Windows.Forms.Label()
        Me.Label115 = New System.Windows.Forms.Label()
        Me.pictureBox8 = New System.Windows.Forms.PictureBox()
        Me.pictureBox9 = New System.Windows.Forms.PictureBox()
        Me.pictureBox11 = New System.Windows.Forms.PictureBox()
        Me.pictureBox12 = New System.Windows.Forms.PictureBox()
        Me.pictureBox13 = New System.Windows.Forms.PictureBox()
        Me.Label101 = New System.Windows.Forms.Label()
        Me.Label102 = New System.Windows.Forms.Label()
        Me.Label104 = New System.Windows.Forms.Label()
        Me.Label105 = New System.Windows.Forms.Label()
        Me.Label106 = New System.Windows.Forms.Label()
        Me.Label107 = New System.Windows.Forms.Label()
        Me.Label108 = New System.Windows.Forms.Label()
        Me.Label109 = New System.Windows.Forms.Label()
        Me.Label110 = New System.Windows.Forms.Label()
        Me.Label112 = New System.Windows.Forms.Label()
        Me.groupBox9 = New System.Windows.Forms.GroupBox()
        Me.Label103 = New System.Windows.Forms.Label()
        Me.Label99 = New System.Windows.Forms.Label()
        Me.Label98 = New System.Windows.Forms.Label()
        Me.Temperature_IC1_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Temperature_IC1_Temp6_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC1_Temp1_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp6_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp1_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC1_Temp5_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC1_Temp2_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp5_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp2_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC1_Temp4_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp3_Label = New System.Windows.Forms.Label()
        Me.Temperature_IC1_Temp4_TextBox = New System.Windows.Forms.TextBox()
        Me.Temperature_IC1_Temp3_TextBox = New System.Windows.Forms.TextBox()
        Me.Label114 = New System.Windows.Forms.Label()
        Me.label74 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.label66 = New System.Windows.Forms.Label()
        Me.label71 = New System.Windows.Forms.Label()
        Me.label67 = New System.Windows.Forms.Label()
        Me.label70 = New System.Windows.Forms.Label()
        Me.label68 = New System.Windows.Forms.Label()
        Me.label69 = New System.Windows.Forms.Label()
        Me.Label13 = New System.Windows.Forms.Label()
        Me.Label14 = New System.Windows.Forms.Label()
        Me.Label48 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox = New System.Windows.Forms.TextBox()
        Me.Label49 = New System.Windows.Forms.Label()
        Me.Label50 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.Label51 = New System.Windows.Forms.Label()
        Me.Label52 = New System.Windows.Forms.Label()
        Me.Label53 = New System.Windows.Forms.Label()
        Me.Label54 = New System.Windows.Forms.Label()
        Me.Label55 = New System.Windows.Forms.Label()
        Me.Label56 = New System.Windows.Forms.Label()
        Me.Label57 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox = New System.Windows.Forms.TextBox()
        Me.Label58 = New System.Windows.Forms.Label()
        Me.Label59 = New System.Windows.Forms.Label()
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox = New System.Windows.Forms.TextBox()
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox = New System.Windows.Forms.TextBox()
        Me.Label60 = New System.Windows.Forms.Label()
        Me.Label61 = New System.Windows.Forms.Label()
        Me.Label62 = New System.Windows.Forms.Label()
        Me.Label63 = New System.Windows.Forms.Label()
        Me.ShapeContainer2 = New Microsoft.VisualBasic.PowerPacks.ShapeContainer()
        Me.RectangleShape12 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape11 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape10 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape9 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape8 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.RectangleShape7 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.groupBox10 = New System.Windows.Forms.GroupBox()
        Me.vBox6 = New System.Windows.Forms.TextBox()
        Me.cellpic6 = New System.Windows.Forms.PictureBox()
        Me.groupBox11 = New System.Windows.Forms.GroupBox()
        Me.vBox5 = New System.Windows.Forms.TextBox()
        Me.cellpic5 = New System.Windows.Forms.PictureBox()
        Me.groupBox12 = New System.Windows.Forms.GroupBox()
        Me.vBox4 = New System.Windows.Forms.TextBox()
        Me.cellpic4 = New System.Windows.Forms.PictureBox()
        Me.groupBox13 = New System.Windows.Forms.GroupBox()
        Me.vBox3 = New System.Windows.Forms.TextBox()
        Me.cellpic3 = New System.Windows.Forms.PictureBox()
        Me.groupBox14 = New System.Windows.Forms.GroupBox()
        Me.vBox2 = New System.Windows.Forms.TextBox()
        Me.cellpic2 = New System.Windows.Forms.PictureBox()
        Me.groupBox15 = New System.Windows.Forms.GroupBox()
        Me.vBox1 = New System.Windows.Forms.TextBox()
        Me.cellpic1 = New System.Windows.Forms.PictureBox()
        Me.TabPage2 = New System.Windows.Forms.TabPage()
        Me.CellGrid = New System.Windows.Forms.DataGridView()
        Me.Data_Logging_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Data_Log_Length_Label = New System.Windows.Forms.Label()
        Me.Data_Log_Stop_ComboBox = New System.Windows.Forms.Button()
        Me.Data_Log_Mem_Usage_Label = New System.Windows.Forms.Label()
        Me.Data_Log_Start_Button = New System.Windows.Forms.Button()
        Me.Data_Log_Length_ComboBox = New System.Windows.Forms.ComboBox()
        Me.Data_Log_Interval_ComboBox = New System.Windows.Forms.ComboBox()
        Me.Data_Log_Length_TextBox = New System.Windows.Forms.TextBox()
        Me.Data_Log_Interval_TextBox = New System.Windows.Forms.TextBox()
        Me.Data_Log_Interval_Label = New System.Windows.Forms.Label()
        Me.Data_Log_CheckBox = New System.Windows.Forms.CheckBox()
        Me.Base_Balance_Current_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Average_Discharge_Current_6Cell_Units_Label = New System.Windows.Forms.Label()
        Me.Average_Charge_Current_6Cell_Units_Label = New System.Windows.Forms.Label()
        Me.Average_Discharge_Current_12Cell_Units_Label = New System.Windows.Forms.Label()
        Me.Average_Charge_Current_12Cell_Units_Label = New System.Windows.Forms.Label()
        Me.Average_Discharge_Current_6Cell_Label = New System.Windows.Forms.Label()
        Me.Average_Discharge_Current_12Cell_Label = New System.Windows.Forms.Label()
        Me.Average_Charge_Current_6Cell_Label = New System.Windows.Forms.Label()
        Me.Average_Charge_Current_12Cell_Label = New System.Windows.Forms.Label()
        Me.Max_Min_Cell_Voltage_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Under_Voltage_Units_Label = New System.Windows.Forms.Label()
        Me.Over_Voltage_Units_Label = New System.Windows.Forms.Label()
        Me.Under_Voltage_Label = New System.Windows.Forms.Label()
        Me.Over_Voltage_Label = New System.Windows.Forms.Label()
        Me.ShapeContainer3 = New Microsoft.VisualBasic.PowerPacks.ShapeContainer()
        Me.RectangleShape13 = New Microsoft.VisualBasic.PowerPacks.RectangleShape()
        Me.CapBoardBtn = New System.Windows.Forms.Button()
        Me.pictureBox7 = New System.Windows.Forms.PictureBox()
        Me.NoteLabel = New System.Windows.Forms.Label()
        Me.Panel1 = New System.Windows.Forms.Panel()
        Me.Board_Selected_GroupBox = New System.Windows.Forms.GroupBox()
        Me.Board_Selected_Number_Label = New System.Windows.Forms.Label()
        Me.Num_Boards_Label = New System.Windows.Forms.Label()
        Me.Board_Count_Label = New System.Windows.Forms.Label()
        Me.Board_Selected_Label = New System.Windows.Forms.Label()
        Me.Calibration_Data_Button = New System.Windows.Forms.Button()
        Me.SN_TextBox = New System.Windows.Forms.TextBox()
        Me.Write_MfgData_Button = New System.Windows.Forms.Button()
        Me.SN_Label = New System.Windows.Forms.Label()
        Me.ErrLogBtn = New System.Windows.Forms.Button()
        Me.PictureBox1 = New System.Windows.Forms.PictureBox()
        Me.Label34 = New System.Windows.Forms.Label()
        Me.Label33 = New System.Windows.Forms.Label()
        Me.Label35 = New System.Windows.Forms.Label()
        Me.Label36 = New System.Windows.Forms.Label()
        Me.Label37 = New System.Windows.Forms.Label()
        Me.Label38 = New System.Windows.Forms.Label()
        Me.Label39 = New System.Windows.Forms.Label()
        Me.Label40 = New System.Windows.Forms.Label()
        Me.Label41 = New System.Windows.Forms.Label()
        Me.Label42 = New System.Windows.Forms.Label()
        Me.Label43 = New System.Windows.Forms.Label()
        Me.Label44 = New System.Windows.Forms.Label()
        Me.Label45 = New System.Windows.Forms.Label()
        Me.Label46 = New System.Windows.Forms.Label()
        Me.Label47 = New System.Windows.Forms.Label()
        Me.Label11 = New System.Windows.Forms.Label()
        Me.Label12 = New System.Windows.Forms.Label()
        Me.Label15 = New System.Windows.Forms.Label()
        Me.Label16 = New System.Windows.Forms.Label()
        Me.Label17 = New System.Windows.Forms.Label()
        Me.Label18 = New System.Windows.Forms.Label()
        Me.Label19 = New System.Windows.Forms.Label()
        Me.Label20 = New System.Windows.Forms.Label()
        Me.Label21 = New System.Windows.Forms.Label()
        Me.Label22 = New System.Windows.Forms.Label()
        Me.Label23 = New System.Windows.Forms.Label()
        Me.Label24 = New System.Windows.Forms.Label()
        Me.Label26 = New System.Windows.Forms.Label()
        Me.Label25 = New System.Windows.Forms.Label()
        Me.Label32 = New System.Windows.Forms.Label()
        Me.Label31 = New System.Windows.Forms.Label()
        Me.Label30 = New System.Windows.Forms.Label()
        Me.Label29 = New System.Windows.Forms.Label()
        Me.Label28 = New System.Windows.Forms.Label()
        Me.Label27 = New System.Windows.Forms.Label()
        Me.TextBox1 = New System.Windows.Forms.TextBox()
        Me.TextBox2 = New System.Windows.Forms.TextBox()
        Me.cmdBox2 = New System.Windows.Forms.TextBox()
        Me.cmdCRC2 = New System.Windows.Forms.TextBox()
        Me.cmdBox1 = New System.Windows.Forms.TextBox()
        Me.cmdCRC1 = New System.Windows.Forms.TextBox()
        Me.statBox2 = New System.Windows.Forms.TextBox()
        Me.statCRC2 = New System.Windows.Forms.TextBox()
        Me.statBox1 = New System.Windows.Forms.TextBox()
        Me.statCRC1 = New System.Windows.Forms.TextBox()
        Me.Cell_Present_Context_Menu_Strip = New System.Windows.Forms.ContextMenuStrip(Me.components)
        Me.Cell4 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell5 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell6 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell7 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell8 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell9 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell10 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell11 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Cell12 = New System.Windows.Forms.ToolStripMenuItem()
        Me.Panel2 = New System.Windows.Forms.Panel()
        Me.Debug_TextBox = New System.Windows.Forms.TextBox()
        Me.noteLabelTimer = New System.Windows.Forms.Timer(Me.components)
        Me.USB_Communication_Timer = New System.Windows.Forms.Timer(Me.components)
        Me.FW_Rev_Label = New System.Windows.Forms.Label()
        Me.FW_Rev_TextBox = New System.Windows.Forms.TextBox()
        Me.CapDemo_Label = New System.Windows.Forms.Label()
        Me.CapDemo_ComboBox = New System.Windows.Forms.ComboBox()
        Me.Model_Label = New System.Windows.Forms.Label()
        Me.Model_ComboBox = New System.Windows.Forms.ComboBox()
        Me.Mfg_PipeTimer = New System.Windows.Forms.Timer(Me.components)
        Me.Mfg_PipeWorker = New System.ComponentModel.BackgroundWorker()
        Me.LED_Label = New System.Windows.Forms.Label()
        Me.WritePipe_BackgroundWorker = New System.ComponentModel.BackgroundWorker()
        CType(Me.Comm_LED_PictureBox, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.Status_LED_PictureBox, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        CType(Me.SplitContainer1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SplitContainer1.Panel1.SuspendLayout()
        Me.SplitContainer1.Panel2.SuspendLayout()
        Me.SplitContainer1.SuspendLayout()
        Me.TabControl1.SuspendLayout()
        Me.TabPage1.SuspendLayout()
        Me.Balance_Control_GroupBox.SuspendLayout()
        Me.Balance_Control_Manual_GroupBox.SuspendLayout()
        Me.GroupBox3.SuspendLayout()
        Me.Balance_Control_Timed_GroupBox.SuspendLayout()
        Me.Panel5.SuspendLayout()
        CType(Me.Config_Load_NumericUpDown, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.Config_Save_NumericUpDown, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.Panel4.SuspendLayout()
        Me.GroupBox5.SuspendLayout()
        Me.Temperature_IC2_GroupBox.SuspendLayout()
        Me.groupBox8.SuspendLayout()
        CType(Me.cellpic12, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox7.SuspendLayout()
        CType(Me.cellpic11, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox6.SuspendLayout()
        CType(Me.cellpic7, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox16.SuspendLayout()
        CType(Me.cellpic8, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox17.SuspendLayout()
        CType(Me.cellpic9, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox18.SuspendLayout()
        CType(Me.cellpic10, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox19.SuspendLayout()
        CType(Me.PictureBox2, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.pictureBox8, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.pictureBox9, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.pictureBox11, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.pictureBox12, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.pictureBox13, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox9.SuspendLayout()
        Me.Temperature_IC1_GroupBox.SuspendLayout()
        Me.groupBox10.SuspendLayout()
        CType(Me.cellpic6, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox11.SuspendLayout()
        CType(Me.cellpic5, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox12.SuspendLayout()
        CType(Me.cellpic4, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox13.SuspendLayout()
        CType(Me.cellpic3, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox14.SuspendLayout()
        CType(Me.cellpic2, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox15.SuspendLayout()
        CType(Me.cellpic1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.TabPage2.SuspendLayout()
        CType(Me.CellGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.Data_Logging_GroupBox.SuspendLayout()
        Me.Base_Balance_Current_GroupBox.SuspendLayout()
        Me.Max_Min_Cell_Voltage_GroupBox.SuspendLayout()
        CType(Me.pictureBox7, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.Panel1.SuspendLayout()
        Me.Board_Selected_GroupBox.SuspendLayout()
        CType(Me.PictureBox1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.Cell_Present_Context_Menu_Strip.SuspendLayout()
        Me.Panel2.SuspendLayout()
        Me.SuspendLayout()
        '
        'ToolTip1
        '
        Me.ToolTip1.AutoPopDelay = 5000
        Me.ToolTip1.BackColor = System.Drawing.Color.Gainsboro
        Me.ToolTip1.InitialDelay = 1500
        Me.ToolTip1.ReshowDelay = 100
        '
        'Balance_Control_Manual_Read_Status_Button
        '
        Me.Balance_Control_Manual_Read_Status_Button.BackColor = System.Drawing.Color.LightGray
        Me.Balance_Control_Manual_Read_Status_Button.Cursor = System.Windows.Forms.Cursors.Default
        Me.Balance_Control_Manual_Read_Status_Button.Enabled = False
        Me.Balance_Control_Manual_Read_Status_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Manual_Read_Status_Button.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_Read_Status_Button.Location = New System.Drawing.Point(15, 174)
        Me.Balance_Control_Manual_Read_Status_Button.Name = "Balance_Control_Manual_Read_Status_Button"
        Me.Balance_Control_Manual_Read_Status_Button.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Balance_Control_Manual_Read_Status_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Manual_Read_Status_Button.TabIndex = 51
        Me.Balance_Control_Manual_Read_Status_Button.Text = "Read Status"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_Read_Status_Button, "Read Cell Statuses from LTC3300-1")
        Me.Balance_Control_Manual_Read_Status_Button.UseVisualStyleBackColor = False
        '
        'Balance_Control_Manual_Read_Command_Button
        '
        Me.Balance_Control_Manual_Read_Command_Button.BackColor = System.Drawing.Color.LightGray
        Me.Balance_Control_Manual_Read_Command_Button.Cursor = System.Windows.Forms.Cursors.Default
        Me.Balance_Control_Manual_Read_Command_Button.Enabled = False
        Me.Balance_Control_Manual_Read_Command_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Manual_Read_Command_Button.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_Read_Command_Button.Location = New System.Drawing.Point(15, 145)
        Me.Balance_Control_Manual_Read_Command_Button.Name = "Balance_Control_Manual_Read_Command_Button"
        Me.Balance_Control_Manual_Read_Command_Button.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Balance_Control_Manual_Read_Command_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Manual_Read_Command_Button.TabIndex = 50
        Me.Balance_Control_Manual_Read_Command_Button.Text = "Read Command"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_Read_Command_Button, "Read Command from LTC3300-1")
        Me.Balance_Control_Manual_Read_Command_Button.UseVisualStyleBackColor = False
        '
        'Balance_Control_Manual_Suspend_Button
        '
        Me.Balance_Control_Manual_Suspend_Button.BackColor = System.Drawing.Color.LightGray
        Me.Balance_Control_Manual_Suspend_Button.Cursor = System.Windows.Forms.Cursors.Default
        Me.Balance_Control_Manual_Suspend_Button.Enabled = False
        Me.Balance_Control_Manual_Suspend_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Manual_Suspend_Button.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_Suspend_Button.Location = New System.Drawing.Point(6, 42)
        Me.Balance_Control_Manual_Suspend_Button.Name = "Balance_Control_Manual_Suspend_Button"
        Me.Balance_Control_Manual_Suspend_Button.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Balance_Control_Manual_Suspend_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Manual_Suspend_Button.TabIndex = 49
        Me.Balance_Control_Manual_Suspend_Button.Text = "Suspend"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_Suspend_Button, "Suspend LTC3300-1 Charge/Discharge")
        Me.Balance_Control_Manual_Suspend_Button.UseVisualStyleBackColor = False
        '
        'Balance_Control_Manual_Execute_Button
        '
        Me.Balance_Control_Manual_Execute_Button.BackColor = System.Drawing.Color.LightGray
        Me.Balance_Control_Manual_Execute_Button.Cursor = System.Windows.Forms.Cursors.Default
        Me.Balance_Control_Manual_Execute_Button.Enabled = False
        Me.Balance_Control_Manual_Execute_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Manual_Execute_Button.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_Execute_Button.Location = New System.Drawing.Point(6, 13)
        Me.Balance_Control_Manual_Execute_Button.Name = "Balance_Control_Manual_Execute_Button"
        Me.Balance_Control_Manual_Execute_Button.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Balance_Control_Manual_Execute_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Manual_Execute_Button.TabIndex = 48
        Me.Balance_Control_Manual_Execute_Button.Text = "Execute"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_Execute_Button, "Execute LTC3300-1 Current Command")
        Me.Balance_Control_Manual_Execute_Button.UseVisualStyleBackColor = False
        '
        'Balance_Control_Manual_Write_Command_Button
        '
        Me.Balance_Control_Manual_Write_Command_Button.BackColor = System.Drawing.Color.LightGray
        Me.Balance_Control_Manual_Write_Command_Button.Cursor = System.Windows.Forms.Cursors.Default
        Me.Balance_Control_Manual_Write_Command_Button.Enabled = False
        Me.Balance_Control_Manual_Write_Command_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Manual_Write_Command_Button.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_Write_Command_Button.Location = New System.Drawing.Point(15, 116)
        Me.Balance_Control_Manual_Write_Command_Button.Name = "Balance_Control_Manual_Write_Command_Button"
        Me.Balance_Control_Manual_Write_Command_Button.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Balance_Control_Manual_Write_Command_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Manual_Write_Command_Button.TabIndex = 47
        Me.Balance_Control_Manual_Write_Command_Button.Text = "Write Command"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_Write_Command_Button, "Write Command to LTC3300-1")
        Me.Balance_Control_Manual_Write_Command_Button.UseVisualStyleBackColor = False
        '
        'Config_Load_Button
        '
        Me.Config_Load_Button.BackColor = System.Drawing.Color.LightGray
        Me.Config_Load_Button.Enabled = False
        Me.Config_Load_Button.Location = New System.Drawing.Point(9, 75)
        Me.Config_Load_Button.Name = "Config_Load_Button"
        Me.Config_Load_Button.Size = New System.Drawing.Size(74, 23)
        Me.Config_Load_Button.TabIndex = 312
        Me.Config_Load_Button.Text = "Load Config"
        Me.ToolTip1.SetToolTip(Me.Config_Load_Button, "Load Configuration Settings from Selected Slot")
        Me.Config_Load_Button.UseVisualStyleBackColor = False
        '
        'Config_Save_Button
        '
        Me.Config_Save_Button.BackColor = System.Drawing.Color.LightGray
        Me.Config_Save_Button.Enabled = False
        Me.Config_Save_Button.Location = New System.Drawing.Point(9, 42)
        Me.Config_Save_Button.Name = "Config_Save_Button"
        Me.Config_Save_Button.Size = New System.Drawing.Size(74, 23)
        Me.Config_Save_Button.TabIndex = 311
        Me.Config_Save_Button.Text = "Save Config"
        Me.ToolTip1.SetToolTip(Me.Config_Save_Button, "Save Configuration Settings to Selected Slot")
        Me.Config_Save_Button.UseVisualStyleBackColor = False
        '
        'Config_Demo_Button
        '
        Me.Config_Demo_Button.BackColor = System.Drawing.Color.LightGray
        Me.Config_Demo_Button.Enabled = False
        Me.Config_Demo_Button.Location = New System.Drawing.Point(9, 10)
        Me.Config_Demo_Button.Name = "Config_Demo_Button"
        Me.Config_Demo_Button.Size = New System.Drawing.Size(114, 23)
        Me.Config_Demo_Button.TabIndex = 270
        Me.Config_Demo_Button.Text = "Demo"
        Me.ToolTip1.SetToolTip(Me.Config_Demo_Button, "Configure Demonstration Settings")
        Me.Config_Demo_Button.UseVisualStyleBackColor = False
        '
        'Balance_Control_Timed_CheckBox
        '
        Me.Balance_Control_Timed_CheckBox.AutoSize = True
        Me.Balance_Control_Timed_CheckBox.Enabled = False
        Me.Balance_Control_Timed_CheckBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Balance_Control_Timed_CheckBox.Location = New System.Drawing.Point(7, 14)
        Me.Balance_Control_Timed_CheckBox.Name = "Balance_Control_Timed_CheckBox"
        Me.Balance_Control_Timed_CheckBox.Size = New System.Drawing.Size(112, 17)
        Me.Balance_Control_Timed_CheckBox.TabIndex = 0
        Me.Balance_Control_Timed_CheckBox.Text = "TIMED BALANCE"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Timed_CheckBox, "Toggle Timed Balancing")
        Me.Balance_Control_Timed_CheckBox.UseVisualStyleBackColor = True
        '
        'Advanced_Button
        '
        Me.Advanced_Button.BackColor = System.Drawing.Color.LightGray
        Me.Advanced_Button.Location = New System.Drawing.Point(603, -2)
        Me.Advanced_Button.Name = "Advanced_Button"
        Me.Advanced_Button.Size = New System.Drawing.Size(106, 21)
        Me.Advanced_Button.TabIndex = 272
        Me.Advanced_Button.Text = "Advanced"
        Me.ToolTip1.SetToolTip(Me.Advanced_Button, "View Advanced Options and Data")
        Me.Advanced_Button.UseVisualStyleBackColor = False
        Me.Advanced_Button.Visible = False
        '
        'vMinBox
        '
        Me.vMinBox.Enabled = False
        Me.vMinBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.vMinBox.Location = New System.Drawing.Point(106, 67)
        Me.vMinBox.MaxLength = 6
        Me.vMinBox.Name = "vMinBox"
        Me.vMinBox.Size = New System.Drawing.Size(56, 20)
        Me.vMinBox.TabIndex = 47
        Me.vMinBox.Text = "2.50"
        Me.vMinBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.vMinBox, "Cell Undervoltage Value")
        '
        'vMaxBox
        '
        Me.vMaxBox.Enabled = False
        Me.vMaxBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.vMaxBox.Location = New System.Drawing.Point(106, 34)
        Me.vMaxBox.MaxLength = 6
        Me.vMaxBox.Name = "vMaxBox"
        Me.vMaxBox.Size = New System.Drawing.Size(56, 20)
        Me.vMaxBox.TabIndex = 46
        Me.vMaxBox.Text = "4.50"
        Me.vMaxBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.vMaxBox, "Cell Overvoltage Value")
        '
        'ButtonRV
        '
        Me.ButtonRV.BackColor = System.Drawing.Color.LightGray
        Me.ButtonRV.Enabled = False
        Me.ButtonRV.Location = New System.Drawing.Point(15, 32)
        Me.ButtonRV.Name = "ButtonRV"
        Me.ButtonRV.Size = New System.Drawing.Size(103, 37)
        Me.ButtonRV.TabIndex = 3
        Me.ButtonRV.Text = "Read Voltages"
        Me.ToolTip1.SetToolTip(Me.ButtonRV, "Read All Cell Voltages")
        Me.ButtonRV.UseVisualStyleBackColor = False
        '
        'autoReadBox
        '
        Me.autoReadBox.AutoSize = True
        Me.autoReadBox.Checked = True
        Me.autoReadBox.CheckState = System.Windows.Forms.CheckState.Checked
        Me.autoReadBox.Enabled = False
        Me.autoReadBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.autoReadBox.Location = New System.Drawing.Point(9, 10)
        Me.autoReadBox.Name = "autoReadBox"
        Me.autoReadBox.Size = New System.Drawing.Size(121, 17)
        Me.autoReadBox.TabIndex = 272
        Me.autoReadBox.Text = "Auto Read Voltages"
        Me.ToolTip1.SetToolTip(Me.autoReadBox, "Automatically Read Voltages")
        Me.autoReadBox.UseVisualStyleBackColor = True
        '
        'Passive_Balancer_Test_IC1_Checkbox
        '
        Me.Passive_Balancer_Test_IC1_Checkbox.AutoSize = True
        Me.Passive_Balancer_Test_IC1_Checkbox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Passive_Balancer_Test_IC1_Checkbox.Location = New System.Drawing.Point(502, 21)
        Me.Passive_Balancer_Test_IC1_Checkbox.Name = "Passive_Balancer_Test_IC1_Checkbox"
        Me.Passive_Balancer_Test_IC1_Checkbox.Size = New System.Drawing.Size(105, 17)
        Me.Passive_Balancer_Test_IC1_Checkbox.TabIndex = 280
        Me.Passive_Balancer_Test_IC1_Checkbox.Text = "Passive Bal Test"
        Me.ToolTip1.SetToolTip(Me.Passive_Balancer_Test_IC1_Checkbox, "Turn On Passive Balancers")
        Me.Passive_Balancer_Test_IC1_Checkbox.UseVisualStyleBackColor = True
        '
        'Passive_Balancer_Test_IC2_Checkbox
        '
        Me.Passive_Balancer_Test_IC2_Checkbox.AutoSize = True
        Me.Passive_Balancer_Test_IC2_Checkbox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Passive_Balancer_Test_IC2_Checkbox.Location = New System.Drawing.Point(502, 22)
        Me.Passive_Balancer_Test_IC2_Checkbox.Name = "Passive_Balancer_Test_IC2_Checkbox"
        Me.Passive_Balancer_Test_IC2_Checkbox.Size = New System.Drawing.Size(105, 17)
        Me.Passive_Balancer_Test_IC2_Checkbox.TabIndex = 280
        Me.Passive_Balancer_Test_IC2_Checkbox.Text = "Passive Bal Test"
        Me.ToolTip1.SetToolTip(Me.Passive_Balancer_Test_IC2_Checkbox, "Turn On Passive Balancers")
        Me.Passive_Balancer_Test_IC2_Checkbox.UseVisualStyleBackColor = True
        '
        'Average_Charge_Current_6Cell_TextBox
        '
        Me.Average_Charge_Current_6Cell_TextBox.Enabled = False
        Me.Average_Charge_Current_6Cell_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_6Cell_TextBox.Location = New System.Drawing.Point(245, 59)
        Me.Average_Charge_Current_6Cell_TextBox.MaxLength = 6
        Me.Average_Charge_Current_6Cell_TextBox.Name = "Average_Charge_Current_6Cell_TextBox"
        Me.Average_Charge_Current_6Cell_TextBox.Size = New System.Drawing.Size(56, 20)
        Me.Average_Charge_Current_6Cell_TextBox.TabIndex = 47
        Me.Average_Charge_Current_6Cell_TextBox.Text = "0.000"
        Me.Average_Charge_Current_6Cell_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.Average_Charge_Current_6Cell_TextBox, "Default Balance Current Value for Charge")
        '
        'Average_Charge_Current_12Cell_TextBox
        '
        Me.Average_Charge_Current_12Cell_TextBox.Enabled = False
        Me.Average_Charge_Current_12Cell_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_12Cell_TextBox.Location = New System.Drawing.Point(245, 15)
        Me.Average_Charge_Current_12Cell_TextBox.MaxLength = 6
        Me.Average_Charge_Current_12Cell_TextBox.Name = "Average_Charge_Current_12Cell_TextBox"
        Me.Average_Charge_Current_12Cell_TextBox.Size = New System.Drawing.Size(56, 20)
        Me.Average_Charge_Current_12Cell_TextBox.TabIndex = 46
        Me.Average_Charge_Current_12Cell_TextBox.Text = "0.000"
        Me.Average_Charge_Current_12Cell_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.Average_Charge_Current_12Cell_TextBox, "Default Balance Current Value for Charge")
        '
        'Reset_Mfg_Data_Button
        '
        Me.Reset_Mfg_Data_Button.BackColor = System.Drawing.Color.LightGray
        Me.Reset_Mfg_Data_Button.Location = New System.Drawing.Point(490, -2)
        Me.Reset_Mfg_Data_Button.Name = "Reset_Mfg_Data_Button"
        Me.Reset_Mfg_Data_Button.Size = New System.Drawing.Size(106, 21)
        Me.Reset_Mfg_Data_Button.TabIndex = 317
        Me.Reset_Mfg_Data_Button.Text = "Reset Mfg Data"
        Me.ToolTip1.SetToolTip(Me.Reset_Mfg_Data_Button, "View Advanced Options and Data")
        Me.Reset_Mfg_Data_Button.UseVisualStyleBackColor = False
        Me.Reset_Mfg_Data_Button.Visible = False
        '
        'Update_Firmware_Button
        '
        Me.Update_Firmware_Button.BackColor = System.Drawing.Color.LightGray
        Me.Update_Firmware_Button.Location = New System.Drawing.Point(627, 6)
        Me.Update_Firmware_Button.Name = "Update_Firmware_Button"
        Me.Update_Firmware_Button.Size = New System.Drawing.Size(106, 37)
        Me.Update_Firmware_Button.TabIndex = 318
        Me.Update_Firmware_Button.Text = "Update Firmware"
        Me.ToolTip1.SetToolTip(Me.Update_Firmware_Button, "View Advanced Options and Data")
        Me.Update_Firmware_Button.UseVisualStyleBackColor = False
        '
        'Temperature_ADC_Test_IC2_Checkbox
        '
        Me.Temperature_ADC_Test_IC2_Checkbox.AutoSize = True
        Me.Temperature_ADC_Test_IC2_Checkbox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_ADC_Test_IC2_Checkbox.Location = New System.Drawing.Point(502, 44)
        Me.Temperature_ADC_Test_IC2_Checkbox.Name = "Temperature_ADC_Test_IC2_Checkbox"
        Me.Temperature_ADC_Test_IC2_Checkbox.Size = New System.Drawing.Size(135, 17)
        Me.Temperature_ADC_Test_IC2_Checkbox.TabIndex = 319
        Me.Temperature_ADC_Test_IC2_Checkbox.Text = "Temperature ADC Test"
        Me.ToolTip1.SetToolTip(Me.Temperature_ADC_Test_IC2_Checkbox, "Output Temperatures in AD Counts")
        Me.Temperature_ADC_Test_IC2_Checkbox.UseVisualStyleBackColor = True
        '
        'Temperature_ADC_Test_IC1_Checkbox
        '
        Me.Temperature_ADC_Test_IC1_Checkbox.AutoSize = True
        Me.Temperature_ADC_Test_IC1_Checkbox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_ADC_Test_IC1_Checkbox.Location = New System.Drawing.Point(502, 42)
        Me.Temperature_ADC_Test_IC1_Checkbox.Name = "Temperature_ADC_Test_IC1_Checkbox"
        Me.Temperature_ADC_Test_IC1_Checkbox.Size = New System.Drawing.Size(135, 17)
        Me.Temperature_ADC_Test_IC1_Checkbox.TabIndex = 320
        Me.Temperature_ADC_Test_IC1_Checkbox.Text = "Temperature ADC Test"
        Me.ToolTip1.SetToolTip(Me.Temperature_ADC_Test_IC1_Checkbox, "Output Temperatures in AD Counts")
        Me.Temperature_ADC_Test_IC1_Checkbox.UseVisualStyleBackColor = True
        '
        'Balance_Control_Manual_CheckBox
        '
        Me.Balance_Control_Manual_CheckBox.AutoSize = True
        Me.Balance_Control_Manual_CheckBox.Checked = True
        Me.Balance_Control_Manual_CheckBox.CheckState = System.Windows.Forms.CheckState.Checked
        Me.Balance_Control_Manual_CheckBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Balance_Control_Manual_CheckBox.Location = New System.Drawing.Point(4, 13)
        Me.Balance_Control_Manual_CheckBox.Name = "Balance_Control_Manual_CheckBox"
        Me.Balance_Control_Manual_CheckBox.Size = New System.Drawing.Size(123, 17)
        Me.Balance_Control_Manual_CheckBox.TabIndex = 66
        Me.Balance_Control_Manual_CheckBox.Text = "MANUAL BALANCE"
        Me.ToolTip1.SetToolTip(Me.Balance_Control_Manual_CheckBox, "Toggle Timed Balancing")
        Me.Balance_Control_Manual_CheckBox.UseVisualStyleBackColor = True
        '
        'Average_Discharge_Current_12Cell_TextBox
        '
        Me.Average_Discharge_Current_12Cell_TextBox.Enabled = False
        Me.Average_Discharge_Current_12Cell_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_12Cell_TextBox.Location = New System.Drawing.Point(245, 37)
        Me.Average_Discharge_Current_12Cell_TextBox.MaxLength = 6
        Me.Average_Discharge_Current_12Cell_TextBox.Name = "Average_Discharge_Current_12Cell_TextBox"
        Me.Average_Discharge_Current_12Cell_TextBox.Size = New System.Drawing.Size(56, 20)
        Me.Average_Discharge_Current_12Cell_TextBox.TabIndex = 49
        Me.Average_Discharge_Current_12Cell_TextBox.Text = "0.000"
        Me.Average_Discharge_Current_12Cell_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.Average_Discharge_Current_12Cell_TextBox, "Default Balance Current Value for Charge")
        '
        'Average_Discharge_Current_6Cell_TextBox
        '
        Me.Average_Discharge_Current_6Cell_TextBox.Enabled = False
        Me.Average_Discharge_Current_6Cell_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_6Cell_TextBox.Location = New System.Drawing.Point(245, 81)
        Me.Average_Discharge_Current_6Cell_TextBox.MaxLength = 6
        Me.Average_Discharge_Current_6Cell_TextBox.Name = "Average_Discharge_Current_6Cell_TextBox"
        Me.Average_Discharge_Current_6Cell_TextBox.Size = New System.Drawing.Size(56, 20)
        Me.Average_Discharge_Current_6Cell_TextBox.TabIndex = 51
        Me.Average_Discharge_Current_6Cell_TextBox.Text = "0.000"
        Me.Average_Discharge_Current_6Cell_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.ToolTip1.SetToolTip(Me.Average_Discharge_Current_6Cell_TextBox, "Default Balance Current Value for Charge")
        '
        'Comm_LED_PictureBox
        '
        Me.Comm_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
        Me.Comm_LED_PictureBox.Location = New System.Drawing.Point(153, 51)
        Me.Comm_LED_PictureBox.Name = "Comm_LED_PictureBox"
        Me.Comm_LED_PictureBox.Size = New System.Drawing.Size(25, 25)
        Me.Comm_LED_PictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.Comm_LED_PictureBox.TabIndex = 317
        Me.Comm_LED_PictureBox.TabStop = False
        Me.ToolTip1.SetToolTip(Me.Comm_LED_PictureBox, "USB Comm LED")
        Me.Comm_LED_PictureBox.Visible = False
        '
        'Status_LED_PictureBox
        '
        Me.Status_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
        Me.Status_LED_PictureBox.Location = New System.Drawing.Point(119, 51)
        Me.Status_LED_PictureBox.Name = "Status_LED_PictureBox"
        Me.Status_LED_PictureBox.Size = New System.Drawing.Size(25, 25)
        Me.Status_LED_PictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.Status_LED_PictureBox.TabIndex = 318
        Me.Status_LED_PictureBox.TabStop = False
        Me.ToolTip1.SetToolTip(Me.Status_LED_PictureBox, "Status LED")
        Me.Status_LED_PictureBox.Visible = False
        '
        'Balance_Action_Cell1_None_RadioButton
        '
        Me.Balance_Action_Cell1_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell1_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell1_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell1_None_RadioButton.Name = "Balance_Action_Cell1_None_RadioButton"
        Me.Balance_Action_Cell1_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell1_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell1_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell1_Discharge_RadioButton
        '
        Me.Balance_Action_Cell1_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell1_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell1_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell1_Discharge_RadioButton.Name = "Balance_Action_Cell1_Discharge_RadioButton"
        Me.Balance_Action_Cell1_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell1_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell1_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell1_Charge_RadioButton
        '
        Me.Balance_Action_Cell1_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell1_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell1_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell1_Charge_RadioButton.Name = "Balance_Action_Cell1_Charge_RadioButton"
        Me.Balance_Action_Cell1_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell1_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell1_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell2_None_RadioButton
        '
        Me.Balance_Action_Cell2_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell2_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell2_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell2_None_RadioButton.Name = "Balance_Action_Cell2_None_RadioButton"
        Me.Balance_Action_Cell2_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell2_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell2_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell2_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell2_Discharge_RadioButton
        '
        Me.Balance_Action_Cell2_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell2_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell2_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell2_Discharge_RadioButton.Name = "Balance_Action_Cell2_Discharge_RadioButton"
        Me.Balance_Action_Cell2_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell2_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell2_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell2_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell2_Charge_RadioButton
        '
        Me.Balance_Action_Cell2_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell2_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell2_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell2_Charge_RadioButton.Name = "Balance_Action_Cell2_Charge_RadioButton"
        Me.Balance_Action_Cell2_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell2_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell2_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell2_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell3_None_RadioButton
        '
        Me.Balance_Action_Cell3_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell3_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell3_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell3_None_RadioButton.Name = "Balance_Action_Cell3_None_RadioButton"
        Me.Balance_Action_Cell3_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell3_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell3_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell3_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell3_Discharge_RadioButton
        '
        Me.Balance_Action_Cell3_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell3_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell3_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell3_Discharge_RadioButton.Name = "Balance_Action_Cell3_Discharge_RadioButton"
        Me.Balance_Action_Cell3_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell3_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell3_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell3_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell3_Charge_RadioButton
        '
        Me.Balance_Action_Cell3_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell3_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell3_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell3_Charge_RadioButton.Name = "Balance_Action_Cell3_Charge_RadioButton"
        Me.Balance_Action_Cell3_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell3_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell3_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell3_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell4_None_RadioButton
        '
        Me.Balance_Action_Cell4_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell4_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell4_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell4_None_RadioButton.Name = "Balance_Action_Cell4_None_RadioButton"
        Me.Balance_Action_Cell4_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell4_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell4_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell4_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell4_Discharge_RadioButton
        '
        Me.Balance_Action_Cell4_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell4_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell4_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell4_Discharge_RadioButton.Name = "Balance_Action_Cell4_Discharge_RadioButton"
        Me.Balance_Action_Cell4_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell4_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell4_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell4_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell4_Charge_RadioButton
        '
        Me.Balance_Action_Cell4_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell4_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell4_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell4_Charge_RadioButton.Name = "Balance_Action_Cell4_Charge_RadioButton"
        Me.Balance_Action_Cell4_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell4_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell4_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell4_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell5_None_RadioButton
        '
        Me.Balance_Action_Cell5_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell5_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell5_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell5_None_RadioButton.Name = "Balance_Action_Cell5_None_RadioButton"
        Me.Balance_Action_Cell5_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell5_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell5_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell5_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell5_Discharge_RadioButton
        '
        Me.Balance_Action_Cell5_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell5_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell5_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell5_Discharge_RadioButton.Name = "Balance_Action_Cell5_Discharge_RadioButton"
        Me.Balance_Action_Cell5_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell5_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell5_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell5_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell5_Charge_RadioButton
        '
        Me.Balance_Action_Cell5_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell5_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell5_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell5_Charge_RadioButton.Name = "Balance_Action_Cell5_Charge_RadioButton"
        Me.Balance_Action_Cell5_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell5_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell5_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell5_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell6_None_RadioButton
        '
        Me.Balance_Action_Cell6_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell6_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell6_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell6_None_RadioButton.Name = "Balance_Action_Cell6_None_RadioButton"
        Me.Balance_Action_Cell6_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell6_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell6_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell6_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell6_Discharge_RadioButton
        '
        Me.Balance_Action_Cell6_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell6_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell6_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell6_Discharge_RadioButton.Name = "Balance_Action_Cell6_Discharge_RadioButton"
        Me.Balance_Action_Cell6_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell6_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell6_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell6_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell6_Charge_RadioButton
        '
        Me.Balance_Action_Cell6_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell6_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell6_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell6_Charge_RadioButton.Name = "Balance_Action_Cell6_Charge_RadioButton"
        Me.Balance_Action_Cell6_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell6_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell6_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell6_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell7_None_RadioButton
        '
        Me.Balance_Action_Cell7_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell7_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell7_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell7_None_RadioButton.Name = "Balance_Action_Cell7_None_RadioButton"
        Me.Balance_Action_Cell7_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell7_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell7_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell7_Discharge_RadioButton
        '
        Me.Balance_Action_Cell7_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell7_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell7_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell7_Discharge_RadioButton.Name = "Balance_Action_Cell7_Discharge_RadioButton"
        Me.Balance_Action_Cell7_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell7_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell7_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell7_Charge_RadioButton
        '
        Me.Balance_Action_Cell7_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell7_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell7_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell7_Charge_RadioButton.Name = "Balance_Action_Cell7_Charge_RadioButton"
        Me.Balance_Action_Cell7_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell7_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell7_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell8_None_RadioButton
        '
        Me.Balance_Action_Cell8_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell8_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell8_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell8_None_RadioButton.Name = "Balance_Action_Cell8_None_RadioButton"
        Me.Balance_Action_Cell8_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell8_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell8_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell8_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell8_Discharge_RadioButton
        '
        Me.Balance_Action_Cell8_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell8_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell8_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell8_Discharge_RadioButton.Name = "Balance_Action_Cell8_Discharge_RadioButton"
        Me.Balance_Action_Cell8_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell8_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell8_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell8_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell8_Charge_RadioButton
        '
        Me.Balance_Action_Cell8_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell8_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell8_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell8_Charge_RadioButton.Name = "Balance_Action_Cell8_Charge_RadioButton"
        Me.Balance_Action_Cell8_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell8_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell8_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell8_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell9_None_RadioButton
        '
        Me.Balance_Action_Cell9_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell9_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell9_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell9_None_RadioButton.Name = "Balance_Action_Cell9_None_RadioButton"
        Me.Balance_Action_Cell9_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell9_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell9_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell9_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell9_Discharge_RadioButton
        '
        Me.Balance_Action_Cell9_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell9_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell9_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell9_Discharge_RadioButton.Name = "Balance_Action_Cell9_Discharge_RadioButton"
        Me.Balance_Action_Cell9_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell9_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell9_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell9_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell9_Charge_RadioButton
        '
        Me.Balance_Action_Cell9_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell9_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell9_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell9_Charge_RadioButton.Name = "Balance_Action_Cell9_Charge_RadioButton"
        Me.Balance_Action_Cell9_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell9_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell9_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell9_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell10_None_RadioButton
        '
        Me.Balance_Action_Cell10_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell10_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell10_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell10_None_RadioButton.Name = "Balance_Action_Cell10_None_RadioButton"
        Me.Balance_Action_Cell10_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell10_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell10_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell10_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell10_Discharge_RadioButton
        '
        Me.Balance_Action_Cell10_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell10_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell10_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell10_Discharge_RadioButton.Name = "Balance_Action_Cell10_Discharge_RadioButton"
        Me.Balance_Action_Cell10_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell10_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell10_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell10_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell10_Charge_RadioButton
        '
        Me.Balance_Action_Cell10_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell10_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell10_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell10_Charge_RadioButton.Name = "Balance_Action_Cell10_Charge_RadioButton"
        Me.Balance_Action_Cell10_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell10_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell10_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell10_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell11_None_RadioButton
        '
        Me.Balance_Action_Cell11_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell11_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell11_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell11_None_RadioButton.Name = "Balance_Action_Cell11_None_RadioButton"
        Me.Balance_Action_Cell11_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell11_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell11_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell11_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell11_Discharge_RadioButton
        '
        Me.Balance_Action_Cell11_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell11_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell11_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell11_Discharge_RadioButton.Name = "Balance_Action_Cell11_Discharge_RadioButton"
        Me.Balance_Action_Cell11_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell11_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell11_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell11_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell11_Charge_RadioButton
        '
        Me.Balance_Action_Cell11_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell11_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell11_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell11_Charge_RadioButton.Name = "Balance_Action_Cell11_Charge_RadioButton"
        Me.Balance_Action_Cell11_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell11_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell11_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell11_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell12_None_RadioButton
        '
        Me.Balance_Action_Cell12_None_RadioButton.AutoSize = True
        Me.Balance_Action_Cell12_None_RadioButton.Enabled = False
        Me.Balance_Action_Cell12_None_RadioButton.Location = New System.Drawing.Point(7, 42)
        Me.Balance_Action_Cell12_None_RadioButton.Name = "Balance_Action_Cell12_None_RadioButton"
        Me.Balance_Action_Cell12_None_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell12_None_RadioButton.TabIndex = 23
        Me.Balance_Action_Cell12_None_RadioButton.TabStop = True
        Me.Balance_Action_Cell12_None_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell12_Discharge_RadioButton
        '
        Me.Balance_Action_Cell12_Discharge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell12_Discharge_RadioButton.Enabled = False
        Me.Balance_Action_Cell12_Discharge_RadioButton.Location = New System.Drawing.Point(7, 61)
        Me.Balance_Action_Cell12_Discharge_RadioButton.Name = "Balance_Action_Cell12_Discharge_RadioButton"
        Me.Balance_Action_Cell12_Discharge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell12_Discharge_RadioButton.TabIndex = 24
        Me.Balance_Action_Cell12_Discharge_RadioButton.TabStop = True
        Me.Balance_Action_Cell12_Discharge_RadioButton.UseVisualStyleBackColor = True
        '
        'Balance_Action_Cell12_Charge_RadioButton
        '
        Me.Balance_Action_Cell12_Charge_RadioButton.AutoSize = True
        Me.Balance_Action_Cell12_Charge_RadioButton.Enabled = False
        Me.Balance_Action_Cell12_Charge_RadioButton.Location = New System.Drawing.Point(7, 80)
        Me.Balance_Action_Cell12_Charge_RadioButton.Name = "Balance_Action_Cell12_Charge_RadioButton"
        Me.Balance_Action_Cell12_Charge_RadioButton.Size = New System.Drawing.Size(14, 13)
        Me.Balance_Action_Cell12_Charge_RadioButton.TabIndex = 25
        Me.Balance_Action_Cell12_Charge_RadioButton.TabStop = True
        Me.Balance_Action_Cell12_Charge_RadioButton.UseVisualStyleBackColor = True
        '
        'LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.Location = New System.Drawing.Point(33, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.Location = New System.Drawing.Point(10, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.Location = New System.Drawing.Point(33, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.Location = New System.Drawing.Point(10, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.Location = New System.Drawing.Point(33, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.Location = New System.Drawing.Point(10, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.Location = New System.Drawing.Point(33, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.Location = New System.Drawing.Point(10, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.Location = New System.Drawing.Point(33, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.Location = New System.Drawing.Point(10, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.Location = New System.Drawing.Point(34, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.TabIndex = 22
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.Location = New System.Drawing.Point(11, 17)
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.TabIndex = 21
        Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell1_TextBox
        '
        Me.Balance_Timer_Cell1_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell1_TextBox.Enabled = False
        Me.Balance_Timer_Cell1_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell1_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell1_TextBox.Name = "Balance_Timer_Cell1_TextBox"
        Me.Balance_Timer_Cell1_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell1_TextBox.TabIndex = 1
        Me.Balance_Timer_Cell1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell2_TextBox
        '
        Me.Balance_Timer_Cell2_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell2_TextBox.Enabled = False
        Me.Balance_Timer_Cell2_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell2_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell2_TextBox.Name = "Balance_Timer_Cell2_TextBox"
        Me.Balance_Timer_Cell2_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell2_TextBox.TabIndex = 2
        Me.Balance_Timer_Cell2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell3_TextBox
        '
        Me.Balance_Timer_Cell3_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell3_TextBox.Enabled = False
        Me.Balance_Timer_Cell3_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell3_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell3_TextBox.Name = "Balance_Timer_Cell3_TextBox"
        Me.Balance_Timer_Cell3_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell3_TextBox.TabIndex = 3
        Me.Balance_Timer_Cell3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell4_TextBox
        '
        Me.Balance_Timer_Cell4_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell4_TextBox.Enabled = False
        Me.Balance_Timer_Cell4_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell4_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell4_TextBox.Name = "Balance_Timer_Cell4_TextBox"
        Me.Balance_Timer_Cell4_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell4_TextBox.TabIndex = 4
        Me.Balance_Timer_Cell4_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell5_TextBox
        '
        Me.Balance_Timer_Cell5_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell5_TextBox.Enabled = False
        Me.Balance_Timer_Cell5_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell5_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell5_TextBox.Name = "Balance_Timer_Cell5_TextBox"
        Me.Balance_Timer_Cell5_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell5_TextBox.TabIndex = 5
        Me.Balance_Timer_Cell5_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell6_TextBox
        '
        Me.Balance_Timer_Cell6_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell6_TextBox.Enabled = False
        Me.Balance_Timer_Cell6_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell6_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell6_TextBox.Name = "Balance_Timer_Cell6_TextBox"
        Me.Balance_Timer_Cell6_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell6_TextBox.TabIndex = 6
        Me.Balance_Timer_Cell6_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell7_TextBox
        '
        Me.Balance_Timer_Cell7_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell7_TextBox.Enabled = False
        Me.Balance_Timer_Cell7_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell7_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell7_TextBox.Name = "Balance_Timer_Cell7_TextBox"
        Me.Balance_Timer_Cell7_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell7_TextBox.TabIndex = 7
        Me.Balance_Timer_Cell7_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell8_TextBox
        '
        Me.Balance_Timer_Cell8_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell8_TextBox.Enabled = False
        Me.Balance_Timer_Cell8_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell8_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell8_TextBox.Name = "Balance_Timer_Cell8_TextBox"
        Me.Balance_Timer_Cell8_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell8_TextBox.TabIndex = 8
        Me.Balance_Timer_Cell8_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell9_TextBox
        '
        Me.Balance_Timer_Cell9_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell9_TextBox.Enabled = False
        Me.Balance_Timer_Cell9_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell9_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell9_TextBox.Name = "Balance_Timer_Cell9_TextBox"
        Me.Balance_Timer_Cell9_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell9_TextBox.TabIndex = 9
        Me.Balance_Timer_Cell9_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell10_TextBox
        '
        Me.Balance_Timer_Cell10_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell10_TextBox.Enabled = False
        Me.Balance_Timer_Cell10_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell10_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell10_TextBox.Name = "Balance_Timer_Cell10_TextBox"
        Me.Balance_Timer_Cell10_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell10_TextBox.TabIndex = 10
        Me.Balance_Timer_Cell10_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell11_TextBox
        '
        Me.Balance_Timer_Cell11_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell11_TextBox.Enabled = False
        Me.Balance_Timer_Cell11_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell11_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell11_TextBox.Name = "Balance_Timer_Cell11_TextBox"
        Me.Balance_Timer_Cell11_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell11_TextBox.TabIndex = 11
        Me.Balance_Timer_Cell11_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Balance_Timer_Cell12_TextBox
        '
        Me.Balance_Timer_Cell12_TextBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Timer_Cell12_TextBox.Enabled = False
        Me.Balance_Timer_Cell12_TextBox.Location = New System.Drawing.Point(9, 119)
        Me.Balance_Timer_Cell12_TextBox.MaxLength = 5
        Me.Balance_Timer_Cell12_TextBox.Name = "Balance_Timer_Cell12_TextBox"
        Me.Balance_Timer_Cell12_TextBox.Size = New System.Drawing.Size(44, 20)
        Me.Balance_Timer_Cell12_TextBox.TabIndex = 12
        Me.Balance_Timer_Cell12_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Command_Label
        '
        Me.LTC3300_Command_Command_Label.AutoSize = True
        Me.LTC3300_Command_Command_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Command_Label.Location = New System.Drawing.Point(16, 74)
        Me.LTC3300_Command_Command_Label.Name = "LTC3300_Command_Command_Label"
        Me.LTC3300_Command_Command_Label.Size = New System.Drawing.Size(54, 13)
        Me.LTC3300_Command_Command_Label.TabIndex = 62
        Me.LTC3300_Command_Command_Label.Text = "Command"
        '
        'LTC3300_Command_Address_Label
        '
        Me.LTC3300_Command_Address_Label.AutoSize = True
        Me.LTC3300_Command_Address_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Address_Label.Location = New System.Drawing.Point(37, 30)
        Me.LTC3300_Command_Address_Label.Name = "LTC3300_Command_Address_Label"
        Me.LTC3300_Command_Address_Label.Size = New System.Drawing.Size(45, 13)
        Me.LTC3300_Command_Address_Label.TabIndex = 53
        Me.LTC3300_Command_Address_Label.Text = "Address"
        '
        'LTC3300_Command_Bit0_TextBox
        '
        Me.LTC3300_Command_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit0_TextBox.Location = New System.Drawing.Point(90, 91)
        Me.LTC3300_Command_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit0_TextBox.Name = "LTC3300_Command_Bit0_TextBox"
        Me.LTC3300_Command_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit0_TextBox.TabIndex = 61
        Me.LTC3300_Command_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit1_TextBox
        '
        Me.LTC3300_Command_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit1_TextBox.Location = New System.Drawing.Point(43, 91)
        Me.LTC3300_Command_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit1_TextBox.Name = "LTC3300_Command_Bit1_TextBox"
        Me.LTC3300_Command_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit1_TextBox.TabIndex = 60
        Me.LTC3300_Command_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit2_TextBox
        '
        Me.LTC3300_Command_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit2_TextBox.Location = New System.Drawing.Point(23, 91)
        Me.LTC3300_Command_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit2_TextBox.Name = "LTC3300_Command_Bit2_TextBox"
        Me.LTC3300_Command_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit2_TextBox.TabIndex = 59
        Me.LTC3300_Command_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit3_TextBox
        '
        Me.LTC3300_Command_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit3_TextBox.Location = New System.Drawing.Point(93, 45)
        Me.LTC3300_Command_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit3_TextBox.Name = "LTC3300_Command_Bit3_TextBox"
        Me.LTC3300_Command_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit3_TextBox.TabIndex = 58
        Me.LTC3300_Command_Bit3_TextBox.Text = "1"
        Me.LTC3300_Command_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit4_TextBox
        '
        Me.LTC3300_Command_Bit4_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit4_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit4_TextBox.Location = New System.Drawing.Point(73, 45)
        Me.LTC3300_Command_Bit4_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit4_TextBox.Name = "LTC3300_Command_Bit4_TextBox"
        Me.LTC3300_Command_Bit4_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit4_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit4_TextBox.TabIndex = 57
        Me.LTC3300_Command_Bit4_TextBox.Text = "0"
        Me.LTC3300_Command_Bit4_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit5_TextBox
        '
        Me.LTC3300_Command_Bit5_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit5_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit5_TextBox.Location = New System.Drawing.Point(53, 45)
        Me.LTC3300_Command_Bit5_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit5_TextBox.Name = "LTC3300_Command_Bit5_TextBox"
        Me.LTC3300_Command_Bit5_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit5_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit5_TextBox.TabIndex = 56
        Me.LTC3300_Command_Bit5_TextBox.Text = "1"
        Me.LTC3300_Command_Bit5_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit6_TextBox
        '
        Me.LTC3300_Command_Bit6_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit6_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit6_TextBox.Location = New System.Drawing.Point(33, 45)
        Me.LTC3300_Command_Bit6_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit6_TextBox.Name = "LTC3300_Command_Bit6_TextBox"
        Me.LTC3300_Command_Bit6_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit6_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit6_TextBox.TabIndex = 55
        Me.LTC3300_Command_Bit6_TextBox.Text = "0"
        Me.LTC3300_Command_Bit6_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Bit7_TextBox
        '
        Me.LTC3300_Command_Bit7_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Command_Bit7_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Bit7_TextBox.Location = New System.Drawing.Point(13, 45)
        Me.LTC3300_Command_Bit7_TextBox.MaxLength = 1
        Me.LTC3300_Command_Bit7_TextBox.Name = "LTC3300_Command_Bit7_TextBox"
        Me.LTC3300_Command_Bit7_TextBox.ReadOnly = True
        Me.LTC3300_Command_Bit7_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Command_Bit7_TextBox.TabIndex = 54
        Me.LTC3300_Command_Bit7_TextBox.Text = "1"
        Me.LTC3300_Command_Bit7_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Command_Parity_Label
        '
        Me.LTC3300_Command_Parity_Label.AutoSize = True
        Me.LTC3300_Command_Parity_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Command_Parity_Label.Location = New System.Drawing.Point(83, 74)
        Me.LTC3300_Command_Parity_Label.Name = "LTC3300_Command_Parity_Label"
        Me.LTC3300_Command_Parity_Label.Size = New System.Drawing.Size(33, 13)
        Me.LTC3300_Command_Parity_Label.TabIndex = 63
        Me.LTC3300_Command_Parity_Label.Text = "Parity"
        '
        'LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 39)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.TabIndex = 61
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 39)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.TabIndex = 60
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 39)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.TabIndex = 59
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 39)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.Name = "LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox"
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.TabIndex = 58
        Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 39)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.TabIndex = 61
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 39)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.TabIndex = 60
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 39)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.TabIndex = 59
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox
        '
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 39)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.Name = "LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox"
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.TabIndex = 58
        Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'lstResults
        '
        Me.lstResults.BackColor = System.Drawing.SystemColors.Window
        Me.lstResults.Cursor = System.Windows.Forms.Cursors.Default
        Me.lstResults.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lstResults.ForeColor = System.Drawing.SystemColors.WindowText
        Me.lstResults.HorizontalScrollbar = True
        Me.lstResults.ItemHeight = 16
        Me.lstResults.Location = New System.Drawing.Point(27, 47)
        Me.lstResults.Name = "lstResults"
        Me.lstResults.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.lstResults.Size = New System.Drawing.Size(306, 148)
        Me.lstResults.TabIndex = 0
        '
        'BulkReadButton
        '
        Me.BulkReadButton.BackColor = System.Drawing.Color.Silver
        Me.BulkReadButton.Enabled = False
        Me.BulkReadButton.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.BulkReadButton.Location = New System.Drawing.Point(362, 145)
        Me.BulkReadButton.Name = "BulkReadButton"
        Me.BulkReadButton.Size = New System.Drawing.Size(120, 25)
        Me.BulkReadButton.TabIndex = 12
        Me.BulkReadButton.Text = "Read Data String"
        Me.BulkReadButton.UseVisualStyleBackColor = False
        '
        'BulkWriteButton
        '
        Me.BulkWriteButton.BackColor = System.Drawing.Color.Silver
        Me.BulkWriteButton.Cursor = System.Windows.Forms.Cursors.Default
        Me.BulkWriteButton.Enabled = False
        Me.BulkWriteButton.Font = New System.Drawing.Font("Arial", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.BulkWriteButton.ForeColor = System.Drawing.SystemColors.ControlText
        Me.BulkWriteButton.Location = New System.Drawing.Point(362, 87)
        Me.BulkWriteButton.Name = "BulkWriteButton"
        Me.BulkWriteButton.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.BulkWriteButton.Size = New System.Drawing.Size(120, 25)
        Me.BulkWriteButton.TabIndex = 8
        Me.BulkWriteButton.Text = "Write Data String"
        Me.BulkWriteButton.UseVisualStyleBackColor = False
        '
        'txtBulkDataWrite
        '
        Me.txtBulkDataWrite.BackColor = System.Drawing.SystemColors.Window
        Me.txtBulkDataWrite.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.txtBulkDataWrite.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtBulkDataWrite.ForeColor = System.Drawing.SystemColors.WindowText
        Me.txtBulkDataWrite.Location = New System.Drawing.Point(362, 114)
        Me.txtBulkDataWrite.MaxLength = 0
        Me.txtBulkDataWrite.Name = "txtBulkDataWrite"
        Me.txtBulkDataWrite.ReadOnly = True
        Me.txtBulkDataWrite.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.txtBulkDataWrite.Size = New System.Drawing.Size(477, 22)
        Me.txtBulkDataWrite.TabIndex = 5
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.Location = New System.Drawing.Point(360, 31)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(144, 16)
        Me.Label1.TabIndex = 14
        Me.Label1.Text = "Current Active Device"
        '
        'ComboBox1
        '
        Me.ComboBox1.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.ComboBox1.FormattingEnabled = True
        Me.ComboBox1.Location = New System.Drawing.Point(362, 48)
        Me.ComboBox1.Name = "ComboBox1"
        Me.ComboBox1.Size = New System.Drawing.Size(477, 24)
        Me.ComboBox1.TabIndex = 15
        '
        'BulkInCheckBox
        '
        Me.BulkInCheckBox.AutoSize = True
        Me.BulkInCheckBox.Location = New System.Drawing.Point(650, 193)
        Me.BulkInCheckBox.Name = "BulkInCheckBox"
        Me.BulkInCheckBox.Size = New System.Drawing.Size(145, 18)
        Me.BulkInCheckBox.TabIndex = 16
        Me.BulkInCheckBox.Text = "Device has a Bulk In port"
        Me.BulkInCheckBox.UseVisualStyleBackColor = True
        Me.BulkInCheckBox.Visible = False
        '
        'BulkOutCheckBox
        '
        Me.BulkOutCheckBox.AutoSize = True
        Me.BulkOutCheckBox.Location = New System.Drawing.Point(832, 192)
        Me.BulkOutCheckBox.Name = "BulkOutCheckBox"
        Me.BulkOutCheckBox.Size = New System.Drawing.Size(154, 18)
        Me.BulkOutCheckBox.TabIndex = 17
        Me.BulkOutCheckBox.Text = "Device has a Bulk Out port"
        Me.BulkOutCheckBox.UseVisualStyleBackColor = True
        Me.BulkOutCheckBox.Visible = False
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(647, 208)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(87, 14)
        Me.Label2.TabIndex = 20
        Me.Label2.Text = "Port size (bytes)"
        Me.Label2.Visible = False
        '
        'BulkInSizeTextBox
        '
        Me.BulkInSizeTextBox.Location = New System.Drawing.Point(650, 220)
        Me.BulkInSizeTextBox.Name = "BulkInSizeTextBox"
        Me.BulkInSizeTextBox.ReadOnly = True
        Me.BulkInSizeTextBox.Size = New System.Drawing.Size(68, 20)
        Me.BulkInSizeTextBox.TabIndex = 21
        Me.BulkInSizeTextBox.Visible = False
        '
        'BulkOutSizeTextBox
        '
        Me.BulkOutSizeTextBox.Location = New System.Drawing.Point(882, 220)
        Me.BulkOutSizeTextBox.Name = "BulkOutSizeTextBox"
        Me.BulkOutSizeTextBox.ReadOnly = True
        Me.BulkOutSizeTextBox.Size = New System.Drawing.Size(68, 20)
        Me.BulkOutSizeTextBox.TabIndex = 23
        Me.BulkOutSizeTextBox.Visible = False
        '
        'Label3
        '
        Me.Label3.AutoSize = True
        Me.Label3.Location = New System.Drawing.Point(841, 204)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(87, 14)
        Me.Label3.TabIndex = 22
        Me.Label3.Text = "Port size (bytes)"
        Me.Label3.Visible = False
        '
        'Label4
        '
        Me.Label4.AutoSize = True
        Me.Label4.Location = New System.Drawing.Point(654, 272)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(87, 14)
        Me.Label4.TabIndex = 24
        Me.Label4.Text = "Port size (bytes)"
        Me.Label4.Visible = False
        '
        'Label5
        '
        Me.Label5.AutoSize = True
        Me.Label5.Location = New System.Drawing.Point(805, 288)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(87, 14)
        Me.Label5.TabIndex = 26
        Me.Label5.Text = "Port size (bytes)"
        Me.Label5.Visible = False
        '
        'DeviceProviderTextBox
        '
        Me.DeviceProviderTextBox.Location = New System.Drawing.Point(239, -50)
        Me.DeviceProviderTextBox.Name = "DeviceProviderTextBox"
        Me.DeviceProviderTextBox.ReadOnly = True
        Me.DeviceProviderTextBox.Size = New System.Drawing.Size(266, 20)
        Me.DeviceProviderTextBox.TabIndex = 28
        Me.DeviceProviderTextBox.Visible = False
        '
        'Label6
        '
        Me.Label6.AutoSize = True
        Me.Label6.Location = New System.Drawing.Point(246, -69)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(83, 14)
        Me.Label6.TabIndex = 29
        Me.Label6.Text = "Device provider"
        Me.Label6.Visible = False
        '
        'Label7
        '
        Me.Label7.AutoSize = True
        Me.Label7.Location = New System.Drawing.Point(246, 41)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(186, 14)
        Me.Label7.TabIndex = 31
        Me.Label7.Text = "USB Specification revision supported"
        Me.Label7.Visible = False
        '
        'USBRevTextBox
        '
        Me.USBRevTextBox.Location = New System.Drawing.Point(239, 60)
        Me.USBRevTextBox.Name = "USBRevTextBox"
        Me.USBRevTextBox.ReadOnly = True
        Me.USBRevTextBox.Size = New System.Drawing.Size(114, 20)
        Me.USBRevTextBox.TabIndex = 30
        Me.USBRevTextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.USBRevTextBox.Visible = False
        '
        'Label8
        '
        Me.Label8.AutoSize = True
        Me.Label8.Location = New System.Drawing.Point(252, 91)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(81, 14)
        Me.Label8.TabIndex = 33
        Me.Label8.Text = "Device revision"
        Me.Label8.Visible = False
        '
        'DeviceRevTextBox
        '
        Me.DeviceRevTextBox.Location = New System.Drawing.Point(239, 108)
        Me.DeviceRevTextBox.Name = "DeviceRevTextBox"
        Me.DeviceRevTextBox.ReadOnly = True
        Me.DeviceRevTextBox.Size = New System.Drawing.Size(114, 20)
        Me.DeviceRevTextBox.TabIndex = 32
        Me.DeviceRevTextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.DeviceRevTextBox.Visible = False
        '
        'Label9
        '
        Me.Label9.AutoSize = True
        Me.Label9.Location = New System.Drawing.Point(246, -8)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(86, 14)
        Me.Label9.TabIndex = 35
        Me.Label9.Text = "Device data rate"
        Me.Label9.Visible = False
        '
        'DeviceSpeedTextBox
        '
        Me.DeviceSpeedTextBox.Location = New System.Drawing.Point(239, 11)
        Me.DeviceSpeedTextBox.Name = "DeviceSpeedTextBox"
        Me.DeviceSpeedTextBox.ReadOnly = True
        Me.DeviceSpeedTextBox.Size = New System.Drawing.Size(266, 20)
        Me.DeviceSpeedTextBox.TabIndex = 34
        Me.DeviceSpeedTextBox.Visible = False
        '
        'BulkReadWorker
        '
        Me.BulkReadWorker.WorkerSupportsCancellation = True
        '
        'AutoBulkReadWorker
        '
        Me.AutoBulkReadWorker.WorkerSupportsCancellation = True
        '
        'TxtBulkDataRead
        '
        Me.TxtBulkDataRead.BackColor = System.Drawing.SystemColors.Window
        Me.TxtBulkDataRead.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.TxtBulkDataRead.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TxtBulkDataRead.ForeColor = System.Drawing.SystemColors.WindowText
        Me.TxtBulkDataRead.Location = New System.Drawing.Point(362, 172)
        Me.TxtBulkDataRead.MaxLength = 0
        Me.TxtBulkDataRead.Name = "TxtBulkDataRead"
        Me.TxtBulkDataRead.ReadOnly = True
        Me.TxtBulkDataRead.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.TxtBulkDataRead.Size = New System.Drawing.Size(477, 22)
        Me.TxtBulkDataRead.TabIndex = 36
        '
        'Label10
        '
        Me.Label10.AutoSize = True
        Me.Label10.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label10.Location = New System.Drawing.Point(24, 26)
        Me.Label10.Name = "Label10"
        Me.Label10.Size = New System.Drawing.Size(188, 18)
        Me.Label10.TabIndex = 37
        Me.Label10.Text = "System Status Information"
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.CheckBox2)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.lstResults)
        Me.GroupBox1.Controls.Add(Me.ComboBox1)
        Me.GroupBox1.Controls.Add(Me.TxtBulkDataRead)
        Me.GroupBox1.Controls.Add(Me.BulkWriteButton)
        Me.GroupBox1.Controls.Add(Me.Label10)
        Me.GroupBox1.Controls.Add(Me.txtBulkDataWrite)
        Me.GroupBox1.Controls.Add(Me.BulkReadButton)
        Me.GroupBox1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox1.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox1.Location = New System.Drawing.Point(10, 131)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(862, 212)
        Me.GroupBox1.TabIndex = 42
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "USB IO"
        '
        'CheckBox2
        '
        Me.CheckBox2.AutoSize = True
        Me.CheckBox2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBox2.Location = New System.Drawing.Point(498, 91)
        Me.CheckBox2.Name = "CheckBox2"
        Me.CheckBox2.Size = New System.Drawing.Size(124, 17)
        Me.CheckBox2.TabIndex = 38
        Me.CheckBox2.Text = "Enable Manual Input"
        Me.CheckBox2.UseVisualStyleBackColor = True
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.Label6)
        Me.GroupBox2.Controls.Add(Me.DeviceProviderTextBox)
        Me.GroupBox2.Controls.Add(Me.USBRevTextBox)
        Me.GroupBox2.Controls.Add(Me.Label7)
        Me.GroupBox2.Controls.Add(Me.Label8)
        Me.GroupBox2.Controls.Add(Me.DeviceRevTextBox)
        Me.GroupBox2.Controls.Add(Me.DeviceSpeedTextBox)
        Me.GroupBox2.Controls.Add(Me.Label9)
        Me.GroupBox2.Location = New System.Drawing.Point(37, 178)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(513, 170)
        Me.GroupBox2.TabIndex = 43
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Visible = False
        '
        'RemovalTimer
        '
        Me.RemovalTimer.Interval = 3000
        '
        'Data_Log_Timer
        '
        '
        'TreeView1
        '
        Me.TreeView1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.TreeView1.HideSelection = False
        Me.TreeView1.ImageIndex = 0
        Me.TreeView1.ImageList = Me.ImageList1
        Me.TreeView1.Location = New System.Drawing.Point(5, 76)
        Me.TreeView1.Name = "TreeView1"
        Me.TreeView1.SelectedImageIndex = 0
        Me.TreeView1.Size = New System.Drawing.Size(183, 673)
        Me.TreeView1.TabIndex = 309
        '
        'ImageList1
        '
        Me.ImageList1.ImageStream = CType(resources.GetObject("ImageList1.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList1.TransparentColor = System.Drawing.Color.Transparent
        Me.ImageList1.Images.SetKeyName(0, "chip.png")
        Me.ImageList1.Images.SetKeyName(1, "circle_green.png")
        Me.ImageList1.Images.SetKeyName(2, "circle_red.png")
        Me.ImageList1.Images.SetKeyName(3, "circle_lightgreen.png")
        Me.ImageList1.Images.SetKeyName(4, "circle_lightred.png")
        '
        'SplitContainer1
        '
        Me.SplitContainer1.Location = New System.Drawing.Point(194, 54)
        Me.SplitContainer1.Name = "SplitContainer1"
        Me.SplitContainer1.Orientation = System.Windows.Forms.Orientation.Horizontal
        '
        'SplitContainer1.Panel1
        '
        Me.SplitContainer1.Panel1.Controls.Add(Me.TabControl1)
        Me.SplitContainer1.Panel1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.SplitContainer1.Panel1MinSize = 100
        '
        'SplitContainer1.Panel2
        '
        Me.SplitContainer1.Panel2.BackColor = System.Drawing.Color.Silver
        Me.SplitContainer1.Panel2.Controls.Add(Me.Data_Logging_GroupBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Base_Balance_Current_GroupBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Max_Min_Cell_Voltage_GroupBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.GroupBox2)
        Me.SplitContainer1.Panel2.Controls.Add(Me.ShapeContainer3)
        Me.SplitContainer1.Panel2.Controls.Add(Me.GroupBox1)
        Me.SplitContainer1.Panel2.Controls.Add(Me.BulkOutSizeTextBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.BulkInSizeTextBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Label5)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Label2)
        Me.SplitContainer1.Panel2.Controls.Add(Me.BulkInCheckBox)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Label3)
        Me.SplitContainer1.Panel2.Controls.Add(Me.Label4)
        Me.SplitContainer1.Panel2.Controls.Add(Me.BulkOutCheckBox)
        Me.SplitContainer1.Panel2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.SplitContainer1.Panel2MinSize = 131
        Me.SplitContainer1.Size = New System.Drawing.Size(1037, 675)
        Me.SplitContainer1.SplitterDistance = 540
        Me.SplitContainer1.TabIndex = 308
        '
        'TabControl1
        '
        Me.TabControl1.Controls.Add(Me.TabPage1)
        Me.TabControl1.Controls.Add(Me.TabPage2)
        Me.TabControl1.Location = New System.Drawing.Point(-3, 0)
        Me.TabControl1.Name = "TabControl1"
        Me.TabControl1.SelectedIndex = 0
        Me.TabControl1.Size = New System.Drawing.Size(1043, 543)
        Me.TabControl1.TabIndex = 305
        '
        'TabPage1
        '
        Me.TabPage1.AutoScroll = True
        Me.TabPage1.BackColor = System.Drawing.Color.Silver
        Me.TabPage1.Controls.Add(Me.Debug2_TextBox)
        Me.TabPage1.Controls.Add(Me.Balance_Control_GroupBox)
        Me.TabPage1.Controls.Add(Me.Panel5)
        Me.TabPage1.Controls.Add(Me.Panel4)
        Me.TabPage1.Controls.Add(Me.GroupBox5)
        Me.TabPage1.Controls.Add(Me.GroupBox19)
        Me.TabPage1.Controls.Add(Me.groupBox9)
        Me.TabPage1.Location = New System.Drawing.Point(4, 23)
        Me.TabPage1.Name = "TabPage1"
        Me.TabPage1.Size = New System.Drawing.Size(1035, 516)
        Me.TabPage1.TabIndex = 0
        Me.TabPage1.Text = " Cells"
        '
        'Debug2_TextBox
        '
        Me.Debug2_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Debug2_TextBox.Enabled = False
        Me.Debug2_TextBox.Location = New System.Drawing.Point(581, -1)
        Me.Debug2_TextBox.Name = "Debug2_TextBox"
        Me.Debug2_TextBox.Size = New System.Drawing.Size(449, 20)
        Me.Debug2_TextBox.TabIndex = 318
        Me.Debug2_TextBox.Visible = False
        '
        'Balance_Control_GroupBox
        '
        Me.Balance_Control_GroupBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Control_GroupBox.Controls.Add(Me.Balance_Control_Manual_GroupBox)
        Me.Balance_Control_GroupBox.Controls.Add(Me.Balance_Control_Timed_GroupBox)
        Me.Balance_Control_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.Balance_Control_GroupBox.Location = New System.Drawing.Point(2, 6)
        Me.Balance_Control_GroupBox.Name = "Balance_Control_GroupBox"
        Me.Balance_Control_GroupBox.Size = New System.Drawing.Size(145, 503)
        Me.Balance_Control_GroupBox.TabIndex = 320
        Me.Balance_Control_GroupBox.TabStop = False
        Me.Balance_Control_GroupBox.Text = "BALANCE CONTROL"
        '
        'Balance_Control_Manual_GroupBox
        '
        Me.Balance_Control_Manual_GroupBox.BackColor = System.Drawing.Color.Silver
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.GroupBox3)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.Balance_Control_Manual_CheckBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Command_Label)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.Balance_Control_Manual_Read_Command_Button)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit2_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.Balance_Control_Manual_Read_Status_Button)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit1_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit0_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Address_Label)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.Balance_Control_Manual_Write_Command_Button)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Parity_Label)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit3_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit7_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit4_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit6_TextBox)
        Me.Balance_Control_Manual_GroupBox.Controls.Add(Me.LTC3300_Command_Bit5_TextBox)
        Me.Balance_Control_Manual_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Balance_Control_Manual_GroupBox.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Manual_GroupBox.Location = New System.Drawing.Point(6, 11)
        Me.Balance_Control_Manual_GroupBox.Name = "Balance_Control_Manual_GroupBox"
        Me.Balance_Control_Manual_GroupBox.Size = New System.Drawing.Size(133, 280)
        Me.Balance_Control_Manual_GroupBox.TabIndex = 267
        Me.Balance_Control_Manual_GroupBox.TabStop = False
        '
        'GroupBox3
        '
        Me.GroupBox3.Controls.Add(Me.Balance_Control_Manual_Execute_Button)
        Me.GroupBox3.Controls.Add(Me.Balance_Control_Manual_Suspend_Button)
        Me.GroupBox3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox3.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox3.Location = New System.Drawing.Point(9, 200)
        Me.GroupBox3.Margin = New System.Windows.Forms.Padding(0)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Padding = New System.Windows.Forms.Padding(0)
        Me.GroupBox3.Size = New System.Drawing.Size(111, 74)
        Me.GroupBox3.TabIndex = 319
        Me.GroupBox3.TabStop = False
        '
        'Balance_Control_Timed_GroupBox
        '
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Time_Remaining_Value_Label)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Next_Stop_Value_Label)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Time_Remaining_Label)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Next_Stop_Label)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Timed_CheckBox)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Timed_StartStop_Button)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Timed_Reset_Button)
        Me.Balance_Control_Timed_GroupBox.Controls.Add(Me.Balance_Control_Timed_Write_Button)
        Me.Balance_Control_Timed_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Balance_Control_Timed_GroupBox.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Balance_Control_Timed_GroupBox.Location = New System.Drawing.Point(6, 291)
        Me.Balance_Control_Timed_GroupBox.Name = "Balance_Control_Timed_GroupBox"
        Me.Balance_Control_Timed_GroupBox.Size = New System.Drawing.Size(133, 205)
        Me.Balance_Control_Timed_GroupBox.TabIndex = 268
        Me.Balance_Control_Timed_GroupBox.TabStop = False
        '
        'Balance_Control_Time_Remaining_Value_Label
        '
        Me.Balance_Control_Time_Remaining_Value_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Time_Remaining_Value_Label.Location = New System.Drawing.Point(3, 89)
        Me.Balance_Control_Time_Remaining_Value_Label.Name = "Balance_Control_Time_Remaining_Value_Label"
        Me.Balance_Control_Time_Remaining_Value_Label.Size = New System.Drawing.Size(127, 17)
        Me.Balance_Control_Time_Remaining_Value_Label.TabIndex = 318
        Me.Balance_Control_Time_Remaining_Value_Label.Text = "0:00:00 Total"
        Me.Balance_Control_Time_Remaining_Value_Label.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'Balance_Control_Next_Stop_Value_Label
        '
        Me.Balance_Control_Next_Stop_Value_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Next_Stop_Value_Label.Location = New System.Drawing.Point(3, 53)
        Me.Balance_Control_Next_Stop_Value_Label.Name = "Balance_Control_Next_Stop_Value_Label"
        Me.Balance_Control_Next_Stop_Value_Label.Size = New System.Drawing.Size(127, 14)
        Me.Balance_Control_Next_Stop_Value_Label.TabIndex = 317
        Me.Balance_Control_Next_Stop_Value_Label.Text = "0.0 s"
        Me.Balance_Control_Next_Stop_Value_Label.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'Balance_Control_Time_Remaining_Label
        '
        Me.Balance_Control_Time_Remaining_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Time_Remaining_Label.Location = New System.Drawing.Point(3, 74)
        Me.Balance_Control_Time_Remaining_Label.Name = "Balance_Control_Time_Remaining_Label"
        Me.Balance_Control_Time_Remaining_Label.Size = New System.Drawing.Size(127, 15)
        Me.Balance_Control_Time_Remaining_Label.TabIndex = 65
        Me.Balance_Control_Time_Remaining_Label.Text = "TIME REMAINING:" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10)
        Me.Balance_Control_Time_Remaining_Label.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'Balance_Control_Next_Stop_Label
        '
        Me.Balance_Control_Next_Stop_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Next_Stop_Label.Location = New System.Drawing.Point(3, 38)
        Me.Balance_Control_Next_Stop_Label.Name = "Balance_Control_Next_Stop_Label"
        Me.Balance_Control_Next_Stop_Label.Size = New System.Drawing.Size(127, 16)
        Me.Balance_Control_Next_Stop_Label.TabIndex = 64
        Me.Balance_Control_Next_Stop_Label.Text = "NEXT STOP TIME:"
        Me.Balance_Control_Next_Stop_Label.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'Balance_Control_Timed_StartStop_Button
        '
        Me.Balance_Control_Timed_StartStop_Button.Enabled = False
        Me.Balance_Control_Timed_StartStop_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Timed_StartStop_Button.Location = New System.Drawing.Point(14, 139)
        Me.Balance_Control_Timed_StartStop_Button.Name = "Balance_Control_Timed_StartStop_Button"
        Me.Balance_Control_Timed_StartStop_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Timed_StartStop_Button.TabIndex = 62
        Me.Balance_Control_Timed_StartStop_Button.Text = "Start"
        Me.Balance_Control_Timed_StartStop_Button.UseVisualStyleBackColor = True
        '
        'Balance_Control_Timed_Reset_Button
        '
        Me.Balance_Control_Timed_Reset_Button.Enabled = False
        Me.Balance_Control_Timed_Reset_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Timed_Reset_Button.Location = New System.Drawing.Point(14, 169)
        Me.Balance_Control_Timed_Reset_Button.Name = "Balance_Control_Timed_Reset_Button"
        Me.Balance_Control_Timed_Reset_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Timed_Reset_Button.TabIndex = 63
        Me.Balance_Control_Timed_Reset_Button.Text = "Reset"
        Me.Balance_Control_Timed_Reset_Button.UseVisualStyleBackColor = True
        '
        'Balance_Control_Timed_Write_Button
        '
        Me.Balance_Control_Timed_Write_Button.Enabled = False
        Me.Balance_Control_Timed_Write_Button.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.Balance_Control_Timed_Write_Button.Location = New System.Drawing.Point(14, 109)
        Me.Balance_Control_Timed_Write_Button.Name = "Balance_Control_Timed_Write_Button"
        Me.Balance_Control_Timed_Write_Button.Size = New System.Drawing.Size(100, 25)
        Me.Balance_Control_Timed_Write_Button.TabIndex = 61
        Me.Balance_Control_Timed_Write_Button.Text = "Write"
        Me.Balance_Control_Timed_Write_Button.UseVisualStyleBackColor = True
        '
        'Panel5
        '
        Me.Panel5.BackColor = System.Drawing.Color.DarkGray
        Me.Panel5.Controls.Add(Me.Config_Load_NumericUpDown)
        Me.Panel5.Controls.Add(Me.Config_Save_NumericUpDown)
        Me.Panel5.Controls.Add(Me.Config_Load_Button)
        Me.Panel5.Controls.Add(Me.Config_Save_Button)
        Me.Panel5.Controls.Add(Me.Config_Demo_Button)
        Me.Panel5.Location = New System.Drawing.Point(881, 399)
        Me.Panel5.Name = "Panel5"
        Me.Panel5.Size = New System.Drawing.Size(133, 110)
        Me.Panel5.TabIndex = 272
        '
        'Config_Load_NumericUpDown
        '
        Me.Config_Load_NumericUpDown.Enabled = False
        Me.Config_Load_NumericUpDown.Font = New System.Drawing.Font("Arial", 9.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Config_Load_NumericUpDown.Location = New System.Drawing.Point(88, 76)
        Me.Config_Load_NumericUpDown.Maximum = New Decimal(New Integer() {1, 0, 0, 0})
        Me.Config_Load_NumericUpDown.Minimum = New Decimal(New Integer() {1, 0, 0, 0})
        Me.Config_Load_NumericUpDown.Name = "Config_Load_NumericUpDown"
        Me.Config_Load_NumericUpDown.Size = New System.Drawing.Size(34, 21)
        Me.Config_Load_NumericUpDown.TabIndex = 314
        Me.Config_Load_NumericUpDown.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.Config_Load_NumericUpDown.Value = New Decimal(New Integer() {1, 0, 0, 0})
        '
        'Config_Save_NumericUpDown
        '
        Me.Config_Save_NumericUpDown.Enabled = False
        Me.Config_Save_NumericUpDown.Font = New System.Drawing.Font("Arial", 9.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Config_Save_NumericUpDown.Location = New System.Drawing.Point(88, 43)
        Me.Config_Save_NumericUpDown.Maximum = New Decimal(New Integer() {1, 0, 0, 0})
        Me.Config_Save_NumericUpDown.Minimum = New Decimal(New Integer() {1, 0, 0, 0})
        Me.Config_Save_NumericUpDown.Name = "Config_Save_NumericUpDown"
        Me.Config_Save_NumericUpDown.Size = New System.Drawing.Size(34, 21)
        Me.Config_Save_NumericUpDown.TabIndex = 313
        Me.Config_Save_NumericUpDown.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.Config_Save_NumericUpDown.Value = New Decimal(New Integer() {1, 0, 0, 0})
        '
        'Panel4
        '
        Me.Panel4.BackColor = System.Drawing.Color.DarkGray
        Me.Panel4.Controls.Add(Me.autoReadBox)
        Me.Panel4.Controls.Add(Me.ButtonRV)
        Me.Panel4.Location = New System.Drawing.Point(881, 16)
        Me.Panel4.Name = "Panel4"
        Me.Panel4.Size = New System.Drawing.Size(133, 83)
        Me.Panel4.TabIndex = 271
        '
        'GroupBox5
        '
        Me.GroupBox5.Controls.Add(Me.Label100)
        Me.GroupBox5.Controls.Add(Me.Label97)
        Me.GroupBox5.Controls.Add(Me.Label96)
        Me.GroupBox5.Controls.Add(Me.Temperature_ADC_Test_IC2_Checkbox)
        Me.GroupBox5.Controls.Add(Me.Passive_Balancer_Test_IC2_Checkbox)
        Me.GroupBox5.Controls.Add(Me.Temperature_IC2_GroupBox)
        Me.GroupBox5.Controls.Add(Me.Label113)
        Me.GroupBox5.Controls.Add(Me.label73)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.label64)
        Me.GroupBox5.Controls.Add(Me.label65)
        Me.GroupBox5.Controls.Add(Me.Label72)
        Me.GroupBox5.Controls.Add(Me.Label75)
        Me.GroupBox5.Controls.Add(Me.Label76)
        Me.GroupBox5.Controls.Add(Me.Label77)
        Me.GroupBox5.Controls.Add(Me.Label78)
        Me.GroupBox5.Controls.Add(Me.Label79)
        Me.GroupBox5.Controls.Add(Me.Label80)
        Me.GroupBox5.Controls.Add(Me.Label81)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox)
        Me.GroupBox5.Controls.Add(Me.Label82)
        Me.GroupBox5.Controls.Add(Me.Label83)
        Me.GroupBox5.Controls.Add(Me.Label84)
        Me.GroupBox5.Controls.Add(Me.Label85)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox)
        Me.GroupBox5.Controls.Add(Me.Label86)
        Me.GroupBox5.Controls.Add(Me.Label87)
        Me.GroupBox5.Controls.Add(Me.Label88)
        Me.GroupBox5.Controls.Add(Me.Label89)
        Me.GroupBox5.Controls.Add(Me.Label90)
        Me.GroupBox5.Controls.Add(Me.Label91)
        Me.GroupBox5.Controls.Add(Me.Label92)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox)
        Me.GroupBox5.Controls.Add(Me.Label93)
        Me.GroupBox5.Controls.Add(Me.Label94)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox)
        Me.GroupBox5.Controls.Add(Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox)
        Me.GroupBox5.Controls.Add(Me.Label95)
        Me.GroupBox5.Controls.Add(Me.ShapeContainer1)
        Me.GroupBox5.Controls.Add(Me.groupBox8)
        Me.GroupBox5.Controls.Add(Me.groupBox7)
        Me.GroupBox5.Controls.Add(Me.GroupBox6)
        Me.GroupBox5.Controls.Add(Me.GroupBox16)
        Me.GroupBox5.Controls.Add(Me.GroupBox17)
        Me.GroupBox5.Controls.Add(Me.GroupBox18)
        Me.GroupBox5.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox5.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox5.Location = New System.Drawing.Point(150, 6)
        Me.GroupBox5.Name = "GroupBox5"
        Me.GroupBox5.Size = New System.Drawing.Size(724, 250)
        Me.GroupBox5.TabIndex = 265
        Me.GroupBox5.TabStop = False
        Me.GroupBox5.Text = "BALANCING ACTION FOR IC 2 (CELLS 7 - 12)"
        '
        'Label100
        '
        Me.Label100.AutoSize = True
        Me.Label100.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label100.Location = New System.Drawing.Point(6, 41)
        Me.Label100.Name = "Label100"
        Me.Label100.Size = New System.Drawing.Size(102, 13)
        Me.Label100.TabIndex = 322
        Me.Label100.Text = "WRITE COMMAND"
        '
        'Label97
        '
        Me.Label97.AutoSize = True
        Me.Label97.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label97.Location = New System.Drawing.Point(664, 195)
        Me.Label97.Name = "Label97"
        Me.Label97.Size = New System.Drawing.Size(31, 26)
        Me.Label97.TabIndex = 321
        Me.Label97.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.Label97.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label96
        '
        Me.Label96.AutoSize = True
        Me.Label96.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label96.Location = New System.Drawing.Point(588, 207)
        Me.Label96.Name = "Label96"
        Me.Label96.Size = New System.Drawing.Size(44, 13)
        Me.Label96.TabIndex = 320
        Me.Label96.Text = "Unused"
        Me.Label96.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Temperature_IC2_GroupBox
        '
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp12_Label)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp9_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp9_Label)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp12_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp7_Label)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp11_Label)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp8_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp10_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp7_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp11_TextBox)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp8_Label)
        Me.Temperature_IC2_GroupBox.Controls.Add(Me.Temperature_IC2_Temp10_Label)
        Me.Temperature_IC2_GroupBox.Location = New System.Drawing.Point(500, 65)
        Me.Temperature_IC2_GroupBox.Name = "Temperature_IC2_GroupBox"
        Me.Temperature_IC2_GroupBox.Size = New System.Drawing.Size(221, 84)
        Me.Temperature_IC2_GroupBox.TabIndex = 318
        Me.Temperature_IC2_GroupBox.TabStop = False
        Me.Temperature_IC2_GroupBox.Text = "Temperature IC2"
        '
        'Temperature_IC2_Temp12_Label
        '
        Me.Temperature_IC2_Temp12_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp12_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp12_Label.Location = New System.Drawing.Point(110, 16)
        Me.Temperature_IC2_Temp12_Label.Name = "Temperature_IC2_Temp12_Label"
        Me.Temperature_IC2_Temp12_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp12_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp12_Label.TabIndex = 291
        Me.Temperature_IC2_Temp12_Label.Text = "Temp 12"
        Me.Temperature_IC2_Temp12_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC2_Temp9_TextBox
        '
        Me.Temperature_IC2_Temp9_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp9_TextBox.Enabled = False
        Me.Temperature_IC2_Temp9_TextBox.Location = New System.Drawing.Point(53, 16)
        Me.Temperature_IC2_Temp9_TextBox.Name = "Temperature_IC2_Temp9_TextBox"
        Me.Temperature_IC2_Temp9_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp9_TextBox.TabIndex = 286
        '
        'Temperature_IC2_Temp9_Label
        '
        Me.Temperature_IC2_Temp9_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp9_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp9_Label.Location = New System.Drawing.Point(2, 16)
        Me.Temperature_IC2_Temp9_Label.Name = "Temperature_IC2_Temp9_Label"
        Me.Temperature_IC2_Temp9_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp9_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp9_Label.TabIndex = 285
        Me.Temperature_IC2_Temp9_Label.Text = "Temp 9"
        Me.Temperature_IC2_Temp9_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC2_Temp12_TextBox
        '
        Me.Temperature_IC2_Temp12_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp12_TextBox.Enabled = False
        Me.Temperature_IC2_Temp12_TextBox.Location = New System.Drawing.Point(162, 16)
        Me.Temperature_IC2_Temp12_TextBox.Name = "Temperature_IC2_Temp12_TextBox"
        Me.Temperature_IC2_Temp12_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp12_TextBox.TabIndex = 292
        '
        'Temperature_IC2_Temp7_Label
        '
        Me.Temperature_IC2_Temp7_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp7_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp7_Label.Location = New System.Drawing.Point(2, 56)
        Me.Temperature_IC2_Temp7_Label.Name = "Temperature_IC2_Temp7_Label"
        Me.Temperature_IC2_Temp7_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp7_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp7_Label.TabIndex = 281
        Me.Temperature_IC2_Temp7_Label.Text = "Temp 7"
        Me.Temperature_IC2_Temp7_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC2_Temp11_Label
        '
        Me.Temperature_IC2_Temp11_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp11_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp11_Label.Location = New System.Drawing.Point(110, 36)
        Me.Temperature_IC2_Temp11_Label.Name = "Temperature_IC2_Temp11_Label"
        Me.Temperature_IC2_Temp11_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp11_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp11_Label.TabIndex = 289
        Me.Temperature_IC2_Temp11_Label.Text = "Temp 11"
        Me.Temperature_IC2_Temp11_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC2_Temp8_TextBox
        '
        Me.Temperature_IC2_Temp8_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp8_TextBox.Enabled = False
        Me.Temperature_IC2_Temp8_TextBox.Location = New System.Drawing.Point(53, 36)
        Me.Temperature_IC2_Temp8_TextBox.Name = "Temperature_IC2_Temp8_TextBox"
        Me.Temperature_IC2_Temp8_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp8_TextBox.TabIndex = 284
        '
        'Temperature_IC2_Temp10_TextBox
        '
        Me.Temperature_IC2_Temp10_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp10_TextBox.Enabled = False
        Me.Temperature_IC2_Temp10_TextBox.Location = New System.Drawing.Point(162, 56)
        Me.Temperature_IC2_Temp10_TextBox.Name = "Temperature_IC2_Temp10_TextBox"
        Me.Temperature_IC2_Temp10_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp10_TextBox.TabIndex = 288
        '
        'Temperature_IC2_Temp7_TextBox
        '
        Me.Temperature_IC2_Temp7_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp7_TextBox.Enabled = False
        Me.Temperature_IC2_Temp7_TextBox.Location = New System.Drawing.Point(53, 56)
        Me.Temperature_IC2_Temp7_TextBox.Name = "Temperature_IC2_Temp7_TextBox"
        Me.Temperature_IC2_Temp7_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp7_TextBox.TabIndex = 282
        '
        'Temperature_IC2_Temp11_TextBox
        '
        Me.Temperature_IC2_Temp11_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp11_TextBox.Enabled = False
        Me.Temperature_IC2_Temp11_TextBox.Location = New System.Drawing.Point(162, 36)
        Me.Temperature_IC2_Temp11_TextBox.Name = "Temperature_IC2_Temp11_TextBox"
        Me.Temperature_IC2_Temp11_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp11_TextBox.TabIndex = 290
        '
        'Temperature_IC2_Temp8_Label
        '
        Me.Temperature_IC2_Temp8_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp8_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp8_Label.Location = New System.Drawing.Point(2, 36)
        Me.Temperature_IC2_Temp8_Label.Name = "Temperature_IC2_Temp8_Label"
        Me.Temperature_IC2_Temp8_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp8_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp8_Label.TabIndex = 283
        Me.Temperature_IC2_Temp8_Label.Text = "Temp 8"
        Me.Temperature_IC2_Temp8_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC2_Temp10_Label
        '
        Me.Temperature_IC2_Temp10_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC2_Temp10_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC2_Temp10_Label.Location = New System.Drawing.Point(110, 56)
        Me.Temperature_IC2_Temp10_Label.Name = "Temperature_IC2_Temp10_Label"
        Me.Temperature_IC2_Temp10_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC2_Temp10_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC2_Temp10_Label.TabIndex = 287
        Me.Temperature_IC2_Temp10_Label.Text = "Temp 10"
        Me.Temperature_IC2_Temp10_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label113
        '
        Me.Label113.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label113.Location = New System.Drawing.Point(10, 119)
        Me.Label113.Name = "Label113"
        Me.Label113.Size = New System.Drawing.Size(109, 13)
        Me.Label113.TabIndex = 107
        Me.Label113.Text = "VOLTAGES --------------"
        '
        'label73
        '
        Me.label73.AutoSize = True
        Me.label73.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label73.Location = New System.Drawing.Point(664, 144)
        Me.label73.Name = "label73"
        Me.label73.Size = New System.Drawing.Size(31, 26)
        Me.label73.TabIndex = 106
        Me.label73.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.label73.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LTC3300_Read_Status_IC2_CRC_Bit3_TextBox
        '
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 223)
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.Name = "LTC3300_Read_Status_IC2_CRC_Bit3_TextBox"
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.TabIndex = 94
        Me.LTC3300_Read_Status_IC2_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_CRC_Bit0_TextBox
        '
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 223)
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.Name = "LTC3300_Read_Status_IC2_CRC_Bit0_TextBox"
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.TabIndex = 97
        Me.LTC3300_Read_Status_IC2_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_CRC_Bit1_TextBox
        '
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 223)
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.Name = "LTC3300_Read_Status_IC2_CRC_Bit1_TextBox"
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.TabIndex = 96
        Me.LTC3300_Read_Status_IC2_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_CRC_Bit2_TextBox
        '
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 223)
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.Name = "LTC3300_Read_Status_IC2_CRC_Bit2_TextBox"
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.TabIndex = 95
        Me.LTC3300_Read_Status_IC2_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 173)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.TabIndex = 90
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 173)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.TabIndex = 93
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 173)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.TabIndex = 91
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 173)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.TabIndex = 92
        Me.LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'label64
        '
        Me.label64.AutoSize = True
        Me.label64.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label64.Location = New System.Drawing.Point(130, 20)
        Me.label64.Name = "label64"
        Me.label64.Size = New System.Drawing.Size(42, 13)
        Me.label64.TabIndex = 83
        Me.label64.Text = "CELL 7"
        Me.label64.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label65
        '
        Me.label65.AutoSize = True
        Me.label65.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label65.Location = New System.Drawing.Point(193, 20)
        Me.label65.Name = "label65"
        Me.label65.Size = New System.Drawing.Size(42, 13)
        Me.label65.TabIndex = 82
        Me.label65.Text = "CELL 8"
        Me.label65.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label72
        '
        Me.Label72.AutoSize = True
        Me.Label72.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label72.Location = New System.Drawing.Point(255, 20)
        Me.Label72.Name = "Label72"
        Me.Label72.Size = New System.Drawing.Size(42, 13)
        Me.Label72.TabIndex = 81
        Me.Label72.Text = "CELL 9"
        Me.Label72.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label75
        '
        Me.Label75.AutoSize = True
        Me.Label75.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label75.Location = New System.Drawing.Point(314, 20)
        Me.Label75.Name = "Label75"
        Me.Label75.Size = New System.Drawing.Size(48, 13)
        Me.Label75.TabIndex = 80
        Me.Label75.Text = "CELL 10"
        Me.Label75.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label76
        '
        Me.Label76.AutoSize = True
        Me.Label76.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label76.Location = New System.Drawing.Point(375, 20)
        Me.Label76.Name = "Label76"
        Me.Label76.Size = New System.Drawing.Size(48, 13)
        Me.Label76.TabIndex = 79
        Me.Label76.Text = "CELL 11"
        Me.Label76.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label77
        '
        Me.Label77.AutoSize = True
        Me.Label77.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label77.Location = New System.Drawing.Point(437, 20)
        Me.Label77.Name = "Label77"
        Me.Label77.Size = New System.Drawing.Size(48, 13)
        Me.Label77.TabIndex = 78
        Me.Label77.Text = "CELL 12"
        Me.Label77.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label78
        '
        Me.Label78.AutoSize = True
        Me.Label78.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label78.Location = New System.Drawing.Point(525, 194)
        Me.Label78.Name = "Label78"
        Me.Label78.Size = New System.Drawing.Size(35, 13)
        Me.Label78.TabIndex = 75
        Me.Label78.Text = "Stack"
        Me.Label78.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label79
        '
        Me.Label79.AutoSize = True
        Me.Label79.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label79.Location = New System.Drawing.Point(493, 194)
        Me.Label79.Name = "Label79"
        Me.Label79.Size = New System.Drawing.Size(29, 13)
        Me.Label79.TabIndex = 74
        Me.Label79.Text = "Cells"
        Me.Label79.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label80
        '
        Me.Label80.AutoSize = True
        Me.Label80.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label80.Location = New System.Drawing.Point(528, 195)
        Me.Label80.Name = "Label80"
        Me.Label80.Size = New System.Drawing.Size(25, 26)
        Me.Label80.TabIndex = 73
        Me.Label80.Text = "___" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OV"
        Me.Label80.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label81
        '
        Me.Label81.AutoSize = True
        Me.Label81.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label81.Location = New System.Drawing.Point(495, 195)
        Me.Label81.Name = "Label81"
        Me.Label81.Size = New System.Drawing.Size(25, 26)
        Me.Label81.TabIndex = 72
        Me.Label81.Text = "___" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OV"
        Me.Label81.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LTC3300_Read_Status_IC2_Unused_Bit2_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.Location = New System.Drawing.Point(590, 223)
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.Name = "LTC3300_Read_Status_IC2_Unused_Bit2_TextBox"
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.TabIndex = 69
        Me.LTC3300_Read_Status_IC2_Unused_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Unused_Bit0_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.Location = New System.Drawing.Point(616, 223)
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.Name = "LTC3300_Read_Status_IC2_Unused_Bit0_TextBox"
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.TabIndex = 71
        Me.LTC3300_Read_Status_IC2_Unused_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Unused_Bit1_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.Location = New System.Drawing.Point(603, 223)
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.Name = "LTC3300_Read_Status_IC2_Unused_Bit1_TextBox"
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.TabIndex = 70
        Me.LTC3300_Read_Status_IC2_Unused_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.Location = New System.Drawing.Point(498, 224)
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.Name = "LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox"
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.TabIndex = 66
        Me.LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Temp_OK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.Location = New System.Drawing.Point(564, 223)
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.Name = "LTC3300_Read_Status_IC2_Temp_OK_TextBox"
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.TabIndex = 68
        Me.LTC3300_Read_Status_IC2_Temp_OK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.Location = New System.Drawing.Point(531, 223)
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.Name = "LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox"
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.TabIndex = 67
        Me.LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label82
        '
        Me.Label82.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label82.Location = New System.Drawing.Point(8, 99)
        Me.Label82.Name = "Label82"
        Me.Label82.Size = New System.Drawing.Size(112, 13)
        Me.Label82.TabIndex = 65
        Me.Label82.Text = "CHARGE = 11 -----------"
        '
        'Label83
        '
        Me.Label83.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label83.Location = New System.Drawing.Point(8, 80)
        Me.Label83.Name = "Label83"
        Me.Label83.Size = New System.Drawing.Size(112, 13)
        Me.Label83.TabIndex = 64
        Me.Label83.Text = "DISCHARGE = 10 -----"
        '
        'Label84
        '
        Me.Label84.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label84.Location = New System.Drawing.Point(7, 62)
        Me.Label84.Name = "Label84"
        Me.Label84.Size = New System.Drawing.Size(113, 13)
        Me.Label84.TabIndex = 63
        Me.Label84.Text = "NONE = 00 ----------------"
        '
        'Label85
        '
        Me.Label85.AutoSize = True
        Me.Label85.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label85.Location = New System.Drawing.Point(11, 226)
        Me.Label85.Name = "Label85"
        Me.Label85.Size = New System.Drawing.Size(111, 13)
        Me.Label85.TabIndex = 54
        Me.Label85.Text = "READBACK STATUS"
        '
        'LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.Location = New System.Drawing.Point(454, 223)
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.TabIndex = 53
        Me.LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.Location = New System.Drawing.Point(392, 223)
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.TabIndex = 52
        Me.LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.Location = New System.Drawing.Point(333, 223)
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.TabIndex = 51
        Me.LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.Location = New System.Drawing.Point(268, 223)
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.TabIndex = 50
        Me.LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.Location = New System.Drawing.Point(206, 223)
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.TabIndex = 49
        Me.LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label86
        '
        Me.Label86.AutoSize = True
        Me.Label86.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label86.Location = New System.Drawing.Point(434, 207)
        Me.Label86.Name = "Label86"
        Me.Label86.Size = New System.Drawing.Size(54, 13)
        Me.Label86.TabIndex = 48
        Me.Label86.Text = "Gate6 OK"
        '
        'Label87
        '
        Me.Label87.AutoSize = True
        Me.Label87.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label87.Location = New System.Drawing.Point(374, 207)
        Me.Label87.Name = "Label87"
        Me.Label87.Size = New System.Drawing.Size(54, 13)
        Me.Label87.TabIndex = 47
        Me.Label87.Text = "Gate5 OK"
        '
        'Label88
        '
        Me.Label88.AutoSize = True
        Me.Label88.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label88.Location = New System.Drawing.Point(314, 207)
        Me.Label88.Name = "Label88"
        Me.Label88.Size = New System.Drawing.Size(54, 13)
        Me.Label88.TabIndex = 46
        Me.Label88.Text = "Gate4 OK"
        '
        'Label89
        '
        Me.Label89.AutoSize = True
        Me.Label89.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label89.Location = New System.Drawing.Point(248, 207)
        Me.Label89.Name = "Label89"
        Me.Label89.Size = New System.Drawing.Size(54, 13)
        Me.Label89.TabIndex = 45
        Me.Label89.Text = "Gate3 OK"
        '
        'Label90
        '
        Me.Label90.AutoSize = True
        Me.Label90.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label90.Location = New System.Drawing.Point(188, 207)
        Me.Label90.Name = "Label90"
        Me.Label90.Size = New System.Drawing.Size(54, 13)
        Me.Label90.TabIndex = 44
        Me.Label90.Text = "Gate2 OK"
        '
        'Label91
        '
        Me.Label91.AutoSize = True
        Me.Label91.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label91.Location = New System.Drawing.Point(128, 207)
        Me.Label91.Name = "Label91"
        Me.Label91.Size = New System.Drawing.Size(54, 13)
        Me.Label91.TabIndex = 43
        Me.Label91.Text = "Gate1 OK"
        '
        'Label92
        '
        Me.Label92.AutoSize = True
        Me.Label92.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label92.Location = New System.Drawing.Point(664, 10)
        Me.Label92.Name = "Label92"
        Me.Label92.Size = New System.Drawing.Size(31, 26)
        Me.Label92.TabIndex = 62
        Me.Label92.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.Label92.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.Location = New System.Drawing.Point(146, 223)
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.Name = "LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.TabIndex = 26
        Me.LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label93
        '
        Me.Label93.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label93.Location = New System.Drawing.Point(9, 142)
        Me.Label93.Name = "Label93"
        Me.Label93.Size = New System.Drawing.Size(110, 13)
        Me.Label93.TabIndex = 42
        Me.Label93.Text = "BALANCE TIMES -----"
        '
        'Label94
        '
        Me.Label94.AutoSize = True
        Me.Label94.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label94.Location = New System.Drawing.Point(6, 177)
        Me.Label94.Name = "Label94"
        Me.Label94.Size = New System.Drawing.Size(124, 13)
        Me.Label94.TabIndex = 28
        Me.Label94.Text = "READBACK COMMAND"
        '
        'LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.Location = New System.Drawing.Point(465, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.TabIndex = 41
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.Location = New System.Drawing.Point(442, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.TabIndex = 40
        Me.LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.Location = New System.Drawing.Point(403, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.TabIndex = 39
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.Location = New System.Drawing.Point(380, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.TabIndex = 38
        Me.LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.Location = New System.Drawing.Point(341, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.TabIndex = 37
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.Location = New System.Drawing.Point(318, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.TabIndex = 36
        Me.LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.Location = New System.Drawing.Point(279, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.TabIndex = 35
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.Location = New System.Drawing.Point(256, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.TabIndex = 34
        Me.LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.Location = New System.Drawing.Point(217, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.TabIndex = 33
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.Location = New System.Drawing.Point(194, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.TabIndex = 32
        Me.LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.Location = New System.Drawing.Point(157, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.TabIndex = 31
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.Location = New System.Drawing.Point(134, 173)
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.TabIndex = 30
        Me.LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label95
        '
        Me.Label95.AutoSize = True
        Me.Label95.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label95.Location = New System.Drawing.Point(557, 194)
        Me.Label95.Name = "Label95"
        Me.Label95.Size = New System.Drawing.Size(34, 26)
        Me.Label95.TabIndex = 76
        Me.Label95.Text = "Temp" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OK"
        Me.Label95.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'ShapeContainer1
        '
        Me.ShapeContainer1.Location = New System.Drawing.Point(3, 16)
        Me.ShapeContainer1.Margin = New System.Windows.Forms.Padding(0)
        Me.ShapeContainer1.Name = "ShapeContainer1"
        Me.ShapeContainer1.Shapes.AddRange(New Microsoft.VisualBasic.PowerPacks.Shape() {Me.RectangleShape6, Me.RectangleShape5, Me.RectangleShape4, Me.RectangleShape3, Me.RectangleShape2, Me.RectangleShape1})
        Me.ShapeContainer1.Size = New System.Drawing.Size(718, 231)
        Me.ShapeContainer1.TabIndex = 108
        Me.ShapeContainer1.TabStop = False
        '
        'RectangleShape6
        '
        Me.RectangleShape6.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape6.CornerRadius = 5
        Me.RectangleShape6.Enabled = False
        Me.RectangleShape6.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape6.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape6.Location = New System.Drawing.Point(180, 10)
        Me.RectangleShape6.Name = "RectangleShape6"
        Me.RectangleShape6.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape5
        '
        Me.RectangleShape5.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape5.CornerRadius = 5
        Me.RectangleShape5.Enabled = False
        Me.RectangleShape5.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape5.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape5.Location = New System.Drawing.Point(117, 9)
        Me.RectangleShape5.Name = "RectangleShape5"
        Me.RectangleShape5.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape4
        '
        Me.RectangleShape4.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape4.CornerRadius = 5
        Me.RectangleShape4.Enabled = False
        Me.RectangleShape4.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape4.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape4.Location = New System.Drawing.Point(304, 10)
        Me.RectangleShape4.Name = "RectangleShape4"
        Me.RectangleShape4.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape3
        '
        Me.RectangleShape3.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape3.CornerRadius = 5
        Me.RectangleShape3.Enabled = False
        Me.RectangleShape3.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape3.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape3.Location = New System.Drawing.Point(242, 10)
        Me.RectangleShape3.Name = "RectangleShape3"
        Me.RectangleShape3.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape2
        '
        Me.RectangleShape2.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape2.CornerRadius = 5
        Me.RectangleShape2.Enabled = False
        Me.RectangleShape2.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape2.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape2.Location = New System.Drawing.Point(366, 10)
        Me.RectangleShape2.Name = "RectangleShape2"
        Me.RectangleShape2.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape1
        '
        Me.RectangleShape1.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape1.CornerRadius = 5
        Me.RectangleShape1.Enabled = False
        Me.RectangleShape1.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape1.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape1.Location = New System.Drawing.Point(428, 10)
        Me.RectangleShape1.Name = "RectangleShape1"
        Me.RectangleShape1.Size = New System.Drawing.Size(60, 140)
        '
        'groupBox8
        '
        Me.groupBox8.Controls.Add(Me.vBox12)
        Me.groupBox8.Controls.Add(Me.Balance_Action_Cell12_None_RadioButton)
        Me.groupBox8.Controls.Add(Me.Balance_Action_Cell12_Discharge_RadioButton)
        Me.groupBox8.Controls.Add(Me.Balance_Timer_Cell12_TextBox)
        Me.groupBox8.Controls.Add(Me.Balance_Action_Cell12_Charge_RadioButton)
        Me.groupBox8.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox)
        Me.groupBox8.Controls.Add(Me.cellpic12)
        Me.groupBox8.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox)
        Me.groupBox8.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox8.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox8.Location = New System.Drawing.Point(432, 21)
        Me.groupBox8.Name = "groupBox8"
        Me.groupBox8.Size = New System.Drawing.Size(60, 146)
        Me.groupBox8.TabIndex = 26
        Me.groupBox8.TabStop = False
        Me.groupBox8.Text = " "
        '
        'vBox12
        '
        Me.vBox12.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox12.Location = New System.Drawing.Point(9, 96)
        Me.vBox12.Name = "vBox12"
        Me.vBox12.ReadOnly = True
        Me.vBox12.Size = New System.Drawing.Size(44, 20)
        Me.vBox12.TabIndex = 30
        Me.vBox12.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic12
        '
        Me.cellpic12.Image = CType(resources.GetObject("cellpic12.Image"), System.Drawing.Image)
        Me.cellpic12.Location = New System.Drawing.Point(21, 42)
        Me.cellpic12.Name = "cellpic12"
        Me.cellpic12.Size = New System.Drawing.Size(35, 45)
        Me.cellpic12.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic12.TabIndex = 10
        Me.cellpic12.TabStop = False
        '
        'groupBox7
        '
        Me.groupBox7.Controls.Add(Me.vBox11)
        Me.groupBox7.Controls.Add(Me.Balance_Action_Cell11_None_RadioButton)
        Me.groupBox7.Controls.Add(Me.Balance_Timer_Cell11_TextBox)
        Me.groupBox7.Controls.Add(Me.Balance_Action_Cell11_Charge_RadioButton)
        Me.groupBox7.Controls.Add(Me.Balance_Action_Cell11_Discharge_RadioButton)
        Me.groupBox7.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox)
        Me.groupBox7.Controls.Add(Me.cellpic11)
        Me.groupBox7.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox)
        Me.groupBox7.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox7.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox7.Location = New System.Drawing.Point(370, 21)
        Me.groupBox7.Name = "groupBox7"
        Me.groupBox7.Size = New System.Drawing.Size(60, 146)
        Me.groupBox7.TabIndex = 26
        Me.groupBox7.TabStop = False
        Me.groupBox7.Text = " "
        '
        'vBox11
        '
        Me.vBox11.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox11.Location = New System.Drawing.Point(9, 96)
        Me.vBox11.Name = "vBox11"
        Me.vBox11.ReadOnly = True
        Me.vBox11.Size = New System.Drawing.Size(44, 20)
        Me.vBox11.TabIndex = 29
        Me.vBox11.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic11
        '
        Me.cellpic11.Image = CType(resources.GetObject("cellpic11.Image"), System.Drawing.Image)
        Me.cellpic11.Location = New System.Drawing.Point(21, 45)
        Me.cellpic11.Name = "cellpic11"
        Me.cellpic11.Size = New System.Drawing.Size(35, 45)
        Me.cellpic11.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic11.TabIndex = 13
        Me.cellpic11.TabStop = False
        '
        'GroupBox6
        '
        Me.GroupBox6.Controls.Add(Me.vBox7)
        Me.GroupBox6.Controls.Add(Me.Balance_Timer_Cell7_TextBox)
        Me.GroupBox6.Controls.Add(Me.Balance_Action_Cell7_Charge_RadioButton)
        Me.GroupBox6.Controls.Add(Me.Balance_Action_Cell7_Discharge_RadioButton)
        Me.GroupBox6.Controls.Add(Me.Balance_Action_Cell7_None_RadioButton)
        Me.GroupBox6.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox)
        Me.GroupBox6.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox)
        Me.GroupBox6.Controls.Add(Me.cellpic7)
        Me.GroupBox6.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox6.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox6.Location = New System.Drawing.Point(122, 21)
        Me.GroupBox6.Name = "GroupBox6"
        Me.GroupBox6.Size = New System.Drawing.Size(60, 146)
        Me.GroupBox6.TabIndex = 22
        Me.GroupBox6.TabStop = False
        Me.GroupBox6.Text = "CELL 7"
        '
        'vBox7
        '
        Me.vBox7.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox7.Location = New System.Drawing.Point(9, 96)
        Me.vBox7.Name = "vBox7"
        Me.vBox7.ReadOnly = True
        Me.vBox7.Size = New System.Drawing.Size(44, 20)
        Me.vBox7.TabIndex = 3
        Me.vBox7.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic7
        '
        Me.cellpic7.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.battery_off
        Me.cellpic7.Location = New System.Drawing.Point(21, 45)
        Me.cellpic7.Name = "cellpic7"
        Me.cellpic7.Size = New System.Drawing.Size(35, 45)
        Me.cellpic7.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic7.TabIndex = 6
        Me.cellpic7.TabStop = False
        '
        'GroupBox16
        '
        Me.GroupBox16.Controls.Add(Me.vBox8)
        Me.GroupBox16.Controls.Add(Me.Balance_Timer_Cell8_TextBox)
        Me.GroupBox16.Controls.Add(Me.Balance_Action_Cell8_Charge_RadioButton)
        Me.GroupBox16.Controls.Add(Me.Balance_Action_Cell8_Discharge_RadioButton)
        Me.GroupBox16.Controls.Add(Me.Balance_Action_Cell8_None_RadioButton)
        Me.GroupBox16.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox)
        Me.GroupBox16.Controls.Add(Me.cellpic8)
        Me.GroupBox16.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox)
        Me.GroupBox16.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox16.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox16.Location = New System.Drawing.Point(184, 21)
        Me.GroupBox16.Name = "GroupBox16"
        Me.GroupBox16.Size = New System.Drawing.Size(60, 146)
        Me.GroupBox16.TabIndex = 26
        Me.GroupBox16.TabStop = False
        Me.GroupBox16.Text = "CELL 8"
        '
        'vBox8
        '
        Me.vBox8.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox8.Location = New System.Drawing.Point(9, 96)
        Me.vBox8.Name = "vBox8"
        Me.vBox8.ReadOnly = True
        Me.vBox8.Size = New System.Drawing.Size(44, 20)
        Me.vBox8.TabIndex = 26
        Me.vBox8.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic8
        '
        Me.cellpic8.Image = CType(resources.GetObject("cellpic8.Image"), System.Drawing.Image)
        Me.cellpic8.Location = New System.Drawing.Point(21, 45)
        Me.cellpic8.Name = "cellpic8"
        Me.cellpic8.Size = New System.Drawing.Size(35, 45)
        Me.cellpic8.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic8.TabIndex = 7
        Me.cellpic8.TabStop = False
        '
        'GroupBox17
        '
        Me.GroupBox17.Controls.Add(Me.vBox9)
        Me.GroupBox17.Controls.Add(Me.Balance_Timer_Cell9_TextBox)
        Me.GroupBox17.Controls.Add(Me.Balance_Action_Cell9_Charge_RadioButton)
        Me.GroupBox17.Controls.Add(Me.Balance_Action_Cell9_Discharge_RadioButton)
        Me.GroupBox17.Controls.Add(Me.Balance_Action_Cell9_None_RadioButton)
        Me.GroupBox17.Controls.Add(Me.cellpic9)
        Me.GroupBox17.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox)
        Me.GroupBox17.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox)
        Me.GroupBox17.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox17.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox17.Location = New System.Drawing.Point(246, 21)
        Me.GroupBox17.Name = "GroupBox17"
        Me.GroupBox17.Size = New System.Drawing.Size(60, 146)
        Me.GroupBox17.TabIndex = 26
        Me.GroupBox17.TabStop = False
        Me.GroupBox17.Text = "CELL 9"
        '
        'vBox9
        '
        Me.vBox9.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox9.Location = New System.Drawing.Point(9, 96)
        Me.vBox9.Name = "vBox9"
        Me.vBox9.ReadOnly = True
        Me.vBox9.Size = New System.Drawing.Size(44, 20)
        Me.vBox9.TabIndex = 27
        Me.vBox9.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic9
        '
        Me.cellpic9.Image = CType(resources.GetObject("cellpic9.Image"), System.Drawing.Image)
        Me.cellpic9.Location = New System.Drawing.Point(21, 45)
        Me.cellpic9.Name = "cellpic9"
        Me.cellpic9.Size = New System.Drawing.Size(35, 45)
        Me.cellpic9.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic9.TabIndex = 4
        Me.cellpic9.TabStop = False
        '
        'GroupBox18
        '
        Me.GroupBox18.Controls.Add(Me.vBox10)
        Me.GroupBox18.Controls.Add(Me.Balance_Action_Cell10_None_RadioButton)
        Me.GroupBox18.Controls.Add(Me.Balance_Timer_Cell10_TextBox)
        Me.GroupBox18.Controls.Add(Me.Balance_Action_Cell10_Charge_RadioButton)
        Me.GroupBox18.Controls.Add(Me.Balance_Action_Cell10_Discharge_RadioButton)
        Me.GroupBox18.Controls.Add(Me.cellpic10)
        Me.GroupBox18.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox)
        Me.GroupBox18.Controls.Add(Me.LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox)
        Me.GroupBox18.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox18.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox18.Location = New System.Drawing.Point(308, 21)
        Me.GroupBox18.Name = "GroupBox18"
        Me.GroupBox18.Size = New System.Drawing.Size(60, 146)
        Me.GroupBox18.TabIndex = 26
        Me.GroupBox18.TabStop = False
        Me.GroupBox18.Text = " "
        '
        'vBox10
        '
        Me.vBox10.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox10.Location = New System.Drawing.Point(9, 96)
        Me.vBox10.Name = "vBox10"
        Me.vBox10.ReadOnly = True
        Me.vBox10.Size = New System.Drawing.Size(44, 20)
        Me.vBox10.TabIndex = 28
        Me.vBox10.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic10
        '
        Me.cellpic10.Image = CType(resources.GetObject("cellpic10.Image"), System.Drawing.Image)
        Me.cellpic10.Location = New System.Drawing.Point(21, 45)
        Me.cellpic10.Name = "cellpic10"
        Me.cellpic10.Size = New System.Drawing.Size(35, 45)
        Me.cellpic10.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic10.TabIndex = 11
        Me.cellpic10.TabStop = False
        '
        'GroupBox19
        '
        Me.GroupBox19.Controls.Add(Me.PictureBox2)
        Me.GroupBox19.Controls.Add(Me.Label111)
        Me.GroupBox19.Controls.Add(Me.Label115)
        Me.GroupBox19.Controls.Add(Me.pictureBox8)
        Me.GroupBox19.Controls.Add(Me.pictureBox9)
        Me.GroupBox19.Controls.Add(Me.pictureBox11)
        Me.GroupBox19.Controls.Add(Me.pictureBox12)
        Me.GroupBox19.Controls.Add(Me.pictureBox13)
        Me.GroupBox19.Controls.Add(Me.Label101)
        Me.GroupBox19.Controls.Add(Me.Label102)
        Me.GroupBox19.Controls.Add(Me.Label104)
        Me.GroupBox19.Controls.Add(Me.Label105)
        Me.GroupBox19.Controls.Add(Me.Label106)
        Me.GroupBox19.Controls.Add(Me.Label107)
        Me.GroupBox19.Controls.Add(Me.Label108)
        Me.GroupBox19.Controls.Add(Me.Label109)
        Me.GroupBox19.Controls.Add(Me.Label110)
        Me.GroupBox19.Controls.Add(Me.Label112)
        Me.GroupBox19.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox19.ForeColor = System.Drawing.SystemColors.ControlText
        Me.GroupBox19.Location = New System.Drawing.Point(880, 103)
        Me.GroupBox19.Name = "GroupBox19"
        Me.GroupBox19.Size = New System.Drawing.Size(135, 285)
        Me.GroupBox19.TabIndex = 270
        Me.GroupBox19.TabStop = False
        Me.GroupBox19.Text = "COLOR KEY"
        '
        'PictureBox2
        '
        Me.PictureBox2.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.battery3300error
        Me.PictureBox2.Location = New System.Drawing.Point(103, 199)
        Me.PictureBox2.Name = "PictureBox2"
        Me.PictureBox2.Size = New System.Drawing.Size(22, 27)
        Me.PictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.PictureBox2.TabIndex = 72
        Me.PictureBox2.TabStop = False
        '
        'Label111
        '
        Me.Label111.BackColor = System.Drawing.Color.FromArgb(CType(CType(229, Byte), Integer), CType(CType(193, Byte), Integer), CType(CType(188, Byte), Integer))
        Me.Label111.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label111.Font = New System.Drawing.Font("Microsoft Sans Serif", 5.25!, System.Drawing.FontStyle.Bold)
        Me.Label111.Location = New System.Drawing.Point(10, 204)
        Me.Label111.Name = "Label111"
        Me.Label111.Size = New System.Drawing.Size(70, 20)
        Me.Label111.TabIndex = 71
        Me.Label111.Text = "LTC3300 Error"
        Me.Label111.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label115
        '
        Me.Label115.AutoSize = True
        Me.Label115.BackColor = System.Drawing.Color.Transparent
        Me.Label115.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label115.Location = New System.Drawing.Point(79, 207)
        Me.Label115.Name = "Label115"
        Me.Label115.Size = New System.Drawing.Size(43, 13)
        Me.Label115.TabIndex = 73
        Me.Label115.Text = "------------"
        '
        'pictureBox8
        '
        Me.pictureBox8.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batterygreen
        Me.pictureBox8.Location = New System.Drawing.Point(103, 23)
        Me.pictureBox8.Name = "pictureBox8"
        Me.pictureBox8.Size = New System.Drawing.Size(22, 27)
        Me.pictureBox8.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox8.TabIndex = 31
        Me.pictureBox8.TabStop = False
        '
        'pictureBox9
        '
        Me.pictureBox9.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryorange
        Me.pictureBox9.Location = New System.Drawing.Point(103, 65)
        Me.pictureBox9.Name = "pictureBox9"
        Me.pictureBox9.Size = New System.Drawing.Size(22, 27)
        Me.pictureBox9.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox9.TabIndex = 30
        Me.pictureBox9.TabStop = False
        '
        'pictureBox11
        '
        Me.pictureBox11.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryred
        Me.pictureBox11.Location = New System.Drawing.Point(103, 111)
        Me.pictureBox11.Name = "pictureBox11"
        Me.pictureBox11.Size = New System.Drawing.Size(22, 27)
        Me.pictureBox11.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox11.TabIndex = 28
        Me.pictureBox11.TabStop = False
        '
        'pictureBox12
        '
        Me.pictureBox12.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryblue
        Me.pictureBox12.Location = New System.Drawing.Point(103, 159)
        Me.pictureBox12.Name = "pictureBox12"
        Me.pictureBox12.Size = New System.Drawing.Size(22, 27)
        Me.pictureBox12.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox12.TabIndex = 27
        Me.pictureBox12.TabStop = False
        '
        'pictureBox13
        '
        Me.pictureBox13.Image = CType(resources.GetObject("pictureBox13.Image"), System.Drawing.Image)
        Me.pictureBox13.Location = New System.Drawing.Point(103, 244)
        Me.pictureBox13.Name = "pictureBox13"
        Me.pictureBox13.Size = New System.Drawing.Size(22, 27)
        Me.pictureBox13.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox13.TabIndex = 26
        Me.pictureBox13.TabStop = False
        '
        'Label101
        '
        Me.Label101.BackColor = System.Drawing.Color.Silver
        Me.Label101.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label101.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label101.ForeColor = System.Drawing.Color.DimGray
        Me.Label101.Location = New System.Drawing.Point(10, 249)
        Me.Label101.Name = "Label101"
        Me.Label101.Size = New System.Drawing.Size(70, 20)
        Me.Label101.TabIndex = 5
        Me.Label101.Text = "No Pop"
        Me.Label101.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label102
        '
        Me.Label102.BackColor = System.Drawing.Color.DarkOrange
        Me.Label102.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label102.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label102.Location = New System.Drawing.Point(10, 70)
        Me.Label102.Name = "Label102"
        Me.Label102.Size = New System.Drawing.Size(70, 20)
        Me.Label102.TabIndex = 2
        Me.Label102.Text = "Overtemp"
        Me.Label102.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label104
        '
        Me.Label104.BackColor = System.Drawing.Color.Lime
        Me.Label104.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label104.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label104.Location = New System.Drawing.Point(10, 28)
        Me.Label104.Name = "Label104"
        Me.Label104.Size = New System.Drawing.Size(70, 20)
        Me.Label104.TabIndex = 0
        Me.Label104.Text = "Normal"
        Me.Label104.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label105
        '
        Me.Label105.BackColor = System.Drawing.Color.DeepSkyBlue
        Me.Label105.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label105.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label105.Location = New System.Drawing.Point(10, 164)
        Me.Label105.Name = "Label105"
        Me.Label105.Size = New System.Drawing.Size(70, 20)
        Me.Label105.TabIndex = 3
        Me.Label105.Text = "Balancing"
        Me.Label105.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label106
        '
        Me.Label106.BackColor = System.Drawing.Color.Red
        Me.Label106.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Label106.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label106.Location = New System.Drawing.Point(10, 116)
        Me.Label106.Name = "Label106"
        Me.Label106.Size = New System.Drawing.Size(70, 20)
        Me.Label106.TabIndex = 1
        Me.Label106.Text = "OV/UV"
        Me.Label106.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label107
        '
        Me.Label107.AutoSize = True
        Me.Label107.BackColor = System.Drawing.Color.Transparent
        Me.Label107.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label107.Location = New System.Drawing.Point(79, 31)
        Me.Label107.Name = "Label107"
        Me.Label107.Size = New System.Drawing.Size(43, 13)
        Me.Label107.TabIndex = 65
        Me.Label107.Text = "------------"
        '
        'Label108
        '
        Me.Label108.AutoSize = True
        Me.Label108.BackColor = System.Drawing.Color.Transparent
        Me.Label108.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label108.Location = New System.Drawing.Point(79, 252)
        Me.Label108.Name = "Label108"
        Me.Label108.Size = New System.Drawing.Size(43, 13)
        Me.Label108.TabIndex = 70
        Me.Label108.Text = "------------"
        '
        'Label109
        '
        Me.Label109.AutoSize = True
        Me.Label109.BackColor = System.Drawing.Color.Transparent
        Me.Label109.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label109.Location = New System.Drawing.Point(79, 167)
        Me.Label109.Name = "Label109"
        Me.Label109.Size = New System.Drawing.Size(43, 13)
        Me.Label109.TabIndex = 69
        Me.Label109.Text = "------------"
        '
        'Label110
        '
        Me.Label110.AutoSize = True
        Me.Label110.BackColor = System.Drawing.Color.Transparent
        Me.Label110.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label110.Location = New System.Drawing.Point(79, 119)
        Me.Label110.Name = "Label110"
        Me.Label110.Size = New System.Drawing.Size(43, 13)
        Me.Label110.TabIndex = 68
        Me.Label110.Text = "------------"
        '
        'Label112
        '
        Me.Label112.AutoSize = True
        Me.Label112.BackColor = System.Drawing.Color.Transparent
        Me.Label112.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label112.Location = New System.Drawing.Point(79, 73)
        Me.Label112.Name = "Label112"
        Me.Label112.Size = New System.Drawing.Size(43, 13)
        Me.Label112.TabIndex = 66
        Me.Label112.Text = "------------"
        '
        'groupBox9
        '
        Me.groupBox9.Controls.Add(Me.Label103)
        Me.groupBox9.Controls.Add(Me.Label99)
        Me.groupBox9.Controls.Add(Me.Label98)
        Me.groupBox9.Controls.Add(Me.Temperature_ADC_Test_IC1_Checkbox)
        Me.groupBox9.Controls.Add(Me.Temperature_IC1_GroupBox)
        Me.groupBox9.Controls.Add(Me.Passive_Balancer_Test_IC1_Checkbox)
        Me.groupBox9.Controls.Add(Me.Label114)
        Me.groupBox9.Controls.Add(Me.label74)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.label66)
        Me.groupBox9.Controls.Add(Me.label71)
        Me.groupBox9.Controls.Add(Me.label67)
        Me.groupBox9.Controls.Add(Me.label70)
        Me.groupBox9.Controls.Add(Me.label68)
        Me.groupBox9.Controls.Add(Me.label69)
        Me.groupBox9.Controls.Add(Me.Label13)
        Me.groupBox9.Controls.Add(Me.Label14)
        Me.groupBox9.Controls.Add(Me.Label48)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox)
        Me.groupBox9.Controls.Add(Me.Label49)
        Me.groupBox9.Controls.Add(Me.Label50)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.Label51)
        Me.groupBox9.Controls.Add(Me.Label52)
        Me.groupBox9.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.Label53)
        Me.groupBox9.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.Label54)
        Me.groupBox9.Controls.Add(Me.Label55)
        Me.groupBox9.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox)
        Me.groupBox9.Controls.Add(Me.Label56)
        Me.groupBox9.Controls.Add(Me.Label57)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox)
        Me.groupBox9.Controls.Add(Me.Label58)
        Me.groupBox9.Controls.Add(Me.Label59)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox)
        Me.groupBox9.Controls.Add(Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox)
        Me.groupBox9.Controls.Add(Me.Label60)
        Me.groupBox9.Controls.Add(Me.Label61)
        Me.groupBox9.Controls.Add(Me.Label62)
        Me.groupBox9.Controls.Add(Me.Label63)
        Me.groupBox9.Controls.Add(Me.ShapeContainer2)
        Me.groupBox9.Controls.Add(Me.groupBox10)
        Me.groupBox9.Controls.Add(Me.groupBox11)
        Me.groupBox9.Controls.Add(Me.groupBox12)
        Me.groupBox9.Controls.Add(Me.groupBox13)
        Me.groupBox9.Controls.Add(Me.groupBox14)
        Me.groupBox9.Controls.Add(Me.groupBox15)
        Me.groupBox9.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox9.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox9.Location = New System.Drawing.Point(150, 259)
        Me.groupBox9.Name = "groupBox9"
        Me.groupBox9.Size = New System.Drawing.Size(724, 250)
        Me.groupBox9.TabIndex = 266
        Me.groupBox9.TabStop = False
        Me.groupBox9.Text = "BALANCING ACTION FOR IC 1 (CELLS 1 - 6)"
        '
        'Label103
        '
        Me.Label103.AutoSize = True
        Me.Label103.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label103.Location = New System.Drawing.Point(8, 41)
        Me.Label103.Name = "Label103"
        Me.Label103.Size = New System.Drawing.Size(102, 13)
        Me.Label103.TabIndex = 323
        Me.Label103.Text = "WRITE COMMAND"
        '
        'Label99
        '
        Me.Label99.AutoSize = True
        Me.Label99.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label99.Location = New System.Drawing.Point(587, 208)
        Me.Label99.Name = "Label99"
        Me.Label99.Size = New System.Drawing.Size(44, 13)
        Me.Label99.TabIndex = 322
        Me.Label99.Text = "Unused"
        Me.Label99.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label98
        '
        Me.Label98.AutoSize = True
        Me.Label98.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label98.Location = New System.Drawing.Point(664, 196)
        Me.Label98.Name = "Label98"
        Me.Label98.Size = New System.Drawing.Size(31, 26)
        Me.Label98.TabIndex = 322
        Me.Label98.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.Label98.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Temperature_IC1_GroupBox
        '
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp6_TextBox)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp1_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp6_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp1_TextBox)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp5_TextBox)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp2_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp5_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp2_TextBox)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp4_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp3_Label)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp4_TextBox)
        Me.Temperature_IC1_GroupBox.Controls.Add(Me.Temperature_IC1_Temp3_TextBox)
        Me.Temperature_IC1_GroupBox.Location = New System.Drawing.Point(500, 65)
        Me.Temperature_IC1_GroupBox.Name = "Temperature_IC1_GroupBox"
        Me.Temperature_IC1_GroupBox.Size = New System.Drawing.Size(220, 84)
        Me.Temperature_IC1_GroupBox.TabIndex = 319
        Me.Temperature_IC1_GroupBox.TabStop = False
        Me.Temperature_IC1_GroupBox.Text = "Temperature IC1"
        '
        'Temperature_IC1_Temp6_TextBox
        '
        Me.Temperature_IC1_Temp6_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp6_TextBox.Enabled = False
        Me.Temperature_IC1_Temp6_TextBox.Location = New System.Drawing.Point(162, 16)
        Me.Temperature_IC1_Temp6_TextBox.Name = "Temperature_IC1_Temp6_TextBox"
        Me.Temperature_IC1_Temp6_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp6_TextBox.TabIndex = 292
        '
        'Temperature_IC1_Temp1_Label
        '
        Me.Temperature_IC1_Temp1_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp1_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp1_Label.Location = New System.Drawing.Point(2, 56)
        Me.Temperature_IC1_Temp1_Label.Name = "Temperature_IC1_Temp1_Label"
        Me.Temperature_IC1_Temp1_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp1_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp1_Label.TabIndex = 281
        Me.Temperature_IC1_Temp1_Label.Text = "Temp 1"
        Me.Temperature_IC1_Temp1_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp6_Label
        '
        Me.Temperature_IC1_Temp6_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp6_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp6_Label.Location = New System.Drawing.Point(110, 16)
        Me.Temperature_IC1_Temp6_Label.Name = "Temperature_IC1_Temp6_Label"
        Me.Temperature_IC1_Temp6_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp6_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp6_Label.TabIndex = 291
        Me.Temperature_IC1_Temp6_Label.Text = "Temp 6"
        Me.Temperature_IC1_Temp6_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp1_TextBox
        '
        Me.Temperature_IC1_Temp1_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp1_TextBox.Enabled = False
        Me.Temperature_IC1_Temp1_TextBox.Location = New System.Drawing.Point(54, 56)
        Me.Temperature_IC1_Temp1_TextBox.Name = "Temperature_IC1_Temp1_TextBox"
        Me.Temperature_IC1_Temp1_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp1_TextBox.TabIndex = 282
        '
        'Temperature_IC1_Temp5_TextBox
        '
        Me.Temperature_IC1_Temp5_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp5_TextBox.Enabled = False
        Me.Temperature_IC1_Temp5_TextBox.Location = New System.Drawing.Point(162, 36)
        Me.Temperature_IC1_Temp5_TextBox.Name = "Temperature_IC1_Temp5_TextBox"
        Me.Temperature_IC1_Temp5_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp5_TextBox.TabIndex = 290
        '
        'Temperature_IC1_Temp2_Label
        '
        Me.Temperature_IC1_Temp2_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp2_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp2_Label.Location = New System.Drawing.Point(2, 36)
        Me.Temperature_IC1_Temp2_Label.Name = "Temperature_IC1_Temp2_Label"
        Me.Temperature_IC1_Temp2_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp2_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp2_Label.TabIndex = 283
        Me.Temperature_IC1_Temp2_Label.Text = "Temp 2"
        Me.Temperature_IC1_Temp2_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp5_Label
        '
        Me.Temperature_IC1_Temp5_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp5_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp5_Label.Location = New System.Drawing.Point(110, 36)
        Me.Temperature_IC1_Temp5_Label.Name = "Temperature_IC1_Temp5_Label"
        Me.Temperature_IC1_Temp5_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp5_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp5_Label.TabIndex = 289
        Me.Temperature_IC1_Temp5_Label.Text = "Temp 5"
        Me.Temperature_IC1_Temp5_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp2_TextBox
        '
        Me.Temperature_IC1_Temp2_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp2_TextBox.Enabled = False
        Me.Temperature_IC1_Temp2_TextBox.Location = New System.Drawing.Point(54, 36)
        Me.Temperature_IC1_Temp2_TextBox.Name = "Temperature_IC1_Temp2_TextBox"
        Me.Temperature_IC1_Temp2_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp2_TextBox.TabIndex = 284
        '
        'Temperature_IC1_Temp4_Label
        '
        Me.Temperature_IC1_Temp4_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp4_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp4_Label.Location = New System.Drawing.Point(110, 56)
        Me.Temperature_IC1_Temp4_Label.Name = "Temperature_IC1_Temp4_Label"
        Me.Temperature_IC1_Temp4_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp4_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp4_Label.TabIndex = 287
        Me.Temperature_IC1_Temp4_Label.Text = "Temp 4"
        Me.Temperature_IC1_Temp4_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp3_Label
        '
        Me.Temperature_IC1_Temp3_Label.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp3_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Temperature_IC1_Temp3_Label.Location = New System.Drawing.Point(2, 16)
        Me.Temperature_IC1_Temp3_Label.Name = "Temperature_IC1_Temp3_Label"
        Me.Temperature_IC1_Temp3_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Temperature_IC1_Temp3_Label.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp3_Label.TabIndex = 285
        Me.Temperature_IC1_Temp3_Label.Text = "Temp 3"
        Me.Temperature_IC1_Temp3_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Temperature_IC1_Temp4_TextBox
        '
        Me.Temperature_IC1_Temp4_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp4_TextBox.Enabled = False
        Me.Temperature_IC1_Temp4_TextBox.Location = New System.Drawing.Point(162, 56)
        Me.Temperature_IC1_Temp4_TextBox.Name = "Temperature_IC1_Temp4_TextBox"
        Me.Temperature_IC1_Temp4_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp4_TextBox.TabIndex = 288
        '
        'Temperature_IC1_Temp3_TextBox
        '
        Me.Temperature_IC1_Temp3_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Temperature_IC1_Temp3_TextBox.Enabled = False
        Me.Temperature_IC1_Temp3_TextBox.Location = New System.Drawing.Point(54, 16)
        Me.Temperature_IC1_Temp3_TextBox.Name = "Temperature_IC1_Temp3_TextBox"
        Me.Temperature_IC1_Temp3_TextBox.Size = New System.Drawing.Size(50, 20)
        Me.Temperature_IC1_Temp3_TextBox.TabIndex = 286
        '
        'Label114
        '
        Me.Label114.AutoSize = True
        Me.Label114.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label114.Location = New System.Drawing.Point(10, 119)
        Me.Label114.Name = "Label114"
        Me.Label114.Size = New System.Drawing.Size(109, 13)
        Me.Label114.TabIndex = 108
        Me.Label114.Text = "VOLTAGES --------------"
        '
        'label74
        '
        Me.label74.AutoSize = True
        Me.label74.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label74.Location = New System.Drawing.Point(664, 144)
        Me.label74.Name = "label74"
        Me.label74.Size = New System.Drawing.Size(31, 26)
        Me.label74.TabIndex = 107
        Me.label74.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.label74.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LTC3300_Read_Status_IC1_CRC_Bit3_TextBox
        '
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 222)
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.Name = "LTC3300_Read_Status_IC1_CRC_Bit3_TextBox"
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.TabIndex = 102
        Me.LTC3300_Read_Status_IC1_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_CRC_Bit0_TextBox
        '
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 222)
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.Name = "LTC3300_Read_Status_IC1_CRC_Bit0_TextBox"
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.TabIndex = 105
        Me.LTC3300_Read_Status_IC1_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_CRC_Bit1_TextBox
        '
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 222)
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.Name = "LTC3300_Read_Status_IC1_CRC_Bit1_TextBox"
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.TabIndex = 104
        Me.LTC3300_Read_Status_IC1_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_CRC_Bit2_TextBox
        '
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 222)
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.Name = "LTC3300_Read_Status_IC1_CRC_Bit2_TextBox"
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.TabIndex = 103
        Me.LTC3300_Read_Status_IC1_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.Location = New System.Drawing.Point(638, 173)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.TabIndex = 98
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.Location = New System.Drawing.Point(702, 173)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.TabIndex = 101
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.Location = New System.Drawing.Point(659, 173)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.TabIndex = 99
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.Location = New System.Drawing.Point(681, 173)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.TabIndex = 100
        Me.LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'label66
        '
        Me.label66.AutoSize = True
        Me.label66.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label66.Location = New System.Drawing.Point(131, 20)
        Me.label66.Name = "label66"
        Me.label66.Size = New System.Drawing.Size(42, 13)
        Me.label66.TabIndex = 89
        Me.label66.Text = "CELL 1"
        Me.label66.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label71
        '
        Me.label71.AutoSize = True
        Me.label71.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label71.Location = New System.Drawing.Point(440, 20)
        Me.label71.Name = "label71"
        Me.label71.Size = New System.Drawing.Size(42, 13)
        Me.label71.TabIndex = 84
        Me.label71.Text = "CELL 6"
        Me.label71.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label67
        '
        Me.label67.AutoSize = True
        Me.label67.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label67.Location = New System.Drawing.Point(193, 20)
        Me.label67.Name = "label67"
        Me.label67.Size = New System.Drawing.Size(42, 13)
        Me.label67.TabIndex = 88
        Me.label67.Text = "CELL 2"
        Me.label67.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label70
        '
        Me.label70.AutoSize = True
        Me.label70.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label70.Location = New System.Drawing.Point(378, 20)
        Me.label70.Name = "label70"
        Me.label70.Size = New System.Drawing.Size(42, 13)
        Me.label70.TabIndex = 85
        Me.label70.Text = "CELL 5"
        Me.label70.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label68
        '
        Me.label68.AutoSize = True
        Me.label68.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label68.Location = New System.Drawing.Point(255, 20)
        Me.label68.Name = "label68"
        Me.label68.Size = New System.Drawing.Size(42, 13)
        Me.label68.TabIndex = 87
        Me.label68.Text = "CELL 3"
        Me.label68.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'label69
        '
        Me.label69.AutoSize = True
        Me.label69.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label69.Location = New System.Drawing.Point(317, 20)
        Me.label69.Name = "label69"
        Me.label69.Size = New System.Drawing.Size(42, 13)
        Me.label69.TabIndex = 86
        Me.label69.Text = "CELL 4"
        Me.label69.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label13
        '
        Me.Label13.AutoSize = True
        Me.Label13.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label13.Location = New System.Drawing.Point(524, 195)
        Me.Label13.Name = "Label13"
        Me.Label13.Size = New System.Drawing.Size(35, 13)
        Me.Label13.TabIndex = 76
        Me.Label13.Text = "Stack"
        Me.Label13.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label14
        '
        Me.Label14.AutoSize = True
        Me.Label14.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label14.Location = New System.Drawing.Point(493, 195)
        Me.Label14.Name = "Label14"
        Me.Label14.Size = New System.Drawing.Size(29, 13)
        Me.Label14.TabIndex = 75
        Me.Label14.Text = "Cells"
        Me.Label14.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label48
        '
        Me.Label48.AutoSize = True
        Me.Label48.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label48.Location = New System.Drawing.Point(528, 196)
        Me.Label48.Name = "Label48"
        Me.Label48.Size = New System.Drawing.Size(25, 26)
        Me.Label48.TabIndex = 75
        Me.Label48.Text = "___" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OV"
        Me.Label48.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LTC3300_Read_Status_IC1_Unused_Bit2_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.Location = New System.Drawing.Point(590, 222)
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.Name = "LTC3300_Read_Status_IC1_Unused_Bit2_TextBox"
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.TabIndex = 69
        Me.LTC3300_Read_Status_IC1_Unused_Bit2_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label49
        '
        Me.Label49.AutoSize = True
        Me.Label49.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label49.Location = New System.Drawing.Point(495, 196)
        Me.Label49.Name = "Label49"
        Me.Label49.Size = New System.Drawing.Size(25, 26)
        Me.Label49.TabIndex = 74
        Me.Label49.Text = "___" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OV"
        Me.Label49.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label50
        '
        Me.Label50.AutoSize = True
        Me.Label50.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label50.Location = New System.Drawing.Point(11, 225)
        Me.Label50.Name = "Label50"
        Me.Label50.Size = New System.Drawing.Size(111, 13)
        Me.Label50.TabIndex = 54
        Me.Label50.Text = "READBACK STATUS"
        '
        'LTC3300_Read_Status_IC1_Unused_Bit0_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.Location = New System.Drawing.Point(616, 222)
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.Name = "LTC3300_Read_Status_IC1_Unused_Bit0_TextBox"
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.TabIndex = 71
        Me.LTC3300_Read_Status_IC1_Unused_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.Location = New System.Drawing.Point(454, 222)
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.TabIndex = 53
        Me.LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Unused_Bit1_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.Location = New System.Drawing.Point(603, 222)
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.Name = "LTC3300_Read_Status_IC1_Unused_Bit1_TextBox"
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.Size = New System.Drawing.Size(12, 20)
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.TabIndex = 70
        Me.LTC3300_Read_Status_IC1_Unused_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.Location = New System.Drawing.Point(498, 222)
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.Name = "LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox"
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.TabIndex = 66
        Me.LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Temp_OK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.Location = New System.Drawing.Point(564, 222)
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.Name = "LTC3300_Read_Status_IC1_Temp_OK_TextBox"
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.TabIndex = 68
        Me.LTC3300_Read_Status_IC1_Temp_OK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.Location = New System.Drawing.Point(392, 222)
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.TabIndex = 52
        Me.LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.Location = New System.Drawing.Point(531, 222)
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.Name = "LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox"
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.ReadOnly = True
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.TabIndex = 67
        Me.LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.Location = New System.Drawing.Point(333, 222)
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.TabIndex = 51
        Me.LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.Location = New System.Drawing.Point(268, 222)
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.TabIndex = 50
        Me.LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.Location = New System.Drawing.Point(206, 222)
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.TabIndex = 49
        Me.LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label51
        '
        Me.Label51.AutoSize = True
        Me.Label51.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label51.Location = New System.Drawing.Point(664, 10)
        Me.Label51.Name = "Label51"
        Me.Label51.Size = New System.Drawing.Size(31, 26)
        Me.Label51.TabIndex = 63
        Me.Label51.Text = "____" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "CRC"
        Me.Label51.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Label52
        '
        Me.Label52.AutoSize = True
        Me.Label52.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label52.Location = New System.Drawing.Point(434, 206)
        Me.Label52.Name = "Label52"
        Me.Label52.Size = New System.Drawing.Size(54, 13)
        Me.Label52.TabIndex = 48
        Me.Label52.Text = "Gate6 OK"
        '
        'Label53
        '
        Me.Label53.AutoSize = True
        Me.Label53.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label53.Location = New System.Drawing.Point(374, 206)
        Me.Label53.Name = "Label53"
        Me.Label53.Size = New System.Drawing.Size(54, 13)
        Me.Label53.TabIndex = 47
        Me.Label53.Text = "Gate5 OK"
        '
        'Label54
        '
        Me.Label54.AutoSize = True
        Me.Label54.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label54.Location = New System.Drawing.Point(314, 206)
        Me.Label54.Name = "Label54"
        Me.Label54.Size = New System.Drawing.Size(54, 13)
        Me.Label54.TabIndex = 46
        Me.Label54.Text = "Gate4 OK"
        '
        'Label55
        '
        Me.Label55.AutoSize = True
        Me.Label55.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label55.Location = New System.Drawing.Point(248, 206)
        Me.Label55.Name = "Label55"
        Me.Label55.Size = New System.Drawing.Size(54, 13)
        Me.Label55.TabIndex = 45
        Me.Label55.Text = "Gate3 OK"
        '
        'Label56
        '
        Me.Label56.AutoSize = True
        Me.Label56.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label56.Location = New System.Drawing.Point(188, 206)
        Me.Label56.Name = "Label56"
        Me.Label56.Size = New System.Drawing.Size(54, 13)
        Me.Label56.TabIndex = 44
        Me.Label56.Text = "Gate2 OK"
        '
        'Label57
        '
        Me.Label57.AutoSize = True
        Me.Label57.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label57.Location = New System.Drawing.Point(128, 206)
        Me.Label57.Name = "Label57"
        Me.Label57.Size = New System.Drawing.Size(54, 13)
        Me.Label57.TabIndex = 43
        Me.Label57.Text = "Gate1 OK"
        '
        'LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox
        '
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.Location = New System.Drawing.Point(146, 222)
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.MaxLength = 1
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.Name = "LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox"
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.TabIndex = 26
        Me.LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label58
        '
        Me.Label58.AutoSize = True
        Me.Label58.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label58.Location = New System.Drawing.Point(9, 142)
        Me.Label58.Name = "Label58"
        Me.Label58.Size = New System.Drawing.Size(110, 13)
        Me.Label58.TabIndex = 42
        Me.Label58.Text = "BALANCE TIMES -----"
        '
        'Label59
        '
        Me.Label59.AutoSize = True
        Me.Label59.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label59.Location = New System.Drawing.Point(6, 179)
        Me.Label59.Name = "Label59"
        Me.Label59.Size = New System.Drawing.Size(124, 13)
        Me.Label59.TabIndex = 28
        Me.Label59.Text = "READBACK COMMAND"
        '
        'LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.Location = New System.Drawing.Point(465, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.TabIndex = 41
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.Location = New System.Drawing.Point(442, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.TabIndex = 40
        Me.LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.Location = New System.Drawing.Point(403, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.TabIndex = 39
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.Location = New System.Drawing.Point(380, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.TabIndex = 38
        Me.LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.Location = New System.Drawing.Point(341, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.TabIndex = 37
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.Location = New System.Drawing.Point(318, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.TabIndex = 36
        Me.LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.Location = New System.Drawing.Point(279, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.TabIndex = 35
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.Location = New System.Drawing.Point(256, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.TabIndex = 34
        Me.LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.Location = New System.Drawing.Point(217, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.TabIndex = 33
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.Location = New System.Drawing.Point(194, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.TabIndex = 32
        Me.LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.Location = New System.Drawing.Point(157, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.TabIndex = 31
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox
        '
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.BackColor = System.Drawing.SystemColors.Window
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.Location = New System.Drawing.Point(134, 173)
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.MaxLength = 1
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.Name = "LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox"
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.ReadOnly = True
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.Size = New System.Drawing.Size(17, 20)
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.TabIndex = 30
        Me.LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label60
        '
        Me.Label60.AutoSize = True
        Me.Label60.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label60.Location = New System.Drawing.Point(8, 99)
        Me.Label60.Name = "Label60"
        Me.Label60.Size = New System.Drawing.Size(112, 13)
        Me.Label60.TabIndex = 29
        Me.Label60.Text = "CHARGE = 11 -----------"
        '
        'Label61
        '
        Me.Label61.AutoSize = True
        Me.Label61.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label61.Location = New System.Drawing.Point(8, 80)
        Me.Label61.Name = "Label61"
        Me.Label61.Size = New System.Drawing.Size(112, 13)
        Me.Label61.TabIndex = 28
        Me.Label61.Text = "DISCHARGE = 10 -----"
        '
        'Label62
        '
        Me.Label62.AutoSize = True
        Me.Label62.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label62.Location = New System.Drawing.Point(8, 62)
        Me.Label62.Name = "Label62"
        Me.Label62.Size = New System.Drawing.Size(113, 13)
        Me.Label62.TabIndex = 27
        Me.Label62.Text = "NONE = 00 ----------------"
        '
        'Label63
        '
        Me.Label63.AutoSize = True
        Me.Label63.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label63.Location = New System.Drawing.Point(556, 195)
        Me.Label63.Name = "Label63"
        Me.Label63.Size = New System.Drawing.Size(34, 26)
        Me.Label63.TabIndex = 77
        Me.Label63.Text = "Temp" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "OK"
        Me.Label63.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'ShapeContainer2
        '
        Me.ShapeContainer2.Location = New System.Drawing.Point(3, 16)
        Me.ShapeContainer2.Margin = New System.Windows.Forms.Padding(0)
        Me.ShapeContainer2.Name = "ShapeContainer2"
        Me.ShapeContainer2.Shapes.AddRange(New Microsoft.VisualBasic.PowerPacks.Shape() {Me.RectangleShape12, Me.RectangleShape11, Me.RectangleShape10, Me.RectangleShape9, Me.RectangleShape8, Me.RectangleShape7})
        Me.ShapeContainer2.Size = New System.Drawing.Size(718, 231)
        Me.ShapeContainer2.TabIndex = 109
        Me.ShapeContainer2.TabStop = False
        '
        'RectangleShape12
        '
        Me.RectangleShape12.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape12.CornerRadius = 5
        Me.RectangleShape12.Enabled = False
        Me.RectangleShape12.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape12.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape12.Location = New System.Drawing.Point(428, 11)
        Me.RectangleShape12.Name = "RectangleShape12"
        Me.RectangleShape12.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape11
        '
        Me.RectangleShape11.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape11.CornerRadius = 5
        Me.RectangleShape11.Enabled = False
        Me.RectangleShape11.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape11.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape11.Location = New System.Drawing.Point(366, 11)
        Me.RectangleShape11.Name = "RectangleShape11"
        Me.RectangleShape11.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape10
        '
        Me.RectangleShape10.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape10.CornerRadius = 5
        Me.RectangleShape10.Enabled = False
        Me.RectangleShape10.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape10.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape10.Location = New System.Drawing.Point(304, 10)
        Me.RectangleShape10.Name = "RectangleShape10"
        Me.RectangleShape10.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape9
        '
        Me.RectangleShape9.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape9.CornerRadius = 5
        Me.RectangleShape9.Enabled = False
        Me.RectangleShape9.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape9.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape9.Location = New System.Drawing.Point(242, 10)
        Me.RectangleShape9.Name = "RectangleShape9"
        Me.RectangleShape9.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape8
        '
        Me.RectangleShape8.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape8.CornerRadius = 5
        Me.RectangleShape8.Enabled = False
        Me.RectangleShape8.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape8.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape8.Location = New System.Drawing.Point(180, 10)
        Me.RectangleShape8.Name = "RectangleShape8"
        Me.RectangleShape8.Size = New System.Drawing.Size(60, 140)
        '
        'RectangleShape7
        '
        Me.RectangleShape7.BorderColor = System.Drawing.SystemColors.ButtonHighlight
        Me.RectangleShape7.CornerRadius = 5
        Me.RectangleShape7.Enabled = False
        Me.RectangleShape7.FillColor = System.Drawing.Color.Transparent
        Me.RectangleShape7.FillGradientColor = System.Drawing.Color.Transparent
        Me.RectangleShape7.Location = New System.Drawing.Point(118, 10)
        Me.RectangleShape7.Name = "RectangleShape7"
        Me.RectangleShape7.Size = New System.Drawing.Size(60, 140)
        '
        'groupBox10
        '
        Me.groupBox10.Controls.Add(Me.vBox6)
        Me.groupBox10.Controls.Add(Me.Balance_Action_Cell6_None_RadioButton)
        Me.groupBox10.Controls.Add(Me.Balance_Action_Cell6_Discharge_RadioButton)
        Me.groupBox10.Controls.Add(Me.Balance_Action_Cell6_Charge_RadioButton)
        Me.groupBox10.Controls.Add(Me.Balance_Timer_Cell6_TextBox)
        Me.groupBox10.Controls.Add(Me.cellpic6)
        Me.groupBox10.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox)
        Me.groupBox10.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox)
        Me.groupBox10.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox10.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox10.Location = New System.Drawing.Point(432, 21)
        Me.groupBox10.Name = "groupBox10"
        Me.groupBox10.Size = New System.Drawing.Size(60, 146)
        Me.groupBox10.TabIndex = 26
        Me.groupBox10.TabStop = False
        Me.groupBox10.Text = "CELL 6"
        '
        'vBox6
        '
        Me.vBox6.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox6.Location = New System.Drawing.Point(9, 96)
        Me.vBox6.Name = "vBox6"
        Me.vBox6.ReadOnly = True
        Me.vBox6.Size = New System.Drawing.Size(44, 20)
        Me.vBox6.TabIndex = 112
        Me.vBox6.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic6
        '
        Me.cellpic6.Image = CType(resources.GetObject("cellpic6.Image"), System.Drawing.Image)
        Me.cellpic6.Location = New System.Drawing.Point(21, 45)
        Me.cellpic6.Name = "cellpic6"
        Me.cellpic6.Size = New System.Drawing.Size(35, 45)
        Me.cellpic6.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic6.TabIndex = 9
        Me.cellpic6.TabStop = False
        '
        'groupBox11
        '
        Me.groupBox11.Controls.Add(Me.vBox5)
        Me.groupBox11.Controls.Add(Me.Balance_Action_Cell5_Discharge_RadioButton)
        Me.groupBox11.Controls.Add(Me.Balance_Action_Cell5_None_RadioButton)
        Me.groupBox11.Controls.Add(Me.Balance_Timer_Cell5_TextBox)
        Me.groupBox11.Controls.Add(Me.Balance_Action_Cell5_Charge_RadioButton)
        Me.groupBox11.Controls.Add(Me.cellpic5)
        Me.groupBox11.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox)
        Me.groupBox11.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox)
        Me.groupBox11.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox11.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox11.Location = New System.Drawing.Point(370, 21)
        Me.groupBox11.Name = "groupBox11"
        Me.groupBox11.Size = New System.Drawing.Size(60, 146)
        Me.groupBox11.TabIndex = 26
        Me.groupBox11.TabStop = False
        Me.groupBox11.Text = "CELL 5"
        '
        'vBox5
        '
        Me.vBox5.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox5.Location = New System.Drawing.Point(9, 96)
        Me.vBox5.Name = "vBox5"
        Me.vBox5.ReadOnly = True
        Me.vBox5.Size = New System.Drawing.Size(44, 20)
        Me.vBox5.TabIndex = 111
        Me.vBox5.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic5
        '
        Me.cellpic5.Image = CType(resources.GetObject("cellpic5.Image"), System.Drawing.Image)
        Me.cellpic5.Location = New System.Drawing.Point(21, 45)
        Me.cellpic5.Name = "cellpic5"
        Me.cellpic5.Size = New System.Drawing.Size(35, 45)
        Me.cellpic5.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic5.TabIndex = 8
        Me.cellpic5.TabStop = False
        '
        'groupBox12
        '
        Me.groupBox12.Controls.Add(Me.vBox4)
        Me.groupBox12.Controls.Add(Me.Balance_Action_Cell4_None_RadioButton)
        Me.groupBox12.Controls.Add(Me.Balance_Timer_Cell4_TextBox)
        Me.groupBox12.Controls.Add(Me.Balance_Action_Cell4_Charge_RadioButton)
        Me.groupBox12.Controls.Add(Me.Balance_Action_Cell4_Discharge_RadioButton)
        Me.groupBox12.Controls.Add(Me.cellpic4)
        Me.groupBox12.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox)
        Me.groupBox12.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox)
        Me.groupBox12.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox12.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox12.Location = New System.Drawing.Point(308, 21)
        Me.groupBox12.Name = "groupBox12"
        Me.groupBox12.Size = New System.Drawing.Size(60, 146)
        Me.groupBox12.TabIndex = 26
        Me.groupBox12.TabStop = False
        Me.groupBox12.Text = "CELL 4"
        '
        'vBox4
        '
        Me.vBox4.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox4.Location = New System.Drawing.Point(9, 96)
        Me.vBox4.Name = "vBox4"
        Me.vBox4.ReadOnly = True
        Me.vBox4.Size = New System.Drawing.Size(44, 20)
        Me.vBox4.TabIndex = 110
        Me.vBox4.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic4
        '
        Me.cellpic4.Image = CType(resources.GetObject("cellpic4.Image"), System.Drawing.Image)
        Me.cellpic4.Location = New System.Drawing.Point(21, 45)
        Me.cellpic4.Name = "cellpic4"
        Me.cellpic4.Size = New System.Drawing.Size(35, 45)
        Me.cellpic4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic4.TabIndex = 12
        Me.cellpic4.TabStop = False
        '
        'groupBox13
        '
        Me.groupBox13.Controls.Add(Me.vBox3)
        Me.groupBox13.Controls.Add(Me.Balance_Timer_Cell3_TextBox)
        Me.groupBox13.Controls.Add(Me.Balance_Action_Cell3_Charge_RadioButton)
        Me.groupBox13.Controls.Add(Me.Balance_Action_Cell3_Discharge_RadioButton)
        Me.groupBox13.Controls.Add(Me.Balance_Action_Cell3_None_RadioButton)
        Me.groupBox13.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox)
        Me.groupBox13.Controls.Add(Me.cellpic3)
        Me.groupBox13.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox)
        Me.groupBox13.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox13.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox13.Location = New System.Drawing.Point(246, 21)
        Me.groupBox13.Name = "groupBox13"
        Me.groupBox13.Size = New System.Drawing.Size(60, 146)
        Me.groupBox13.TabIndex = 26
        Me.groupBox13.TabStop = False
        Me.groupBox13.Text = "CELL 3"
        '
        'vBox3
        '
        Me.vBox3.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox3.Location = New System.Drawing.Point(9, 96)
        Me.vBox3.Name = "vBox3"
        Me.vBox3.ReadOnly = True
        Me.vBox3.Size = New System.Drawing.Size(44, 20)
        Me.vBox3.TabIndex = 109
        Me.vBox3.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic3
        '
        Me.cellpic3.Image = CType(resources.GetObject("cellpic3.Image"), System.Drawing.Image)
        Me.cellpic3.Location = New System.Drawing.Point(21, 45)
        Me.cellpic3.Name = "cellpic3"
        Me.cellpic3.Size = New System.Drawing.Size(35, 45)
        Me.cellpic3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic3.TabIndex = 3
        Me.cellpic3.TabStop = False
        '
        'groupBox14
        '
        Me.groupBox14.Controls.Add(Me.vBox2)
        Me.groupBox14.Controls.Add(Me.Balance_Timer_Cell2_TextBox)
        Me.groupBox14.Controls.Add(Me.Balance_Action_Cell2_Charge_RadioButton)
        Me.groupBox14.Controls.Add(Me.Balance_Action_Cell2_Discharge_RadioButton)
        Me.groupBox14.Controls.Add(Me.Balance_Action_Cell2_None_RadioButton)
        Me.groupBox14.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox)
        Me.groupBox14.Controls.Add(Me.cellpic2)
        Me.groupBox14.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox)
        Me.groupBox14.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox14.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox14.Location = New System.Drawing.Point(184, 21)
        Me.groupBox14.Name = "groupBox14"
        Me.groupBox14.Size = New System.Drawing.Size(60, 146)
        Me.groupBox14.TabIndex = 26
        Me.groupBox14.TabStop = False
        Me.groupBox14.Text = "CELL 2"
        '
        'vBox2
        '
        Me.vBox2.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox2.Location = New System.Drawing.Point(9, 96)
        Me.vBox2.Name = "vBox2"
        Me.vBox2.ReadOnly = True
        Me.vBox2.Size = New System.Drawing.Size(44, 20)
        Me.vBox2.TabIndex = 108
        Me.vBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic2
        '
        Me.cellpic2.Image = CType(resources.GetObject("cellpic2.Image"), System.Drawing.Image)
        Me.cellpic2.Location = New System.Drawing.Point(21, 45)
        Me.cellpic2.Name = "cellpic2"
        Me.cellpic2.Size = New System.Drawing.Size(35, 45)
        Me.cellpic2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic2.TabIndex = 2
        Me.cellpic2.TabStop = False
        '
        'groupBox15
        '
        Me.groupBox15.Controls.Add(Me.vBox1)
        Me.groupBox15.Controls.Add(Me.Balance_Timer_Cell1_TextBox)
        Me.groupBox15.Controls.Add(Me.Balance_Action_Cell1_Charge_RadioButton)
        Me.groupBox15.Controls.Add(Me.Balance_Action_Cell1_Discharge_RadioButton)
        Me.groupBox15.Controls.Add(Me.Balance_Action_Cell1_None_RadioButton)
        Me.groupBox15.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox)
        Me.groupBox15.Controls.Add(Me.LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox)
        Me.groupBox15.Controls.Add(Me.cellpic1)
        Me.groupBox15.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox15.ForeColor = System.Drawing.SystemColors.ControlText
        Me.groupBox15.Location = New System.Drawing.Point(122, 21)
        Me.groupBox15.Name = "groupBox15"
        Me.groupBox15.Size = New System.Drawing.Size(60, 146)
        Me.groupBox15.TabIndex = 22
        Me.groupBox15.TabStop = False
        Me.groupBox15.Text = "CELL 1"
        '
        'vBox1
        '
        Me.vBox1.BackColor = System.Drawing.Color.WhiteSmoke
        Me.vBox1.Location = New System.Drawing.Point(9, 96)
        Me.vBox1.Name = "vBox1"
        Me.vBox1.ReadOnly = True
        Me.vBox1.Size = New System.Drawing.Size(44, 20)
        Me.vBox1.TabIndex = 31
        Me.vBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cellpic1
        '
        Me.cellpic1.Image = CType(resources.GetObject("cellpic1.Image"), System.Drawing.Image)
        Me.cellpic1.Location = New System.Drawing.Point(21, 45)
        Me.cellpic1.Name = "cellpic1"
        Me.cellpic1.Size = New System.Drawing.Size(35, 45)
        Me.cellpic1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.cellpic1.TabIndex = 5
        Me.cellpic1.TabStop = False
        '
        'TabPage2
        '
        Me.TabPage2.BackColor = System.Drawing.Color.Silver
        Me.TabPage2.Controls.Add(Me.CellGrid)
        Me.TabPage2.Location = New System.Drawing.Point(4, 23)
        Me.TabPage2.Name = "TabPage2"
        Me.TabPage2.Size = New System.Drawing.Size(1035, 516)
        Me.TabPage2.TabIndex = 0
        Me.TabPage2.Text = "Global Channel Monitor"
        '
        'CellGrid
        '
        Me.CellGrid.AllowUserToAddRows = False
        Me.CellGrid.AllowUserToDeleteRows = False
        Me.CellGrid.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize
        Me.CellGrid.GridColor = System.Drawing.SystemColors.ControlLightLight
        Me.CellGrid.Location = New System.Drawing.Point(3, 3)
        Me.CellGrid.Name = "CellGrid"
        DataGridViewCellStyle2.Alignment = System.Windows.Forms.DataGridViewContentAlignment.MiddleCenter
        Me.CellGrid.RowsDefaultCellStyle = DataGridViewCellStyle2
        Me.CellGrid.ScrollBars = System.Windows.Forms.ScrollBars.None
        Me.CellGrid.Size = New System.Drawing.Size(1029, 510)
        Me.CellGrid.TabIndex = 0
        '
        'Data_Logging_GroupBox
        '
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Length_Label)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Stop_ComboBox)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Mem_Usage_Label)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Start_Button)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Length_ComboBox)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Interval_ComboBox)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Length_TextBox)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Interval_TextBox)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_Interval_Label)
        Me.Data_Logging_GroupBox.Controls.Add(Me.Data_Log_CheckBox)
        Me.Data_Logging_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.Data_Logging_GroupBox.Location = New System.Drawing.Point(628, 10)
        Me.Data_Logging_GroupBox.Name = "Data_Logging_GroupBox"
        Me.Data_Logging_GroupBox.Size = New System.Drawing.Size(397, 109)
        Me.Data_Logging_GroupBox.TabIndex = 275
        Me.Data_Logging_GroupBox.TabStop = False
        Me.Data_Logging_GroupBox.Text = "DATA LOGGING"
        '
        'Data_Log_Length_Label
        '
        Me.Data_Log_Length_Label.AutoSize = True
        Me.Data_Log_Length_Label.ForeColor = System.Drawing.Color.DimGray
        Me.Data_Log_Length_Label.Location = New System.Drawing.Point(22, 79)
        Me.Data_Log_Length_Label.Name = "Data_Log_Length_Label"
        Me.Data_Log_Length_Label.Size = New System.Drawing.Size(50, 26)
        Me.Data_Log_Length_Label.TabIndex = 281
        Me.Data_Log_Length_Label.Text = "Length:" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10)
        '
        'Data_Log_Stop_ComboBox
        '
        Me.Data_Log_Stop_ComboBox.BackColor = System.Drawing.Color.LightGray
        Me.Data_Log_Stop_ComboBox.Enabled = False
        Me.Data_Log_Stop_ComboBox.Location = New System.Drawing.Point(226, 78)
        Me.Data_Log_Stop_ComboBox.Name = "Data_Log_Stop_ComboBox"
        Me.Data_Log_Stop_ComboBox.Size = New System.Drawing.Size(118, 25)
        Me.Data_Log_Stop_ComboBox.TabIndex = 280
        Me.Data_Log_Stop_ComboBox.Text = "Stop Data Log"
        Me.Data_Log_Stop_ComboBox.UseVisualStyleBackColor = False
        '
        'Data_Log_Mem_Usage_Label
        '
        Me.Data_Log_Mem_Usage_Label.AutoSize = True
        Me.Data_Log_Mem_Usage_Label.ForeColor = System.Drawing.Color.DimGray
        Me.Data_Log_Mem_Usage_Label.Location = New System.Drawing.Point(227, 16)
        Me.Data_Log_Mem_Usage_Label.Name = "Data_Log_Mem_Usage_Label"
        Me.Data_Log_Mem_Usage_Label.Size = New System.Drawing.Size(108, 26)
        Me.Data_Log_Mem_Usage_Label.TabIndex = 279
        Me.Data_Log_Mem_Usage_Label.Text = "Projected Memory" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Usage:"
        '
        'Data_Log_Start_Button
        '
        Me.Data_Log_Start_Button.BackColor = System.Drawing.Color.LightGray
        Me.Data_Log_Start_Button.Enabled = False
        Me.Data_Log_Start_Button.Location = New System.Drawing.Point(226, 49)
        Me.Data_Log_Start_Button.Name = "Data_Log_Start_Button"
        Me.Data_Log_Start_Button.Size = New System.Drawing.Size(118, 25)
        Me.Data_Log_Start_Button.TabIndex = 278
        Me.Data_Log_Start_Button.Text = "Start Data Log"
        Me.Data_Log_Start_Button.UseVisualStyleBackColor = False
        '
        'Data_Log_Length_ComboBox
        '
        Me.Data_Log_Length_ComboBox.BackColor = System.Drawing.Color.DarkGray
        Me.Data_Log_Length_ComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.Data_Log_Length_ComboBox.Enabled = False
        Me.Data_Log_Length_ComboBox.FormattingEnabled = True
        Me.Data_Log_Length_ComboBox.ItemHeight = 13
        Me.Data_Log_Length_ComboBox.Items.AddRange(New Object() {"Secs", "Mins", "Hours", "Days", "Weeks"})
        Me.Data_Log_Length_ComboBox.Location = New System.Drawing.Point(143, 79)
        Me.Data_Log_Length_ComboBox.Name = "Data_Log_Length_ComboBox"
        Me.Data_Log_Length_ComboBox.Size = New System.Drawing.Size(58, 21)
        Me.Data_Log_Length_ComboBox.TabIndex = 277
        '
        'Data_Log_Interval_ComboBox
        '
        Me.Data_Log_Interval_ComboBox.BackColor = System.Drawing.Color.DarkGray
        Me.Data_Log_Interval_ComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.Data_Log_Interval_ComboBox.Enabled = False
        Me.Data_Log_Interval_ComboBox.FormattingEnabled = True
        Me.Data_Log_Interval_ComboBox.ItemHeight = 13
        Me.Data_Log_Interval_ComboBox.Items.AddRange(New Object() {"Secs", "Mins", "Hours", "Days", "Weeks"})
        Me.Data_Log_Interval_ComboBox.Location = New System.Drawing.Point(143, 51)
        Me.Data_Log_Interval_ComboBox.Name = "Data_Log_Interval_ComboBox"
        Me.Data_Log_Interval_ComboBox.Size = New System.Drawing.Size(58, 21)
        Me.Data_Log_Interval_ComboBox.TabIndex = 276
        '
        'Data_Log_Length_TextBox
        '
        Me.Data_Log_Length_TextBox.BackColor = System.Drawing.Color.DarkGray
        Me.Data_Log_Length_TextBox.Enabled = False
        Me.Data_Log_Length_TextBox.Location = New System.Drawing.Point(90, 80)
        Me.Data_Log_Length_TextBox.MaxLength = 2
        Me.Data_Log_Length_TextBox.Name = "Data_Log_Length_TextBox"
        Me.Data_Log_Length_TextBox.Size = New System.Drawing.Size(40, 20)
        Me.Data_Log_Length_TextBox.TabIndex = 275
        Me.Data_Log_Length_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Data_Log_Interval_TextBox
        '
        Me.Data_Log_Interval_TextBox.BackColor = System.Drawing.Color.DarkGray
        Me.Data_Log_Interval_TextBox.Enabled = False
        Me.Data_Log_Interval_TextBox.Location = New System.Drawing.Point(90, 52)
        Me.Data_Log_Interval_TextBox.MaxLength = 2
        Me.Data_Log_Interval_TextBox.Name = "Data_Log_Interval_TextBox"
        Me.Data_Log_Interval_TextBox.Size = New System.Drawing.Size(40, 20)
        Me.Data_Log_Interval_TextBox.TabIndex = 274
        Me.Data_Log_Interval_TextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Data_Log_Interval_Label
        '
        Me.Data_Log_Interval_Label.ForeColor = System.Drawing.Color.DimGray
        Me.Data_Log_Interval_Label.Location = New System.Drawing.Point(19, 54)
        Me.Data_Log_Interval_Label.Name = "Data_Log_Interval_Label"
        Me.Data_Log_Interval_Label.Size = New System.Drawing.Size(54, 20)
        Me.Data_Log_Interval_Label.TabIndex = 273
        Me.Data_Log_Interval_Label.Text = "Interval:" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & Global.Microsoft.VisualBasic.ChrW(13)
        '
        'Data_Log_CheckBox
        '
        Me.Data_Log_CheckBox.AutoSize = True
        Me.Data_Log_CheckBox.Enabled = False
        Me.Data_Log_CheckBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Data_Log_CheckBox.Location = New System.Drawing.Point(28, 24)
        Me.Data_Log_CheckBox.Name = "Data_Log_CheckBox"
        Me.Data_Log_CheckBox.Size = New System.Drawing.Size(126, 17)
        Me.Data_Log_CheckBox.TabIndex = 272
        Me.Data_Log_CheckBox.Text = "Enable Data Logging"
        Me.Data_Log_CheckBox.UseVisualStyleBackColor = True
        '
        'Base_Balance_Current_GroupBox
        '
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_6Cell_Units_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_6Cell_Units_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_12Cell_Units_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_12Cell_Units_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_6Cell_TextBox)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_6Cell_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_12Cell_TextBox)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Discharge_Current_12Cell_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_6Cell_TextBox)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_6Cell_Label)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_12Cell_TextBox)
        Me.Base_Balance_Current_GroupBox.Controls.Add(Me.Average_Charge_Current_12Cell_Label)
        Me.Base_Balance_Current_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Base_Balance_Current_GroupBox.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Base_Balance_Current_GroupBox.Location = New System.Drawing.Point(281, 10)
        Me.Base_Balance_Current_GroupBox.Name = "Base_Balance_Current_GroupBox"
        Me.Base_Balance_Current_GroupBox.Size = New System.Drawing.Size(339, 109)
        Me.Base_Balance_Current_GroupBox.TabIndex = 272
        Me.Base_Balance_Current_GroupBox.TabStop = False
        Me.Base_Balance_Current_GroupBox.Text = "NOMINAL BALANCE CURRENTS"
        '
        'Average_Discharge_Current_6Cell_Units_Label
        '
        Me.Average_Discharge_Current_6Cell_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_6Cell_Units_Label.Location = New System.Drawing.Point(302, 81)
        Me.Average_Discharge_Current_6Cell_Units_Label.Name = "Average_Discharge_Current_6Cell_Units_Label"
        Me.Average_Discharge_Current_6Cell_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Average_Discharge_Current_6Cell_Units_Label.TabIndex = 54
        Me.Average_Discharge_Current_6Cell_Units_Label.Text = "A"
        Me.Average_Discharge_Current_6Cell_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Average_Charge_Current_6Cell_Units_Label
        '
        Me.Average_Charge_Current_6Cell_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_6Cell_Units_Label.Location = New System.Drawing.Point(302, 59)
        Me.Average_Charge_Current_6Cell_Units_Label.Name = "Average_Charge_Current_6Cell_Units_Label"
        Me.Average_Charge_Current_6Cell_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Average_Charge_Current_6Cell_Units_Label.TabIndex = 53
        Me.Average_Charge_Current_6Cell_Units_Label.Text = "A"
        Me.Average_Charge_Current_6Cell_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Average_Discharge_Current_12Cell_Units_Label
        '
        Me.Average_Discharge_Current_12Cell_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_12Cell_Units_Label.Location = New System.Drawing.Point(303, 37)
        Me.Average_Discharge_Current_12Cell_Units_Label.Name = "Average_Discharge_Current_12Cell_Units_Label"
        Me.Average_Discharge_Current_12Cell_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Average_Discharge_Current_12Cell_Units_Label.TabIndex = 52
        Me.Average_Discharge_Current_12Cell_Units_Label.Text = "A"
        Me.Average_Discharge_Current_12Cell_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Average_Charge_Current_12Cell_Units_Label
        '
        Me.Average_Charge_Current_12Cell_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_12Cell_Units_Label.Location = New System.Drawing.Point(303, 15)
        Me.Average_Charge_Current_12Cell_Units_Label.Name = "Average_Charge_Current_12Cell_Units_Label"
        Me.Average_Charge_Current_12Cell_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Average_Charge_Current_12Cell_Units_Label.TabIndex = 50
        Me.Average_Charge_Current_12Cell_Units_Label.Text = "A"
        Me.Average_Charge_Current_12Cell_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Average_Discharge_Current_6Cell_Label
        '
        Me.Average_Discharge_Current_6Cell_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_6Cell_Label.Location = New System.Drawing.Point(5, 81)
        Me.Average_Discharge_Current_6Cell_Label.Name = "Average_Discharge_Current_6Cell_Label"
        Me.Average_Discharge_Current_6Cell_Label.Size = New System.Drawing.Size(240, 20)
        Me.Average_Discharge_Current_6Cell_Label.TabIndex = 50
        Me.Average_Discharge_Current_6Cell_Label.Text = "Average Balancing Discharge Current (6 Cell):"
        Me.Average_Discharge_Current_6Cell_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Average_Discharge_Current_12Cell_Label
        '
        Me.Average_Discharge_Current_12Cell_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Discharge_Current_12Cell_Label.Location = New System.Drawing.Point(5, 37)
        Me.Average_Discharge_Current_12Cell_Label.Name = "Average_Discharge_Current_12Cell_Label"
        Me.Average_Discharge_Current_12Cell_Label.Size = New System.Drawing.Size(240, 20)
        Me.Average_Discharge_Current_12Cell_Label.TabIndex = 48
        Me.Average_Discharge_Current_12Cell_Label.Text = "Average Balancing Discharge Current (12 Cell):"
        Me.Average_Discharge_Current_12Cell_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Average_Charge_Current_6Cell_Label
        '
        Me.Average_Charge_Current_6Cell_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_6Cell_Label.Location = New System.Drawing.Point(5, 59)
        Me.Average_Charge_Current_6Cell_Label.Name = "Average_Charge_Current_6Cell_Label"
        Me.Average_Charge_Current_6Cell_Label.Size = New System.Drawing.Size(240, 20)
        Me.Average_Charge_Current_6Cell_Label.TabIndex = 45
        Me.Average_Charge_Current_6Cell_Label.Text = "Average Balancing Charge Current (6 Cell):"
        Me.Average_Charge_Current_6Cell_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Average_Charge_Current_12Cell_Label
        '
        Me.Average_Charge_Current_12Cell_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Average_Charge_Current_12Cell_Label.Location = New System.Drawing.Point(5, 17)
        Me.Average_Charge_Current_12Cell_Label.Name = "Average_Charge_Current_12Cell_Label"
        Me.Average_Charge_Current_12Cell_Label.Size = New System.Drawing.Size(240, 20)
        Me.Average_Charge_Current_12Cell_Label.TabIndex = 44
        Me.Average_Charge_Current_12Cell_Label.Text = "Average Balancing Charge Current (12 Cell):"
        Me.Average_Charge_Current_12Cell_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Max_Min_Cell_Voltage_GroupBox
        '
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.Under_Voltage_Units_Label)
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.Over_Voltage_Units_Label)
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.vMinBox)
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.Under_Voltage_Label)
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.vMaxBox)
        Me.Max_Min_Cell_Voltage_GroupBox.Controls.Add(Me.Over_Voltage_Label)
        Me.Max_Min_Cell_Voltage_GroupBox.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Max_Min_Cell_Voltage_GroupBox.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Max_Min_Cell_Voltage_GroupBox.Location = New System.Drawing.Point(7, 10)
        Me.Max_Min_Cell_Voltage_GroupBox.Name = "Max_Min_Cell_Voltage_GroupBox"
        Me.Max_Min_Cell_Voltage_GroupBox.Size = New System.Drawing.Size(266, 109)
        Me.Max_Min_Cell_Voltage_GroupBox.TabIndex = 271
        Me.Max_Min_Cell_Voltage_GroupBox.TabStop = False
        Me.Max_Min_Cell_Voltage_GroupBox.Text = "OVER AND UNDER VOLTAGE SETTINGS"
        '
        'Under_Voltage_Units_Label
        '
        Me.Under_Voltage_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Under_Voltage_Units_Label.Location = New System.Drawing.Point(167, 67)
        Me.Under_Voltage_Units_Label.Name = "Under_Voltage_Units_Label"
        Me.Under_Voltage_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Under_Voltage_Units_Label.TabIndex = 49
        Me.Under_Voltage_Units_Label.Text = "V"
        Me.Under_Voltage_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Over_Voltage_Units_Label
        '
        Me.Over_Voltage_Units_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Over_Voltage_Units_Label.Location = New System.Drawing.Point(167, 34)
        Me.Over_Voltage_Units_Label.Name = "Over_Voltage_Units_Label"
        Me.Over_Voltage_Units_Label.Size = New System.Drawing.Size(31, 20)
        Me.Over_Voltage_Units_Label.TabIndex = 48
        Me.Over_Voltage_Units_Label.Text = "V"
        Me.Over_Voltage_Units_Label.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Under_Voltage_Label
        '
        Me.Under_Voltage_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Under_Voltage_Label.Location = New System.Drawing.Point(13, 67)
        Me.Under_Voltage_Label.Name = "Under_Voltage_Label"
        Me.Under_Voltage_Label.Size = New System.Drawing.Size(86, 20)
        Me.Under_Voltage_Label.TabIndex = 45
        Me.Under_Voltage_Label.Text = "Min Cell Voltage:"
        Me.Under_Voltage_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Over_Voltage_Label
        '
        Me.Over_Voltage_Label.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Over_Voltage_Label.Location = New System.Drawing.Point(13, 34)
        Me.Over_Voltage_Label.Name = "Over_Voltage_Label"
        Me.Over_Voltage_Label.Size = New System.Drawing.Size(89, 20)
        Me.Over_Voltage_Label.TabIndex = 44
        Me.Over_Voltage_Label.Text = "Max Cell Voltage:"
        Me.Over_Voltage_Label.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ShapeContainer3
        '
        Me.ShapeContainer3.Location = New System.Drawing.Point(0, 0)
        Me.ShapeContainer3.Margin = New System.Windows.Forms.Padding(0)
        Me.ShapeContainer3.Name = "ShapeContainer3"
        Me.ShapeContainer3.Shapes.AddRange(New Microsoft.VisualBasic.PowerPacks.Shape() {Me.RectangleShape13})
        Me.ShapeContainer3.Size = New System.Drawing.Size(1037, 131)
        Me.ShapeContainer3.TabIndex = 274
        Me.ShapeContainer3.TabStop = False
        '
        'RectangleShape13
        '
        Me.RectangleShape13.BackColor = System.Drawing.Color.Transparent
        Me.RectangleShape13.BorderColor = System.Drawing.SystemColors.ControlLightLight
        Me.RectangleShape13.Enabled = False
        Me.RectangleShape13.Location = New System.Drawing.Point(0, 0)
        Me.RectangleShape13.Name = "RectangleShape13"
        Me.RectangleShape13.Size = New System.Drawing.Size(1036, 130)
        '
        'CapBoardBtn
        '
        Me.CapBoardBtn.BackColor = System.Drawing.Color.LightGray
        Me.CapBoardBtn.Enabled = False
        Me.CapBoardBtn.Location = New System.Drawing.Point(966, 6)
        Me.CapBoardBtn.Name = "CapBoardBtn"
        Me.CapBoardBtn.Size = New System.Drawing.Size(106, 37)
        Me.CapBoardBtn.TabIndex = 270
        Me.CapBoardBtn.Text = "Graph Data"
        Me.CapBoardBtn.UseVisualStyleBackColor = False
        '
        'pictureBox7
        '
        Me.pictureBox7.Image = CType(resources.GetObject("pictureBox7.Image"), System.Drawing.Image)
        Me.pictureBox7.Location = New System.Drawing.Point(1079, -6)
        Me.pictureBox7.Name = "pictureBox7"
        Me.pictureBox7.Size = New System.Drawing.Size(370, 121)
        Me.pictureBox7.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox7.TabIndex = 269
        Me.pictureBox7.TabStop = False
        '
        'NoteLabel
        '
        Me.NoteLabel.Anchor = System.Windows.Forms.AnchorStyles.Right
        Me.NoteLabel.AutoSize = True
        Me.NoteLabel.Font = New System.Drawing.Font("Arial", 12.0!, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.NoteLabel.Location = New System.Drawing.Point(6, 2)
        Me.NoteLabel.Name = "NoteLabel"
        Me.NoteLabel.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.NoteLabel.Size = New System.Drawing.Size(0, 19)
        Me.NoteLabel.TabIndex = 273
        Me.NoteLabel.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Panel1
        '
        Me.Panel1.BackColor = System.Drawing.Color.Silver
        Me.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.Panel1.Controls.Add(Me.Update_Firmware_Button)
        Me.Panel1.Controls.Add(Me.Board_Selected_GroupBox)
        Me.Panel1.Controls.Add(Me.Calibration_Data_Button)
        Me.Panel1.Controls.Add(Me.SN_TextBox)
        Me.Panel1.Controls.Add(Me.Write_MfgData_Button)
        Me.Panel1.Controls.Add(Me.SN_Label)
        Me.Panel1.Controls.Add(Me.ErrLogBtn)
        Me.Panel1.Controls.Add(Me.CapBoardBtn)
        Me.Panel1.Controls.Add(Me.pictureBox7)
        Me.Panel1.Location = New System.Drawing.Point(-3, 0)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(1451, 51)
        Me.Panel1.TabIndex = 310
        '
        'Board_Selected_GroupBox
        '
        Me.Board_Selected_GroupBox.Controls.Add(Me.Board_Selected_Number_Label)
        Me.Board_Selected_GroupBox.Controls.Add(Me.Num_Boards_Label)
        Me.Board_Selected_GroupBox.Controls.Add(Me.Board_Count_Label)
        Me.Board_Selected_GroupBox.Controls.Add(Me.Board_Selected_Label)
        Me.Board_Selected_GroupBox.Location = New System.Drawing.Point(14, -1)
        Me.Board_Selected_GroupBox.Name = "Board_Selected_GroupBox"
        Me.Board_Selected_GroupBox.Size = New System.Drawing.Size(139, 45)
        Me.Board_Selected_GroupBox.TabIndex = 281
        Me.Board_Selected_GroupBox.TabStop = False
        '
        'Board_Selected_Number_Label
        '
        Me.Board_Selected_Number_Label.Location = New System.Drawing.Point(97, 26)
        Me.Board_Selected_Number_Label.Name = "Board_Selected_Number_Label"
        Me.Board_Selected_Number_Label.Size = New System.Drawing.Size(37, 14)
        Me.Board_Selected_Number_Label.TabIndex = 280
        Me.Board_Selected_Number_Label.Text = "N/A"
        '
        'Num_Boards_Label
        '
        Me.Num_Boards_Label.Location = New System.Drawing.Point(10, 11)
        Me.Num_Boards_Label.Name = "Num_Boards_Label"
        Me.Num_Boards_Label.Size = New System.Drawing.Size(88, 14)
        Me.Num_Boards_Label.TabIndex = 2
        Me.Num_Boards_Label.Text = "# Boards:"
        Me.Num_Boards_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'Board_Count_Label
        '
        Me.Board_Count_Label.Location = New System.Drawing.Point(97, 11)
        Me.Board_Count_Label.Name = "Board_Count_Label"
        Me.Board_Count_Label.Size = New System.Drawing.Size(37, 14)
        Me.Board_Count_Label.TabIndex = 279
        Me.Board_Count_Label.Text = "0"
        '
        'Board_Selected_Label
        '
        Me.Board_Selected_Label.Location = New System.Drawing.Point(4, 26)
        Me.Board_Selected_Label.Name = "Board_Selected_Label"
        Me.Board_Selected_Label.Size = New System.Drawing.Size(95, 14)
        Me.Board_Selected_Label.TabIndex = 278
        Me.Board_Selected_Label.Text = "Board Selected:"
        Me.Board_Selected_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'Calibration_Data_Button
        '
        Me.Calibration_Data_Button.BackColor = System.Drawing.Color.LightGray
        Me.Calibration_Data_Button.Location = New System.Drawing.Point(740, 6)
        Me.Calibration_Data_Button.Name = "Calibration_Data_Button"
        Me.Calibration_Data_Button.Size = New System.Drawing.Size(106, 37)
        Me.Calibration_Data_Button.TabIndex = 277
        Me.Calibration_Data_Button.Text = "Calibration Data"
        Me.Calibration_Data_Button.UseVisualStyleBackColor = False
        '
        'SN_TextBox
        '
        Me.SN_TextBox.Enabled = False
        Me.SN_TextBox.Location = New System.Drawing.Point(366, 3)
        Me.SN_TextBox.Name = "SN_TextBox"
        Me.SN_TextBox.Size = New System.Drawing.Size(141, 20)
        Me.SN_TextBox.TabIndex = 274
        Me.SN_TextBox.Text = "N/A"
        '
        'Write_MfgData_Button
        '
        Me.Write_MfgData_Button.BackColor = System.Drawing.Color.LightGray
        Me.Write_MfgData_Button.Enabled = False
        Me.Write_MfgData_Button.Location = New System.Drawing.Point(514, 6)
        Me.Write_MfgData_Button.Name = "Write_MfgData_Button"
        Me.Write_MfgData_Button.Size = New System.Drawing.Size(106, 37)
        Me.Write_MfgData_Button.TabIndex = 275
        Me.Write_MfgData_Button.Text = "Checkout SN and Write Mfg Data"
        Me.Write_MfgData_Button.UseVisualStyleBackColor = False
        Me.Write_MfgData_Button.Visible = False
        '
        'SN_Label
        '
        Me.SN_Label.Location = New System.Drawing.Point(313, 6)
        Me.SN_Label.Name = "SN_Label"
        Me.SN_Label.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.SN_Label.Size = New System.Drawing.Size(50, 14)
        Me.SN_Label.TabIndex = 273
        Me.SN_Label.Text = "S/N:"
        Me.SN_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'ErrLogBtn
        '
        Me.ErrLogBtn.BackColor = System.Drawing.Color.LightGray
        Me.ErrLogBtn.Location = New System.Drawing.Point(853, 6)
        Me.ErrLogBtn.Name = "ErrLogBtn"
        Me.ErrLogBtn.Size = New System.Drawing.Size(106, 37)
        Me.ErrLogBtn.TabIndex = 272
        Me.ErrLogBtn.Text = "Event Log"
        Me.ErrLogBtn.UseVisualStyleBackColor = False
        '
        'PictureBox1
        '
        Me.PictureBox1.BackColor = System.Drawing.Color.Transparent
        Me.PictureBox1.Image = CType(resources.GetObject("PictureBox1.Image"), System.Drawing.Image)
        Me.PictureBox1.InitialImage = CType(resources.GetObject("PictureBox1.InitialImage"), System.Drawing.Image)
        Me.PictureBox1.Location = New System.Drawing.Point(371, 10)
        Me.PictureBox1.Name = "PictureBox1"
        Me.PictureBox1.Size = New System.Drawing.Size(331, 105)
        Me.PictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.PictureBox1.TabIndex = 304
        Me.PictureBox1.TabStop = False
        '
        'Label34
        '
        Me.Label34.AutoSize = True
        Me.Label34.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label34.Location = New System.Drawing.Point(376, 146)
        Me.Label34.Name = "Label34"
        Me.Label34.Size = New System.Drawing.Size(16, 18)
        Me.Label34.TabIndex = 290
        '
        'Label33
        '
        Me.Label33.AutoSize = True
        Me.Label33.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label33.Location = New System.Drawing.Point(432, 146)
        Me.Label33.Name = "Label33"
        Me.Label33.Size = New System.Drawing.Size(16, 18)
        Me.Label33.TabIndex = 291
        '
        'Label35
        '
        Me.Label35.AutoSize = True
        Me.Label35.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label35.Location = New System.Drawing.Point(322, 146)
        Me.Label35.Name = "Label35"
        Me.Label35.Size = New System.Drawing.Size(16, 18)
        Me.Label35.TabIndex = 289
        '
        'Label36
        '
        Me.Label36.AutoSize = True
        Me.Label36.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label36.Location = New System.Drawing.Point(264, 146)
        Me.Label36.Name = "Label36"
        Me.Label36.Size = New System.Drawing.Size(16, 18)
        Me.Label36.TabIndex = 288
        '
        'Label37
        '
        Me.Label37.AutoSize = True
        Me.Label37.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label37.Location = New System.Drawing.Point(211, 146)
        Me.Label37.Name = "Label37"
        Me.Label37.Size = New System.Drawing.Size(16, 18)
        Me.Label37.TabIndex = 287
        '
        'Label38
        '
        Me.Label38.AutoSize = True
        Me.Label38.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label38.Location = New System.Drawing.Point(155, 146)
        Me.Label38.Name = "Label38"
        Me.Label38.Size = New System.Drawing.Size(16, 18)
        Me.Label38.TabIndex = 286
        '
        'Label39
        '
        Me.Label39.AutoSize = True
        Me.Label39.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label39.Location = New System.Drawing.Point(425, 61)
        Me.Label39.Name = "Label39"
        Me.Label39.Size = New System.Drawing.Size(24, 18)
        Me.Label39.TabIndex = 285
        '
        'Label40
        '
        Me.Label40.AutoSize = True
        Me.Label40.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label40.Location = New System.Drawing.Point(369, 61)
        Me.Label40.Name = "Label40"
        Me.Label40.Size = New System.Drawing.Size(24, 18)
        Me.Label40.TabIndex = 284
        '
        'Label41
        '
        Me.Label41.AutoSize = True
        Me.Label41.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label41.Location = New System.Drawing.Point(316, 61)
        Me.Label41.Name = "Label41"
        Me.Label41.Size = New System.Drawing.Size(24, 18)
        Me.Label41.TabIndex = 283
        '
        'Label42
        '
        Me.Label42.AutoSize = True
        Me.Label42.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label42.Location = New System.Drawing.Point(263, 61)
        Me.Label42.Name = "Label42"
        Me.Label42.Size = New System.Drawing.Size(16, 18)
        Me.Label42.TabIndex = 282
        '
        'Label43
        '
        Me.Label43.AutoSize = True
        Me.Label43.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label43.Location = New System.Drawing.Point(209, 61)
        Me.Label43.Name = "Label43"
        Me.Label43.Size = New System.Drawing.Size(16, 18)
        Me.Label43.TabIndex = 281
        '
        'Label44
        '
        Me.Label44.AutoSize = True
        Me.Label44.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label44.Location = New System.Drawing.Point(156, 61)
        Me.Label44.Name = "Label44"
        Me.Label44.Size = New System.Drawing.Size(16, 18)
        Me.Label44.TabIndex = 280
        '
        'Label45
        '
        Me.Label45.AutoSize = True
        Me.Label45.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label45.Location = New System.Drawing.Point(91, 62)
        Me.Label45.Name = "Label45"
        Me.Label45.Size = New System.Drawing.Size(40, 18)
        Me.Label45.TabIndex = 279
        '
        'Label46
        '
        Me.Label46.AutoSize = True
        Me.Label46.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label46.Location = New System.Drawing.Point(32, 120)
        Me.Label46.Name = "Label46"
        Me.Label46.Size = New System.Drawing.Size(98, 16)
        Me.Label46.TabIndex = 266
        '
        'Label47
        '
        Me.Label47.AutoSize = True
        Me.Label47.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label47.Location = New System.Drawing.Point(56, 89)
        Me.Label47.Name = "Label47"
        Me.Label47.Size = New System.Drawing.Size(74, 16)
        Me.Label47.TabIndex = 265
        '
        'Label11
        '
        Me.Label11.AutoSize = True
        Me.Label11.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label11.Location = New System.Drawing.Point(40, 99)
        Me.Label11.Name = "Label11"
        Me.Label11.Size = New System.Drawing.Size(74, 16)
        Me.Label11.TabIndex = 52
        '
        'Label12
        '
        Me.Label12.AutoSize = True
        Me.Label12.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label12.Location = New System.Drawing.Point(16, 127)
        Me.Label12.Name = "Label12"
        Me.Label12.Size = New System.Drawing.Size(98, 16)
        Me.Label12.TabIndex = 53
        '
        'Label15
        '
        Me.Label15.AutoSize = True
        Me.Label15.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label15.Location = New System.Drawing.Point(327, 72)
        Me.Label15.Name = "Label15"
        Me.Label15.Size = New System.Drawing.Size(41, 18)
        Me.Label15.TabIndex = 56
        '
        'Label16
        '
        Me.Label16.AutoSize = True
        Me.Label16.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label16.Location = New System.Drawing.Point(72, 73)
        Me.Label16.Name = "Label16"
        Me.Label16.Size = New System.Drawing.Size(40, 18)
        Me.Label16.TabIndex = 239
        '
        'Label17
        '
        Me.Label17.AutoSize = True
        Me.Label17.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label17.Location = New System.Drawing.Point(122, 72)
        Me.Label17.Name = "Label17"
        Me.Label17.Size = New System.Drawing.Size(16, 18)
        Me.Label17.TabIndex = 240
        '
        'Label18
        '
        Me.Label18.AutoSize = True
        Me.Label18.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label18.Location = New System.Drawing.Point(152, 72)
        Me.Label18.Name = "Label18"
        Me.Label18.Size = New System.Drawing.Size(16, 18)
        Me.Label18.TabIndex = 241
        '
        'Label19
        '
        Me.Label19.AutoSize = True
        Me.Label19.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label19.Location = New System.Drawing.Point(185, 72)
        Me.Label19.Name = "Label19"
        Me.Label19.Size = New System.Drawing.Size(16, 18)
        Me.Label19.TabIndex = 242
        '
        'Label20
        '
        Me.Label20.AutoSize = True
        Me.Label20.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label20.Location = New System.Drawing.Point(218, 72)
        Me.Label20.Name = "Label20"
        Me.Label20.Size = New System.Drawing.Size(24, 18)
        Me.Label20.TabIndex = 243
        '
        'Label21
        '
        Me.Label21.AutoSize = True
        Me.Label21.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label21.Location = New System.Drawing.Point(251, 72)
        Me.Label21.Name = "Label21"
        Me.Label21.Size = New System.Drawing.Size(24, 18)
        Me.Label21.TabIndex = 244
        '
        'Label22
        '
        Me.Label22.AutoSize = True
        Me.Label22.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label22.Location = New System.Drawing.Point(284, 72)
        Me.Label22.Name = "Label22"
        Me.Label22.Size = New System.Drawing.Size(24, 18)
        Me.Label22.TabIndex = 245
        '
        'Label23
        '
        Me.Label23.AutoSize = True
        Me.Label23.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label23.Location = New System.Drawing.Point(440, 72)
        Me.Label23.Name = "Label23"
        Me.Label23.Size = New System.Drawing.Size(112, 16)
        Me.Label23.TabIndex = 246
        '
        'Label24
        '
        Me.Label24.AutoSize = True
        Me.Label24.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label24.Location = New System.Drawing.Point(549, 72)
        Me.Label24.Name = "Label24"
        Me.Label24.Size = New System.Drawing.Size(41, 18)
        Me.Label24.TabIndex = 247
        '
        'Label26
        '
        Me.Label26.AutoSize = True
        Me.Label26.Font = New System.Drawing.Font("Arial", 10.2!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label26.Location = New System.Drawing.Point(667, 72)
        Me.Label26.Name = "Label26"
        Me.Label26.Size = New System.Drawing.Size(52, 16)
        Me.Label26.TabIndex = 248
        '
        'Label25
        '
        Me.Label25.AutoSize = True
        Me.Label25.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label25.Location = New System.Drawing.Point(737, 72)
        Me.Label25.Name = "Label25"
        Me.Label25.Size = New System.Drawing.Size(41, 18)
        Me.Label25.TabIndex = 249
        '
        'Label32
        '
        Me.Label32.AutoSize = True
        Me.Label32.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label32.Location = New System.Drawing.Point(122, 151)
        Me.Label32.Name = "Label32"
        Me.Label32.Size = New System.Drawing.Size(16, 18)
        Me.Label32.TabIndex = 250
        '
        'Label31
        '
        Me.Label31.AutoSize = True
        Me.Label31.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label31.Location = New System.Drawing.Point(152, 151)
        Me.Label31.Name = "Label31"
        Me.Label31.Size = New System.Drawing.Size(16, 18)
        Me.Label31.TabIndex = 251
        '
        'Label30
        '
        Me.Label30.AutoSize = True
        Me.Label30.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label30.Location = New System.Drawing.Point(185, 151)
        Me.Label30.Name = "Label30"
        Me.Label30.Size = New System.Drawing.Size(16, 18)
        Me.Label30.TabIndex = 252
        '
        'Label29
        '
        Me.Label29.AutoSize = True
        Me.Label29.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label29.Location = New System.Drawing.Point(218, 151)
        Me.Label29.Name = "Label29"
        Me.Label29.Size = New System.Drawing.Size(16, 18)
        Me.Label29.TabIndex = 253
        '
        'Label28
        '
        Me.Label28.AutoSize = True
        Me.Label28.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label28.Location = New System.Drawing.Point(251, 151)
        Me.Label28.Name = "Label28"
        Me.Label28.Size = New System.Drawing.Size(16, 18)
        Me.Label28.TabIndex = 254
        '
        'Label27
        '
        Me.Label27.AutoSize = True
        Me.Label27.Font = New System.Drawing.Font("Arial", 11.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label27.Location = New System.Drawing.Point(284, 151)
        Me.Label27.Name = "Label27"
        Me.Label27.Size = New System.Drawing.Size(16, 18)
        Me.Label27.TabIndex = 255
        '
        'TextBox1
        '
        Me.TextBox1.BackColor = System.Drawing.SystemColors.Window
        Me.TextBox1.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.TextBox1.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox1.ForeColor = System.Drawing.SystemColors.WindowText
        Me.TextBox1.Location = New System.Drawing.Point(321, 93)
        Me.TextBox1.MaxLength = 0
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.ReadOnly = True
        Me.TextBox1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.TextBox1.Size = New System.Drawing.Size(47, 22)
        Me.TextBox1.TabIndex = 37
        Me.TextBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'TextBox2
        '
        Me.TextBox2.BackColor = System.Drawing.SystemColors.Window
        Me.TextBox2.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.TextBox2.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox2.ForeColor = System.Drawing.SystemColors.WindowText
        Me.TextBox2.Location = New System.Drawing.Point(321, 126)
        Me.TextBox2.MaxLength = 0
        Me.TextBox2.Name = "TextBox2"
        Me.TextBox2.ReadOnly = True
        Me.TextBox2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.TextBox2.Size = New System.Drawing.Size(47, 22)
        Me.TextBox2.TabIndex = 256
        Me.TextBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cmdBox2
        '
        Me.cmdBox2.BackColor = System.Drawing.SystemColors.Window
        Me.cmdBox2.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.cmdBox2.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdBox2.ForeColor = System.Drawing.SystemColors.WindowText
        Me.cmdBox2.Location = New System.Drawing.Point(448, 93)
        Me.cmdBox2.MaxLength = 0
        Me.cmdBox2.Name = "cmdBox2"
        Me.cmdBox2.ReadOnly = True
        Me.cmdBox2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdBox2.Size = New System.Drawing.Size(96, 22)
        Me.cmdBox2.TabIndex = 257
        Me.cmdBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cmdCRC2
        '
        Me.cmdCRC2.BackColor = System.Drawing.SystemColors.Window
        Me.cmdCRC2.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.cmdCRC2.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdCRC2.ForeColor = System.Drawing.SystemColors.WindowText
        Me.cmdCRC2.Location = New System.Drawing.Point(550, 93)
        Me.cmdCRC2.MaxLength = 0
        Me.cmdCRC2.Name = "cmdCRC2"
        Me.cmdCRC2.ReadOnly = True
        Me.cmdCRC2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdCRC2.Size = New System.Drawing.Size(34, 22)
        Me.cmdCRC2.TabIndex = 258
        Me.cmdCRC2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cmdBox1
        '
        Me.cmdBox1.BackColor = System.Drawing.SystemColors.Window
        Me.cmdBox1.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.cmdBox1.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdBox1.ForeColor = System.Drawing.SystemColors.WindowText
        Me.cmdBox1.Location = New System.Drawing.Point(448, 121)
        Me.cmdBox1.MaxLength = 0
        Me.cmdBox1.Name = "cmdBox1"
        Me.cmdBox1.ReadOnly = True
        Me.cmdBox1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdBox1.Size = New System.Drawing.Size(96, 22)
        Me.cmdBox1.TabIndex = 259
        Me.cmdBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'cmdCRC1
        '
        Me.cmdCRC1.BackColor = System.Drawing.SystemColors.Window
        Me.cmdCRC1.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.cmdCRC1.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdCRC1.ForeColor = System.Drawing.SystemColors.WindowText
        Me.cmdCRC1.Location = New System.Drawing.Point(550, 121)
        Me.cmdCRC1.MaxLength = 0
        Me.cmdCRC1.Name = "cmdCRC1"
        Me.cmdCRC1.ReadOnly = True
        Me.cmdCRC1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdCRC1.Size = New System.Drawing.Size(34, 22)
        Me.cmdCRC1.TabIndex = 260
        Me.cmdCRC1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'statBox2
        '
        Me.statBox2.BackColor = System.Drawing.SystemColors.Window
        Me.statBox2.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.statBox2.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.statBox2.ForeColor = System.Drawing.SystemColors.WindowText
        Me.statBox2.Location = New System.Drawing.Point(645, 93)
        Me.statBox2.MaxLength = 0
        Me.statBox2.Name = "statBox2"
        Me.statBox2.ReadOnly = True
        Me.statBox2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.statBox2.Size = New System.Drawing.Size(89, 22)
        Me.statBox2.TabIndex = 261
        Me.statBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'statCRC2
        '
        Me.statCRC2.BackColor = System.Drawing.SystemColors.Window
        Me.statCRC2.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.statCRC2.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.statCRC2.ForeColor = System.Drawing.SystemColors.WindowText
        Me.statCRC2.Location = New System.Drawing.Point(740, 93)
        Me.statCRC2.MaxLength = 0
        Me.statCRC2.Name = "statCRC2"
        Me.statCRC2.ReadOnly = True
        Me.statCRC2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.statCRC2.Size = New System.Drawing.Size(34, 22)
        Me.statCRC2.TabIndex = 262
        Me.statCRC2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'statBox1
        '
        Me.statBox1.BackColor = System.Drawing.SystemColors.Window
        Me.statBox1.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.statBox1.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.statBox1.ForeColor = System.Drawing.SystemColors.WindowText
        Me.statBox1.Location = New System.Drawing.Point(645, 121)
        Me.statBox1.MaxLength = 0
        Me.statBox1.Name = "statBox1"
        Me.statBox1.ReadOnly = True
        Me.statBox1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.statBox1.Size = New System.Drawing.Size(89, 22)
        Me.statBox1.TabIndex = 263
        Me.statBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'statCRC1
        '
        Me.statCRC1.BackColor = System.Drawing.SystemColors.Window
        Me.statCRC1.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.statCRC1.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.statCRC1.ForeColor = System.Drawing.SystemColors.WindowText
        Me.statCRC1.Location = New System.Drawing.Point(740, 121)
        Me.statCRC1.MaxLength = 0
        Me.statCRC1.Name = "statCRC1"
        Me.statCRC1.ReadOnly = True
        Me.statCRC1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.statCRC1.Size = New System.Drawing.Size(34, 22)
        Me.statCRC1.TabIndex = 264
        Me.statCRC1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Cell_Present_Context_Menu_Strip
        '
        Me.Cell_Present_Context_Menu_Strip.Items.AddRange(New System.Windows.Forms.ToolStripItem() {Me.Cell4, Me.Cell5, Me.Cell6, Me.Cell7, Me.Cell8, Me.Cell9, Me.Cell10, Me.Cell11, Me.Cell12})
        Me.Cell_Present_Context_Menu_Strip.Name = "ContextMenuStrip1"
        Me.Cell_Present_Context_Menu_Strip.Size = New System.Drawing.Size(184, 202)
        '
        'Cell4
        '
        Me.Cell4.Name = "Cell4"
        Me.Cell4.Size = New System.Drawing.Size(183, 22)
        Me.Cell4.Text = "ToolStripMenuItem1"
        '
        'Cell5
        '
        Me.Cell5.Name = "Cell5"
        Me.Cell5.Size = New System.Drawing.Size(183, 22)
        Me.Cell5.Text = "ToolStripMenuItem1"
        '
        'Cell6
        '
        Me.Cell6.Name = "Cell6"
        Me.Cell6.Size = New System.Drawing.Size(183, 22)
        Me.Cell6.Text = "ToolStripMenuItem1"
        '
        'Cell7
        '
        Me.Cell7.Name = "Cell7"
        Me.Cell7.Size = New System.Drawing.Size(183, 22)
        Me.Cell7.Text = "ToolStripMenuItem1"
        '
        'Cell8
        '
        Me.Cell8.Name = "Cell8"
        Me.Cell8.Size = New System.Drawing.Size(183, 22)
        Me.Cell8.Text = "ToolStripMenuItem1"
        '
        'Cell9
        '
        Me.Cell9.Name = "Cell9"
        Me.Cell9.Size = New System.Drawing.Size(183, 22)
        Me.Cell9.Text = "ToolStripMenuItem1"
        '
        'Cell10
        '
        Me.Cell10.Name = "Cell10"
        Me.Cell10.Size = New System.Drawing.Size(183, 22)
        Me.Cell10.Text = "ToolStripMenuItem1"
        '
        'Cell11
        '
        Me.Cell11.Name = "Cell11"
        Me.Cell11.Size = New System.Drawing.Size(183, 22)
        Me.Cell11.Text = "ToolStripMenuItem1"
        '
        'Cell12
        '
        Me.Cell12.Name = "Cell12"
        Me.Cell12.Size = New System.Drawing.Size(183, 22)
        Me.Cell12.Text = "ToolStripMenuItem1"
        '
        'Panel2
        '
        Me.Panel2.BackColor = System.Drawing.Color.Transparent
        Me.Panel2.Controls.Add(Me.Debug_TextBox)
        Me.Panel2.Controls.Add(Me.Reset_Mfg_Data_Button)
        Me.Panel2.Controls.Add(Me.NoteLabel)
        Me.Panel2.Controls.Add(Me.Advanced_Button)
        Me.Panel2.Location = New System.Drawing.Point(361, 52)
        Me.Panel2.Name = "Panel2"
        Me.Panel2.Size = New System.Drawing.Size(816, 23)
        Me.Panel2.TabIndex = 274
        '
        'Debug_TextBox
        '
        Me.Debug_TextBox.AccessibleRole = System.Windows.Forms.AccessibleRole.None
        Me.Debug_TextBox.Enabled = False
        Me.Debug_TextBox.Location = New System.Drawing.Point(415, 3)
        Me.Debug_TextBox.Name = "Debug_TextBox"
        Me.Debug_TextBox.Size = New System.Drawing.Size(449, 20)
        Me.Debug_TextBox.TabIndex = 293
        Me.Debug_TextBox.Visible = False
        '
        'noteLabelTimer
        '
        Me.noteLabelTimer.Interval = 1000
        '
        'USB_Communication_Timer
        '
        Me.USB_Communication_Timer.Interval = 20
        '
        'FW_Rev_Label
        '
        Me.FW_Rev_Label.BackColor = System.Drawing.Color.Silver
        Me.FW_Rev_Label.Location = New System.Drawing.Point(313, 29)
        Me.FW_Rev_Label.Name = "FW_Rev_Label"
        Me.FW_Rev_Label.Size = New System.Drawing.Size(50, 14)
        Me.FW_Rev_Label.TabIndex = 311
        Me.FW_Rev_Label.Text = "FW Rev:"
        Me.FW_Rev_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'FW_Rev_TextBox
        '
        Me.FW_Rev_TextBox.Enabled = False
        Me.FW_Rev_TextBox.Location = New System.Drawing.Point(364, 25)
        Me.FW_Rev_TextBox.Name = "FW_Rev_TextBox"
        Me.FW_Rev_TextBox.Size = New System.Drawing.Size(141, 20)
        Me.FW_Rev_TextBox.TabIndex = 312
        Me.FW_Rev_TextBox.Text = "N/A"
        '
        'CapDemo_Label
        '
        Me.CapDemo_Label.AutoSize = True
        Me.CapDemo_Label.BackColor = System.Drawing.Color.Silver
        Me.CapDemo_Label.Location = New System.Drawing.Point(162, 28)
        Me.CapDemo_Label.Name = "CapDemo_Label"
        Me.CapDemo_Label.Size = New System.Drawing.Size(59, 14)
        Me.CapDemo_Label.TabIndex = 313
        Me.CapDemo_Label.Text = "Cap Demo:"
        Me.CapDemo_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'CapDemo_ComboBox
        '
        Me.CapDemo_ComboBox.Enabled = False
        Me.CapDemo_ComboBox.FormattingEnabled = True
        Me.CapDemo_ComboBox.Items.AddRange(New Object() {"FALSE", "TRUE"})
        Me.CapDemo_ComboBox.Location = New System.Drawing.Point(221, 24)
        Me.CapDemo_ComboBox.Name = "CapDemo_ComboBox"
        Me.CapDemo_ComboBox.Size = New System.Drawing.Size(94, 22)
        Me.CapDemo_ComboBox.TabIndex = 314
        '
        'Model_Label
        '
        Me.Model_Label.AutoSize = True
        Me.Model_Label.BackColor = System.Drawing.Color.Silver
        Me.Model_Label.Location = New System.Drawing.Point(182, 6)
        Me.Model_Label.Name = "Model_Label"
        Me.Model_Label.Size = New System.Drawing.Size(38, 14)
        Me.Model_Label.TabIndex = 315
        Me.Model_Label.Text = "Model:"
        Me.Model_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'Model_ComboBox
        '
        Me.Model_ComboBox.Enabled = False
        Me.Model_ComboBox.FormattingEnabled = True
        Me.Model_ComboBox.Items.AddRange(New Object() {"DC2100A-A", "DC2100A-B", "DC2100A-C", "DC2100A-D"})
        Me.Model_ComboBox.Location = New System.Drawing.Point(221, 2)
        Me.Model_ComboBox.Name = "Model_ComboBox"
        Me.Model_ComboBox.Size = New System.Drawing.Size(94, 22)
        Me.Model_ComboBox.TabIndex = 316
        '
        'Mfg_PipeTimer
        '
        Me.Mfg_PipeTimer.Interval = 500
        '
        'Mfg_PipeWorker
        '
        Me.Mfg_PipeWorker.WorkerSupportsCancellation = True
        '
        'LED_Label
        '
        Me.LED_Label.Location = New System.Drawing.Point(5, 56)
        Me.LED_Label.Name = "LED_Label"
        Me.LED_Label.Size = New System.Drawing.Size(110, 14)
        Me.LED_Label.TabIndex = 281
        Me.LED_Label.Text = "Board Status LEDs:"
        Me.LED_Label.TextAlign = System.Drawing.ContentAlignment.TopRight
        Me.LED_Label.Visible = False
        '
        'WritePipe_BackgroundWorker
        '
        Me.WritePipe_BackgroundWorker.WorkerSupportsCancellation = True
        '
        'D33001
        '
        Me.AutoScaleDimensions = New System.Drawing.SizeF(96.0!, 96.0!)
        Me.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Dpi
        Me.BackColor = System.Drawing.Color.DarkGray
        Me.ClientSize = New System.Drawing.Size(1229, 730)
        Me.Controls.Add(Me.LED_Label)
        Me.Controls.Add(Me.Status_LED_PictureBox)
        Me.Controls.Add(Me.Comm_LED_PictureBox)
        Me.Controls.Add(Me.Model_ComboBox)
        Me.Controls.Add(Me.Model_Label)
        Me.Controls.Add(Me.CapDemo_ComboBox)
        Me.Controls.Add(Me.CapDemo_Label)
        Me.Controls.Add(Me.FW_Rev_TextBox)
        Me.Controls.Add(Me.FW_Rev_Label)
        Me.Controls.Add(Me.Panel2)
        Me.Controls.Add(Me.Panel1)
        Me.Controls.Add(Me.TreeView1)
        Me.Controls.Add(Me.SplitContainer1)
        Me.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Location = New System.Drawing.Point(21, 28)
        Me.MaximizeBox = False
        Me.MaximumSize = New System.Drawing.Size(1245, 768)
        Me.Name = "D33001"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "DC2100A Control Panel"
        CType(Me.Comm_LED_PictureBox, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.Status_LED_PictureBox, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.SplitContainer1.Panel1.ResumeLayout(False)
        Me.SplitContainer1.Panel2.ResumeLayout(False)
        Me.SplitContainer1.Panel2.PerformLayout()
        CType(Me.SplitContainer1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.SplitContainer1.ResumeLayout(False)
        Me.TabControl1.ResumeLayout(False)
        Me.TabPage1.ResumeLayout(False)
        Me.TabPage1.PerformLayout()
        Me.Balance_Control_GroupBox.ResumeLayout(False)
        Me.Balance_Control_Manual_GroupBox.ResumeLayout(False)
        Me.Balance_Control_Manual_GroupBox.PerformLayout()
        Me.GroupBox3.ResumeLayout(False)
        Me.Balance_Control_Timed_GroupBox.ResumeLayout(False)
        Me.Balance_Control_Timed_GroupBox.PerformLayout()
        Me.Panel5.ResumeLayout(False)
        CType(Me.Config_Load_NumericUpDown, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.Config_Save_NumericUpDown, System.ComponentModel.ISupportInitialize).EndInit()
        Me.Panel4.ResumeLayout(False)
        Me.Panel4.PerformLayout()
        Me.GroupBox5.ResumeLayout(False)
        Me.GroupBox5.PerformLayout()
        Me.Temperature_IC2_GroupBox.ResumeLayout(False)
        Me.Temperature_IC2_GroupBox.PerformLayout()
        Me.groupBox8.ResumeLayout(False)
        Me.groupBox8.PerformLayout()
        CType(Me.cellpic12, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox7.ResumeLayout(False)
        Me.groupBox7.PerformLayout()
        CType(Me.cellpic11, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox6.ResumeLayout(False)
        Me.GroupBox6.PerformLayout()
        CType(Me.cellpic7, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox16.ResumeLayout(False)
        Me.GroupBox16.PerformLayout()
        CType(Me.cellpic8, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox17.ResumeLayout(False)
        Me.GroupBox17.PerformLayout()
        CType(Me.cellpic9, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox18.ResumeLayout(False)
        Me.GroupBox18.PerformLayout()
        CType(Me.cellpic10, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox19.ResumeLayout(False)
        Me.GroupBox19.PerformLayout()
        CType(Me.PictureBox2, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.pictureBox8, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.pictureBox9, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.pictureBox11, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.pictureBox12, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.pictureBox13, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox9.ResumeLayout(False)
        Me.groupBox9.PerformLayout()
        Me.Temperature_IC1_GroupBox.ResumeLayout(False)
        Me.Temperature_IC1_GroupBox.PerformLayout()
        Me.groupBox10.ResumeLayout(False)
        Me.groupBox10.PerformLayout()
        CType(Me.cellpic6, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox11.ResumeLayout(False)
        Me.groupBox11.PerformLayout()
        CType(Me.cellpic5, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox12.ResumeLayout(False)
        Me.groupBox12.PerformLayout()
        CType(Me.cellpic4, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox13.ResumeLayout(False)
        Me.groupBox13.PerformLayout()
        CType(Me.cellpic3, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox14.ResumeLayout(False)
        Me.groupBox14.PerformLayout()
        CType(Me.cellpic2, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox15.ResumeLayout(False)
        Me.groupBox15.PerformLayout()
        CType(Me.cellpic1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.TabPage2.ResumeLayout(False)
        CType(Me.CellGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.Data_Logging_GroupBox.ResumeLayout(False)
        Me.Data_Logging_GroupBox.PerformLayout()
        Me.Base_Balance_Current_GroupBox.ResumeLayout(False)
        Me.Base_Balance_Current_GroupBox.PerformLayout()
        Me.Max_Min_Cell_Voltage_GroupBox.ResumeLayout(False)
        Me.Max_Min_Cell_Voltage_GroupBox.PerformLayout()
        CType(Me.pictureBox7, System.ComponentModel.ISupportInitialize).EndInit()
        Me.Panel1.ResumeLayout(False)
        Me.Panel1.PerformLayout()
        Me.Board_Selected_GroupBox.ResumeLayout(False)
        CType(Me.PictureBox1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.Cell_Present_Context_Menu_Strip.ResumeLayout(False)
        Me.Panel2.ResumeLayout(False)
        Me.Panel2.PerformLayout()
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub
#End Region

#Region "Form Startup and Shutdown"
    ''' <summary>
    ''' Perform startup operations.
    ''' </summary>
    Private Sub D33001_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs
                                 ) Handles MyBase.Load

        ' Add the current version to the title bar
        Me.Text += " -- Version " & Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString

        Try
            ' Set the Device Interface GUID for the LTCDevices instance of the DeviceManagement class
            LTCDevices.DeviceInterfaceGUIDvalue = New Guid(LTC_DEVICE_INTERFACE_GUID_STRING)

            ' This both invokes a catalog of all the connected devices with the Device Interface GUID and
            ' returns a count.  CatalogDevices will return a -1 if the GUID is invalid, or a device count of
            ' 0, if the GUID is valid but there are no devices of that Device Interface GUID attached.
            If LTCDevices.CatalogDevices > 0 Then
                For i As Integer = 0 To LTCDevices.AllDevices.Count - 1
                    ComboBox1.Items.Add(LTCDevices.AllDevices(i).DeviceName _
                                        & ", PID = " & LTCDevices.AllDevices(i).PID & ", S/N = " _
                                        & LTCDevices.AllDevices(i).SerialNo)
                Next i
                ' If exist, select the first device by default, at form load.  The Listbox selected item
                ' change event will fire and the event handler will take care of the initializing the device.
                ComboBox1.SelectedIndex = 0
                '   Else
                '      ComboBox1.SelectedIndex = -1          ' -1 means 'none'

            End If

            ' Register for attach/detach messages from the Device Interface GUID, ignore success
            LTCDevices.RegisterForDeviceNotifications(Me.Handle)

            RemovalTimer.Stop()

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try

        ' Initialize the directory where we are running
        'checkDirectory()
        filePath = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase)
        filePath = filePath.Substring("file:\".Length()) + System.IO.Path.DirectorySeparatorChar

        ' todo - this is so gross.  The interface between the FW and the SW needs to be much better controlled
        ' These commands are fixed length
        USB_Parser_Response_Data.Add(USB_PARSER_MFG_COMMAND, 1 + (1 * 2) + DC2100A_MODEL_NUM_DEFAULT.Length + 1 + DC2100A_SERIAL_NUM_DEFAULT.Length + (4 * 2 * 2) + APP_FW_STRING_DEFAULT.Length)
        USB_Parser_Response_Data.Add(USB_PARSER_SYSTEM_COMMAND, 1 + (1 * 2) + (LTC6804_MAX_BOARDS * 1 * 2) + (2 * 2) + (2 * 2) + (1 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_VOLTAGE_COMMAND, 1 + (1 * 2) + (4 * 2) + (MAX_CELLS * 2 * 2) + (1 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_TEMPERATURE_COMMAND, 1 + (1 * 2) + (4 * 2) + (MAX_CELLS * 2 * 2) + (1 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_TEMP_ADC_COMMAND, 1 + (1 * 2) + (MAX_CELLS * 2 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_PASSIVE_BALANCE_COMMAND, 1 + (1 * 2) + (2 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_CELL_PRESENT_COMMAND, 1 + (1 * 2) + (2 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_TIMED_BALANCE_COMMAND, 1 + (1 * 2) + (MAX_CELLS * 2 * 2) + (2 * (2 + 1) * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_UVOV_COMMAND, 1 + (1 * 2) + (2 * 3))
        USB_Parser_Response_Data.Add(USB_PARSER_ERROR_COMMAND, 1 + (1 * 2) + (2 * ERROR_DATA_SIZE))
        USB_Parser_Response_Data.Add(USB_PARSER_BOOT_MODE_COMMAND, 1 + USB_PARSER_BOOTLOAD_STRING.Length)

        ' These commands are variable length
        USB_Parser_Response_Data.Add(USB_PARSER_LTC3300_COMMAND, 1 + (1 * 2) + 1 + (1 * 2))
        USB_Parser_Response_Data.Add(USB_PARSER_EEPROM_COMMAND, 1 + (1 * 2) + 1)

        ' These are random strings sent out without an identifier, so don't make any commands that use the same first letter as these random strings
        USB_Parser_Response_Data.Add(USB_PARSER_HELLO_COMMAND, HELLOSTRING.Length)
        USB_Parser_Response_Data.Add(USB_PARSER_IDSTRING_COMMAND, DC2100A_IDSTRING.Length)
        USB_Parser_Response_Data.Add(USB_PARSER_DEFAULT_COMMAND, USB_PARSER_DEFAULT_STRING.Length)

        ' Look for manufacturing data file and enable controls/indicators depending upon whether or not it exists.
        Try
            Mfg_File = New Mfg_File(filePath + MFG_FILE_NAME)
            If Mfg_File.Is_Valid(PRODUCT_STRING) = True Then
                Mfg_Enabled = True
#If MFG_PIPE_SUPPORT = True Then
                    Mfg_PipeServer = New PipeServer(MFG_PIPE_NAME)
                    Mfg_PipeTimer.Enabled = True
#End If
            Else
                Mfg_Enabled = False
            End If
        Catch ex As Exception
            ' todo - Give special message when the file exists, but can not be written
            Mfg_Enabled = False
        End Try

        ' Look for error file and enable logging if it can be written.
        Try
            Error_File = New Error_File(filePath + ERROR_FILE_NAME)
        Catch ex As Exception
            ' Chicken and Egg...Can't Log Exceptions to Error File while creating the Error File 
            'Handle_Exception(ex)
        End Try

        ' Look for config file and enable configuration buttons they can be written.
        Try
            ' Create New Config File
            Config_File = New Config_File(filePath + CONFIG_FILE_NAME)
        Catch ex As Exception
            ' todo - let them save their own Config 
        End Try
        Config_Save_NumericUpDown.Maximum = Config_File.num_configurations + 1
        Config_Load_NumericUpDown.Maximum = Config_File.num_configurations

        ' Create New Data Log Object.  The actual File doesn't get created until logging is begun.
        Data_Log = New Data_Log()

        ' Create arrays to group the voltages together
        Voltage_TextBoxes(0) = vBox1
        Voltage_TextBoxes(1) = vBox2
        Voltage_TextBoxes(2) = vBox3
        Voltage_TextBoxes(3) = vBox4
        Voltage_TextBoxes(4) = vBox5
        Voltage_TextBoxes(5) = vBox6
        Voltage_TextBoxes(6) = vBox7
        Voltage_TextBoxes(7) = vBox8
        Voltage_TextBoxes(8) = vBox9
        Voltage_TextBoxes(9) = vBox10
        Voltage_TextBoxes(10) = vBox11
        Voltage_TextBoxes(11) = vBox12

        ' Create arrays to group the voltages together
        Temperature_TextBoxes(0) = Temperature_IC1_Temp1_TextBox
        Temperature_TextBoxes(1) = Temperature_IC1_Temp2_TextBox
        Temperature_TextBoxes(2) = Temperature_IC1_Temp3_TextBox
        Temperature_TextBoxes(3) = Temperature_IC1_Temp4_TextBox
        Temperature_TextBoxes(4) = Temperature_IC1_Temp5_TextBox
        Temperature_TextBoxes(5) = Temperature_IC1_Temp6_TextBox
        Temperature_TextBoxes(6) = Temperature_IC2_Temp7_TextBox
        Temperature_TextBoxes(7) = Temperature_IC2_Temp8_TextBox
        Temperature_TextBoxes(8) = Temperature_IC2_Temp9_TextBox
        Temperature_TextBoxes(9) = Temperature_IC2_Temp10_TextBox
        Temperature_TextBoxes(10) = Temperature_IC2_Temp11_TextBox
        Temperature_TextBoxes(11) = Temperature_IC2_Temp12_TextBox

        ' Create objects to group all cell balancer controls together
        For board_num As Integer = 0 To MAX_BOARDS - 1

            Cell_Balancers(board_num, 0) = New Cell_Balancer(0, Balance_Timer_Cell1_TextBox, Balance_Action_Cell1_None_RadioButton, Balance_Action_Cell1_Discharge_RadioButton, Balance_Action_Cell1_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell1_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell1_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell1_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell1_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell1_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 1) = New Cell_Balancer(1, Balance_Timer_Cell2_TextBox, Balance_Action_Cell2_None_RadioButton, Balance_Action_Cell2_Discharge_RadioButton, Balance_Action_Cell2_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell2_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell2_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell2_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell2_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell2_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 2) = New Cell_Balancer(2, Balance_Timer_Cell3_TextBox, Balance_Action_Cell3_None_RadioButton, Balance_Action_Cell3_Discharge_RadioButton, Balance_Action_Cell3_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell3_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell3_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell3_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell3_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell3_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 3) = New Cell_Balancer(3, Balance_Timer_Cell4_TextBox, Balance_Action_Cell4_None_RadioButton, Balance_Action_Cell4_Discharge_RadioButton, Balance_Action_Cell4_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell4_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell4_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell4_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell4_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell4_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 4) = New Cell_Balancer(4, Balance_Timer_Cell5_TextBox, Balance_Action_Cell5_None_RadioButton, Balance_Action_Cell5_Discharge_RadioButton, Balance_Action_Cell5_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell5_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell5_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell5_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell5_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell5_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 5) = New Cell_Balancer(5, Balance_Timer_Cell6_TextBox, Balance_Action_Cell6_None_RadioButton, Balance_Action_Cell6_Discharge_RadioButton, Balance_Action_Cell6_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC1_Cell6_Bit1_TextBox, LTC3300_Write_Balance_Command_IC1_Cell6_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC1_Cell6_Bit1_TextBox, LTC3300_Read_Balance_Command_IC1_Cell6_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC1_Cell6_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 6) = New Cell_Balancer(6, Balance_Timer_Cell7_TextBox, Balance_Action_Cell7_None_RadioButton, Balance_Action_Cell7_Discharge_RadioButton, Balance_Action_Cell7_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell7_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell7_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell7_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell7_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell7_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 7) = New Cell_Balancer(7, Balance_Timer_Cell8_TextBox, Balance_Action_Cell8_None_RadioButton, Balance_Action_Cell8_Discharge_RadioButton, Balance_Action_Cell8_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell8_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell8_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell8_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell8_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell8_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 8) = New Cell_Balancer(8, Balance_Timer_Cell9_TextBox, Balance_Action_Cell9_None_RadioButton, Balance_Action_Cell9_Discharge_RadioButton, Balance_Action_Cell9_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell9_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell9_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell9_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell9_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell9_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 9) = New Cell_Balancer(9, Balance_Timer_Cell10_TextBox, Balance_Action_Cell10_None_RadioButton, Balance_Action_Cell10_Discharge_RadioButton, Balance_Action_Cell10_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell10_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell10_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell10_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell10_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell10_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 10) = New Cell_Balancer(10, Balance_Timer_Cell11_TextBox, Balance_Action_Cell11_None_RadioButton, Balance_Action_Cell11_Discharge_RadioButton, Balance_Action_Cell11_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell11_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell11_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell11_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell11_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell11_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
            Cell_Balancers(board_num, 11) = New Cell_Balancer(11, Balance_Timer_Cell12_TextBox, Balance_Action_Cell12_None_RadioButton, Balance_Action_Cell12_Discharge_RadioButton, Balance_Action_Cell12_Charge_RadioButton, _
                                                  LTC3300_Write_Balance_Command_IC2_Cell12_Bit1_TextBox, LTC3300_Write_Balance_Command_IC2_Cell12_Bit0_TextBox, _
                                                  LTC3300_Read_Balance_Command_IC2_Cell12_Bit1_TextBox, LTC3300_Read_Balance_Command_IC2_Cell12_Bit0_TextBox, _
                                                  LTC3300_Read_Status_IC2_Cell12_GateOK_TextBox, AddressOf Balance_Action_RadioButton_CheckedChanged)
        Next board_num

        ' Create objects to group parts of all LTC3000 together
        For board_num As Integer = 0 To MAX_BOARDS - 1

            For ic_num As Integer = 0 To NUM_LTC3300 - 1

                ' Group together the balancers for this LTC3300
                Dim Balancer_Group(LTC3300.NUM_CELLS - 1) As Cell_Balancer
                For cell_index As Integer = 0 To LTC3300.NUM_CELLS - 1
                    Dim cell_num As Integer = cell_index + ic_num * LTC3300.NUM_CELLS
                    Balancer_Group(cell_index) = Cell_Balancers(board_num, cell_num)
                Next cell_index

                ' Group together the crc bits for this LTC3300
                Dim write_command_crc_group(4) As System.Windows.Forms.TextBox
                Dim read_command_crc_group(4) As System.Windows.Forms.TextBox
                Dim read_read_status_crc_copy_group(4) As System.Windows.Forms.TextBox
                Dim ltc_status_bits_group(LTC3300.BALANCE_COMMAND_SIZE - LTC3300.NUM_CELLS - LTC3300.CRC_SIZE) As System.Windows.Forms.TextBox
                If ic_num = 0 Then
                    write_command_crc_group(0) = LTC3300_Write_Balance_Command_IC1_CRC_Bit0_TextBox
                    write_command_crc_group(1) = LTC3300_Write_Balance_Command_IC1_CRC_Bit1_TextBox
                    write_command_crc_group(2) = LTC3300_Write_Balance_Command_IC1_CRC_Bit2_TextBox
                    write_command_crc_group(3) = LTC3300_Write_Balance_Command_IC1_CRC_Bit3_TextBox
                    read_command_crc_group(0) = LTC3300_Read_Balance_Command_IC1_CRC_Bit0_TextBox
                    read_command_crc_group(1) = LTC3300_Read_Balance_Command_IC1_CRC_Bit1_TextBox
                    read_command_crc_group(2) = LTC3300_Read_Balance_Command_IC1_CRC_Bit2_TextBox
                    read_command_crc_group(3) = LTC3300_Read_Balance_Command_IC1_CRC_Bit3_TextBox
                    read_read_status_crc_copy_group(0) = LTC3300_Read_Status_IC1_CRC_Bit0_TextBox
                    read_read_status_crc_copy_group(1) = LTC3300_Read_Status_IC1_CRC_Bit1_TextBox
                    read_read_status_crc_copy_group(2) = LTC3300_Read_Status_IC1_CRC_Bit2_TextBox
                    read_read_status_crc_copy_group(3) = LTC3300_Read_Status_IC1_CRC_Bit3_TextBox
                    ltc_status_bits_group(0) = LTC3300_Read_Status_IC1_Cells_Not_OV_TextBox
                    ltc_status_bits_group(1) = LTC3300_Read_Status_IC1_Stack_Not_OV_TextBox
                    ltc_status_bits_group(2) = LTC3300_Read_Status_IC1_Temp_OK_TextBox
                    ltc_status_bits_group(3) = LTC3300_Read_Status_IC1_Unused_Bit2_TextBox
                    ltc_status_bits_group(4) = LTC3300_Read_Status_IC1_Unused_Bit1_TextBox
                    ltc_status_bits_group(5) = LTC3300_Read_Status_IC1_Unused_Bit0_TextBox
                Else
                    write_command_crc_group(0) = LTC3300_Write_Balance_Command_IC2_CRC_Bit0_TextBox
                    write_command_crc_group(1) = LTC3300_Write_Balance_Command_IC2_CRC_Bit1_TextBox
                    write_command_crc_group(2) = LTC3300_Write_Balance_Command_IC2_CRC_Bit2_TextBox
                    write_command_crc_group(3) = LTC3300_Write_Balance_Command_IC2_CRC_Bit3_TextBox
                    read_command_crc_group(0) = LTC3300_Read_Balance_Command_IC2_CRC_Bit0_TextBox
                    read_command_crc_group(1) = LTC3300_Read_Balance_Command_IC2_CRC_Bit1_TextBox
                    read_command_crc_group(2) = LTC3300_Read_Balance_Command_IC2_CRC_Bit2_TextBox
                    read_command_crc_group(3) = LTC3300_Read_Balance_Command_IC2_CRC_Bit3_TextBox
                    read_read_status_crc_copy_group(0) = LTC3300_Read_Status_IC2_CRC_Bit0_TextBox
                    read_read_status_crc_copy_group(1) = LTC3300_Read_Status_IC2_CRC_Bit1_TextBox
                    read_read_status_crc_copy_group(2) = LTC3300_Read_Status_IC2_CRC_Bit2_TextBox
                    read_read_status_crc_copy_group(3) = LTC3300_Read_Status_IC2_CRC_Bit3_TextBox
                    ltc_status_bits_group(0) = LTC3300_Read_Status_IC2_Cells_Not_OV_TextBox
                    ltc_status_bits_group(1) = LTC3300_Read_Status_IC2_Stack_Not_OV_TextBox
                    ltc_status_bits_group(2) = LTC3300_Read_Status_IC2_Temp_OK_TextBox
                    ltc_status_bits_group(3) = LTC3300_Read_Status_IC2_Unused_Bit2_TextBox
                    ltc_status_bits_group(4) = LTC3300_Read_Status_IC2_Unused_Bit1_TextBox
                    ltc_status_bits_group(5) = LTC3300_Read_Status_IC2_Unused_Bit0_TextBox
                End If

                ' Group together the IC level status bits for this LTC3300
                LTC3300s(board_num, ic_num) = New LTC3300(ic_num, Balancer_Group, write_command_crc_group, _
                                                          read_command_crc_group, read_read_status_crc_copy_group, ltc_status_bits_group)
            Next ic_num

        Next board_num

        ' Create objects for timestamps
        For board_num As Integer = 0 To MAX_BOARDS - 1
            voltage_timestamp(board_num) = New Timestamp
            temperature_timestamp(board_num) = New Timestamp
        Next board_num

        ' Check if a device is attached when GUI is launched
        ' todo - is there a way to do this without repeating code
        If LTCDevices.AllDevices.Count <> 0 Then
            LTCDevices.AddtoCatalog(CurrentDevice, 0)
            ComboBox1.Items.Add(LTCDevices.AllDevices(0).DeviceName & ", PID = " & _
                                LTCDevices.AllDevices(0).PID & ", S/N = " & _
                                LTCDevices.AllDevices(0).SerialNo)
            AddStringToListBox("A device has arrived.")
            ComboBox1.SelectedIndex = 0
            NoteLabel.Text = "A device has arrived."
            System_Init(True)
        Else
            System_Init(False)
        End If

    End Sub

    Private Sub D33001_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If Mfg_Enabled Then
            ' Closes the Manufacturing File in clean way.
            Mfg_File.Close()
#If MFG_PIPE_SUPPORT = True Then
                Mfg_PipeServer.Close()
#End If
        End If

        ' Closes the Error File in clean way.
        If Error_File IsNot Nothing Then
            Error_File.Close()
        End If

    End Sub

    ''' <summary>
    ''' Cleanup before shutdown.  Closes all open Devices and stop attach/detach notifications.
    ''' </summary>
    ''' <param name="eventSender">
    ''' ? MS won't share
    ''' </param>
    ''' <param name="eventArgs">
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub D33001_Closed(ByVal eventSender As System.Object,
                                   ByVal eventArgs As System.EventArgs
                                   ) Handles MyBase.Closed

        Try
            WinUsbDevice.StopDevice(CurrentDevice)
            LTCDevices.StopReceivingDeviceNotifications()

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

#End Region

#Region "Direct590 USB Driver Interface"

    ' The Device Interface GUID from the LTC INF file
    Private Const LTC_DEVICE_INTERFACE_GUID_STRING As String = "{27876b85-3b46-453a-8477-afbcd86533c0}"
    ' Instantiate LTCDevices as a new DeviceManagement class object.  This class instance has a property that
    ' is the Device Interface GUID of the devices it manages.  This class instance can register for device
    ' attach/detach messages for devices with the Device Interface GUID, and has a property for holding the
    ' device notification handle.  Finally, this class instance can have a catalog of all the currently
    ' attached devices with the Device Interface GUID.
    Private LTCDevices As New DeviceManagement
    ' This is a local instance of the devInfo structure to keep track of the current active device.
    ' Initialized to 0.
    Private CurrentDevice As New WinUsbDevice.devInfo(0)
    ' The background worker can only return one object in e.result, so package the information we need to
    ' return into one structure to use as the object.
    Friend Structure WinUSBData
        Friend ReturnCode As Integer
        Friend DataString As String
        Friend CallTime As DateTime
        Friend ReturnTime As DateTime
    End Structure

    Friend Class BackGroundWorker_Monitor

        Friend Const TIME_LIMIT As Integer = 4  ' seconds
        Friend ThreadLaunchedTime As DateTime
        Friend WinUSBCallTime As DateTime
        Friend WinUSBReturnTime As DateTime
        Friend ThreadCompleteTime As DateTime
        Friend Num_Times_Over_Limit As Integer
        Friend TimeSpans(3 - 1) As TimeSpan

        Friend Sub New()
            ThreadLaunchedTime = DateTime.Now
            WinUSBCallTime = DateTime.Now
            WinUSBReturnTime = DateTime.Now
            ThreadCompleteTime = DateTime.Now
            Num_Times_Over_Limit = 0
        End Sub

        Friend Function Check_Limit_And_Set_Time_Spans() As Boolean

            Me.ThreadCompleteTime = DateTime.Now
            If (Me.ThreadCompleteTime.Subtract(Me.ThreadLaunchedTime).Seconds > TIME_LIMIT) Then
                Me.TimeSpans(0) = Me.WinUSBCallTime.Subtract(Me.ThreadLaunchedTime)
                Me.TimeSpans(1) = Me.WinUSBReturnTime.Subtract(WinUSBCallTime)
                Me.TimeSpans(2) = Me.ThreadCompleteTime.Subtract(Me.WinUSBReturnTime)
                Num_Times_Over_Limit += 1

                Return True
            End If

            Return False
        End Function

    End Class
    Public WritePipe_BackGroundWorker_Monitor As New BackGroundWorker_Monitor
    Public ReadPipe_BackGroundWorker_Monitor As New BackGroundWorker_Monitor
    Public Const NUM_COMM_TIMES As Integer = 10
    Public Comm_Times(NUM_COMM_TIMES - 1) As DateTime
    Public comm_times_index As Integer = 0

    Public num_times_start_device_error As Integer = 0
    Public num_times_read_pipe_error As Integer = 0
    Public num_times_write_pipe_error As Integer = 0

    ' RemovalTimeout is the amount of time to wait after the current device detaches before pronouncing
    ' it gone, in ms.
    Private Const RemovalTimeout As Integer = 3000
    Dim noteLabelTime As Integer = 5 'seconds

    ''' <summary>
    ''' The RemovalTimer was started when the 'current' device detached.  If this event fires, the current
    ''' device has been gone for > RemovalTimeout.  Permanently remove the 'current' device from the device
    ''' catalog and clear the 'current device'.
    ''' </summary>
    ''' <param name="sender">
    ''' ? MS won't share
    ''' </param>
    ''' <param name="e">
    ''' </param>
    ''' <remarks>
    ''' The elapsed time before this event triggers is set using the RemovalTimeout constant.
    ''' </remarks>
    Private Sub RemovalTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RemovalTimer.Tick
        Try
            ' If you are here the current device has been gone for more than the RemovalTimeout, and its time to 
            ' part ways.
            If LTCDevices.AllDevices.Contains(CurrentDevice) Then
                Dim i As Integer = LTCDevices.AllDevices.IndexOf(CurrentDevice) ' Get index of CurrentDevice

                WinUsbDevice.StopDevice(CurrentDevice)      ' Stop the current device
                LTCDevices.AllDevices.RemoveAt(i)         ' Delete the CurrentDevice from the catalog
                CurrentDevice = New WinUsbDevice.devInfo(0) ' Clear the local CurrentDevice devInfo structure

                ComboBox1.Text = ""                       ' Clear the displayed value
                ComboBox1.Items.RemoveAt(i)               ' Delete the CurrentDevice from the list of available devices
                '     ComboBox1.SelectedIndex = -1              ' Set the selected list item to 'none' (Commented by ZP, was throwing exceptions)

                ' This should be done in the ComboBox1.SelectedIndexChanged event?
                ' Me.Text = ""
                UpdateDeviceDataBoxes()

                ' Tell the world.
                AddStringToListBox("Current device removed.")
            End If
        Catch

        End Try

        RemovalTimer.Stop()

    End Sub

    ''' <summary>
    ''' Overrides WndProc to enable checking for and handling WM_DEVICECHANGE messages.
    ''' </summary>
    ''' <param name="m"> A Windows message.
    ''' </param> 
    Protected Overrides Sub WndProc(ByRef m As Message)

        Try
            'The OnDeviceChange routine processes WM_DEVICECHANGE messages.
            If m.Msg = DeviceManagement.WM_DEVICECHANGE Then
                OnDeviceChange(m)
            End If

            'Let the base form process the message.
            MyBase.WndProc(m)

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try

    End Sub


    ''' <summary>
    ''' Sends data via a bulk transfer.
    ''' </summary>
    ''' <remarks>
    ''' </remarks>
    Private Sub SendViaBulkTransfers()

        Try
            Dim bytesToSend As UInt32
            Dim dataToSend As String = ""
            Dim databuffer() As Byte
            Dim formText As String = ""
            Dim myEncoder As New System.Text.ASCIIEncoding()
            Dim ReturnedCode As Integer

            ' Get data to send from the textbox.
            dataToSend = txtBulkDataWrite.Text

            ' Convert the string to a byte array.
            databuffer = myEncoder.GetBytes(dataToSend)
            bytesToSend = Convert.ToUInt32(databuffer.Length)

            'Send the data
            ReturnedCode = WinUsbDevice.WritePipe(CurrentDevice, CurrentDevice.bulkOutPipe, databuffer, bytesToSend)

            ' Display the received data in the form's text box, and status in the status box.
            If (ReturnedCode > 0) Then
                AddStringToListBox("Data successfully sent to Bulk OUT pipe.") ' More than 0 bytes sent, success
            ElseIf (ReturnedCode = -1) Then
                AddStringToListBox("Invalid Device") ' Attempted to send data to an invalid device
            ElseIf (ReturnedCode = -2) Then
                AddStringToListBox("Invalid Pipe or Pipe Direction") ' Attempted to write data to other than OUT pipe
            Else
                AddStringToListBox("Cannot send 0 bytes") ' Attempted to send 0 bytes
                NoteLabel.Text = "Error sending data string, reset device."
            End If

            USB_Comm_Can_Send = True

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try

    End Sub



#End Region

#Region "Direct590 Hidden GUI Controls"

    ''' <summary>
    ''' When the user selects a new current device, close the previous current device (if open) and open the
    ''' new one.
    ''' </summary>
    ''' <param name="sender">
    ''' </param>
    ''' <param name="e">
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub ComboBox1_SelectedIndexChanged(ByVal sender As System.Object,
                                               ByVal e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged

        Try
            WinUsbDevice.StopDevice(CurrentDevice)
            ' Change the current active device
            If ComboBox1.SelectedIndex <> -1 Then
                CurrentDevice = LTCDevices.AllDevices(ComboBox1.SelectedIndex)
                ' Once a device in the device catalog has been selected, open it and initialize it.
                If (WinUsbDevice.StartDevice(CurrentDevice) = False) Then
                    num_times_start_device_error += 1
                    Error_File.Add(Error_File.Error_Code.WinUSB_StartDeviceError, num_times_start_device_error.ToString(), _
                                   Extract_Function_Name_From_String(System.Reflection.MethodInfo.GetCurrentMethod().ToString()))
                End If
                ' This is for testing purposes only.  In the product implementation, this form will be the parent
                ' Form, therefore its banner will not contain device specific information.
                '------------------------------------------------------------
                '                    Me.Text = "Connected to: " & CurrentDevice.DeviceName _            (this changed the form title when connected)
                '                             & ", PID = " & CurrentDevice.PID & ", s/n = " _
                '                          & CurrentDevice.SerialNo
                '------------------------------------------------------------
                ' Update displayed device data
                UpdateDeviceDataBoxes()
            Else
                'Me.Text = ""
                CurrentDevice = New WinUsbDevice.devInfo(0)
                UpdateDeviceDataBoxes()
            End If

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try

    End Sub

    ''' <summary>
    ''' Display the device's speed in the list box.
    ''' </summary>
    ''' <remarks>
    ''' Precondition: device speed was obtained by calling WinUsb_QueryDeviceInformation
    ''' and stored in myDevInfo.
    ''' 0 = low speed, 1 = full speed, 2 = high speed
    ''' http://msdn.microsoft.com/en-us/library/ff539294(v=VS.85).aspx 
    ''' </remarks >
    Private Function DisplayDeviceSpeed() As String

        Dim speed As String = ""

        Try
            Select Case CurrentDevice.devicespeed
                Case 0
                    speed = "Low Speed (LS)"
                Case 1
                    speed = "Full Speed (FS)"
                Case 2
                    speed = "High Speed (HS)"
            End Select

            Return speed

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Function

    ''' <summary>
    ''' Initializes elements on the form.
    ''' </summary>
    Private Sub InitializeDisplay()

        Dim byteValue As String = ""

        Try

            If Not (WinUsbDevice.IsWindowsXpOrLater()) Then
                AddStringToListBox("The operating system is not Windows XP or later.")
                AddStringToListBox("The WinUSB driver requires Windows XP or later.")
            End If

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try

    End Sub

    ''' <summary>
    ''' Called when a WM_DEVICECHANGE (Msg = 0x219) message has arrived. indicating that a device has been
    ''' attached or removed.  A WM_DEVICECHANGE message with a Wparam of DeviceManagement.DBT_DEVICEARRIVAL
    ''' (0x8000) or DeviceManagement.DBT_DEVICEREMOVECOMPLETE (0x8004) will have an Lparam that is a pointer
    ''' to a structure with the path name of the noobie or dearly departed device.
    ''' </summary>
    ''' <param name="m">
    ''' A WM_DEVICECHANGE message with information about the device.  Specifically the Wparam element
    ''' indicates whether the device departed or arrived, and the Lparam has the path name of the device.
    ''' </param>
    Friend Sub OnDeviceChange(ByVal m As Message)
        Dim i As Integer

        Try
            If (m.WParam.ToInt32 = DeviceManagement.DBT_DEVICEARRIVAL) Then
                ' If Wparam = DeviceManagement.DBT_DEVICEARRIVAL, a device has been attached.  Find out if
                ' it's the 'current' device.  If it is the 'current' device, stop the removal timer.  If the
                ' removal timer had already timed out, the 'current' device was reset to 0, so the compare
                ' will fail.
                If LTCDevices.AllDevices.Count = 0 Then
                    LTCDevices.DevInfofromPathname(LTCDevices.IdentifyDeviceChanged(m), CurrentDevice)
                    LTCDevices.AddtoCatalog(CurrentDevice, 0)
                    ComboBox1.Items.Add(LTCDevices.AllDevices(0).DeviceName & ", PID = " & _
                                        LTCDevices.AllDevices(0).PID & ", S/N = " & _
                                        LTCDevices.AllDevices(0).SerialNo)
                    AddStringToListBox("A device has arrived.")
                    ComboBox1.SelectedIndex = 0
                    NoteLabel.Text = "A device has arrived."
                    System_Init(True)
                ElseIf (LTCDevices.DevicepathnameCompare(CurrentDevice, LTCDevices.IdentifyDeviceChanged(m))) Then
                    AddStringToListBox("Current device reattached.")
                    If (WinUsbDevice.StartDevice(CurrentDevice) = False) Then
                        num_times_start_device_error += 1
                        Error_File.Add(Error_File.Error_Code.WinUSB_StartDeviceError, num_times_start_device_error.ToString(), _
                                       Extract_Function_Name_From_String(System.Reflection.MethodInfo.GetCurrentMethod().ToString()))
                    End If
                    RemovalTimer.Stop()
                    NoteLabel.Text = "Current device reattached."
                    System_Init(True)
                Else
                    Dim FreshDevice As New WinUsbDevice.devInfo(0)

                    AddStringToListBox("New device added to device catalog.")
                    LTCDevices.DevInfofromPathname(LTCDevices.IdentifyDeviceChanged(m), FreshDevice)
                    LTCDevices.AllDevices.Add(FreshDevice)
                    i = LTCDevices.AllDevices.IndexOf(FreshDevice)
                    ComboBox1.Items.Add(LTCDevices.AllDevices(i).DeviceName & ", PID = " & _
                                        LTCDevices.AllDevices(i).PID & ", S/N = " & _
                                        LTCDevices.AllDevices(i).SerialNo)
                End If

            ElseIf (m.WParam.ToInt32 = DeviceManagement.DBT_DEVICEREMOVECOMPLETE) Then
                ' If Wparam = DeviceManagement.DBT_DEVICEREMOVECOMPLETE, a device has been removed, find out
                ' if it's the 'current' device.  If it is the 'current' device start the removal timer.  When
                ' the removal timer interval expires, clear the 'current' device.
                If (LTCDevices.DevicepathnameCompare(CurrentDevice, LTCDevices.IdentifyDeviceChanged(m))) Then
                    AddStringToListBox("Current device detached.")
                    RemovalTimer.Interval = RemovalTimeout
                    RemovalTimer.Start()
                    NoteLabel.Text = "Current device detached."
                    System_Init(False)
                Else
                    i = LTCDevices.IndexOfPathName(LTCDevices.IdentifyDeviceChanged(m))
                    LTCDevices.DeletefromCatalog(i)
                    ComboBox1.Items.RemoveAt(i)
                    ComboBox1.SelectedIndex = LTCDevices.IndexOfDevinfo(CurrentDevice)
                    AddStringToListBox("Device removed from catalog.")
                End If
            End If

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

    ''' <summary>
    '''  Requests a read operation from a bulk IN endpoint.
    ''' </summary>
    ''' <param name="sender">
    ''' </param>
    ''' <param name="e">
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub BulkReadButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs
                                     ) Handles BulkReadButton.Click
        Dim readsize As Integer = USB_MAX_PACKET_SIZE
        Try
            ReadDataViaBulkTransfer(readsize)

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

    ''' <summary>
    ''' Requests a write operation to a bulk OUT endpoint.
    ''' </summary>
    ''' ? MS won't share
    ''' <param name="eventSender">
    ''' </param>
    ''' <param name="eventArgs">
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub BulkWriteButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs
                                      ) Handles BulkWriteButton.Click

        Try
            SendViaBulkTransfers()

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

    ''' <summary>
    ''' Initiates a read operation from a bulk IN endpoint.  To enable reading without blocking the main
    ''' thread, uses an background worker.
    ''' </summary>
    ''' <param name="bytestoread">
    ''' Number of bytes to read from the bulk IN endpoint.
    ''' </param>
    ''' <returns>
    ''' Returns a BOOLEAN indicating the success of starting a background read of the bulk IN endpoint
    ''' </returns>
    ''' <remarks>
    ''' </remarks>
    Private Function ReadDataViaBulkTransfer(ByVal bytestoread As Integer) As Boolean

        If BulkReadWorker.IsBusy <> True Then
            BulkReadWorker.RunWorkerAsync(bytestoread) ' Pass how many bytes to read
            Return True
        Else
            Return False
        End If

    End Function

    ''' <summary>
    '''  This the handler for the event raised by BulkReadWorker.RunWorkerAsync
    ''' </summary>
    ''' <param name="sender">
    ''' ? MS won't share
    ''' </param>
    ''' <param name="e">
    ''' e.Argument contains the number of bytes to read from the bulk IN channel.
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub BulkReadWorker_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs
                                      ) Handles BulkReadWorker.DoWork

        Dim Data As New WinUSBData
        Dim buffer(CInt(e.Argument) - 1) As Byte
        Dim bytesRead As UInt32
        Dim bytesToRead As UInt32 = CUInt(e.Argument)
        Dim ReturnedCode As Integer

        Try
            ' Read data from bulk IN channel
            ReturnedCode = WinUsbDevice.ReadPipe(
                                    CurrentDevice,
                                    CurrentDevice.bulkInPipe,
                                    bytesToRead,
                                    buffer,
                                    bytesRead)

            ' Fill the return object with data
            Data.ReturnCode = ReturnedCode
            Data.DataString = Encoding.UTF8.GetString(buffer)

            ' Return the entire object
            e.Result = Data

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

    ''' <summary>
    ''' Event raised when the BulkReadWorker is done
    ''' </summary>
    ''' <param name="sender">
    ''' ? MS won't share
    ''' </param>
    ''' <param name="e">
    '''  e.Result contains the data from the worker thread
    ''' </param>
    ''' <remarks>
    ''' </remarks>
    Private Sub BulkReadWorker_RunWorkerCompleted(ByVal sender As System.Object,
                                                  ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs
                                                  ) Handles BulkReadWorker.RunWorkerCompleted
        Dim Data As WinUSBData

        Try
            Data = DirectCast(e.Result, WinUSBData)

            ' Display the received data in the form's text box, and status in the status box.
            If (Data.ReturnCode = 0) Then
                TxtBulkDataRead.Text = ""             ' 0 data returned, with no other error means pipe was empty
                AddStringToListBox("No data available in pipe")
            ElseIf (Data.ReturnCode > 0) Then
                TxtBulkDataRead.Text = Data.DataString
                AddStringToListBox("Data successfully read from Bulk IN pipe")
            ElseIf (Data.ReturnCode = -1) Then
                AddStringToListBox("Invalid Device")
            Else
                AddStringToListBox("Invalid Pipe or Pipe Direction")
            End If

        Catch ex As Exception
            Handle_Exception(ex)

            NoteLabel.Text = "!"
        End Try
    End Sub

    ''' <summary>
    ''' Add String to the list box, scroll to the bottom, and trim if needed.
    ''' </summary>
    Private Sub AddStringToListBox(ByVal listbox_string As String)

        Try
            'If the list box is getting too large, trim its contents.
            If lstResults.Items.Count >= 100 Then
                lstResults.Items.RemoveAt(0)
            End If

            ' Add message to the listbox
            lstResults.Items.Add(listbox_string)

            ' Scroll to the end
            lstResults.SelectedIndex = lstResults.Items.Count - 1

        Catch ex As Exception
            Handle_Exception(ex)

            Throw
        End Try
    End Sub

    ''' <summary>
    ''' Update the check and text boxes, and the knobs
    ''' </summary>
    ''' <remarks>
    ''' </remarks>
    Private Sub UpdateDeviceDataBoxes()

        If CurrentDevice.bulkInPipe = 0 Then
            BulkInCheckBox.Checked = False
            BulkInSizeTextBox.Visible = False
            BulkInSizeTextBox.Text = ""
            TxtBulkDataRead.Enabled = False
            BulkReadButton.Enabled = False
        Else
            BulkInCheckBox.Checked = True
            BulkInSizeTextBox.Visible = False
            BulkInSizeTextBox.Text = CurrentDevice.bulkInPipeSize.ToString
            TxtBulkDataRead.Enabled = True
            BulkReadButton.Enabled = True
        End If

        ' TxtBulkDataRead.Text = ""

        If CurrentDevice.bulkOutPipe = 0 Then
            BulkOutCheckBox.Checked = False
            BulkOutSizeTextBox.Visible = False
            BulkOutSizeTextBox.Text = ""
            'txtBulkDataWrite.Enabled = FALSE
            'BulkWriteButton.Enabled = FALSE
        Else
            BulkOutCheckBox.Checked = True
            ' BulkOutSizeTextBox.Visible = TRUE
            BulkOutSizeTextBox.Text = CurrentDevice.bulkInPipeSize.ToString
            txtBulkDataWrite.Enabled = True
            '    BulkWriteButton.Enabled = TRUE                                                         (write Button Disabled)
        End If

        txtBulkDataWrite.Text = ""

        If (CurrentDevice.DeviceProvider <> "Unable to read Device Provider string") Then
            DeviceProviderTextBox.Text = CurrentDevice.DeviceProvider
            DeviceProviderTextBox.Visible = True
        Else
            DeviceProviderTextBox.Text = ""
            DeviceProviderTextBox.Visible = False
        End If

        If CurrentDevice.bcdUSB <> 0 Then
            USBRevTextBox.Text = Convert.ToString(CurrentDevice.bcdUSB, 16).Substring(0, 1) & "." _
                                                  & Convert.ToString(CurrentDevice.bcdUSB, 16).Substring(1, 2)
            USBRevTextBox.Visible = True
            DeviceSpeedTextBox.Text = DisplayDeviceSpeed()
            DeviceSpeedTextBox.Visible = True
        Else
            USBRevTextBox.Text = ""
            USBRevTextBox.Visible = False
            DeviceSpeedTextBox.Text = """"
            DeviceSpeedTextBox.Visible = False
        End If

        If CurrentDevice.bcdDevice <> 0 Then
            If CurrentDevice.bcdDevice < &H100 Then
                DeviceRevTextBox.Text = "0." & Convert.ToString(CurrentDevice.bcdDevice, 16)
            ElseIf CurrentDevice.bcdDevice < &H1000 Then
                DeviceRevTextBox.Text = Convert.ToString(CurrentDevice.bcdDevice, 16).Substring(0, 1) & "." & _
                                                        Convert.ToString(CurrentDevice.bcdDevice).Substring(1, 2)
            Else
                DeviceRevTextBox.Text = Convert.ToString(CurrentDevice.bcdDevice, 16).Substring(0, 2) & "." & _
                                                        Convert.ToString(CurrentDevice.bcdDevice).Substring(2, 2)
            End If
            DeviceRevTextBox.Visible = True
        Else
            DeviceRevTextBox.Text = ""
            DeviceRevTextBox.Visible = False
        End If

    End Sub

    Private Sub SplitContainer1_SplitterMoved(ByVal sender As System.Object, ByVal e As System.Windows.Forms.SplitterEventArgs) Handles SplitContainer1.SplitterMoved
        TabControl1.Height = SplitContainer1.SplitterDistance + 2
        CellGrid.Height = TabControl1.Height - 33

        If SplitContainer1.SplitterDistance >= 540 Then
            Advanced_Button.Text = "Advanced"
        Else
            Advanced_Button.Text = "Default"
        End If

        RectangleShape13.Height = 670 - SplitContainer1.SplitterDistance

    End Sub

    Private Sub divideButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Advanced_Button.Click
        If SplitContainer1.SplitterDistance >= 540 Then
            SplitContainer1.SplitterDistance = 317
        Else
            SplitContainer1.SplitterDistance = 540
        End If
    End Sub

    Private Sub NoteLabel_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NoteLabel.TextChanged
        If (NoteLabel.Text <> "") AndAlso (Data_Log.logging = False) Then
            noteLabelTime = 5
            noteLabelTimer.Enabled = True
            noteLabelTimer.Start()
        End If
    End Sub

    Private Sub noteLabelTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles noteLabelTimer.Tick
        noteLabelTime = noteLabelTime - 1

        If noteLabelTime < 1 Then
            noteLabelTimer.Stop()
            noteLabelTimer.Enabled = False
            NoteLabel.Text = ""
        End If
    End Sub

    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged
        If CheckBox2.Checked Then
            BulkWriteButton.Enabled = True
            txtBulkDataWrite.ReadOnly = False
        Else
            BulkWriteButton.Enabled = False
            txtBulkDataWrite.ReadOnly = True
        End If
    End Sub

#End Region

#Region "DC2100A GUI Variables"
    ' *** Debug variables, always have DEBUG set to FALSE for customer software
    Public Const DEBUG As Boolean = False
    Public Const DEBUG_ERRORS As Boolean = False
    Public Const DEBUG_LED As Boolean = True

    ' *** Generally useful constants
    Public Const MS_PER_SEC As Integer = 1000
    Public Const MV_PER_V As Integer = 1000
    Public Const SEC_PER_MIN As Integer = 60
    Public Const MIN_PER_HR As Integer = 60
    Public Const SEC_PER_HR As Integer = (SEC_PER_MIN * MIN_PER_HR)
    Public Const HR_PER_DAY As Integer = 24
    Public Const SEC_PER_DAY As Integer = (SEC_PER_MIN * MIN_PER_HR * HR_PER_DAY)
    Public Const DAY_PER_WK As Integer = 7
    Public Const SEC_PER_WK As Integer = (SEC_PER_MIN * MIN_PER_HR * HR_PER_DAY * DAY_PER_WK)

    ' *** Constants to configure DC2100A GUI
    Public filePath As String = ""
    Public Const PRODUCT_STRING As String = "DC2100A"
    Public Const LTC6804_MAX_BOARDS As Integer = 16                 ' The maximum number of addresses available to the LTC6804-2
    Public Const LTC6804_BROADCAST As Integer = LTC6804_MAX_BOARDS  ' Code for application code to indicate an LTC6804 command is to be broadcast to all boards
    Public Const MAX_BOARDS As Integer = 10                         ' The maximum number of boards that can be in a DC2100A system (note that LTC6804_MAX_BOARDS <> MAX_BOARDS due to RAM limitations in the PIC)
    Public Const MAX_CELLS As Integer = 12
    Public Const MIN_CELLS As Integer = 4
    Public Const NUM_TEMPS As Integer = 12
    Public Const NUM_LTC3300 As Integer = 2
    Public Const ALL_BOARDS As Integer = MAX_BOARDS
    Public Const ALL_CELLS As Integer = MAX_CELLS
    Public Const ALL_ICS As Integer = NUM_LTC3300

    ' *** DC2100A USB Communication

    ' Variables to control rate at which commands are sent and responses are received
    Public Const USB_COMM_TIMER_INTERVAL As Integer = 20            ' in ms
    Public Const USB_COMM_CYCLE_PERIOD_DEFAULT As Integer = 360     ' in ms
    Public Const USB_COMM_TIMER_INTERVALS_PER_BOARD As Integer = 5  ' in ms
    Public USB_Comm_Can_Send As Boolean = True                      ' TRUE if allowed to send data to pipe
    Public USB_Comm_Can_Receive As Boolean = True                   ' Now that a message box could be opened upon reading the FW Revision, collecting characters while waiting for message box to be closed results in exception.

    Public USB_Comm_Cycle_Counter As Integer = 0
    Public USB_Comm_Cycle_Counter_Period As Integer = USB_COMM_CYCLE_PERIOD_DEFAULT

    ' Variables to contain commands that are sent to the boards
    ' todo - some kind of timeout between sending commands and getting responses would be great, but the underlying system doesn't account for this easily.
    Public USB_Comm_List_Out As New List(Of String)                 ' List for accumulating responses to USB
    Public USB_Comm_List_Out_Count_This_Cycle As Integer            ' Variable to track how many commands were sent in this comm cycle
    Public USB_Comm_List_Out_Count_Per_Cycle_Max As Integer         ' Variable to track the maximum number of commands sent in a comm cycle

    ' Variables to contain responses from before they are parsed
    Public USB_Parser_Buffer_In As String                           ' Buffer for accumulating responses from USB
    Public USB_Parser_Buffer_Dropped As String                      ' Buffer for accumulating characters dropped from USB
    Public Const USB_MAX_PACKET_SIZE As Integer = 64

    ' Defined USB Commands and Responses 
    Public Const USB_PARSER_MFG_COMMAND As String = "O"             ' Read/Write Board Manufacturing Data 
    Public Const USB_PARSER_SYSTEM_COMMAND As String = "s"          ' Read System Data
    Public Const USB_PARSER_VOLTAGE_COMMAND As String = "v"         ' Read Board Voltage Data 
    Public Const USB_PARSER_TEMPERATURE_COMMAND As String = "t"     ' Read Board Temperature Data 
    Public Const USB_PARSER_TEMP_ADC_COMMAND As String = "l"        ' Read Board Temperature Adc Values 
    Public Const USB_PARSER_PASSIVE_BALANCE_COMMAND As String = "M" ' Board Passive Balancers 
    Public Const USB_PARSER_CELL_PRESENT_COMMAND As String = "n"    ' Board Cell Present 
    Public Const USB_PARSER_TIMED_BALANCE_COMMAND As String = "m"   ' Board Timed Balance 
    Public Const USB_PARSER_UVOV_COMMAND As String = "V"            ' Read Board Over-Voltage and Under-Voltage Conditions 
    Public Const USB_PARSER_ERROR_COMMAND As String = "o"           ' Read System Error Data 
    Public Const USB_PARSER_LTC3300_COMMAND As String = "k"         ' LTC3300 Raw Write via LTC6804 
    Public Const USB_PARSER_EEPROM_COMMAND As String = "g"          ' Read/Write/Default EEPROM 
    Public Const USB_PARSER_ALGORITHM_COMMAND As String = "j"       ' timed balance incorporating algorithm 
    Public Const USB_PARSER_UVOV_THRESHOLDS_COMMAND As String = "L" ' Write Over and Under Voltage Thresholds 
    Public Const USB_PARSER_CAP_DEMO_COMMAND As String = "p"        ' charge the cap board 
    Public Const USB_PARSER_HELLO_COMMAND As String = "H"           ' Reply with Hello String.  Mostly useful for testing. 
    Public Const USB_PARSER_IDSTRING_COMMAND As String = "D"        ' Read controller ID and firmware rev, this supports legacy functions 
    Public Const USB_PARSER_DEFAULT_COMMAND As String = "N"         ' By default anything not specified is a no-op 
    Public Const USB_PARSER_BOOT_MODE_COMMAND As String = "r"       ' Enter Bootload Mode 

    ' Dictionary used to wait for the proper number of characters before attempting to process the communication, without just throwing it away.
    Public Const DC2100A_MODEL_NUM_DEFAULT As String = "DC2100A-?"
    Public Const DC2100A_SERIAL_NUM_DEFAULT As String = "None             "
    Public Const APP_FW_STRING_DEFAULT As String = "N/A        "
    Public Const HELLOSTRING As String = "Hello "
    Public Const DC2100A_IDSTRING As String = "DC2100A-A,LTC3300-1 demonstration board"
    Public Const USB_PARSER_DEFAULT_STRING As String = "Not a recognized command!"
    Public Const USB_PARSER_BOOTLOAD_STRING As String = "bootload"
    Public USB_Parser_Response_Data As New Dictionary(Of String, Integer)

    ' From "Error Codes" Sheet in DC2100A_Design.xlsm
    ' Definition of error codes passed from the App FW to the GUI
    Public Enum FW_ERROR_CODE
        NONE                        ' No Error is present in DC2100A System.
        TEST                        ' Test Code for sending ERROR_DATA_SIZE raw bytes to the DC2100A GUI.
        LTC6804_FAILED_CFG_WRITE    ' Errata in early LTC6804 silicon was detected, where configuration registers do not write successfully.
        LTC6804_CRC                 ' An LTC6804 response had an incorrect CRC.
        LTC3300_CRC                 ' An LTC3300 response had an incorrect CRC.
        LTC6804_ADC_CLEAR           ' An LTC6804 ADC conversion returned clear, indicating that the command to start the conversion was not received.
        LTC3300_FAILED_CMD_WRITE    ' An LTC3300 Balancer Command Read did not match the last value written.
    End Enum
    Public Const ERROR_DATA_SIZE As Integer = 12

    ' *** System Tree View
    Public numBoards As Integer = 0         ' Total number of boards
    Public selectedBoard As Integer = 0     ' Number of selected board
    Public selectedCell As Integer = 0      ' Cell selected on board
    Public selectedIC As Integer = 0        ' LTC3300 balancing the selected cell
    Public cellPresent(MAX_BOARDS - 1, MAX_CELLS - 1) As Boolean
    Public board_address_table(LTC6804_MAX_BOARDS - 1) As Integer

    ' The states the DC2100A goes through as it powers up, waits for the cells to be powered up, detects how many boards are in the system, and then enters the Awake mode.
    Public Enum System_State_Type
        Off
        PIC_Board_Init
        System_Init
        Awake
        Sleep
        Num_States
    End Enum
    Public system_state As System_State_Type
    Public board_connected_led_counter_period() As Integer = {0, 200, 200, 1000, 10000} ' in ms, the period for which the green LED is flashed.
    Public board_connected_led_counter As Integer                                       ' counter to time the flashing of the green LED.
    Public board_connected_led_toggle As Boolean                                        ' flag to track if the green LED is flashed on or off.

    ' *** Board ID Information
    Public Structure Board_ID_Data_Structure
        Public Model As String
        Public Serial_Number As String
        Public Cap_Demo As Boolean
        Public Average_Charge_Current_12Cell As Single
        Public Average_Discharge_Current_12Cell As Single
        Public Average_Charge_Current_6Cell As Single
        Public Average_Discharge_Current_6Cell As Single
        Public FW_Rev As String
    End Structure
    Public Board_ID_Data(MAX_BOARDS - 1) As Board_ID_Data_Structure
    Public DC2100A_PIC_BOARD_NUM As Integer = 0                   ' It makes a lot of things simpler if the board with the PIC always has the same address.

    ' *** FW Update
    ' todo - this really should not be hard coded in here
    Public Class Firmware_Revision
        Private Const delimiter As String = "."
        Private Const beta_delimiter As String = "b"
        Public Valid As Boolean
        Public Rev_Major As Integer
        Public Rev_Minor As Integer
        Public Rev_SubMinor As Integer
        Public Rev_Beta As Integer

        Public Sub New()
            Me.Valid = False
        End Sub

        Public Sub New(ByVal rev_major As Integer, ByVal rev_minor As Integer, ByVal rev_subminor As Integer, ByVal rev_beta As Integer)
            Me.Rev_Major = rev_major
            Me.Rev_Minor = rev_minor
            Me.Rev_SubMinor = rev_subminor
            Me.Rev_Beta = rev_beta
            Me.Valid = True
        End Sub

        Public Sub Set_String(ByVal fw_string As String)
            Dim temp_rev_major As Integer
            Dim temp_rev_minor As Integer
            Dim temp_rev_subminor As Integer
            Dim temp_rev_beta As Integer

            Try
                ' Attempt to unpack the FW revision.
                temp_rev_major = Integer.Parse(fw_string.Substring(0, fw_string.IndexOf(delimiter)), NumberStyles.AllowHexSpecifier)
                fw_string = fw_string.Remove(0, fw_string.IndexOf(delimiter) + 1)
                temp_rev_minor = Integer.Parse(fw_string.Substring(0, fw_string.IndexOf(delimiter)), NumberStyles.AllowHexSpecifier)
                fw_string = fw_string.Remove(0, fw_string.IndexOf(delimiter) + 1)
                If (fw_string.IndexOf(beta_delimiter) >= 0) Then
                    ' This is a beta revision
                    temp_rev_subminor = Integer.Parse(fw_string.Substring(0, fw_string.IndexOf(beta_delimiter)), NumberStyles.AllowHexSpecifier)
                    fw_string = fw_string.Remove(0, fw_string.IndexOf(beta_delimiter) + 1)
                    temp_rev_beta = Integer.Parse(fw_string, NumberStyles.AllowHexSpecifier)
                Else
                    ' This is not a beta revision
                    temp_rev_subminor = Integer.Parse(fw_string.Trim(), NumberStyles.AllowHexSpecifier)
                    temp_rev_beta = 0
                End If

                ' If unpacking was successful, we have a valid FW revision to set
                Me.Rev_Major = temp_rev_major
                Me.Rev_Minor = temp_rev_minor
                Me.Rev_SubMinor = temp_rev_subminor
                Me.Rev_Beta = temp_rev_beta
                Me.Valid = True
            Catch ex As Exception
                Me.Valid = False
            End Try

        End Sub

        Public Function Get_String() As String
            If (Me.Valid = False) Then
                ' There is no FW revision detected
                Return APP_FW_STRING_DEFAULT
            ElseIf (Me.Rev_Beta = 0) Then
                ' This is not a beta FW revision
                Return Me.Rev_Major.ToString() + delimiter + Me.Rev_Minor.ToString() + delimiter + Me.Rev_SubMinor.ToString()
            Else
                ' There is a beta FW revision
                Return Me.Rev_Major.ToString() + delimiter + Me.Rev_Minor.ToString() + delimiter + Me.Rev_SubMinor.ToString() + beta_delimiter + Me.Rev_Beta.ToString()
            End If
        End Function

        Public Function Is_Older_Than(ByVal fw_rev As Firmware_Revision) As Boolean
            If (Me.Valid = False) Or (fw_rev.Valid = False) Then
                Return True
            ElseIf (Me.Rev_Major <> fw_rev.Rev_Major) Then
                If (Me.Rev_Major < fw_rev.Rev_Major) Then
                    Return True
                Else
                    Return False
                End If
            ElseIf (Me.Rev_Minor <> fw_rev.Rev_Minor) Then
                If (Me.Rev_Minor < fw_rev.Rev_Minor) Then
                    Return True
                Else
                    Return False
                End If
            ElseIf (Me.Rev_SubMinor <> fw_rev.Rev_SubMinor) Then
                If (Me.Rev_SubMinor < fw_rev.Rev_SubMinor) Then
                    Return True
                Else
                    Return False
                End If
            ElseIf (Me.Rev_Beta <> fw_rev.Rev_Beta) Then
                If (Me.Rev_Beta < fw_rev.Rev_Beta) Then
                    Return True
                Else
                    Return False
                End If
            Else
                Return False
            End If
        End Function

    End Class
    ' todo - it'd be great for Firmware_Version_Expected and Firmware_Hex_File_Name to not need to be set manually.
    Public Firmware_Version_Expected As New Firmware_Revision(1, 2, 0, &H0)                 ' the version of FW for which this GUI was designed.  Other FW version may be compatible, but this is the one that is tested for compatibility and has its hex file included with the GUI.
    Public Firmware_Version_Connected As New Firmware_Revision()                            ' the version of FW currently connected to the GUI
    Public FW_Update_PopUp As Boolean = False                                               ' flag that the customer is being asked to update the firmware.
    Public FW_Update_Offered As Boolean = False                                             ' flag that the customer has been asked to FW update this board once.
    Public Bootloader_Command_Sent As Boolean = False                                       ' flag that the bootloader command has been sent, and the DC2100A should re-enumerate as a bootloader soon.
    Public Bootloader_Response_Received As Boolean = False                                  ' flag that the bootloader response has been received, and the DC2100A should re-enumerate as a bootloader very soon.
    Public Const Firmware_Update_Command As String = "fw_update.exe"                        ' command line utility used to upgrade the firmware.
    Public Const Firmware_Update_Options As String = "-e -w -vid 0x1272 -pid 0xb00b -ix"    ' options necessary for command line utility to update Linear devices.
    Public Const Firmware_Hex_File_Name As String = "DC2100A_boot_1_0_2_app_1_2_0.hex"    ' filename for hex file containing Firmware_Version_Expected.
    Public Const Bootloader_Reboot_Delay As Integer = 1000                                  ' in ms, the delay waited for the DC2100A to unenumerate and re-enumerate as a bootload device.

    ' *** EEPROM Information
    Public Structure EEPROM_Data_Structure
        Public Capacity() As Single
        Public Charge_Currents() As Single
        Public Discharge_Currents() As Single
    End Structure
    Public EEPROM_Data(MAX_BOARDS - 1) As EEPROM_Data_Structure
    Public Enum EEPROM_Item_Type
        Cap
        Current
    End Enum
    Public ENABLED_COLOR As System.Drawing.Color = Drawing.Color.White
    Public CHANGED_COLOR As System.Drawing.Color = Drawing.Color.LightGray
    Public Enum Calibration_Column
        Capacity
        Charge_Current
        Discharge_Current
    End Enum
    Public Const SOC_CAP_SCALE_FACTOR As Integer = 128
    Public Const CAP_MAX As Integer = ((1 << 16) - 1) ' 16 bit capacity
    Public Const CAP_FORMAT As String = "##0.0"
    Public Const CURRENT_SCALE_FACTOR As Integer = 256
    Public Const CURRENT_SCALE_MAX As Integer = 127
    Public Const CURRENT_SCALE_MIN As Integer = -128
    Public Const CURRENT_FORMAT As String = "0.000"

    ' *** Voltage Display
    Public Const VOLTAGE_RESOLUTION As Single = 1 / 10000 ' V per bit
    Public Const VOLTAGE_MAX As Integer = ((1 << 16) - 1) ' 16 bit voltage
    Public Const VOLTAGE_FORMAT As String = "0.0000"
    Public Voltage_Update_Flag As Boolean = False
    Public Voltages(MAX_BOARDS - 1, MAX_CELLS - 1) As Single
    Public Voltage_TextBoxes(MAX_CELLS - 1) As TextBox

    ' *** Temperature Display
    Public Const TEMPERATURE_RESOLUTION As Integer = 1 ' C per bit
    Public Const TEMPERATURE_MAX As Integer = 160 ' C per bit
    Public Const TEMPERATURE_MIN As Integer = -56 ' C per bit
    Public Const TEMPERATURE_FORMAT As String = ""
    Public Temperature_Update_Flag As Boolean = True
    Public Temperatures(MAX_BOARDS - 1, MAX_CELLS - 1) As Integer
    Public Temperature_TextBoxes(NUM_TEMPS - 1) As TextBox

    ' *** Timestamps for Voltage and Temperature
    Public Class Timestamp
        Public Const PIC18FXXJ_TIMER_TICKS_PER_SEC As Integer = 46875          ' in ticks per second
        Public Const SYSTEM_TIMER_TICKS_OVERFLOW As ULong = (1UL << 32)     ' the value at which the timestamps overflow
        Public timestamp_last As UInteger
        Public time As Single
        Public time_difference As Single
        Public is_balancing As Boolean

        Public Sub New()
            Me.Reset()
        End Sub

        Public Sub Reset()
            Me.timestamp_last = 0
            Me.time = -1
            Me.is_balancing = False
        End Sub

        Public Sub Update(ByVal timestamp_new As UInteger, ByVal is_balancing_new As Byte)
            Dim timestamp_difference As ULong

            If Me.time < 0 Then
                ' If this is first update, start at zero
                Me.timestamp_last = timestamp_new
                Me.time = CSng(timestamp_new) / PIC18FXXJ_TIMER_TICKS_PER_SEC
            Else
                ' Calculate the amount of time passed since last update, and add to counter
                If (timestamp_new >= Me.timestamp_last) Then
                    timestamp_difference = timestamp_new - Me.timestamp_last
                Else
                    timestamp_difference = SYSTEM_TIMER_TICKS_OVERFLOW + timestamp_new - Me.timestamp_last
                End If
                Me.time_difference = CSng(timestamp_difference) / PIC18FXXJ_TIMER_TICKS_PER_SEC
                Me.time += CSng(timestamp_difference) / PIC18FXXJ_TIMER_TICKS_PER_SEC
            End If

            Me.timestamp_last = timestamp_new
            If is_balancing_new <> 0 Then
                Me.is_balancing = True
            Else
                Me.is_balancing = False
            End If

        End Sub

    End Class
    Public voltage_timestamp(MAX_BOARDS - 1) As Timestamp
    Public temperature_timestamp(MAX_BOARDS - 1) As Timestamp
    Public max_time_difference As Single = 0
    Public num_times_over_4sec As Integer = 0

    ' *** Summary of Board and System Voltages and Temperatures Display
    Public Structure Summary_Structure
        Public Num_Cells As Integer
        Public Volt_Sum As Single
        Public Volt_Average As Single
        Public Volt_Max As Single
        Public Volt_Min As Single
        Public Temp_Max As Integer
        Public Temp_Min As Integer
        Public Volt_Max_Cell As Integer
        Public Volt_Min_Cell As Integer
        Public Temp_Max_Cell As Integer
        Public Temp_Min_Cell As Integer
    End Structure
    Public Board_Summary_Data(MAX_BOARDS - 1) As Summary_Structure
    Public Stack_Summary_Data As Summary_Structure

    ' *** Over and Under Voltage Settings
    Public Const VOLTAGE_LIMIT_FORMAT As String = "0.000"
    Public Const VOLTAGE_MAX_DEFAULT As Single = 4.5
    Public Const VOLTAGE_MIN_DEFAULT As Single = 2.5
    Public Const VOLTAGE_MAX_LIMIT As Single = 4.7
    Public Const VOLTAGE_MAX_MFG_LIMIT As Single = 5.7
    Public Const VOLTAGE_MIN_LIMIT As Single = 2.2
    Public Const VOLTAGE_MIN_MFG_LIMIT As Single = 1.5
    Public OV_Flags(MAX_BOARDS - 1) As Integer
    Public UV_Flags(MAX_BOARDS - 1) As Integer
    Public vMax As Single
    Public vMin As Single

    ' *** Balancer Controls
    Public LTC3300s(MAX_BOARDS - 1, NUM_LTC3300 - 1) As LTC3300
    Public Cell_Balancers(MAX_BOARDS - 1, MAX_CELLS - 1) As Cell_Balancer
    Public Passive_Balancers(MAX_BOARDS - 1) As Integer
    Public Min_Balance_Time_Value As Single
    Public Min_Balance_Time_Board As Integer
    Public Max_Balance_Time_Value As Single
    Public Max_Balance_Time_Board As Integer
    Public isBalancing As Boolean
    Public isTimedBalancing As Boolean

    ' *** Graph View/Cap Demo
    Public is_charging As Boolean
    Public is_discharging As Boolean

    ' *** Data Log
    Public Data_Log As Data_Log

    ' *** Configuration Save and Load
    Public Config_File As Config_File
    Public Const CONFIG_FILE_NAME As String = "ConfigData.txt"

    ' *** Manufacturing Support
    Public Cal_Pending As Boolean = False       ' Flag indicates that calibration data has been sent to the UUT, and we're awaiting the response to show it was successfully written after quantization.
    Public Mfg_Model As String                  ' Copy of the setting in the board.  Note that control can be changed, but not written, letting these get out of sync.
    Public Mfg_Cap_Demo As String               ' Copy of the setting in the board.  Note that control can be changed, but not written, letting these get out of sync.
    Public Mfg_Enabled As Boolean               ' Flag indicating that MFG_FILE_NAME is present, which allows serial numbers to be checked out and a repository for factory calibration information.
    Public Mfg_File As Mfg_File
    Public Const MFG_FILE_NAME As String = "MfgData.txt"

    ' Manufacturing Pipe Server
    Public Const MFG_PIPE_SUPPORT As Boolean = False
#If MFG_PIPE_SUPPORT = True Then
    Public Mfg_PipeServer As PipeServer
    Public Const MFG_PIPE_NAME As String = "DC2100A_Pipe.txt"
#End If
    ' Error File Objects
    Public Error_File As Error_File
    Public Const ERROR_FILE_NAME As String = "EventData.txt"

    ' Initializes GUI variables, controls, and indicators as systems are attached and detached
    Private Sub System_Init(ByVal attached As Boolean)
        Try
            ' Check if the board was detached because a FW Upgrade was started.  If so, start the Upgrade.
            If (attached = False) And (Bootloader_Command_Sent = True) Then
                Bootloader_Process_Start()
                Bootloader_Command_Sent = False
            End If

            ' Init Tree View
            If (attached = False) Then
                system_state = System_State_Type.Off
            Else
                system_state = System_State_Type.PIC_Board_Init
            End If
            numBoards = 0
            selectedBoard = 0
            selectedCell = ALL_CELLS
            selectedIC = Get_IC_From_Cell_Number(selectedCell)
            For board_num As Integer = 0 To LTC6804_MAX_BOARDS - 1
                board_address_table(board_num) = 0
            Next board_num

            If DEBUG_LED = True Then
                board_connected_led_counter = 0
                board_connected_led_toggle = False
                Me.Comm_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
                Me.Status_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
            End If

            ' Init Board Selected Indicators
            Board_Count_Label.Text = numBoards.ToString
            If attached = False Then
                Board_Selected_Number_Label.Text = "N/A"
            Else
                Board_Selected_Number_Label.Text = (selectedBoard + 1).ToString
            End If
            DataInputPopup.Board_Count_Label.Text = Board_Count_Label.Text
            DataInputPopup.Board_Selected_Number_Label.Text = Board_Selected_Number_Label.Text
            GraphData.Board_Count_Label.Text = Board_Count_Label.Text
            GraphData.Board_Selected_Number_Label.Text = Board_Selected_Number_Label.Text

            ' Init Board ID
            For board_num As Integer = 0 To MAX_BOARDS - 1
                Board_ID_Data(board_num).Model = DC2100A_MODEL_NUM_DEFAULT
                Board_ID_Data(board_num).Serial_Number = DC2100A_SERIAL_NUM_DEFAULT
                Board_ID_Data(board_num).Cap_Demo = False
                Board_ID_Data(board_num).Average_Charge_Current_12Cell = 0
                Board_ID_Data(board_num).Average_Discharge_Current_12Cell = 0
                Board_ID_Data(board_num).Average_Charge_Current_6Cell = 0
                Board_ID_Data(board_num).Average_Discharge_Current_6Cell = 0
                Board_ID_Data(board_num).FW_Rev = APP_FW_STRING_DEFAULT
            Next board_num

            SN_TextBox.Text = "N/A"
            Me.FW_Rev_TextBox.Text = "N/A"
            Model_ComboBox.SelectedIndex = -1
            CapDemo_ComboBox.SelectedIndex = -1

            ' Reset the offer to upgrade the FW, when the board that was offered disappears
            If (attached = False) Then
                FW_Update_Offered = False
                Bootloader_Response_Received = False
            End If

            ' Init DC2100A USB Communication
            USB_Comm_Cycle_Counter = 0
            USB_Comm_Can_Send = True
            USB_Comm_Can_Receive = True
            While USB_Comm_List_Out.Count > 0
                USB_Comm_List_Out.Remove(USB_Comm_List_Out(0))
            End While
            USB_Comm_List_Out_Count_This_Cycle = 0
            USB_Comm_List_Out_Count_Per_Cycle_Max = 0

            USB_Parser_Buffer_In = ""
            USB_Parser_Buffer_Dropped = ""

            ' Init Voltage Display Controls
            autoReadBox.Enabled = attached
            ButtonRV.Enabled = attached

            ' Init Voltages
            Voltage_Update_Flag = False
            For board_num As Integer = 0 To MAX_BOARDS - 1
                OV_Flags(board_num) = 0
                UV_Flags(board_num) = 0
                For cell_num As Integer = 0 To MAX_CELLS - 1
                    cellPresent(board_num, cell_num) = attached
                    Voltages(board_num, cell_num) = 0
                Next cell_num
                If attached = True Then
                    Board_Summary_Data(board_num).Num_Cells = MAX_CELLS
                Else
                    Board_Summary_Data(board_num).Num_Cells = 0
                End If
                Board_Summary_Data(board_num).Volt_Max = 0
                Board_Summary_Data(board_num).Volt_Min = VOLTAGE_MAX
                Board_Summary_Data(board_num).Volt_Sum = 0
                Board_Summary_Data(board_num).Volt_Average = 0
                voltage_timestamp(board_num).Reset()
            Next board_num
            Stack_Summary_Data.Volt_Max = 0
            Stack_Summary_Data.Volt_Min = VOLTAGE_MAX
            Stack_Summary_Data.Volt_Sum = 0
            Stack_Summary_Data.Volt_Average = 0

            For cell_num As Integer = 0 To MAX_CELLS - 1
                Voltage_TextBoxes(cell_num).Text = ""
            Next cell_num

            ' Init Over Voltage and Under Voltage Settings
            vMax = VOLTAGE_MAX_DEFAULT
            vMin = VOLTAGE_MIN_DEFAULT
            vMaxBox.Enabled = attached
            vMinBox.Enabled = attached

            ' Init Global Channel Monitor
            ' Remove all of the boards from the tree view and the cell grid
            If attached = False Then
                TreeView1.Nodes.Clear()
                CellGrid.Columns.Clear()
            End If

            ' Init Temperatures
            Temperature_Update_Flag = False
            For board_num As Integer = 0 To MAX_BOARDS - 1
                For temp_num As Integer = 0 To NUM_TEMPS - 1
                    Temperatures(board_num, temp_num) = 0
                Next temp_num
                Board_Summary_Data(board_num).Temp_Max = TEMPERATURE_MIN
                Board_Summary_Data(board_num).Temp_Min = TEMPERATURE_MAX
                temperature_timestamp(board_num).Reset()
            Next board_num
            Stack_Summary_Data.Volt_Max = TEMPERATURE_MIN
            Stack_Summary_Data.Volt_Min = TEMPERATURE_MAX

            For temp_num As Integer = 0 To NUM_TEMPS - 1
                Temperature_TextBoxes(temp_num).Text = ""
            Next temp_num

            ' Init Balancers
            For board_num As Integer = 0 To MAX_BOARDS - 1
                Passive_Balancers(board_num) = 0

                For ic_num As Integer = 0 To NUM_LTC3300 - 1
                    LTC3300s(board_num, ic_num).Init(True, Balance_Control_Timed_CheckBox.Checked)
                Next ic_num

                For cell_num As Integer = 0 To MAX_CELLS - 1
                    If attached = True Then
                        Cell_Balancers(selectedBoard, cell_num).Enable(Balance_Control_Timed_CheckBox.Checked)
                    Else
                        Cell_Balancers(selectedBoard, cell_num).Disable()
                    End If
                Next cell_num
            Next board_num
            Min_Balance_Time_Value = 0
            Min_Balance_Time_Board = 0
            Max_Balance_Time_Value = 0
            Max_Balance_Time_Board = 0
            isBalancing = False
            isTimedBalancing = False

            ' todo - these are the only textboxes not assigned to the LTC3300 object....
            LTC3300_Command_Bit2_TextBox.Text = ""
            LTC3300_Command_Bit1_TextBox.Text = ""
            LTC3300_Command_Bit0_TextBox.Text = ""

            ' Init Balancer Controls
            ' If no system attached, everything is disabled.  If system attached, either Manual or Timed Balancing is enabled.
            Balance_Control_Manual_CheckBox.Enabled = attached
            Balance_Control_Timed_CheckBox.Enabled = attached
            If (attached = True) Then
                Balance_Control_Manual_Write_Command_Button.Enabled = Balance_Control_Manual_CheckBox.Checked
                Balance_Control_Manual_Execute_Button.Enabled = Balance_Control_Manual_CheckBox.Checked
                Balance_Control_Manual_Suspend_Button.Enabled = Balance_Control_Manual_CheckBox.Checked
                Balance_Control_Manual_Read_Command_Button.Enabled = Balance_Control_Manual_CheckBox.Checked
                Balance_Control_Manual_Read_Status_Button.Enabled = Balance_Control_Manual_CheckBox.Checked
                Balance_Control_Timed_Write_Button.Enabled = Balance_Control_Timed_CheckBox.Checked
                Balance_Control_Timed_StartStop_Button.Enabled = Balance_Control_Timed_CheckBox.Checked
                Balance_Control_Timed_Reset_Button.Enabled = Balance_Control_Timed_CheckBox.Checked
            Else
                Balance_Control_Manual_Write_Command_Button.Enabled = False
                Balance_Control_Manual_Execute_Button.Enabled = False
                Balance_Control_Manual_Suspend_Button.Enabled = False
                Balance_Control_Manual_Read_Command_Button.Enabled = False
                Balance_Control_Manual_Read_Status_Button.Enabled = False
                Balance_Control_Timed_Write_Button.Enabled = False
                Balance_Control_Timed_StartStop_Button.Enabled = False
                Balance_Control_Timed_Reset_Button.Enabled = False
            End If

            ' Init Config Buttons
            ' todo - Most stuff should be stored in the EEPROM.
            Config_Demo_Button.Enabled = attached
            Config_Save_Button.Enabled = attached
            Config_Load_Button.Enabled = attached
            Config_Save_NumericUpDown.Enabled = attached
            Config_Load_NumericUpDown.Enabled = attached

            ' Init Data Log
            Data_Log_CheckBox.Enabled = attached

            ' Init Cap Demo and Graph
            CapBoardBtn.Enabled = True
            is_charging = False
            is_discharging = False
            If (attached = False) And (GraphData.Opened = True) Then
                GraphData.Reset()
            End If
            If (attached = False) And (CapBoardPopup.Opened = True) Then
                CapBoardPopup.Reset()
            End If

            ' Init EEPROM Information
            For board_num As Integer = 0 To MAX_BOARDS - 1
                ReDim EEPROM_Data(board_num).Capacity(MAX_CELLS - 1)
                ReDim EEPROM_Data(board_num).Charge_Currents(MAX_CELLS - 1)
                ReDim EEPROM_Data(board_num).Discharge_Currents(MAX_CELLS - 1)
                For cell_num As Integer = 0 To MAX_CELLS - 1
                    EEPROM_Data(board_num).Capacity(cell_num) = 0
                    EEPROM_Data(board_num).Charge_Currents(cell_num) = 0
                    EEPROM_Data(board_num).Discharge_Currents(cell_num) = 0
                Next cell_num
            Next board_num

            ' Initialize Mfg Variables
            If (attached = False) And (Mfg_Enabled = True) Then
                Mfg_File.Close()
            End If
            Cal_Pending = False

            ' Update GUI
            For ic_num As Integer = 0 To NUM_LTC3300 - 1
                LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
            Next ic_num
            manageBatteryImages()
            Enable_MfgControlsAndIndicators()

            ' Init DC2100A USB Communication
            txtBulkDataWrite.Enabled = attached
            TxtBulkDataRead.Enabled = attached
            USB_Communication_Timer.Enabled = attached
            If attached = True Then
                USB_Communication_Timer.Interval = USB_COMM_TIMER_INTERVAL
                USB_Communication_Timer.Start()
            Else
                txtBulkDataWrite.Text = ""
                USB_Communication_Timer.Stop()
            End If

        Catch ex As Exception
            Handle_Exception(ex)
        End Try

    End Sub

#End Region

#Region "DC2100A USB Communication"
    Public Sub readAllData() 'reads voltages, status, and command in that order

        ' get strings to read the LTC3300 registers for the selected board
        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Balance))
        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Status))

        ' todo - the autoread stuff will need to change when FW is in control of streaming the data
        If autoReadBox.Checked = False Then
            USB_Comm_List_Out.Add(USB_PARSER_VOLTAGE_COMMAND)
            USB_Comm_List_Out.Add(USB_PARSER_TEMPERATURE_COMMAND)
            Temperature_Update_Flag = True
            Voltage_Update_Flag = True
        End If

    End Sub

    'This is code to be converted into a timer manager which will read the pipe on a regular interval
    'if the data in the pipe is the same as the data that was last read, txtbulkdataread has NO CHANGE (this is important for the event triggered
    '                                                                                                   when txtbulkdataread's text changes)
    'therefore we will have to save the present string in txtbulkdataread for a comparison before checking the pipe!
    Private Sub USB_Communication_Timer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles USB_Communication_Timer.Tick

        Dim dataString As String = ""

        Comm_Times(comm_times_index) = DateTime.Now
        If comm_times_index < NUM_COMM_TIMES - 1 Then
            comm_times_index += 1
        Else
            comm_times_index = 0
        End If

        ' As good a place as any to periodically update the debug indicators
        If DEBUG_LED = True Then
            Me.Comm_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED

            ' If no boards are connected, turn off green LED.  If boards are connected, toggle green LED to look like the PCB.
            If numBoards = 0 Then
                board_connected_led_counter = 0
                board_connected_led_toggle = False
                Me.Status_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
            Else
                board_connected_led_counter += USB_COMM_TIMER_INTERVAL
                If (board_connected_led_counter >= board_connected_led_counter_period(system_state)) Then
                    board_connected_led_counter -= board_connected_led_counter_period(system_state)

                    If board_connected_led_toggle = True Then
                        Me.Status_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.unlit_LED
                        board_connected_led_toggle = False
                    Else
                        Me.Status_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.green_LED
                        board_connected_led_toggle = True
                    End If
                End If
            End If
        End If

        ' If we're able to send more commands, send them.
        ' Don't send if we are expecting the DC2100A to enter the bootloader, however, or if we're in the middle of asking if they want to enter the bootloader.
        If (USB_Comm_Can_Send = True) And (FW_Update_PopUp = False) And (Bootloader_Response_Received = False) Then

            If system_state <> System_State_Type.Awake Then
                ' If the number of boards is still 0, then continue polling system data
                If USB_Comm_Cycle_Counter = 0 Then
                    dataString = USB_PARSER_SYSTEM_COMMAND
                End If
            Else
                If (USB_Comm_Cycle_Counter = ((CInt(0 * USB_COMM_CYCLE_PERIOD_DEFAULT) \ USB_COMM_TIMER_INTERVAL) * USB_COMM_TIMER_INTERVAL)) Then
                    If (autoReadBox.Checked = True) Or (GraphData.Enable_CheckBox.Checked = True) Or (CapBoardPopup.Enable_CheckBox.Checked = True) Then
                        dataString = USB_PARSER_VOLTAGE_COMMAND
                    End If
                ElseIf (USB_Comm_Cycle_Counter = ((CInt(0.2 * USB_COMM_CYCLE_PERIOD_DEFAULT) \ USB_COMM_TIMER_INTERVAL) * USB_COMM_TIMER_INTERVAL)) Then
                    If (autoReadBox.Checked = True) Or (GraphData.Enable_CheckBox.Checked = True) Or (CapBoardPopup.Enable_CheckBox.Checked = True) Then
                        dataString = USB_PARSER_TEMPERATURE_COMMAND
                    End If
                ElseIf (USB_Comm_Cycle_Counter = ((CInt(0.4 * USB_COMM_CYCLE_PERIOD_DEFAULT) \ USB_COMM_TIMER_INTERVAL) * USB_COMM_TIMER_INTERVAL)) Then
                    If (autoReadBox.Checked = True) Or (GraphData.Enable_CheckBox.Checked = True) Or (CapBoardPopup.Enable_CheckBox.Checked = True) Then
                        If (Temperature_ADC_Test_IC1_Checkbox.Checked Or Temperature_ADC_Test_IC2_Checkbox.Checked) Then
                            dataString = USB_PARSER_TEMP_ADC_COMMAND + selectedBoard.ToString("X2")
                        End If
                    End If
                ElseIf (USB_Comm_Cycle_Counter = ((CInt(0.6 * USB_COMM_CYCLE_PERIOD_DEFAULT) \ USB_COMM_TIMER_INTERVAL) * USB_COMM_TIMER_INTERVAL)) Then
                    If isTimedBalancing = True Then
                        dataString = USB_PARSER_TIMED_BALANCE_COMMAND + "R" + selectedBoard.ToString("X2")
                    End If
                ElseIf USB_Comm_Cycle_Counter = ((CInt(0.8 * USB_COMM_CYCLE_PERIOD_DEFAULT) \ USB_COMM_TIMER_INTERVAL) * USB_COMM_TIMER_INTERVAL) Then
                    ' Note that this is the only polled command that wouldn't be simple to turn into something the FW can stream on its own.
                    If isBalancing = True Then
                        dataString = LTC3300_Raw_Read(LTC3300.Command.Read_Balance) + LTC3300_Raw_Read(LTC3300.Command.Read_Status)
                    End If
                End If
            End If

            ' If no periodic commands are being sent, send the special commands accumulated from elsewhere in the code.
            If dataString = "" Then
                ' Send up to USB_MAX_PACKET_SIZE characters
                While (USB_Comm_List_Out.Count > 0) AndAlso (USB_Comm_List_Out(0).Length < (USB_MAX_PACKET_SIZE - dataString.Length))
                    dataString += USB_Comm_List_Out(0)
                    USB_Comm_List_Out_Count_This_Cycle += USB_Comm_List_Out(0).Length
                    USB_Comm_List_Out.Remove(USB_Comm_List_Out(0))
                End While
            End If

            ' If any commands need to be sent, send them.
            If dataString <> "" Then
                ' Clear flag to prevent any new commands from being sent
                USB_Comm_Can_Send = False
                ' Copy data where hidden screen displays it in a field and then sends via USB
                txtBulkDataWrite.Text = dataString
                If WritePipe_BackgroundWorker.IsBusy = False Then
                    WritePipe_BackGroundWorker_Monitor.ThreadLaunchedTime = DateTime.Now
                    WritePipe_BackgroundWorker.RunWorkerAsync(dataString) ' Pass the string to write
                End If
            End If

            ' Increment the timer for sending commands and reset once over the interval
            USB_Comm_Cycle_Counter += USB_COMM_TIMER_INTERVAL
            If (USB_Comm_Cycle_Counter >= USB_Comm_Cycle_Counter_Period) Then
                ' Track the number of commands sent this comm cycle
                If (USB_Comm_List_Out_Count_This_Cycle > USB_Comm_List_Out_Count_Per_Cycle_Max) Then
                    USB_Comm_List_Out_Count_Per_Cycle_Max = USB_Comm_List_Out_Count_This_Cycle
                End If

                ' Clear variables to start next cycle
                USB_Comm_Cycle_Counter = 0
                USB_Comm_List_Out_Count_This_Cycle = 0
            End If
        End If

        'If we aren't already reading from the USB, start a thread to read characters from the USB and process them
        If USB_Comm_Can_Receive = True Then
            USB_Comm_Can_Receive = False
            If AutoBulkReadWorker.IsBusy <> True AndAlso BulkReadWorker.IsBusy <> True Then
                ReadPipe_BackGroundWorker_Monitor.ThreadLaunchedTime = DateTime.Now
                AutoBulkReadWorker.RunWorkerAsync(USB_MAX_PACKET_SIZE) ' Pass how many bytes to read
            End If
        End If
    End Sub

    Private Sub WritePipe_BackgroundWorker_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles WritePipe_BackgroundWorker.DoWork
        Dim Data As New WinUSBData
        Dim ReturnedCode As Integer

        Try
            ' Get data to send 
            Dim dataToSend As String = DirectCast(e.Argument, String)

            ' Convert the string to a byte array.
            Dim myEncoder As New System.Text.ASCIIEncoding()
            Dim bytesToSend As UInt32 = Convert.ToUInt32(dataToSend.Length())
            Dim databuffer(dataToSend.Length() - 1) As Byte
            databuffer = myEncoder.GetBytes(dataToSend)

            'Send the data
            Data.CallTime = DateTime.Now
            ReturnedCode = WinUsbDevice.WritePipe(CurrentDevice, CurrentDevice.bulkOutPipe, databuffer, bytesToSend)

            If ReturnedCode > 0 Then
                ' Do something in another thread when USB data is successfully received.
            End If

            ' Fill the return object with data
            Data.ReturnCode = ReturnedCode
            Data.DataString = Encoding.UTF8.GetString(databuffer).TrimEnd(Chr(0))

        Catch
            Throw
        End Try

        ' Return the entire object
        Data.ReturnTime = DateTime.Now
        e.Result = Data

    End Sub

    Private Sub WritePipe_BackgroundWorker_RunWorkerCompleted(ByVal sender As System.Object, ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs) _
        Handles WritePipe_BackgroundWorker.RunWorkerCompleted

        WritePipe_BackGroundWorker_Monitor.ThreadCompleteTime = DateTime.Now

        Dim Data As WinUSBData = DirectCast(e.Result, WinUSBData)
        WritePipe_BackGroundWorker_Monitor.WinUSBCallTime = Data.CallTime
        WritePipe_BackGroundWorker_Monitor.WinUSBReturnTime = Data.ReturnTime

        If WritePipe_BackGroundWorker_Monitor.Check_Limit_And_Set_Time_Spans() = True Then
            Error_File.Add(Error_File.Error_Code.WinUSB_WritePipeDelay, _
                           WritePipe_BackGroundWorker_Monitor.TimeSpans(0).ToString + "+++" + _
                           WritePipe_BackGroundWorker_Monitor.TimeSpans(1).ToString + "+++" + _
                           WritePipe_BackGroundWorker_Monitor.TimeSpans(2).ToString + "+++", Data.DataString)
        End If


        ' Display the received data in the form's text box, and status in the status box.
        If Data.ReturnCode > 0 Then
            AddStringToListBox("Data successfully sent to Bulk OUT pipe.") ' More than 0 bytes sent, success
        Else
            num_times_write_pipe_error += 1

            If (Data.ReturnCode = -1) Then
                AddStringToListBox("Invalid Device") ' Attempted to send data to an invalid device
            ElseIf (Data.ReturnCode = -2) Then
                AddStringToListBox("Invalid Pipe or Pipe Direction") ' Attempted to write data to other than OUT pipe
            Else
                AddStringToListBox("Cannot send 0 bytes") ' Attempted to send 0 bytes
                NoteLabel.Text = "Error sending data string, reset device."
            End If

            Error_File.Add(Error_File.Error_Code.WinUSB_WritePipeError, Data.ReturnCode.ToString() + ":" + num_times_write_pipe_error.ToString(), _
                           Extract_Function_Name_From_String(System.Reflection.MethodInfo.GetCurrentMethod().ToString()))
        End If

        If DEBUG = True Then
            Try
                Me.Debug_TextBox.Text = WritePipe_BackGroundWorker_Monitor.Num_Times_Over_Limit.ToString() + ", " +
                                        num_times_write_pipe_error.ToString() + ", " +
                                        ReadPipe_BackGroundWorker_Monitor.Num_Times_Over_Limit.ToString() + ", " +
                                        num_times_read_pipe_error.ToString()
            Catch ex As Exception
                Handle_Exception(ex)
            End Try
        End If

        USB_Comm_Can_Send = True

    End Sub

    Private Sub AutoBulkReadWorker_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs
                                            ) Handles AutoBulkReadWorker.DoWork

        Dim Data As New WinUSBData
        Dim buffer(CInt(e.Argument) - 1) As Byte
        Dim bytesRead As UInt32
        Dim bytesToRead As UInt32 = CUInt(e.Argument)
        Dim ReturnedCode As Integer

        Try

            ' Read data from bulk IN channel
            Data.CallTime = DateTime.Now
            ReturnedCode = WinUsbDevice.ReadPipe(CurrentDevice, CurrentDevice.bulkInPipe, bytesToRead, buffer, bytesRead)

            If ReturnedCode > 0 Then
                ' Do something in another thread when USB data is successfully received.
            End If

            ' Fill the return object with data
            Data.ReturnCode = ReturnedCode
            Data.DataString = Encoding.UTF8.GetString(buffer).TrimEnd(Chr(0))

        Catch
            Throw
        End Try

        ' Return the entire object
        Data.ReturnTime = DateTime.Now
        e.Result = Data

    End Sub

    Private Sub AutoBulkReadWorker_RunWorkerCompleted(ByVal sender As System.Object,
                                                     ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs
                                                     ) Handles AutoBulkReadWorker.RunWorkerCompleted
        ReadPipe_BackGroundWorker_Monitor.ThreadCompleteTime = DateTime.Now

        Dim Data As WinUSBData = DirectCast(e.Result, WinUSBData)
        ReadPipe_BackGroundWorker_Monitor.WinUSBCallTime = Data.CallTime
        ReadPipe_BackGroundWorker_Monitor.WinUSBReturnTime = Data.ReturnTime

        If (ReadPipe_BackGroundWorker_Monitor.Check_Limit_And_Set_Time_Spans() = True) Then
            Error_File.Add(Error_File.Error_Code.WinUSB_ReadPipeDelay, _
                           ReadPipe_BackGroundWorker_Monitor.TimeSpans(0).ToString + "+++" + _
                           ReadPipe_BackGroundWorker_Monitor.TimeSpans(1).ToString + "+++" + _
                           ReadPipe_BackGroundWorker_Monitor.TimeSpans(2).ToString + "+++", Data.DataString)
        Else

            ' Display the received data in the form's text box, and status in the status box.
            If Data.ReturnCode > 0 Then
                USB_Parser(Data.DataString)   ' todo - this isn't actually in the spawned thread, where we'd like it to be to keep the GUI smooth
                TxtBulkDataRead.Text = Data.DataString
            Else
                num_times_read_pipe_error += 1

                Error_File.Add(Error_File.Error_Code.WinUSB_ReadPipeError, Data.ReturnCode.ToString() + ":" + num_times_read_pipe_error.ToString(), _
                               Extract_Function_Name_From_String(System.Reflection.MethodInfo.GetCurrentMethod().ToString()))
            End If

        End If


        If DEBUG = True Then
            Try
                Me.Debug_TextBox.Text = WritePipe_BackGroundWorker_Monitor.Num_Times_Over_Limit.ToString() + ", " +
                                        num_times_write_pipe_error.ToString() + ", " +
                                        ReadPipe_BackGroundWorker_Monitor.Num_Times_Over_Limit.ToString() + ", " +
                                        num_times_read_pipe_error.ToString()
            Catch ex As Exception
                Handle_Exception(ex)
            End Try
        End If

        USB_Comm_Can_Receive = True
    End Sub

    ' PARSER!!
    ' Handles all commands
    ' Note that more than message may be received in one string, and note that one message may be contained in multiple strings.
    ' We need to :
    '               #1, copy the text to a working buffer
    '               #2, operate on as much as we can in this working buffer
    '               #3, leave what we can in this working buffer for the next time we receive data
    Private Sub USB_Parser(ByRef new_data As String)

        Dim response_length As Integer

        ' Don't parse anything after the bootloader response is received, as it's probably garbage and certainly not important.
        If (Bootloader_Response_Received = True) Then
            Exit Sub
        End If

        ' Get the new characters
        USB_Parser_Buffer_In += new_data

        ' If string is empty, do nothing,
        If (USB_Parser_Buffer_In = "") Then
            Exit Sub
        End If

        ' Try to process all of the characters
        Do While (USB_Parser_Buffer_In.Length > response_length)

            ' If this is a response that we know, then attempt to process it
            If USB_Parser_Response_Data.ContainsKey(USB_Parser_Buffer_In(0)) Then

                response_length = USB_Parser_Response_Data(USB_Parser_Buffer_In(0))

                If USB_Parser_Buffer_In.Length >= response_length Then

                    If DEBUG_LED = True Then
                        Me.Comm_LED_PictureBox.Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.orange_LED
                    End If

                    If (USB_Process_Response(USB_Parser_Buffer_In, response_length) = True) Then

                        ' When a USB response does not process correctly, it will report back to drop only one character.  
                        ' It is a subtley betwen USB_Process_Response returning a Done flag rather than a Success factor.
                        ' It'd be good to remove that subtley from the code.
                        If response_length = 1 Then
                            USB_Parser_Buffer_Dropped += USB_Parser_Buffer_In(0)
                        ElseIf USB_Parser_Buffer_Dropped <> "" Then
                            ' Send all of the dropped characters in one error message, which we can't know which is the last dropped character until we see a successful USB response processed.
                            Error_File.Add(Error_File.Error_Code.USB_Dropped, USB_Parser_Buffer_Dropped)
                            USB_Parser_Buffer_Dropped = ""
                        End If

                        ' If done processing the response (whether it was successful or dropping the command byte that parsed unsuccessfully, remove it from the buffer
                        USB_Parser_Buffer_In = USB_Parser_Buffer_In.Remove(0, response_length)
                        response_length = 0

                    End If

                Else
                    ' Wait for more characters, if entire response is not yet received
                End If

            Else
                ' Save the characters that were dropped, and write them into the Error log at the next good transaction.
                USB_Parser_Buffer_Dropped += USB_Parser_Buffer_In(0)
                If USB_Parser_Buffer_Dropped.Length >= USB_MAX_PACKET_SIZE Then
                    Error_File.Add(Error_File.Error_Code.USB_Dropped, USB_Parser_Buffer_Dropped)
                    USB_Parser_Buffer_Dropped = ""
                End If

                ' If this is not a response that we know, then throw it away
                USB_Parser_Buffer_In = USB_Parser_Buffer_In.Remove(0, 1)

                response_length = 0

            End If

        Loop
    End Sub

    ' todo - This is where the USB processing is actually done.  The commands, and their format has got to be better managed between the FW and GUI.
    Private Function USB_Process_Response(ByRef buffer As String, ByRef length As Integer) As Boolean
        Dim success As Boolean = True
        Dim done As Boolean = True

        Select Case buffer.Substring(0, 1)
            Case USB_PARSER_HELLO_COMMAND
                If buffer.Substring(0, length - 1) <> HELLOSTRING.Substring(0, length - 1) Then  ' allow the LF to be different
                    success = False
                End If
            Case USB_PARSER_IDSTRING_COMMAND
                Dim first_string As String
                Dim second_string As String

                first_string = buffer.Substring(0, DC2100A_MODEL_NUM_DEFAULT.Length - 1)
                second_string = DC2100A_IDSTRING.Substring(0, DC2100A_MODEL_NUM_DEFAULT.Length - 1)
                If first_string <> second_string Then
                    success = False
                End If

                first_string = buffer.Substring(DC2100A_MODEL_NUM_DEFAULT.Length, length - DC2100A_MODEL_NUM_DEFAULT.Length)
                second_string = DC2100A_IDSTRING.Substring(DC2100A_MODEL_NUM_DEFAULT.Length, length - DC2100A_MODEL_NUM_DEFAULT.Length)
                If first_string <> second_string Then
                    success = False
                End If
            Case USB_PARSER_DEFAULT_COMMAND
                If buffer.Substring(0, length) <> USB_PARSER_DEFAULT_STRING Then
                    success = False
                End If

            Case USB_PARSER_BOOT_MODE_COMMAND
                Try
                    If buffer.Substring(1, length - 1) = USB_PARSER_BOOTLOAD_STRING Then
                        Error_File.Add(Error_File.Error_Code.Message, "Bootload Response Received")
                        Bootloader_Response_Received = True
                    Else
                        success = False
                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_ERROR_COMMAND
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim temp_error_num As Integer
                    Dim temp_error_data(ERROR_DATA_SIZE - 1) As Integer

                    ' get the error number
                    index = 1
                    num_bytes = 2
                    temp_error_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    ' get the error data
                    num_bytes = 2
                    For byte_num As Integer = 0 To ERROR_DATA_SIZE - 1
                        temp_error_data(byte_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes
                    Next byte_num

                    ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables

                    ' *** Update all of the indicators dependent upon this USB data
                    ' todo - move this out of here so that the comm can be handled in its own thread

                    ' Create error log entry
                    Dim error_string As String = ""
                    Select Case temp_error_num
                        Case FW_ERROR_CODE.LTC6804_CRC
                            error_string = "Board " + (temp_error_data(0) + 1).ToString
                            error_string += ", Command: " + ((temp_error_data(1) << 8) + temp_error_data(2)).ToString("X4")
                            error_string += ", Bytes: "
                            For byte_num As Integer = 3 To ERROR_DATA_SIZE - 1
                                error_string += temp_error_data(byte_num).ToString("X2") + ", "
                            Next byte_num
                            Error_File.Add(Error_File.Error_Code.LTC6804_CRC, error_string, Board_Summary_Data(temp_error_data(0)).Volt_Sum.ToString(VOLTAGE_FORMAT))
                        Case FW_ERROR_CODE.LTC3300_CRC
                            error_string = "Board " + (temp_error_data(0) + 1).ToString
                            error_string += ", IC: " + temp_error_data(1).ToString
                            error_string += ", Command: " + temp_error_data(2).ToString("X2")
                            error_string += ", Bytes: "
                            For byte_num As Integer = 3 To ERROR_DATA_SIZE - 1
                                error_string += temp_error_data(byte_num).ToString("X2") + ", "
                            Next byte_num
                            Error_File.Add(Error_File.Error_Code.LTC3300_CRC, error_string, Board_Summary_Data(temp_error_data(0)).Volt_Sum.ToString(VOLTAGE_FORMAT))
                        Case FW_ERROR_CODE.LTC6804_FAILED_CFG_WRITE
                            error_string = "Board " + (temp_error_data(0) + 1).ToString
                            error_string += ", Test_Value_VUV: " + ((temp_error_data(1) << 8) + temp_error_data(2)).ToString
                            error_string += " : " + ((temp_error_data(3) << 8) + temp_error_data(4)).ToString
                            error_string += ", Test_Value_VOV: " + ((temp_error_data(5) << 8) + temp_error_data(6)).ToString
                            error_string += " : " + ((temp_error_data(7) << 8) + temp_error_data(8)).ToString
                            Error_File.Add(Error_File.Error_Code.LTC6804_Failed_CFG_Write, error_string)
                        Case FW_ERROR_CODE.LTC6804_ADC_CLEAR
                            error_string = "Board " + (temp_error_data(0) + 1).ToString
                            error_string += " failed to start ADC conversion."
                            Dim fail_timestamp As Integer = ((temp_error_data(1) << 24) + (temp_error_data(2) << 16) + (temp_error_data(3) << 8) + (temp_error_data(4)))
                            Error_File.Add(Error_File.Error_Code.LTC6804_ADC_Clear, error_string, fail_timestamp.ToString())
                        Case FW_ERROR_CODE.LTC3300_FAILED_CMD_WRITE
                            error_string = "Board " + (temp_error_data(0) + 1).ToString
                            error_string += " failed to write balance command."
                            error_string += ", write value:" + ((temp_error_data(1) << 16) + (temp_error_data(2) << 8) + temp_error_data(3)).ToString("X4")
                            error_string += ", read value:" + ((temp_error_data(4) << 16) + (temp_error_data(5) << 8) + temp_error_data(6)).ToString("X4")
                            Error_File.Add(Error_File.Error_Code.LTC3300_Failed_Write_Command, error_string, Board_Summary_Data(temp_error_data(0)).Volt_Sum.ToString(VOLTAGE_FORMAT))

                        Case Else
                            error_string = "Bytes: "
                            For byte_num As Integer = 0 To ERROR_DATA_SIZE - 1
                                error_string += temp_error_data(byte_num).ToString() + ", "
                            Next byte_num
                            Error_File.Add(Error_File.Error_Code.Test, error_string)
                    End Select

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try
            Case USB_PARSER_UVOV_COMMAND
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim system_ov_last As Boolean
                    Dim system_uv_last As Boolean
                    Dim condition_string As String = ""
                    Dim action_string As String = ""
                    Dim temp_ov_flags As Integer
                    Dim temp_uv_flags As Integer

                    ' save last OV and UV condition, so that we can pop-up a message if it changes.
                    system_ov_last = Get_SystemOV(board_num)
                    system_uv_last = Get_SystemUV(board_num)

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else
                        ' get the ov flags
                        num_bytes = 3
                        temp_ov_flags = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' get the uv flags
                        num_bytes = 3
                        temp_uv_flags = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables

                        ' If flags haven't actually changed, nothing needs to be done
                        If (UV_Flags(board_num) <> temp_uv_flags) Or (OV_Flags(board_num) <> temp_ov_flags) Then

                            UV_Flags(board_num) = temp_uv_flags
                            OV_Flags(board_num) = temp_ov_flags

                            ' *** Update all of the indicators dependent upon this USB data
                            ' todo - move this out of here so that the comm can be handled in its own thread
                            ' update battery images for the changed UV and OV conditions.
                            If board_num = selectedBoard Then
                                manageBatteryImages()
                            End If

                            ' When an Overvoltage or Undervoltage condition occurs, always create an error log entry, but
                            ' only pop up messages Pop up message if an action is being cancelled due to a new OV/UV condition.
                            condition_string = Get_OVUV_Condition_String(board_num)

                            ' Figure out if an action is being taken due to the new OV/UV condition.
                            If (((system_ov_last = False) And (Get_SystemOV(board_num) = True)) Or
                                ((system_uv_last = False) And (Get_SystemUV(board_num) = True))) Then

                                ' Stop balancing.
                                If isBalancing Then
                                    Timed_Balance_Stop(False)
                                    If action_string <> "" Then
                                        action_string += "/"
                                    End If
                                    action_string += "Balancing"
                                End If

                                ' Turn off charger if cap board demo and OV.
                                If (OV_Flags(board_num) <> 0) And (CapBoardPopup.ChgBox.Checked = True) Then

                                    If action_string <> "" Then
                                        action_string += "/"
                                    End If
                                    action_string += "Charging"

                                    ' Stop test that was in progress, and then act as it stop charge/discharge button was pressed
                                    CapBoardPopup.Update_GUI_Cap_Demo_Buttons(CapBoardPopup.Cap_Demo_Button_Type.None_Selected)
                                    CapBoardPopup.Update_GUI_Cap_Demo_Buttons(CapBoardPopup.Cap_Demo_Button_Type.Stop_Chg_Dchg)

                                    USB_Comm_List_Out.Add(USB_PARSER_CAP_DEMO_COMMAND + "N")
                                End If

                                ' Display information about OV/UV condition and actions taken due to it.
                                If (action_string <> "") Then
                                    NoteLabel.Text = action_string + " suspended due to " + condition_string + "."
                                End If

                                ' Pop up message if action is being cancelled due to OV/UV condition.
                                If (action_string <> "") Then
                                    If OVorUVPopup.Visible = False Then
                                        OVorUVPopup.Set_Text(action_string, condition_string, board_num, True)
                                        OVorUVPopup.Show()
                                    End If
                                End If
                            End If

                            ' Create error log entry
                            If (condition_string <> "") Then
                                Error_File.Add(Error_File.Error_Code.OVUV, "Board " + (board_num + 1).ToString + " " + condition_string + ". Flags = " + buffer.Substring(buffer.Length - 6), buffer)
                            Else
                                Error_File.Add(Error_File.Error_Code.OVUV, "Board " + (board_num + 1).ToString + " returned from OV/UV" + ". Flags = " + buffer.Substring(buffer.Length - 6), buffer)
                            End If
                        End If
                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try
            Case USB_PARSER_SYSTEM_COMMAND
                ' Process the system configuration information
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim num_boards_next As Integer
                    Dim temp_board_address_table(LTC6804_MAX_BOARDS - 1) As Integer
                    Dim temp_vmin As Single
                    Dim temp_vmax As Single
                    Dim temp_cap_demo_bitmap As Integer
                    Dim temp_charge As Boolean
                    Dim temp_discharge As Boolean

                    ' get the number of boards
                    index = 1
                    num_bytes = 2
                    num_boards_next = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    ' get the board addresses
                    num_bytes = 2
                    For board_num As Integer = 0 To LTC6804_MAX_BOARDS - 1
                        temp_board_address_table(board_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes
                    Next board_num

                    ' get the undervoltage and overvoltage thresholds
                    num_bytes = 4
                    temp_vmin = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) * VOLTAGE_RESOLUTION
                    index = index + num_bytes
                    temp_vmax = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) * VOLTAGE_RESOLUTION
                    index = index + num_bytes

                    ' get the cap demo bitmap
                    num_bytes = 2
                    temp_cap_demo_bitmap = CInt(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier))
                    index = index + num_bytes
                    If (temp_cap_demo_bitmap And &H7) = &H3 Then
                        temp_charge = True
                        temp_discharge = False
                    ElseIf (temp_cap_demo_bitmap And &H7) = &H5 Then
                        temp_charge = False
                        temp_discharge = True
                    Else
                        temp_charge = False
                        temp_discharge = False
                    End If

                    ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                    For board_num As Integer = 0 To LTC6804_MAX_BOARDS - 1
                        board_address_table(board_num) = temp_board_address_table(board_num)
                        index = index + num_bytes
                    Next board_num
                    vMin = temp_vmin
                    vMax = temp_vmax
                    is_charging = temp_charge
                    is_discharging = temp_discharge

                    ' *** Update all of the indicators dependent upon this USB data
                    ' todo - move this out of here so that the comm can be handled in its own thread

                    ' If we're receiving responses to the "s" command then we must have a board attached.
                    ' It just must not have its cells powered up.
                    If num_boards_next = 0 Then
                        num_boards_next = 1

                        ' Give a special message when the DC2100A is connected, but unable to communicate with its LTC6804 due to the cells being unpowered.
                        If numBoards = 0 Then
                            NoteLabel.Text = "DC2100A has connected, but its cells are not charged."
                        End If
                    Else
                        ' If this is the special case where the PIC board was connected but is now powered, request its data so that the EEPROM and LTC3300 data is updated.
                        ' todo - this is so gross
                        If (num_boards_next = 1) And (system_state <> System_State_Type.Awake) Then

                            USB_Comm_List_Out.Add(USB_PARSER_MFG_COMMAND + "R" + DC2100A_PIC_BOARD_NUM.ToString("X2"))
                            USB_Comm_List_Out.Add(D33001.USB_PARSER_EEPROM_COMMAND + "R" + DC2100A_PIC_BOARD_NUM.ToString("X2") + "0")
                            USB_Comm_List_Out.Add(D33001.USB_PARSER_EEPROM_COMMAND + "R" + DC2100A_PIC_BOARD_NUM.ToString("X2") + "1")

                            ' Read UV/OV, passive balancer, and ltc3300 register data for selected board
                            USB_Comm_List_Out.Add(USB_PARSER_UVOV_COMMAND + DC2100A_PIC_BOARD_NUM.ToString("X2"))
                            USB_Comm_List_Out.Add(USB_PARSER_PASSIVE_BALANCE_COMMAND + "R" + DC2100A_PIC_BOARD_NUM.ToString("X2"))
                            USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Balance))
                            USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Status))

                            NoteLabel.Text = "DC2100A has connected, and its cells are charged."

                        End If

                        system_state = System_State_Type.Awake   ' If the number of boards reported by this command is non-zero, then the boards must be powered.

                    End If

                    If num_boards_next <> numBoards Then
                        ' If the number of boards changed, rebuild GUI

                        ' First remove all of the old boards
                        numBoards = 0
                        TreeView1.Nodes.Clear()
                        CellGrid.Columns.Clear()

                        ' Then add all of the new boards
                        For board_num As Integer = 0 To (num_boards_next - 1)
                            numBoards = numBoards + 1
                            addNode()
                            addGridColumn()
                        Next board_num

                        ' Start with first board in stack as the selected board
                        selectedBoard = 0
                        selectedCell = ALL_CELLS
                        selectedIC = 1
                        TreeView1.SelectedNode = TreeView1.Nodes(0)

                        ' Update Board Count Labels
                        Board_Count_Label.Text = numBoards.ToString
                        DataInputPopup.Board_Count_Label.Text = Board_Count_Label.Text
                        GraphData.Board_Count_Label.Text = Board_Count_Label.Text

                        ' Boards are detected, start reading data

                        ' Read ID and EEPROM data for all boards
                        For board_num As Integer = 0 To (numBoards - 1)
                            USB_Comm_List_Out.Add(USB_PARSER_MFG_COMMAND + "R" + board_num.ToString("X2"))
                            USB_Comm_List_Out.Add(D33001.USB_PARSER_EEPROM_COMMAND + "R" + board_num.ToString("X2") + "0")
                            USB_Comm_List_Out.Add(D33001.USB_PARSER_EEPROM_COMMAND + "R" + board_num.ToString("X2") + "1")
                        Next
                        ' Read UV/OV, passive balancer, and ltc3300 register data for selected board
                        USB_Comm_List_Out.Add(USB_PARSER_UVOV_COMMAND + selectedBoard.ToString("X2"))
                        USB_Comm_List_Out.Add(USB_PARSER_PASSIVE_BALANCE_COMMAND + "R" + selectedBoard.ToString("X2"))
                        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Balance))
                        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Status))


                        ' Adjust the polling interval to account for more boards
                        USB_Comm_Cycle_Counter_Period = USB_COMM_CYCLE_PERIOD_DEFAULT + (numBoards - 1) * USB_COMM_TIMER_INTERVAL * USB_COMM_TIMER_INTERVALS_PER_BOARD

                        ' Restart the counter so that the voltage will be the first value read
                        USB_Comm_Cycle_Counter = 0

                    End If

                    If (vMaxBox.Focused = False) Then
                        vMaxBox.Text = vMax.ToString(VOLTAGE_LIMIT_FORMAT)
                    End If

                    If (vMinBox.Focused = False) Then
                        vMinBox.Text = vMin.ToString(VOLTAGE_LIMIT_FORMAT)
                    End If

                    CapBoardPopup.ChgBox.Checked = is_charging
                    CapBoardPopup.DchgBox.Checked = is_discharging

                    Enable_MfgControlsAndIndicators()

                Catch ex As Exception
                    Handle_Exception(ex)

                    ' Only offer once when a new board is connected.
                    If (FW_Update_Offered = False) Then
                        FW_Update_Offered = True

                        Dim popup_msg As String = "This board contains firmware (FW) that is obsolete for this GUI."
                        popup_msg += ChrW(13) + ChrW(10) + ChrW(13) + ChrW(10)
                        popup_msg += "Update to "
                        popup_msg += Firmware_Version_Expected.Get_String()
                        popup_msg += "?"

                        Bootloader_Popup(popup_msg)
                    End If

                    success = False
                End Try

            Case USB_PARSER_MFG_COMMAND
                ' Process the Manufacturing Data
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim TempString As String
                    Dim temp_board_id_data As Board_ID_Data_Structure

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the model number
                        num_bytes = DC2100A_MODEL_NUM_DEFAULT.Length
                        temp_board_id_data.Model = buffer.Substring(index, num_bytes)
                        index = index + num_bytes

                        ' get setting for whether this is a cap board demo or not.
                        num_bytes = 1
                        TempString = buffer.Substring(index, num_bytes)
                        index = index + num_bytes
                        If TempString = "T" Then
                            temp_board_id_data.Cap_Demo = True
                        ElseIf TempString = "F" Then
                            temp_board_id_data.Cap_Demo = False
                        Else
                            temp_board_id_data.Cap_Demo = True ' Default to True if we're not sure, as being configured as a Cap Demo system allows us to turn the charger pin on.
                        End If

                        ' get the serial number
                        num_bytes = DC2100A_SERIAL_NUM_DEFAULT.Length
                        temp_board_id_data.Serial_Number = buffer.Substring(index, num_bytes)
                        index = index + num_bytes

                        ' BEGINNING OF PARAMETERS THAT ARE NOT STORED IN EEPROM
                        ' get the 12 cell charge current
                        num_bytes = 4
                        temp_board_id_data.Average_Charge_Current_12Cell = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) / 1000
                        index = index + num_bytes

                        ' get the 12 cell discharge current
                        num_bytes = 4
                        temp_board_id_data.Average_Discharge_Current_12Cell = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) / 1000
                        index = index + num_bytes

                        ' get the 6 cell charge current
                        num_bytes = 4
                        temp_board_id_data.Average_Charge_Current_6Cell = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) / 1000
                        index = index + num_bytes

                        ' get the 6 cell discharge current
                        num_bytes = 4
                        temp_board_id_data.Average_Discharge_Current_6Cell = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) / 1000
                        index = index + num_bytes

                        ' get the firmware revision
                        num_bytes = APP_FW_STRING_DEFAULT.Length
                        temp_board_id_data.FW_Rev = buffer.Substring(index, num_bytes)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables

                        ' If this is the PIC board, then translate the FW revision from a string into a parsed object
                        If board_num = DC2100A_PIC_BOARD_NUM Then
                            Firmware_Version_Connected.Set_String(temp_board_id_data.FW_Rev)
                            temp_board_id_data.FW_Rev = Firmware_Version_Connected.Get_String()
                        End If

                        Board_ID_Data(board_num) = temp_board_id_data

                        ' If Cap Demo Board and Cap Demo window is open, set up to start graphing signals.
                        If (CapBoardPopup.Opened = True) Then
                            CapBoardPopup.Setup_Graphed_Signals()
                        End If

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread
                        If (board_num = selectedBoard) Then
                            GUI_Refresh_Board_ID_Data()
                        End If

                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_VOLTAGE_COMMAND
                ' Process the voltage data for one board
                Try

                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim temp_timestamp As UInteger
                    Dim temp_voltages(MAX_CELLS - 1) As Integer
                    Dim temp_balancestamp As Byte

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the timestamp
                        num_bytes = 8
                        temp_timestamp = UInteger.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' get the board voltages
                        num_bytes = 4
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            temp_voltages(cell_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                            index = index + num_bytes
                        Next cell_num

                        ' get the balancestamp
                        num_bytes = 2
                        temp_balancestamp = Byte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables

                        ' Set the voltages and summary data for this board
                        Dim temp_max As Single = 0                     ' Start max as value that's really low
                        Dim temp_min As Single = VOLTAGE_MAX           ' Start min as value that's really high
                        Dim cell_max As Integer = 0
                        Dim cell_min As Integer = 0
                        Dim temp_sum As Single = 0
                        Dim temp_num_cells As Integer = 0
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            Voltages(board_num, cell_num) = temp_voltages(cell_num) * VOLTAGE_RESOLUTION
                            If cellPresent(board_num, cell_num) = True Then
                                If Voltages(board_num, cell_num) > temp_max Then
                                    temp_max = Voltages(board_num, cell_num)
                                    cell_max = cell_num
                                End If
                                If Voltages(board_num, cell_num) < temp_min Then
                                    temp_min = Voltages(board_num, cell_num)
                                    cell_min = cell_num
                                End If
                                temp_sum += Voltages(board_num, cell_num)
                            End If
                        Next cell_num
                        Board_Summary_Data(board_num).Volt_Max = temp_max
                        Board_Summary_Data(board_num).Volt_Min = temp_min
                        Board_Summary_Data(board_num).Volt_Max_Cell = cell_max
                        Board_Summary_Data(board_num).Volt_Min_Cell = cell_min
                        Board_Summary_Data(board_num).Volt_Sum = temp_sum
                        Board_Summary_Data(board_num).Volt_Average = temp_sum / Board_Summary_Data(board_num).Num_Cells

                        ' Set the summary data for system
                        temp_max = 0                        ' Start max as value that's really low
                        temp_min = VOLTAGE_MAX * MAX_CELLS  ' Start min as value that's really high
                        temp_sum = 0
                        temp_num_cells = 0
                        For temp_board As Integer = 0 To numBoards - 1
                            If Board_Summary_Data(temp_board).Volt_Max > temp_max Then
                                temp_max = Board_Summary_Data(temp_board).Volt_Max
                                cell_max = Board_Summary_Data(temp_board).Volt_Max_Cell
                            End If
                            If Board_Summary_Data(temp_board).Volt_Min < temp_min Then
                                temp_min = Board_Summary_Data(temp_board).Volt_Min
                                cell_min = Board_Summary_Data(temp_board).Volt_Max_Cell
                            End If
                            temp_num_cells += Board_Summary_Data(temp_board).Num_Cells
                            temp_sum += Board_Summary_Data(temp_board).Volt_Sum
                        Next temp_board
                        Stack_Summary_Data.Volt_Max = temp_max
                        Stack_Summary_Data.Volt_Min = temp_min
                        Stack_Summary_Data.Volt_Max_Cell = cell_max
                        Stack_Summary_Data.Volt_Min_Cell = cell_min
                        Stack_Summary_Data.Volt_Sum = temp_sum
                        Stack_Summary_Data.Volt_Average = temp_sum / temp_num_cells

                        voltage_timestamp(board_num).Update(temp_timestamp, temp_balancestamp)
                        Try
                            If voltage_timestamp(board_num).time_difference > 4 Then
                                num_times_over_4sec += 1
                                Error_File.Add(Error_File.Error_Code.USB_Delayed, voltage_timestamp(board_num).time_difference.ToString() + ":" + num_times_over_4sec.ToString(), buffer)
                            End If

                            If voltage_timestamp(board_num).time_difference > max_time_difference Then
                                max_time_difference = voltage_timestamp(board_num).time_difference
                            End If
                            Me.Debug2_TextBox.Text = voltage_timestamp(board_num).time_difference.ToString() + ", " + _
                                                     max_time_difference.ToString() + ", " + _
                                                     num_times_over_4sec.ToString()
                        Catch ex As Exception
                            Handle_Exception(ex)
                        End Try

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread

                        ' Update the Global Channel Monitor
                        For cell_num As Integer = 0 To MAX_CELLS - 1

                            ' It can happen that a board is still sending "v" data when the GUI reconnects.  This shouldn't cause an error.
                            If (board_num < numBoards) Then
                                Try
                                    If cellPresent(selectedBoard, cell_num) Then
                                        CellGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(board_num).Value = Voltages(board_num, cell_num).ToString(VOLTAGE_FORMAT)
                                    Else
                                        CellGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(board_num).Value = VOLTAGE_FORMAT
                                    End If
                                Catch ex As Exception
                                    Handle_Exception(ex)

                                End Try
                            End If

                        Next cell_num

                        ' Update the GUI Indicators if this is the selected board
                        If selectedBoard = board_num Then

                            ' If the OV or UV Popup has not been closed, freeze the Control Panel so that the user can see which cell caused the UV or OV.
                            If OVorUVPopup.Visible = False Then
                                If (autoReadBox.Checked = True) Or (Voltage_Update_Flag = True) Then
                                    Voltage_Update_Flag = False
                                    For cell_num As Integer = 0 To MAX_CELLS - 1
                                        'Voltages into text boxes
                                        If cellPresent(selectedBoard, cell_num) Then
                                            Voltage_TextBoxes(cell_num).Text = Voltages(board_num, cell_num).ToString(VOLTAGE_FORMAT)
                                        Else
                                            Voltage_TextBoxes(cell_num).Text = VOLTAGE_FORMAT
                                        End If
                                    Next cell_num
                                    manageBatteryImages()   ' display new battery statuses depending on voltage readout
                                End If
                            End If

                            ' Update the GUI Indicators if this is the selected board
                            If GraphData.Opened = True Then
                                GraphData.Stack_Summary_Sum_Label.Text = Stack_Summary_Data.Volt_Sum.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Stack_Summary_Average_Label.Text = Stack_Summary_Data.Volt_Average.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Stack_Summary_Min_Cell_Voltage_Label.Text = Stack_Summary_Data.Volt_Min.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Stack_Summary_Max_Cell_Voltage_Label.Text = Stack_Summary_Data.Volt_Max.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Board_Summary_Sum_Label.Text = Board_Summary_Data(selectedBoard).Volt_Sum.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Board_Summary_Average_Label.Text = Board_Summary_Data(selectedBoard).Volt_Average.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Board_Summary_Min_Cell_Voltage_Label.Text = Board_Summary_Data(selectedBoard).Volt_Min.ToString(VOLTAGE_FORMAT) + "V"
                                GraphData.Board_Summary_Max_Cell_Voltage_Label.Text = Board_Summary_Data(selectedBoard).Volt_Max.ToString(VOLTAGE_FORMAT) + "V"
                            End If

                            ' Update the GUI Indicators if this is the selected board
                            If CapBoardPopup.Opened = True Then
                                CapBoardPopup.Update_GUI_Plot(False)

                                CapBoardPopup.Update_Demos()
                                CapBoardPopup.Update_Trade_Show_Demo_State_Machine()

                                CapBoardPopup.Stack_Voltage_Value_Label.Text = Board_Summary_Data(selectedBoard).Volt_Sum.ToString(VOLTAGE_FORMAT) + " V"
                                CapBoardPopup.Average_Voltage_Value_Label.Text = Board_Summary_Data(selectedBoard).Volt_Average.ToString(VOLTAGE_FORMAT) + " V"
                                CapBoardPopup.Imbalance_Voltage_Value_Label.Text = (Board_Summary_Data(selectedBoard).Volt_Max - Board_Summary_Data(selectedBoard).Volt_Min).ToString(VOLTAGE_FORMAT) + " V"
                            End If

                        End If

                    End If

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_TEMPERATURE_COMMAND
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim temp_temperatures(NUM_TEMPS - 1) As Integer
                    Dim temp_timestamp As UInteger
                    Dim temp_balancestamp As Byte

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else
                        ' get the timestamp
                        num_bytes = 8
                        temp_timestamp = UInteger.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' get the board temperatures
                        num_bytes = 4
                        For temp_num As Integer = 0 To NUM_TEMPS - 1
                            temp_temperatures(temp_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)

                            ' todo - this is an ugly way to handle signs
                            If (temp_temperatures(temp_num) >= 65536 / 2) Then
                                temp_temperatures(temp_num) = temp_temperatures(temp_num) - 65536
                            End If

                            index = index + num_bytes
                        Next temp_num

                        ' get the balancestamp
                        num_bytes = 2
                        temp_balancestamp = Byte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                    End If

                    ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                    Dim temp_max As Integer = TEMPERATURE_MIN       ' Start max as value that's really low
                    Dim temp_min As Integer = TEMPERATURE_MAX       ' Start min as value that's really high
                    Dim cell_max As Integer = 0
                    Dim cell_min As Integer = 0
                    For temp_num As Integer = 0 To NUM_TEMPS - 1
                        Temperatures(board_num, temp_num) = temp_temperatures(temp_num)
                        If Temperatures(board_num, temp_num) > temp_max Then
                            temp_max = Temperatures(board_num, temp_num)
                            cell_max = temp_num
                        End If
                        If Temperatures(board_num, temp_num) < temp_min Then
                            temp_min = Temperatures(board_num, temp_num)
                            cell_min = temp_num
                        End If
                    Next temp_num
                    Board_Summary_Data(board_num).Temp_Max = temp_max
                    Board_Summary_Data(board_num).Temp_Min = temp_min
                    Board_Summary_Data(board_num).Temp_Max_Cell = cell_max
                    Board_Summary_Data(board_num).Temp_Min_Cell = cell_min

                    ' Set the summary data for system
                    temp_max = TEMPERATURE_MIN       ' Start max as value that's really low
                    temp_min = TEMPERATURE_MAX       ' Start min as value that's really high
                    For temp_board As Integer = 0 To numBoards - 1
                        If Board_Summary_Data(temp_board).Temp_Max > temp_max Then
                            temp_max = Board_Summary_Data(temp_board).Temp_Max
                            cell_max = Board_Summary_Data(temp_board).Temp_Max_Cell
                        End If
                        If Board_Summary_Data(temp_board).Temp_Min < temp_min Then
                            temp_min = Board_Summary_Data(temp_board).Temp_Min
                            cell_min = Board_Summary_Data(temp_board).Temp_Min_Cell
                        End If
                    Next temp_board
                    Stack_Summary_Data.Temp_Max = temp_max
                    Stack_Summary_Data.Temp_Min = temp_min
                    Stack_Summary_Data.Temp_Max_Cell = cell_max
                    Stack_Summary_Data.Temp_Min_Cell = cell_min

                    temperature_timestamp(board_num).Update(temp_timestamp, temp_balancestamp)
                    Try
                        If temperature_timestamp(board_num).time_difference > 4 Then
                            num_times_over_4sec += 1
                            Error_File.Add(Error_File.Error_Code.USB_Delayed, temperature_timestamp(board_num).time_difference.ToString() + ":" + num_times_over_4sec.ToString(), buffer)
                        End If

                        If temperature_timestamp(board_num).time_difference > max_time_difference Then
                            max_time_difference = temperature_timestamp(board_num).time_difference
                        End If
                        Me.Debug2_TextBox.Text = temperature_timestamp(board_num).time_difference.ToString() + ", " + _
                                                 max_time_difference.ToString() + ", " + _
                                                 num_times_over_4sec.ToString()
                    Catch ex As Exception
                        Handle_Exception(ex)
                    End Try

                    ' *** Update all of the indicators dependent upon this USB data
                    ' todo - move this out of here so that the comm can be handled in its own thread
                    If selectedBoard = board_num Then

                        If (autoReadBox.Checked = True) Or (Temperature_Update_Flag = True) Then
                            Temperature_Update_Flag = False

                            'Tmperatures into text boxes
                            If (Temperature_ADC_Test_IC1_Checkbox.Checked = False) Then
                                For temp_num As Integer = 0 To (NUM_TEMPS \ NUM_LTC3300) - 1
                                    Temperature_TextBoxes(temp_num).Text = Temperatures(board_num, temp_num).ToString(TEMPERATURE_FORMAT) + "C"
                                Next temp_num
                            End If

                            If (Temperature_ADC_Test_IC2_Checkbox.Checked = False) Then
                                For temp_num As Integer = (NUM_TEMPS \ NUM_LTC3300) To NUM_TEMPS - 1
                                    Temperature_TextBoxes(temp_num).Text = Temperatures(board_num, temp_num).ToString(TEMPERATURE_FORMAT) + "C"
                                Next temp_num
                            End If
                        End If

                        If GraphData.Opened = True Then
                            GraphData.Stack_Summary_Min_Temperature_Label.Text = Stack_Summary_Data.Temp_Min.ToString(TEMPERATURE_FORMAT) + "C"
                            GraphData.Stack_Summary_Max_Temperature_Label.Text = Stack_Summary_Data.Temp_Max.ToString(TEMPERATURE_FORMAT) + "C"
                            GraphData.Board_Summary_Min_Temperature_Label.Text = Board_Summary_Data(selectedBoard).Temp_Min.ToString(TEMPERATURE_FORMAT) + "C"
                            GraphData.Board_Summary_Max_Temperature_Label.Text = Board_Summary_Data(selectedBoard).Temp_Max.ToString(TEMPERATURE_FORMAT) + "C"
                        End If

                    End If

                    ' Update the data to be graphed.
                    ' Note that voltage and temperature data get updated together, to prevent different numbers of data points from being entered for each.
                    ' If update was done after every temperature and the voltage were received, we would be generating a line of data 2 times for every board!
                    ' For that reason, we need to only update after one of the commands, after the last board's data has been received.
                    If (board_num = numBoards - 1) And (GraphData.Opened = True) Then
                        GraphData.Update_GUI_Plot(False)
                    End If

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_PASSIVE_BALANCE_COMMAND
                ' Process the passive balancer data for one board

                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim passive_balancer_bitmap As Integer

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the passive balancer values
                        num_bytes = 4
                        passive_balancer_bitmap = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                        Passive_Balancers(board_num) = passive_balancer_bitmap

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread
                        If selectedBoard = board_num Then
                            If ((Passive_Balancers(selectedBoard) And ((1 << LTC3300.NUM_CELLS) - 1)) <> 0) Then
                                Passive_Balancer_Test_IC1_Checkbox.Checked = True
                            Else
                                Passive_Balancer_Test_IC1_Checkbox.Checked = False
                            End If

                            If ((Passive_Balancers(selectedBoard) And (((1 << LTC3300.NUM_CELLS) - 1) << LTC3300.NUM_CELLS)) <> 0) Then
                                Passive_Balancer_Test_IC2_Checkbox.Checked = True
                            Else
                                Passive_Balancer_Test_IC2_Checkbox.Checked = False
                            End If
                        End If
                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_CELL_PRESENT_COMMAND
                ' Process the passive balancer data for one board

                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim cell_present_bitmap As Integer

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the cell present values
                        num_bytes = 4
                        cell_present_bitmap = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                        Dim num_cells As Integer = 0
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            If (cell_present_bitmap And 1) = 0 Then
                                cellPresent(board_num, cell_num) = False
                            Else
                                cellPresent(board_num, cell_num) = True
                                num_cells += 1
                            End If
                            cell_present_bitmap >>= 1
                        Next cell_num

                        LTC3300s(board_num, 0).Enabled = True
                        If (num_cells <= LTC3300.NUM_CELLS) Then
                            LTC3300s(board_num, 1).Enabled = False
                        Else
                            LTC3300s(board_num, 1).Enabled = True
                        End If

                        ' Note that Get_Cell_Number_From_String returns a zero referenced number
                        Board_Summary_Data(board_num).Num_Cells = num_cells

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread
                        If selectedBoard = board_num Then
                            manageNodes()
                            manageCellGridColors()
                            manageBatteryImages()
                            Enable_BalancingControlsAndIndicators()
                        End If
                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_TEMP_ADC_COMMAND
                ' Process the thermistor adc data for one board

                Try

                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim adc_values(NUM_TEMPS - 1) As Integer

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the board temperature adc values
                        num_bytes = 4
                        For temp_num As Integer = 0 To NUM_TEMPS - 1
                            adc_values(temp_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                            index = index + num_bytes
                        Next temp_num

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread
                        If selectedBoard = board_num Then
                            'ADC values into text boxes
                            If (Temperature_ADC_Test_IC1_Checkbox.Checked = True) Then
                                For adc_num As Integer = 0 To (NUM_TEMPS \ NUM_LTC3300) - 1
                                    Temperature_TextBoxes(adc_num).Text = adc_values(adc_num).ToString()
                                Next adc_num
                            End If

                            If (Temperature_ADC_Test_IC2_Checkbox.Checked = True) Then
                                For adc_num As Integer = (NUM_TEMPS \ NUM_LTC3300) To NUM_TEMPS - 1
                                    Temperature_TextBoxes(adc_num).Text = adc_values(adc_num).ToString()
                                Next adc_num
                            End If
                        End If

                    End If
                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_LTC3300_COMMAND
                ' Process the LTC3300 raw data for one board
                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim bytes_read As Integer
                    Dim ics_read As Integer
                    Dim command As Integer
                    Dim register(NUM_LTC3300 - 1) As Integer

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else
                        ' get the number of bytes read
                        num_bytes = 1
                        bytes_read = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' get the command
                        num_bytes = 2
                        command = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        If (command <> LTC3300.Command.Read_Balance) AndAlso (command <> LTC3300.Command.Read_Status) Then
                            ' If this is some invalid LTC3300 command, then this is a failed response
                            success = False
                        Else

                            ' Add to the length to wait the number of data bytes actually in this response.
                            length += (bytes_read - 1) * 2      ' subtract the command byte, to add 2 ascii characters per register byte
                            ics_read = ((bytes_read - 1) \ 2)   ' each ic requires 4 ascii bytes per register

                            If (buffer.Length < length) Then
                                ' If the full response has not been received, exit and wait for it without deleting anything from the buffer
                                done = False
                            Else
                                ' Read bytes returned, if they're for 1 or 2 ICs
                                For ic_num As Integer = 0 To ics_read - 1
                                    num_bytes = 4
                                    register(ic_num) = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                                    index = index + num_bytes
                                Next ic_num
                            End If
                        End If
                    End If

                    ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                    For ic_num As Integer = 0 To ics_read - 1
                        LTC3300s(board_num, ic_num).Set_Read_Register(CType(command, LTC3300.Command), register(ic_num))
                        If (LTC3300s(board_num, ic_num).Get_Error = True) Then
                            ' Output LTC3300 Error bits to log file
                            Error_File.Add(Error_File.Error_Code.LTC3300_Status, "Board " + (board_num + 1).ToString + ", IC " + (ic_num + 1).ToString() + ", Register " + register(ic_num).ToString("X4"), buffer)
                        End If
                    Next (ic_num)

                    ' *** Update all of the indicators dependent upon this USB data
                    ' todo - move this out of here so that the comm can be handled in its own thread
                    If (board_num = selectedBoard) Then
                        For ic_num As Integer = 0 To ics_read - 1
                            LTC3300s(board_num, ic_num).Update_Register_GUI((CType(command, LTC3300.Command)))
                        Next (ic_num)

                        manageBatteryImages()
                    End If

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

            Case USB_PARSER_TIMED_BALANCE_COMMAND
                ' Process the timed balance data for one board

                Try
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim balancer_state As Integer
                    Dim balance_action(MAX_CELLS - 1) As Cell_Balancer.Balance_Action
                    Dim balance_timer(MAX_CELLS - 1) As Single
                    Dim max_time As Single
                    Dim max_board As Byte
                    Dim min_time As Single
                    Dim min_board As Byte

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num >= MAX_BOARDS Then
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    Else

                        ' get the board balance states
                        num_bytes = 4
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            balancer_state = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                            If balancer_state = 0 Then
                                balance_action(cell_num) = Cell_Balancer.Balance_Action.None
                            ElseIf ((balancer_state And &H8000) = 0) Then
                                balance_action(cell_num) = Cell_Balancer.Balance_Action.Charge
                            Else
                                balance_action(cell_num) = Cell_Balancer.Balance_Action.Discharge
                            End If
                            balance_timer(cell_num) = CSng(balancer_state And &H7FFF) * Cell_Balancer.BALANCE_TIME_RESOLUTION
                            index = index + num_bytes
                        Next cell_num

                        ' get the max balance time
                        num_bytes = 4
                        max_time = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) * Cell_Balancer.BALANCE_TIME_RESOLUTION
                        index = index + num_bytes

                        ' get the board with the max balance time
                        num_bytes = 2
                        max_board = Byte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' get the min balance time
                        num_bytes = 4
                        min_time = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) * Cell_Balancer.BALANCE_TIME_RESOLUTION
                        index = index + num_bytes

                        ' get the board with the min balance time
                        num_bytes = 2
                        min_board = Byte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            ' Set actions from FW values.  Since values are coming from FW, the color codes can obviously indicate the FW matches the GUI
                            Cell_Balancers(board_num, cell_num).Set_Write_Action(balance_action(cell_num))
                            Cell_Balancers(board_num, cell_num).Write_Action_Set()
                            Cell_Balancers(board_num, cell_num).Set_Balance_Time(balance_timer(cell_num))
                            Cell_Balancers(board_num, cell_num).Balance_Time_Set()
                        Next cell_num

                        Min_Balance_Time_Value = min_time
                        Min_Balance_Time_Board = min_board
                        Max_Balance_Time_Value = max_time
                        Max_Balance_Time_Board = max_board

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread

                        ' Update the display if this was the selected board.
                        If (board_num = selectedBoard) Then
                            For ic_num As Integer = 0 To NUM_LTC3300 - 1
                                LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
                            Next ic_num

                            For cell_num As Integer = 0 To MAX_CELLS - 1
                                Cell_Balancers(selectedBoard, cell_num).Update_Balance_Time_GUI()
                            Next cell_num

                            manageBatteryImages()
                        End If

                        ' update the message for the min and max balance times
                        Dim temp_string As String
                        temp_string = Math.Floor(Max_Balance_Time_Value / SEC_PER_HR).ToString("0") + ":" + Math.Floor((Max_Balance_Time_Value Mod SEC_PER_HR) / SEC_PER_MIN).ToString("00") + ":" + (Max_Balance_Time_Value Mod SEC_PER_MIN).ToString("00") + " Total"
                        Balance_Control_Time_Remaining_Value_Label.Text = temp_string
                        If Min_Balance_Time_Value <> 0 Then
                            temp_string = Min_Balance_Time_Value.ToString(Cell_Balancer.BALANCE_TIME_FORMAT) + " s , ( board " + (Min_Balance_Time_Board + 1).ToString + ")"
                        Else
                            temp_string = 0.ToString("##0.00") + " s"
                        End If
                        Balance_Control_Next_Stop_Value_Label.Text = temp_string

                        ' When balancing is complete, make it known throughout the GUI
                        ' If voltage matching, let voltage matching algorithm end the balancing
                        If (Max_Balance_Time_Value = 0) AndAlso (isTimedBalancing = True) AndAlso (CapBoardPopup.VMBox.Checked = False) Then
                            Timed_Balance_Stop(False)
                        End If

                    End If

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

                If success = True Then
                    ' Only update the real variables if the entire command was parsed correctly
                End If

            Case USB_PARSER_EEPROM_COMMAND
                Try
                    ' Process the eeprom data for one board
                    Dim index As Integer
                    Dim num_bytes As Integer
                    Dim board_num As Integer
                    Dim item_num As Integer
                    Dim temp_eeprom_data As EEPROM_Data_Structure
                    ReDim temp_eeprom_data.Capacity(MAX_CELLS - 1)
                    ReDim temp_eeprom_data.Charge_Currents(MAX_CELLS - 1)
                    ReDim temp_eeprom_data.Discharge_Currents(MAX_CELLS - 1)

                    ' get the board number
                    index = 1
                    num_bytes = 2
                    board_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                    index = index + num_bytes

                    If board_num < MAX_BOARDS Then
                        ' get the eeprom item number
                        num_bytes = 1
                        item_num = Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                        index = index + num_bytes

                        If item_num = EEPROM_Item_Type.Cap Then
                            length += 4 * MAX_CELLS
                            If (buffer.Length < length) Then
                                ' If the full response has not been received, exit and wait for it
                                done = False
                            Else
                                For cell_num As Integer = 0 To MAX_CELLS - 1
                                    num_bytes = 4
                                    ' Get Capacitance or Capacity
                                    temp_eeprom_data.Capacity(cell_num) = CSng(Integer.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)) / SOC_CAP_SCALE_FACTOR
                                    index = index + num_bytes
                                Next cell_num
                            End If
                        ElseIf item_num = EEPROM_Item_Type.Current Then

                            length += 4 * MAX_CELLS
                            If (buffer.Length < length) Then
                                ' If the full response has not been received, exit and wait for it
                                done = False
                            Else
                                Dim cal_factor As SByte
                                Dim current As Single

                                For cell_num As Integer = 0 To MAX_CELLS - 1
                                    num_bytes = 2
                                    ' Get Charge Current Scale Factor
                                    cal_factor = SByte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                                    current = Board_ID_Data(board_num).Average_Charge_Current_6Cell + _
                                              Board_ID_Data(board_num).Average_Charge_Current_6Cell * cal_factor / CURRENT_SCALE_FACTOR
                                    temp_eeprom_data.Charge_Currents(cell_num) = current
                                    index = index + num_bytes

                                    ' Get Discharge Current Scale Factor
                                    cal_factor = SByte.Parse(buffer.Substring(index, num_bytes), NumberStyles.AllowHexSpecifier)
                                    current = Board_ID_Data(board_num).Average_Discharge_Current_6Cell + _
                                              Board_ID_Data(board_num).Average_Discharge_Current_6Cell * cal_factor / CURRENT_SCALE_FACTOR
                                    temp_eeprom_data.Discharge_Currents(cell_num) = current
                                    index = index + num_bytes
                                Next cell_num
                            End If
                        End If
                        ' *** If we got here, all of the data conversion was successful!  Copy from temporary to GUI variables
                        If item_num = EEPROM_Item_Type.Cap Then
                            DataInputPopup.Capacity_Changed = False

                            For cell_num As Integer = 0 To MAX_CELLS - 1
                                EEPROM_Data(board_num).Capacity(cell_num) = temp_eeprom_data.Capacity(cell_num)
                            Next cell_num

                            ' If this is a response to a recent cal, save that response to the mfg file if this is the mfg computer
                        ElseIf (item_num = EEPROM_Item_Type.Current) Then
                            DataInputPopup.Currents_Changed = False

                            For cell_num As Integer = 0 To MAX_CELLS - 1
                                EEPROM_Data(board_num).Charge_Currents(cell_num) = temp_eeprom_data.Charge_Currents(cell_num)
                                EEPROM_Data(board_num).Discharge_Currents(cell_num) = temp_eeprom_data.Discharge_Currents(cell_num)
                            Next cell_num

                            If (Mfg_Enabled = True) AndAlso (Cal_Pending = True) Then
                                ' To account for multiple computers calibrating at the same time, always copy the board ID data before the calibration data.
                                Mfg_File.Restart_Old_Board(SN_TextBox.Text, Mfg_Model, Mfg_Cap_Demo)
                                Mfg_File.Add_Cal_Data(temp_eeprom_data.Charge_Currents, temp_eeprom_data.Discharge_Currents)
                                Mfg_File.New_Line()
                                Cal_Pending = False
                            End If
                        Else
                            ' If this is a response for some EEPROM number we don't know, then this is a failed response
                            success = False
                            Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_EEPROM_Item, "Board " + (board_num + 1).ToString + "Item " + (item_num + 1).ToString, buffer)
                        End If

                        ' *** Update all of the indicators dependent upon this USB data
                        ' todo - move this out of here so that the comm can be handled in its own thread
                        If (board_num = selectedBoard) Then
                            GUI_Refresh_Calibration_Data()
                        End If
                    Else
                        ' If this is a board we don't know, then this is a failed response
                        Error_File.Add(Error_File.Error_Code.USB_Parse_Unknown_Board, "Board " + (board_num + 1).ToString, buffer)
                        success = False
                    End If

                Catch ex As Exception
                    Handle_Exception(ex)

                    success = False
                End Try

        End Select

        ' If parsing failed, record error and return that we're done parsing that one character.  We're not sure if anything else in the response
        ' other than the first character, are parts of a different response.
        If success = False Then
            Error_File.Add(Error_File.Error_Code.USB_Parse, "Unrecognized response received from DC2100A", buffer)
            done = True
            length = 1
        End If

        Return done

    End Function

    Public Function LTC3300_Raw_Write(ByVal command As LTC3300.Command) As String
        Dim dataString As String = D33001.USB_PARSER_LTC3300_COMMAND + "W"
        Dim num_bytes As Integer
        Dim command_string As String

        ' Send the board requested
        If (command = LTC3300.Command.Write_Balance) Then
            dataString += selectedBoard.ToString("X2")
        ElseIf (command = LTC3300.Command.Execute) Or (command = LTC3300.Command.Suspend) Then
            dataString += LTC6804_BROADCAST.ToString("X2")
        End If

        ' Send number of bytes
        num_bytes = 1
        If (command = LTC3300.Command.Write_Balance) Then
            For ic_num As Integer = 0 To NUM_LTC3300 - 1
                If LTC3300s(selectedBoard, ic_num).Enabled = True Then
                    num_bytes += 2
                End If
            Next ic_num
        End If
        dataString += num_bytes.ToString("X1")

        ' Send Command Byte
        ' todo - "X2" seriously doesn't work with an enum value converted into a string???
        command_string = command.ToString("X")
        dataString += command_string.Substring(command_string.Length - 2)

        ' Send Balance Command
        If (command = LTC3300.Command.Write_Balance) Then
            For ic_num As Integer = (NUM_LTC3300 - 1) To 0 Step -1
                If LTC3300s(selectedBoard, ic_num).Enabled = True Then
                    dataString += LTC3300s(selectedBoard, ic_num).Get_Write_Command()
                End If
            Next ic_num
        End If

        Return dataString

    End Function

    ' Returns the USB command to read from the LTC3300s on the selected board
    Public Function LTC3300_Raw_Read(ByVal command As LTC3300.Command) As String
        Dim dataString As String = D33001.USB_PARSER_LTC3300_COMMAND + "R"
        Dim num_bytes As Integer
        Dim command_string As String

        ' This is ugly, but if if the board isn't powered up the LTC3300 can not communicate so no point in trying
        If system_state <> System_State_Type.Awake Then
            Return ""
        End If

        ' Send the board requested
        dataString += selectedBoard.ToString("X2")

        ' Send number of bytes
        num_bytes = 1
        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            If LTC3300s(selectedBoard, ic_num).Enabled = True Then
                num_bytes += 2
            End If
        Next ic_num
        dataString += num_bytes.ToString("X1")

        ' Send Command Byte
        ' todo - "X2" seriously doesn't work with an enum value converted into a string???
        command_string = command.ToString("X")
        dataString += command_string.Substring(command_string.Length - 2)

        Return dataString
    End Function

    Public Sub Timed_Balance_Write(ByVal board_num As Integer)
        Dim dataString As String
        Dim balancer_state As Integer
        Dim balancer_error As Boolean = False

        ' Send the command for the selected DC2100A
        dataString = USB_PARSER_TIMED_BALANCE_COMMAND + "W" + board_num.ToString("X2")

        For cell_num As Integer = 0 To MAX_CELLS - 1
            Dim balance_action As Cell_Balancer.Balance_Action = Cell_Balancers(board_num, cell_num).Get_Write_Action()
            Dim balance_timer As Single = Cell_Balancers(board_num, cell_num).Get_Balance_Time

            If (balance_action = Cell_Balancer.Balance_Action.None) AndAlso (balance_timer <> 0) Then
                ' If timed balance settings do not make sense, flag error to popup message box instead of write to the board.
                balancer_error = True
            Else
                ' If timed balance settings are reasonable, then write them to the board
                balancer_state = CInt(balance_timer / Cell_Balancer.BALANCE_TIME_RESOLUTION)
                If (balance_timer <> 0) AndAlso balance_action = Cell_Balancer.Balance_Action.Discharge Then
                    balancer_state += &H8000    ' todo - this is pretty gross, hardcoding that the top bit indicates whether the balancer is discharging or charging when the timer <> 0
                End If
                dataString += balancer_state.ToString("X4")
            End If

        Next

        If balancer_error = True Then
            MsgBox("A Timed Balance Value Must be Assigned to Charge or Discharge.")
        Else
            USB_Comm_List_Out.Add(dataString)
        End If
    End Sub

    Public Sub Cell_Present_Write(ByVal board_num As Integer)
        Dim dataString As String = USB_PARSER_CELL_PRESENT_COMMAND + "W"
        Dim cell_present_bitmap As Integer = 0

        dataString += selectedBoard.ToString("X2")

        For cell_num As Integer = MAX_CELLS - 1 To 0 Step -1
            cell_present_bitmap <<= 1
            If cellPresent(selectedBoard, cell_num) Then
                cell_present_bitmap += 1
            End If
        Next cell_num

        dataString += cell_present_bitmap.ToString("X4")

        USB_Comm_List_Out.Add(dataString)
    End Sub


#End Region

#Region "Balancing Controls"
    '------------------------------------------------------------------------------------------------------------------------------------------
    '---------------------------------------------------------Buttons--------------------------------------------------------------------------    
    '------------------------------------------------------------------------------------------------------------------------------------------
    Private Sub Balance_Control_Manual_Write_Command_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_Write_Command_Button.Click
        LTC3300_Write_Balance()
    End Sub

    Private Sub Balance_Control_Manual_Execute_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_Execute_Button.Click
        LTC3300_Execute()
    End Sub

    Private Sub Balance_Control_Manual_Suspend_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_Suspend_Button.Click
        LTC3300_Suspend()
        readAllData()
    End Sub

    Private Sub Balance_Control_Manual_Read_Command_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_Read_Command_Button.Click
        LTC3300_Command_Bit2_TextBox.Text = "0"
        LTC3300_Command_Bit1_TextBox.Text = "1"
        LTC3300_Command_Bit0_TextBox.Text = "0"

        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Balance))
    End Sub

    Private Sub Balance_Control_Manual_Read_Status_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_Read_Status_Button.Click   'READ STATUS BUTTON
        LTC3300_Command_Bit2_TextBox.Text = "1"
        LTC3300_Command_Bit1_TextBox.Text = "0"
        LTC3300_Command_Bit0_TextBox.Text = "0"

        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Status))
    End Sub

    Public Sub Balance_Action_RadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles Balance_Action_Cell1_None_RadioButton.CheckedChanged, Balance_Action_Cell1_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell1_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell2_None_RadioButton.CheckedChanged, Balance_Action_Cell2_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell2_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell3_None_RadioButton.CheckedChanged, Balance_Action_Cell3_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell3_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell4_None_RadioButton.CheckedChanged, Balance_Action_Cell4_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell4_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell5_None_RadioButton.CheckedChanged, Balance_Action_Cell5_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell5_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell6_None_RadioButton.CheckedChanged, Balance_Action_Cell6_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell6_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell7_None_RadioButton.CheckedChanged, Balance_Action_Cell7_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell7_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell8_None_RadioButton.CheckedChanged, Balance_Action_Cell8_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell8_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell9_None_RadioButton.CheckedChanged, Balance_Action_Cell9_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell9_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell10_None_RadioButton.CheckedChanged, Balance_Action_Cell10_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell10_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell11_None_RadioButton.CheckedChanged, Balance_Action_Cell11_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell11_Charge_RadioButton.CheckedChanged, _
                Balance_Action_Cell12_None_RadioButton.CheckedChanged, Balance_Action_Cell12_Discharge_RadioButton.CheckedChanged, Balance_Action_Cell12_Charge_RadioButton.CheckedChanged
        Dim this_radiobutton As RadioButton = DirectCast(sender, RadioButton)
        Dim cell_num As Integer = Get_Cell_Number_From_String(this_radiobutton.Name)
        Dim ic_num As Integer = Get_IC_From_Cell_Number(cell_num)

        ' First update the Cell Balancer command from the radio button value.
        Cell_Balancers(selectedBoard, cell_num).Human_Set_Write_Action()

        ' Next update the balance command code and crc text boxes
        LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
    End Sub

    Private Sub Balance_Control_Timed_CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Timed_CheckBox.CheckedChanged
        If Balance_Control_Timed_CheckBox.Checked = True Then

            ' Turn Off Manual Control
            Balance_Control_Manual_CheckBox.Checked = False

            ' Turn On Timed Control
            Balance_Control_Next_Stop_Label.Enabled = True
            Balance_Control_Time_Remaining_Label.Enabled = True
            Balance_Control_Timed_Write_Button.Enabled = True
            Balance_Control_Timed_StartStop_Button.Enabled = True
            Balance_Control_Timed_Reset_Button.Enabled = True
        Else
            ' Turn On Manual Control
            Balance_Control_Manual_CheckBox.Checked = True

            ' Turn Off Timed Control
            Balance_Control_Next_Stop_Label.Enabled = False
            Balance_Control_Time_Remaining_Label.Enabled = False
            Balance_Control_Timed_Write_Button.Enabled = False
            Balance_Control_Timed_StartStop_Button.Enabled = False
            Balance_Control_Timed_Reset_Button.Enabled = False
        End If

        ' Request the actual balance timers set for this board.
        For cell_num As Integer = 0 To MAX_CELLS - 1
            If cellPresent(selectedBoard, cell_num) = True Then
                Cell_Balancers(selectedBoard, cell_num).Enable(Balance_Control_Timed_CheckBox.Checked)
            Else
                Cell_Balancers(selectedBoard, cell_num).Disable()
            End If
        Next cell_num

        ' Request the actual balance timers set for this board.
        USB_Comm_List_Out.Add(USB_PARSER_TIMED_BALANCE_COMMAND + "R" + selectedBoard.ToString("X2"))

    End Sub

    Private Sub Balance_Control_Manual_CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Manual_CheckBox.CheckedChanged
        If Balance_Control_Manual_CheckBox.Checked = True Then

            ' Only one balancing method can be enabled at a time
            Balance_Control_Timed_CheckBox.Checked = False

            ' Turn On Manual Control
            LTC3300_Command_Command_Label.Enabled = True
            LTC3300_Command_Parity_Label.Enabled = True
            LTC3300_Command_Bit2_TextBox.Enabled = True
            LTC3300_Command_Bit2_TextBox.Text = ""
            LTC3300_Command_Bit1_TextBox.Enabled = True
            LTC3300_Command_Bit1_TextBox.Text = ""
            LTC3300_Command_Bit0_TextBox.Enabled = True
            LTC3300_Command_Bit0_TextBox.Text = ""

            Balance_Control_Manual_Write_Command_Button.Enabled = True
            Balance_Control_Manual_Execute_Button.Enabled = True
            Balance_Control_Manual_Suspend_Button.Enabled = True
            Balance_Control_Manual_Read_Command_Button.Enabled = True
            Balance_Control_Manual_Read_Status_Button.Enabled = True

        Else
            Balance_Control_Timed_CheckBox.Checked = True

            LTC3300_Command_Command_Label.Enabled = False
            LTC3300_Command_Parity_Label.Enabled = False
            LTC3300_Command_Bit2_TextBox.Enabled = False
            LTC3300_Command_Bit2_TextBox.Text = ""
            LTC3300_Command_Bit1_TextBox.Enabled = False
            LTC3300_Command_Bit1_TextBox.Text = ""
            LTC3300_Command_Bit0_TextBox.Enabled = False
            LTC3300_Command_Bit0_TextBox.Text = ""

            Balance_Control_Manual_Write_Command_Button.Enabled = False
            Balance_Control_Manual_Execute_Button.Enabled = False
            Balance_Control_Manual_Suspend_Button.Enabled = False
            Balance_Control_Manual_Read_Command_Button.Enabled = False
            Balance_Control_Manual_Read_Status_Button.Enabled = False

        End If
    End Sub

    Private Sub Balance_Timer_TextBox_LostFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles Balance_Timer_Cell1_TextBox.LostFocus, Balance_Timer_Cell2_TextBox.LostFocus, Balance_Timer_Cell3_TextBox.LostFocus, _
                Balance_Timer_Cell4_TextBox.LostFocus, Balance_Timer_Cell5_TextBox.LostFocus, Balance_Timer_Cell6_TextBox.LostFocus, _
                Balance_Timer_Cell7_TextBox.LostFocus, Balance_Timer_Cell8_TextBox.LostFocus, Balance_Timer_Cell9_TextBox.LostFocus, _
                Balance_Timer_Cell10_TextBox.LostFocus, Balance_Timer_Cell11_TextBox.LostFocus, Balance_Timer_Cell12_TextBox.LostFocus
        Dim this_textbox As TextBox = DirectCast(sender, TextBox)
        Dim cell_num As Integer = Get_Cell_Number_From_String(this_textbox.Name)

        If cell_num < MAX_CELLS Then
            Cell_Balancers(selectedBoard, cell_num).Human_Set_Balance_Time()
            Cell_Balancers(selectedBoard, cell_num).Update_Balance_Time_GUI()
        End If
    End Sub

    Private Sub Balance_Timer_EnterPress(ByVal sender As System.Object, ByVal e As KeyPressEventArgs) _
        Handles Balance_Timer_Cell1_TextBox.KeyPress, Balance_Timer_Cell2_TextBox.KeyPress, Balance_Timer_Cell3_TextBox.KeyPress, _
                Balance_Timer_Cell4_TextBox.KeyPress, Balance_Timer_Cell5_TextBox.KeyPress, Balance_Timer_Cell6_TextBox.KeyPress, _
                Balance_Timer_Cell7_TextBox.KeyPress, Balance_Timer_Cell8_TextBox.KeyPress, Balance_Timer_Cell9_TextBox.KeyPress, _
                Balance_Timer_Cell10_TextBox.KeyPress, Balance_Timer_Cell11_TextBox.KeyPress, Balance_Timer_Cell12_TextBox.KeyPress
        If e.KeyChar = Convert.ToChar(Keys.Enter) Then
            Balance_Timer_TextBox_LostFocus(sender, e)
            NoteLabel.Focus()
        End If
    End Sub

    Private Sub Balance_Timer_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) _
        Handles Balance_Timer_Cell1_TextBox.MouseUp, Balance_Timer_Cell2_TextBox.MouseUp, Balance_Timer_Cell3_TextBox.MouseUp, _
                Balance_Timer_Cell4_TextBox.MouseUp, Balance_Timer_Cell5_TextBox.MouseUp, Balance_Timer_Cell6_TextBox.MouseUp, _
                Balance_Timer_Cell7_TextBox.MouseUp, Balance_Timer_Cell8_TextBox.MouseUp, Balance_Timer_Cell9_TextBox.MouseUp, _
        Balance_Timer_Cell10_TextBox.MouseUp, Balance_Timer_Cell11_TextBox.MouseUp, Balance_Timer_Cell12_TextBox.MouseUp
        Dim this_textbox As TextBox = DirectCast(sender, TextBox)
        If this_textbox.Text = "0" Then
            this_textbox.SelectAll()
        End If
    End Sub

    Private Sub Balance_Control_Timed_Write_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Timed_Write_Button.Click
        Timed_Balance_Write(selectedBoard)
    End Sub

    Private Sub Balance_Control_Timed_StartStop_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Timed_StartStop_Button.Click

        If isTimedBalancing = False Then

            ' If not currently balancing, then start it if there's not an UV/OV condition.
            Dim board_num As Integer
            If Get_SystemOVorUV(board_num) = True Then
                ' If OV or UV present, do not start the balancing
                ' Popup a message about OV or UV preventing balancing
                If OVorUVPopup.Visible = False Then
                    OVorUVPopup.Set_Text("Balancing", Get_OVUV_Condition_String(board_num), board_num, False)
                    OVorUVPopup.Show()
                End If
            Else
                ' If starting balancing but last balance changes weren't written, write them now.
                Timed_Balance_Write(selectedBoard)

                ' Start balancing.
                Timed_Balance_Start()
            End If

        Else
            ' If currently balancing, then stop it.
            Timed_Balance_Stop(False)
        End If

    End Sub

    Private Sub Balance_Control_Timed_Reset_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Balance_Control_Timed_Reset_Button.Click
        Timed_Balance_Stop(True)
    End Sub

    Public Sub LTC3300_Execute()
        Dim board_num As Integer

        ' If OV or UV not present, start the balancing
        If Get_SystemOVorUV(board_num) = False Then
            Dim ltc3300_Command As LTC3300.Command = LTC3300.Command.Execute
            LTC3300_Command_Bit2_TextBox.Text = ((ltc3300_Command >> 2) And &H1).ToString("X1")
            LTC3300_Command_Bit1_TextBox.Text = ((ltc3300_Command >> 1) And &H1).ToString("X1")
            LTC3300_Command_Bit0_TextBox.Text = ((ltc3300_Command >> 0) And &H1).ToString("X1")
            USB_Comm_List_Out.Add(LTC3300_Raw_Write(ltc3300_Command))

            isBalancing = True
            readAllData()
        Else
            ' If OV or UV not present, start the balancing
            If OVorUVPopup.Visible = False Then
                OVorUVPopup.Set_Text("Balancing", Get_OVUV_Condition_String(board_num), board_num, False)
                OVorUVPopup.Show()
            End If
        End If
    End Sub

    Public Sub LTC3300_Suspend()
        Dim ltc3300_Command As LTC3300.Command = LTC3300.Command.Suspend
        LTC3300_Command_Bit2_TextBox.Text = ((ltc3300_Command >> 2) And &H1).ToString("X1")
        LTC3300_Command_Bit1_TextBox.Text = ((ltc3300_Command >> 1) And &H1).ToString("X1")
        LTC3300_Command_Bit0_TextBox.Text = ((ltc3300_Command >> 0) And &H1).ToString("X1")

        USB_Comm_List_Out.Add(LTC3300_Raw_Write(ltc3300_Command))
        readAllData()

        isBalancing = False
    End Sub

    Public Sub LTC3300_Write_Balance()
        ' Set the text box command fields for the command selected.
        Dim ltc3300_Command As LTC3300.Command = LTC3300.Command.Write_Balance
        LTC3300_Command_Bit2_TextBox.Text = ((ltc3300_Command >> 2) And &H1).ToString("X1")
        LTC3300_Command_Bit1_TextBox.Text = ((ltc3300_Command >> 1) And &H1).ToString("X1")
        LTC3300_Command_Bit0_TextBox.Text = ((ltc3300_Command >> 0) And &H1).ToString("X1")

        USB_Comm_List_Out.Add(LTC3300_Raw_Write(ltc3300_Command))

        ' Update to show that the balance command was written
        For cell_num As Integer = 0 To MAX_CELLS - 1
            Cell_Balancers(selectedBoard, cell_num).Write_Action_Set()
        Next cell_num

        ' Update GUI to show that the balance command was written
        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
        Next ic_num
    End Sub

    Public Sub Timed_Balance_Start()

        ' If doing a cap demo operational demo, the buttons are already enabled/disabled properly.
        If (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.None_Selected) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Charge) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Discharge) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Stop_Chg_Dchg) Then

        Else
            ' Set buttons to the started position
            Balance_Control_Timed_CheckBox.Checked = True
            Balance_Control_Timed_Write_Button.Enabled = False
            Balance_Control_Timed_StartStop_Button.Text = "Stop"
            Balance_Control_Timed_Reset_Button.Enabled = False

            ' Disable all of the operational demos on the Cap Demo Window
            If CapBoardPopup.Opened = True Then
                CapBoardPopup.Disable_All_Cap_Demo_Buttons()
                CapBoardPopup.balStartBtn.Enabled = False
                CapBoardPopup.balStopBtn.Enabled = True
                CapBoardPopup.VMBox.Enabled = False
                CapBoardPopup.AlgoBtn.Enabled = False
            End If
        End If

        ' Disable ways to modify timed balancing controls, including the Config buttons.
        Config_Demo_Button.Enabled = False
        Config_Save_Button.Enabled = False
        Config_Load_Button.Enabled = False
        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To MAX_CELLS - 1
                Cell_Balancers(board_num, cell_num).Disable()
            Next cell_num
        Next board_num

        ' Flag that balancing is started
        isTimedBalancing = True
        isBalancing = True

        ' If voltage matching, wait until we received the response to the USB_PARSER_ALGORITHM_COMMAND before starting balancing.
        If (CapBoardPopup.VMBox.Checked = False) Then
            ' Send the command for the selected DC2100A
            ' Note that the whole system will start balancing.  The selected board is the only one that will reply with its balancing data for display, however.
            USB_Comm_List_Out.Add(USB_PARSER_TIMED_BALANCE_COMMAND + "B" + selectedBoard.ToString("X2"))
        End If

    End Sub

    Public Sub Timed_Balance_Stop(ByVal reset As Boolean)

        ' If doing a cap demo operational demo, stop it.
        If (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.None_Selected) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Charge) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Discharge) AndAlso
           (CapBoardPopup.cap_demo_button_activated <> CapBoardPopup.Cap_Demo_Button_Type.Stop_Chg_Dchg) Then

            CapBoardPopup.Update_GUI_Cap_Demo_Buttons(CapBoardPopup.Cap_Demo_Button_Type.None_Selected)
        Else
            ' Return buttons to the stopped position
            Balance_Control_Timed_Write_Button.Enabled = True
            Balance_Control_Timed_Reset_Button.Enabled = True
            Balance_Control_Timed_StartStop_Button.Text = "Start"

            ' Enable all of the operational demos on the Cap Demo Window
            If CapBoardPopup.Opened = True Then
                CapBoardPopup.balStartBtn.Enabled = True
                CapBoardPopup.balStopBtn.Enabled = False
                CapBoardPopup.VMBox.Enabled = True
                CapBoardPopup.AlgoBtn.Enabled = True
                CapBoardPopup.Enable_All_Cap_Demo_Buttons()
            End If
        End If

        ' Re-enable ways to modify timed balancing controls
        Config_Demo_Button.Enabled = True
        Config_Save_Button.Enabled = True
        Config_Load_Button.Enabled = True
        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To MAX_CELLS - 1

                If cellPresent(board_num, cell_num) = True Then
                    Cell_Balancers(board_num, cell_num).Enable(True)
                End If
            Next cell_num
        Next board_num

        ' Flag that timed balancing is stopped
        isTimedBalancing = False
        isBalancing = False

        ' Either reset or suspend the balancing operation
        If reset = False Then
            ' Send the command for the selected DC2100A
            ' Note that the whole system will suspend balancing.  The selected board is the only one that will reply with its balancing data for display, however.
            USB_Comm_List_Out.Add(USB_PARSER_TIMED_BALANCE_COMMAND + "S" + selectedBoard.ToString("X2"))
        Else

            ' Send the command for the selected DC2100A
            ' Note that the whole system will end balancing.  The selected board is the only one that will reply with its balancing data for display, however.
            USB_Comm_List_Out.Add(USB_PARSER_TIMED_BALANCE_COMMAND + "E" + selectedBoard.ToString("X2"))
        End If

        ' todo - do we need to refresh data here?
        readAllData()

    End Sub

    Private Sub Enable_BalancingControlsAndIndicators()
        For cell_num As Integer = 0 To MAX_CELLS - 1
            If cellPresent(selectedBoard, cell_num) = True Then
                Cell_Balancers(selectedBoard, cell_num).Enable(Balance_Control_Timed_CheckBox.Checked)
            Else
                Cell_Balancers(selectedBoard, cell_num).Disable()
            End If
        Next cell_num
    End Sub

#End Region

#Region "Voltage Display"
    Private Sub ButtonRV_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonRV.Click   'READ VOLTAGES BUTTON
        Voltage_Update_Flag = True
        Temperature_Update_Flag = True
        USB_Comm_List_Out.Add(USB_PARSER_VOLTAGE_COMMAND)
        USB_Comm_List_Out.Add(USB_PARSER_TEMPERATURE_COMMAND)
    End Sub

    Public Function vReadoutToDecimal(ByVal vreadout As String) As Single() 'converts the voltage readout from the PIC to a decimal form
        ' assumes vreadout is a 48-digit inverted hex number (inverted: 871A written as 1A87) +++++ string vreadout
        Dim voltages As Single() = New Single(12 * numBoards) {}
        For i As Integer = 0 To 11
            voltages(i) = CSng((Integer.Parse(vreadout.Substring((i * 4 + 2), 2), NumberStyles.AllowHexSpecifier) << 8) + Integer.Parse(vreadout.Substring((i * 4), 2), NumberStyles.AllowHexSpecifier)) / 10000
        Next i
        Return voltages 'returns decimal voltage array
    End Function

    Private Sub autoReadBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles autoReadBox.CheckedChanged
        If autoReadBox.Checked = True Then
            ButtonRV.Enabled = False
        Else
            ButtonRV.Enabled = True
        End If
    End Sub

    ' Returns True if OV or UV is present, returns the first board found with an OV/UV as board_num.
    Public Function Get_SystemOVorUV(ByRef board_num As Integer) As Boolean

        If (Get_SystemOV(board_num) = True) OrElse (Get_SystemUV(board_num) = True) Then
            Return True
        End If

        Return False
    End Function

    ' Returns True if OV is present, returns the first board found with an OV/UV as board_num.
    Public Function Get_SystemOV(ByRef board_num As Integer) As Boolean

        For board_num = 0 To numBoards - 1
            If (OV_Flags(board_num) <> 0) Then
                Return True
            End If
        Next board_num

        Return False
    End Function

    ' Returns True if UV is present, returns the first board found with an OV/UV as board_num.
    ' Note that a board with cells so low that the 6804 can not communicate, counts as UV.
    Public Function Get_SystemUV(ByRef board_num As Integer) As Boolean

        For board_num = 0 To numBoards - 1
            If (UV_Flags(board_num) <> 0) Or (system_state <> System_State_Type.Awake) Then
                Return True
            End If
        Next board_num

        Return False
    End Function

    Public Function Get_OVUV_Condition_String(ByVal board_num As Integer) As String
        Dim condition_string As String = ""

        ' Figure out if it is an OV condition, an UV condition, or both.
        If (OV_Flags(board_num) <> 0) Then
            If condition_string <> "" Then
                condition_string += "/"
            End If
            condition_string += "OV"
        End If

        If (UV_Flags(board_num) <> 0) Or (system_state <> System_State_Type.Awake) Then
            If condition_string <> "" Then
                condition_string += "/"
            End If
            condition_string += "UV"
        End If

        Return condition_string

    End Function

#End Region

#Region "Cells Tab"

    Private Sub manageBatteryImages() 'Manages and reloads all battery images for selected board
        ' todo - eventually the cells should be a Class that includes a balancer object.  Until then, handle this way
        Dim cell_pic() As System.Windows.Forms.PictureBox = {cellpic1, cellpic2, cellpic3, cellpic4, cellpic5, cellpic6, _
                                                             cellpic7, cellpic8, cellpic9, cellpic10, cellpic11, cellpic12}
        Dim cell_num As Integer
        Dim cell_mask As Integer
        Dim ic_num As Integer

        ' If the OV or UV Popup has not been closed, freeze the Control Panel so that the user can see which cell caused the UV or OV.
        If OVorUVPopup.Visible = True Then
            Exit Sub
        End If

        cell_mask = 1
        For cell_num = 0 To MAX_CELLS - 1
            ic_num = Get_IC_From_Cell_Number(cell_num)

            ' Update the pictures
            If cellPresent(selectedBoard, cell_num) = False Then
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.battery_off
            ElseIf ((cell_mask And UV_Flags(selectedBoard)) = cell_mask) Then
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryreddown
            ElseIf ((cell_mask And OV_Flags(selectedBoard)) = cell_mask) Then
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryredup
                'ElseIf (LTC3300s(selectedBoard, ic_num).Get_Error() = True) Then
                'cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.battery3300error
                'ElseIf (LTC3300s(selectedBoard, ic_num).Get_Combined_Balance_Action(cell_num Mod LTC3300.NUM_CELLS) = Cell_Balancer.Balance_Action.IC_Error) Then
                'cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.battery3300error
            ElseIf (LTC3300s(selectedBoard, ic_num).Get_Combined_Balance_Action(cell_num Mod LTC3300.NUM_CELLS) = Cell_Balancer.Balance_Action.Discharge) Then
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batterybluedownlight
            ElseIf (LTC3300s(selectedBoard, ic_num).Get_Combined_Balance_Action(cell_num Mod LTC3300.NUM_CELLS) = Cell_Balancer.Balance_Action.Charge) Then
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batteryblueup
            Else
                cell_pic(cell_num).Image = Global.LinearTechnology.DemoBoards.DC2100A.My.Resources.Resources.batterygreen
            End If

            cell_mask = cell_mask << 1

        Next

    End Sub

#End Region

#Region "System Tree View"

    Private Sub addNode()           'add a Parent Node (and 12 Children) to TreeView1
        Dim parentNode As TreeNode
        Dim Channel12 As New TreeNode("IC2:C12")
        Dim Channel11 As New TreeNode("IC2:C11")
        Dim Channel10 As New TreeNode("IC2:C10")
        Dim Channel9 As New TreeNode("IC2:C9")
        Dim Channel8 As New TreeNode("IC2:C8")
        Dim Channel7 As New TreeNode("IC2:C7")
        Dim Channel6 As New TreeNode("IC1:C6")
        Dim Channel5 As New TreeNode("IC1:C5")
        Dim Channel4 As New TreeNode("IC1:C4")
        Dim Channel3 As New TreeNode("IC1:C3")
        Dim Channel2 As New TreeNode("IC1:C2")
        Dim Channel1 As New TreeNode("IC1:C1")

        Channel1.ImageIndex = 1 'Image is green circle
        Channel2.ImageIndex = 1
        Channel3.ImageIndex = 1
        Channel4.ImageIndex = 1
        Channel5.ImageIndex = 1
        Channel6.ImageIndex = 1
        Channel7.ImageIndex = 1
        Channel8.ImageIndex = 1
        Channel9.ImageIndex = 1
        Channel10.ImageIndex = 1
        Channel11.ImageIndex = 1
        Channel12.ImageIndex = 1

        Channel1.SelectedImageIndex = 3 'When selected (and turned on as initialized), show light green circle
        Channel2.SelectedImageIndex = 3
        Channel3.SelectedImageIndex = 3
        Channel4.SelectedImageIndex = 3
        Channel5.SelectedImageIndex = 3
        Channel6.SelectedImageIndex = 3
        Channel7.SelectedImageIndex = 3
        Channel8.SelectedImageIndex = 3
        Channel9.SelectedImageIndex = 3
        Channel10.SelectedImageIndex = 3
        Channel11.SelectedImageIndex = 3
        Channel12.SelectedImageIndex = 3

        Dim nodeArr As TreeNode() = New TreeNode() {Channel12, Channel11, Channel10, Channel9, Channel8, Channel7, Channel6, Channel5, Channel4, Channel3, Channel2, Channel1}

        parentNode = New TreeNode("Board " + CStr(numBoards) + " (0x" + board_address_table(numBoards - 1).ToString("X2") + ")", nodeArr)

        parentNode.ImageIndex = 0
        parentNode.Tag = "Board"

        TreeView1.Nodes.Add(parentNode)
    End Sub

    Private Sub TreeView1_NodeMouseClick(ByVal sender As System.Object, ByVal e As TreeNodeMouseClickEventArgs) Handles TreeView1.NodeMouseClick
        Dim selected_board_next As Integer
        Dim selected_cell_next As Integer

        ' event is called when user clicks ANY node (parent/child) on TreeView1 (used to set selectedCell and selectedBoard)
        ' don't change the selected board or cell when the tree is simply expanded or collapsed.
        If (e.X > 20) Then
            If (e.Node.Tag Is "Board") Then
                selected_board_next = e.Node.Index
                selected_cell_next = ALL_CELLS
            Else
                selected_board_next = e.Node.Parent.Index
                selected_cell_next = MAX_CELLS - e.Node.Index - 1
            End If
        Else
            selected_board_next = selectedBoard
            selected_cell_next = selectedCell
        End If

        If (selected_board_next <> selectedBoard) Then
            Dim settings_changed As Boolean

            ' If a new board is selected, warn about unsaved balance changes before switching to new board
            settings_changed = False    ' Start assuming the settings didn't change

            ' Check if any of the write command changed on either IC
            For ic_num As Integer = 0 To NUM_LTC3300 - 1
                If LTC3300s(selectedBoard, ic_num).Is_Write_Command_Set() = False Then
                    settings_changed = True
                End If
            Next ic_num

            If Balance_Control_Timed_CheckBox.Checked = False Then
                ' If manual balancing, prompt if the user desires to write the manual commands to the FW
                If settings_changed = True Then
                    If popup_board_changed_message("Manual Balance Settings") = True Then
                        USB_Comm_List_Out.Add(LTC3300_Raw_Write(LTC3300.Command.Write_Balance))
                        ' Update to show that the balance command was written
                        For cell_num As Integer = 0 To MAX_CELLS - 1
                            Cell_Balancers(selectedBoard, cell_num).Write_Action_Set()
                        Next cell_num
                    End If
                End If
            Else
                ' If timed balancing, check if any of the balance timers changed
                For cell_num As Integer = 0 To MAX_CELLS - 1
                    If Cell_Balancers(selectedBoard, cell_num).Is_Balance_Time_Set() = False Then
                        settings_changed = True
                    End If
                Next cell_num

                ' If the settings changed, give the user the option to write them to the board
                If settings_changed = True Then
                    If popup_board_changed_message("Timed Balance Settings") = True Then
                        Timed_Balance_Write(selectedBoard)
                    End If
                End If
            End If


            ' If a new board is selected, warn about unsaved EEPROm changes before switching to new board
            If (DataInputPopup.Capacity_Changed = True) Or (DataInputPopup.Currents_Changed = True) Then
                If popup_board_changed_message("Calibration Data") = True Then
                    If (DataInputPopup.Capacity_Changed = True) Then
                        DataInputPopup.Cal_Data_Capacity_Write()
                    End If
                    If (DataInputPopup.Currents_Changed = True) Then
                        DataInputPopup.Cal_Data_Currents_Write()
                    End If
                End If
            End If

            ' Officially Change the Selected Board
            selectedBoard = selected_board_next

            ' Refresh the GUI for the Selected Board
            GUI_Refresh_Selected_Board()
        End If

        ' Officially Change the Selected Cell
        If (selected_cell_next <> selectedCell) Then
            selectedCell = selected_cell_next
            selectedIC = Get_IC_From_Cell_Number(selectedCell)
        End If

        ' If a board is right clicked, bring up menu to select its configuration
        If e.Button = System.Windows.Forms.MouseButtons.Right AndAlso e.Node.Tag Is "Board" Then
            For cell_num As Integer = (MIN_CELLS - 1) To (MAX_CELLS - 1)
                Cell_Present_Context_Menu_Strip.Items(cell_num + 1 - MIN_CELLS).Text = (cell_num + 1).ToString() + "Cell Configuration"
            Next cell_num

            ' so menu doesn't start on pointer
            Cell_Present_Context_Menu_Strip.Show(TreeView1, (105), (e.Location.Y - 17))
        End If

        ' Update the colors in the Global Channel Monitor Grid View
        For board_num As Integer = 0 To (numBoards - 1)
            For cell_num As Integer = 0 To MAX_CELLS - 1 'When a TreeView1 cell is selected, the same cell is selected on CellGrid
                If (selectedBoard = board_num) AndAlso ((cell_num = selectedCell) Or (selectedCell = ALL_CELLS)) Then
                    CellGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(board_num).Selected = True
                Else
                    CellGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(board_num).Selected = False
                End If
            Next cell_num
        Next board_num

    End Sub

    'Options from Cell_Present_Context_Menu_Strip
    Private Sub Cell_Present_MouseClick(ByVal sender As System.Object, ByVal e As EventArgs) _
        Handles Cell4.Click, Cell5.Click, Cell6.Click, Cell7.Click, Cell8.Click, Cell9.Click, Cell10.Click, Cell11.Click, Cell12.Click
        Dim this_toolstripitem As ToolStripItem = DirectCast(sender, ToolStripItem)
        Dim cell_config As Integer = Get_Cell_Number_From_String(this_toolstripitem.Name)
        Dim board_config(MAX_CELLS - 1) As Boolean
        Dim ic_config(NUM_LTC3300 - 1) As Boolean

        ' Note that Get_Cell_Number_From_String returns a zero referenced number
        Select Case cell_config + 1
            Case 4
                board_config = {False, False, True, True, True, True, False, False, False, False, False, False}
                ic_config = {True, False}
            Case 5
                board_config = {False, True, True, True, True, True, False, False, False, False, False, False}
                ic_config = {True, False}
            Case 6
                board_config = {True, True, True, True, True, True, False, False, False, False, False, False}
                ic_config = {True, False}
            Case 7
                board_config = {False, False, False, True, True, True, False, False, True, True, True, True}
                ic_config = {True, True}
            Case 8
                board_config = {False, False, True, True, True, True, False, False, True, True, True, True}
                ic_config = {True, True}
            Case 9
                board_config = {False, False, True, True, True, True, False, True, True, True, True, True}
                ic_config = {True, True}
            Case 10
                board_config = {False, True, True, True, True, True, False, True, True, True, True, True}
                ic_config = {True, True}
            Case 11
                board_config = {False, True, True, True, True, True, True, True, True, True, True, True}
                ic_config = {True, True}
            Case 12
                board_config = {True, True, True, True, True, True, True, True, True, True, True, True}
                ic_config = {True, True}
            Case Else
                board_config = {True, True, True, True, True, True, True, True, True, True, True, True}
                ic_config = {True, True}
        End Select

        For cell_num As Integer = 0 To MAX_CELLS - 1
            cellPresent(selectedBoard, cell_num) = board_config(cell_num)
        Next cell_num

        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            LTC3300s(selectedBoard, ic_num).Enabled = ic_config(ic_num)
        Next ic_num

        ' Note that Get_Cell_Number_From_String returns a zero referenced number
        Board_Summary_Data(selectedBoard).Num_Cells = cell_config + 1

        ' Tell board how many cells are present
        Cell_Present_Write(selectedBoard)

        manageNodes()
        manageCellGridColors()
        manageBatteryImages()
        Enable_BalancingControlsAndIndicators()

    End Sub

    Private Sub manageNodes()
        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To MAX_CELLS - 1
                If cellPresent(board_num, cell_num) = True Then
                    TreeView1.Nodes(board_num).Nodes(MAX_CELLS - 1 - cell_num).ImageIndex = 1
                    TreeView1.Nodes(board_num).Nodes(MAX_CELLS - 1 - cell_num).SelectedImageIndex = 3
                Else
                    TreeView1.Nodes(board_num).Nodes(MAX_CELLS - 1 - cell_num).ImageIndex = 2
                    TreeView1.Nodes(board_num).Nodes(MAX_CELLS - 1 - cell_num).SelectedImageIndex = 4
                End If
            Next cell_num
        Next board_num
    End Sub

    Private Function popup_board_changed_message(ByVal datatype As String) As Boolean

        Dim popup_msg As String = "The "
        popup_msg += datatype
        popup_msg += " were changed but not written to this board." & ChrW(13) & ChrW(10)

        popup_msg += ChrW(13) & ChrW(10) & ChrW(13) & ChrW(10) & "Do you want to write them now?"

        ' todo - need to use consistent popups?
        If MsgBox(popup_msg, MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            Return True
        Else
            Return False
        End If

    End Function

    Private Sub GUI_Refresh_Selected_Board()

        ' Start Building Commands to send to the newly selected board.

        ' Update the Selected Board Indicators
        Board_Selected_Number_Label.Text = (selectedBoard + 1).ToString
        DataInputPopup.Board_Selected_Number_Label.Text = Board_Selected_Number_Label.Text
        GraphData.Board_Selected_Number_Label.Text = Board_Selected_Number_Label.Text

        ' Refresh Board ID Info to last received from this board
        GUI_Refresh_Board_ID_Data()

        ' Refresh EEPROM Info to last received from this board
        GUI_Refresh_Calibration_Data()

        ' Clear Voltage Readings and send command to update GUI with fresh readings
        For cell_num As Integer = 0 To MAX_CELLS - 1
            Voltage_TextBoxes(cell_num).Text = ""
        Next cell_num

        If autoReadBox.Checked = False Then
            ' If autoreading, these will be refreshed automatically
            Voltage_Update_Flag = True
            USB_Comm_List_Out.Add(USB_PARSER_VOLTAGE_COMMAND)
        End If

        ' Clear Temperature Readings and send command to update GUI with fresh readings
        For temp_num As Integer = 0 To NUM_TEMPS - 1
            Temperature_TextBoxes(temp_num).Text = ""
        Next temp_num

        If autoReadBox.Checked = False Then
            ' If autoreading, these will be refreshed automatically
            Temperature_Update_Flag = True

            USB_Comm_List_Out.Add(USB_PARSER_TEMPERATURE_COMMAND)
            ' If GUI displaying the raw ADC values, request them
            If (Temperature_ADC_Test_IC1_Checkbox.Checked Or Temperature_ADC_Test_IC2_Checkbox.Checked) Then
                USB_Comm_List_Out.Add(USB_PARSER_TEMP_ADC_COMMAND)
            End If
        End If

        ' Clear LTC3300 Read Registers, then send command to update GUI with fresh readings
        ' Clear Balance Timers, then send command to update GUI with fresh readings if balancing
        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            LTC3300s(selectedBoard, ic_num).Init(False, Balance_Control_Timed_CheckBox.Checked)
        Next ic_num
        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Balance))
        USB_Comm_List_Out.Add(LTC3300_Raw_Read(LTC3300.Command.Read_Status))
        ' If balancing, update the balance timers and actions
        If Balance_Control_Timed_CheckBox.Checked = True Then
            USB_Comm_List_Out.Add(USB_PARSER_TIMED_BALANCE_COMMAND + "R" + selectedBoard.ToString("X2"))
        End If

        ' Update LTC3300 write command display.
        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
        Next ic_num

        ' Clear Passive Balancer Settings and send command to update GUI with fresh readings
        Passive_Balancer_Test_IC1_Checkbox.Checked = False
        Passive_Balancer_Test_IC2_Checkbox.Checked = False
        USB_Comm_List_Out.Add(USB_PARSER_PASSIVE_BALANCE_COMMAND + "R" + selectedBoard.ToString("X2"))

        ' Refresh flags for UV/OV
        USB_Comm_List_Out.Add(USB_PARSER_UVOV_COMMAND + selectedBoard.ToString("X2"))

        ' Update battery images, which depend upon voltage, temperature, and balancing information
        manageBatteryImages()

        ' Update Balancer Controls and Indicators
        Enable_BalancingControlsAndIndicators()

        ' Update cell grid.
        manageCellGridColors()

        ' Update the checkboxes on the Graph View
        GraphData.Update_GUI_CheckBoxes()

    End Sub

#End Region

#Region "Global Channel Monitor"

    Private Sub addGridColumn()   'Adds a new column to CellGrid (one for each board)
        CellGrid.Columns.Add("BD" & numBoards, "         Board " & numBoards)
        CellGrid.Columns(numBoards - 1).SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable

        If numBoards = 1 Then
            CellGrid.Rows.Add(MAX_CELLS)
            For cell_num As Integer = 0 To MAX_CELLS - 1
                CellGrid.Rows(cell_num).HeaderCell.Value = "   Cell " & (12 - cell_num)
            Next
        End If
    End Sub

    Private Sub manageCellGridColors()  'must be modified for multiple boards
        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To MAX_CELLS - 1
                If cellPresent(board_num, cell_num) = True Then
                    CellGrid.Rows(11 - cell_num).Cells(board_num).Style.BackColor = Drawing.Color.White
                Else
                    CellGrid.Rows(11 - cell_num).Cells(board_num).Style.BackColor = Drawing.Color.LightGray
                End If
            Next cell_num
        Next board_num
    End Sub
#End Region

#Region "Over and Under Voltage Settings"

    Private Sub vMaxBox_Enter(ByVal sender As System.Object, ByVal e As KeyPressEventArgs) Handles vMaxBox.KeyPress
        If e.KeyChar = Convert.ToChar(Keys.Enter) Then
            vMaxBox_LostFocus(sender, e)
            NoteLabel.Focus()
        End If
    End Sub

    Public Sub vMaxBox_LostFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles vMaxBox.LostFocus
        Dim vmax_last As Single = vMax

        If vMaxBox.Text <> "" Then
            Try
                ' Pick limit for OV setting.  Mfg needs more range than the customer, as they intentionally force the LTC3300 into OV conditions.
                Dim vmax_limit As Single
                If Mfg_Enabled = True Then
                    vmax_limit = VOLTAGE_MAX_MFG_LIMIT
                Else
                    vmax_limit = VOLTAGE_MAX_LIMIT
                End If

                ' Bounds Check the OV setting
                vMax = CSng(vMaxBox.Text)
                If vMax > vmax_limit Then
                    vMax = vmax_limit
                ElseIf vMax < vMin Then
                    vMax = vMin
                End If
                vMaxBox.Text = vMax.ToString(VOLTAGE_LIMIT_FORMAT)

                USB_Comm_List_Out.Add(USB_PARSER_UVOV_THRESHOLDS_COMMAND + CInt(vMax / VOLTAGE_RESOLUTION).ToString("X4") + CInt(vMin / VOLTAGE_RESOLUTION).ToString("X4"))

            Catch ex As Exception
                Handle_Exception(ex)
                vMax = vmax_last
                vMaxBox.Text = vmax_last.ToString(VOLTAGE_LIMIT_FORMAT)
            End Try
        Else
            vMax = vmax_last
            vMaxBox.Text = vmax_last.ToString(VOLTAGE_LIMIT_FORMAT)
        End If

    End Sub

    Private Sub vMinBox_Enter(ByVal sender As System.Object, ByVal e As KeyPressEventArgs) Handles vMinBox.KeyPress
        If e.KeyChar = Convert.ToChar(Keys.Enter) Then
            vMinBox_LostFocus(sender, e)
            NoteLabel.Focus()
        End If
    End Sub

    Public Sub vMinBox_LostFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles vMinBox.LostFocus
        Dim vmin_last As Single = vMin

        If vMinBox.Text <> "" Then
            Try
                ' Pick limit for OV setting.  Mfg needs more range than the customer, as they intentionally force the LTC3300 into OV conditions.
                Dim vmin_limit As Single
                If Mfg_Enabled = True Then
                    vmin_limit = VOLTAGE_MIN_MFG_LIMIT
                Else
                    vmin_limit = VOLTAGE_MIN_LIMIT
                End If

                ' Bounds Check the OV setting
                vMin = CSng(vMinBox.Text)
                If vMin > vMax Then
                    vMin = vMax
                ElseIf vMin < vmin_limit Then
                    vMin = vmin_limit
                End If
                vMinBox.Text = vMin.ToString(VOLTAGE_LIMIT_FORMAT)

                USB_Comm_List_Out.Add(USB_PARSER_UVOV_THRESHOLDS_COMMAND + CInt(vMax / VOLTAGE_RESOLUTION).ToString("X4") + CInt(vMin / VOLTAGE_RESOLUTION).ToString("X4"))

            Catch ex As Exception
                Handle_Exception(ex)
                vMin = vmin_last
                vMinBox.Text = vmin_last.ToString(VOLTAGE_LIMIT_FORMAT)
            End Try
        Else
            vMin = vmin_last
            vMinBox.Text = vmin_last.ToString(VOLTAGE_LIMIT_FORMAT)
        End If

    End Sub
#End Region

#Region "Configuration Save and Load"

    Private Sub Config_Demo_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Config_Demo_Button.Click

        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To MAX_CELLS - 1
                Dim balance_action As Cell_Balancer.Balance_Action

                cellPresent(board_num, cell_num) = True
                Cell_Balancers(board_num, cell_num).Enable(True)

                If cell_num Mod 2 = 1 Then
                    balance_action = Cell_Balancer.Balance_Action.Charge
                Else
                    balance_action = Cell_Balancer.Balance_Action.Discharge
                End If

                Cell_Balancers(board_num, cell_num).Set_Write_Action(balance_action)
                Cell_Balancers(board_num, cell_num).Set_Balance_Time((cell_num + 1) << 1)
            Next cell_num

            Timed_Balance_Write(board_num)

        Next board_num

        vMaxBox.Text = VOLTAGE_MAX_DEFAULT.ToString(VOLTAGE_LIMIT_FORMAT)
        vMinBox.Text = VOLTAGE_MIN_DEFAULT.ToString(VOLTAGE_LIMIT_FORMAT)
        vMaxBox_LostFocus(sender, e)
        vMinBox_LostFocus(sender, e)

        For ic_num As Integer = 0 To NUM_LTC3300 - 1
            LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
        Next ic_num

        For cell_num As Integer = 0 To MAX_CELLS - 1
            Cell_Balancers(selectedBoard, cell_num).Update_Balance_Time_GUI()
        Next cell_num

        manageCellGridColors()
        manageBatteryImages()
        manageNodes()

        ' All loaded configurations are for Timed balance
        Balance_Control_Timed_CheckBox.Checked = True

    End Sub

    Private Sub Config_Save_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Config_Save_Button.Click
        Dim config_data As Config_File.Config_Data_Type

        config_data.Num_Boards = numBoards
        config_data.OV_Threshold = vMax
        config_data.UV_Threshold = vMin

        ReDim config_data.Cell_Present(numBoards - 1, D33001.MAX_CELLS - 1)
        ReDim config_data.Balance_Times(numBoards - 1, D33001.MAX_CELLS - 1)
        ReDim config_data.Balance_Actions(numBoards - 1, D33001.MAX_CELLS - 1)
        For board_num As Integer = 0 To numBoards - 1
            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                config_data.Cell_Present(board_num, cell_num) = cellPresent(board_num, cell_num)
            Next cell_num
            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                config_data.Balance_Times(board_num, cell_num) = Cell_Balancers(board_num, cell_num).Get_Balance_Time()
            Next cell_num
            For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                config_data.Balance_Actions(board_num, cell_num) = Cell_Balancers(board_num, cell_num).Get_Write_Action()
            Next cell_num
        Next board_num

        If (Config_File.Save(numBoards, CInt(Config_Save_NumericUpDown.Value), config_data) = True) Then
            Config_Save_NumericUpDown.Maximum = Config_File.num_configurations + 1
            Config_Load_NumericUpDown.Maximum = Config_File.num_configurations
        End If
    End Sub

    Private Sub Config_Load_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Config_Load_Button.Click

        Dim config_data As Config_File.Config_Data_Type

        ReDim config_data.Cell_Present(numBoards - 1, D33001.MAX_CELLS - 1)
        ReDim config_data.Balance_Times(numBoards - 1, D33001.MAX_CELLS - 1)
        ReDim config_data.Balance_Actions(numBoards - 1, D33001.MAX_CELLS - 1)

        If (Config_File.Load(numBoards, CInt(Config_Load_NumericUpDown.Value), config_data) = True) Then

            vMax = config_data.OV_Threshold
            vMin = config_data.UV_Threshold
            vMaxBox.Text = vMax.ToString(VOLTAGE_LIMIT_FORMAT)
            vMinBox.Text = vMin.ToString(VOLTAGE_LIMIT_FORMAT)
            vMaxBox_LostFocus(sender, e)
            vMinBox_LostFocus(sender, e)

            For board_num As Integer = 0 To numBoards - 1
                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    cellPresent(board_num, cell_num) = config_data.Cell_Present(board_num, cell_num)
                Next cell_num
                Cell_Present_Write(board_num)

                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    Cell_Balancers(board_num, cell_num).Set_Balance_Time(config_data.Balance_Times(board_num, cell_num))
                Next cell_num
                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    Cell_Balancers(board_num, cell_num).Set_Write_Action(config_data.Balance_Actions(board_num, cell_num))
                Next cell_num
                Timed_Balance_Write(board_num)
            Next board_num

            For ic_num As Integer = 0 To NUM_LTC3300 - 1
                LTC3300s(selectedBoard, ic_num).Update_Write_Command_GUI()
            Next ic_num

            For cell_num As Integer = 0 To MAX_CELLS - 1
                Cell_Balancers(selectedBoard, cell_num).Update_Balance_Time_GUI()
            Next cell_num

            manageCellGridColors()
            manageBatteryImages()
            manageNodes()

            ' All loaded configurations are for Timed balance
            Balance_Control_Timed_CheckBox.Checked = True
        End If
    End Sub

#End Region

#Region "Graph View/Cap Demo"

    Private Sub CapBoardBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CapBoardBtn.Click

        If (Board_ID_Data(0).Cap_Demo = True) Then

            If CapBoardPopup.Opened = False Then
                CapBoardPopup.RectangleShape1.Location = New Drawing.Point(0, 0)
                CapBoardPopup.RectangleShape13.Location = New Drawing.Point(0, 0)
                CapBoardPopup.Location = New Drawing.Point(Me.Location.X + 300, Me.Location.Y + 50)
                CapBoardPopup.HScrollBar.Hide()
                CapBoardPopup.Show()
            Else
                CapBoardPopup.WindowState = FormWindowState.Normal
                CapBoardPopup.TopMost = True
                CapBoardPopup.TopMost = False
            End If
        Else
            If GraphData.Opened = False Then
                GraphData.RectangleShape1.Location = New Drawing.Point(0, 0)
                GraphData.Location = New Drawing.Point(Me.Location.X + 300, Me.Location.Y + 50)
                GraphData.HScrollBar.Hide()
                GraphData.Show()
                GraphData.Board_Count_Label.Text = Board_Count_Label.Text
                GraphData.Board_Selected_Number_Label.Text = Board_Selected_Number_Label.Text
            Else
                GraphData.WindowState = FormWindowState.Normal
                GraphData.TopMost = True
                GraphData.TopMost = False
            End If
        End If

    End Sub

#End Region

#Region "Error Log"
    Private Sub ErrLogBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ErrLogBtn.Click
        If ErrLogPopup.Visible = False Then
            ErrLogPopup.Show()
        Else
            ErrLogPopup.Select()
        End If

    End Sub
#End Region

#Region "Data Log"

    Private Sub LongLogBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Data_Log_CheckBox.CheckedChanged   'POLL BUTTON (may delete)
        If Data_Log_CheckBox.Checked Then
            Data_Log_Interval_Label.ForeColor = Drawing.Color.Black
            Data_Log_Mem_Usage_Label.ForeColor = Drawing.Color.Black
            Data_Log_Interval_TextBox.Enabled = True
            Data_Log_Interval_TextBox.BackColor = Drawing.Color.White
            Data_Log_Interval_ComboBox.Enabled = True
            Data_Log_Interval_ComboBox.BackColor = Drawing.Color.White
            Data_Log_Length_TextBox.Enabled = True
            Data_Log_Length_TextBox.BackColor = Drawing.Color.White
            Data_Log_Length_ComboBox.Enabled = True
            Data_Log_Length_ComboBox.BackColor = Drawing.Color.White
            Data_Log_Interval_TextBox.Text = Data_Log.DEFAULT_INTERVAL.ToString()
            Data_Log_Length_TextBox.Text = Data_Log.DEFAULT_LENGTH.ToString()
            Data_Log_Interval_ComboBox.SelectedIndex = 0
            Data_Log_Length_ComboBox.SelectedIndex = 0
            Data_Log_Start_Button.Enabled = True
        Else
            Data_Log_Interval_Label.ForeColor = Drawing.Color.DimGray
            Data_Log_Mem_Usage_Label.ForeColor = Drawing.Color.DimGray
            Data_Log_Interval_TextBox.Enabled = False
            Data_Log_Interval_TextBox.BackColor = Drawing.Color.DarkGray
            Data_Log_Interval_ComboBox.Enabled = False
            Data_Log_Interval_ComboBox.BackColor = Drawing.Color.DarkGray
            Data_Log_Length_TextBox.Enabled = False
            Data_Log_Length_TextBox.BackColor = Drawing.Color.DarkGray
            Data_Log_Length_ComboBox.Enabled = False
            Data_Log_Length_ComboBox.BackColor = Drawing.Color.DarkGray
            Data_Log_Start_Button.Enabled = False

        End If
    End Sub

    Private Sub LTlengthCombo_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles Data_Log_Length_ComboBox.SelectedIndexChanged, Data_Log_Interval_ComboBox.SelectedIndexChanged, Data_Log_Interval_TextBox.TextChanged, Data_Log_Length_TextBox.TextChanged

        Dim interval As Integer
        Dim length As Integer
        Dim memUsed As Long

        If (Data_Log_Interval_TextBox.Text = "") Or (Data_Log_Interval_ComboBox.Text = "") Or _
            (Data_Log_Length_TextBox.Text = "") Or (Data_Log_Length_ComboBox.Text = "") Then
            memUsed = 0
        Else
            interval = Get_Time_In_Seconds(CInt(Data_Log_Interval_TextBox.Text), Data_Log_Interval_ComboBox.Text)
            length = Get_Time_In_Seconds(CInt(Data_Log_Length_TextBox.Text), Data_Log_Length_ComboBox.Text)
            memUsed = Data_Log.Update_Size(interval, length)
        End If
        NoteLabel.Text = "Length: " + CStr(length) + ", " + "Interval: " + CStr(interval)
        Data_Log_Mem_Usage_Label.Text = "Projected Memory" + System.Environment.NewLine + "Usage: " + (CSng(memUsed) / (2 ^ 20)).ToString("0.00") + " MB"

    End Sub

    Private Sub longTermStopBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Data_Log_Stop_ComboBox.Click

        Data_Log.Stop_Log()
        Data_Log_Timer.Stop()

        Data_Log_CheckBox.Enabled = True
        Data_Log_Interval_TextBox.Enabled = True
        Data_Log_Interval_ComboBox.Enabled = True
        Data_Log_Length_TextBox.Enabled = True
        Data_Log_Length_ComboBox.Enabled = True

        Data_Log_Start_Button.Enabled = True
        Data_Log_Stop_ComboBox.Enabled = False
        NoteLabel.Visible = True
        NoteLabel.Text = "Long-Term Data Logging Interrupted."
    End Sub

    Private Sub longTermStartBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Data_Log_Start_Button.Click
        Dim save_file_dialog As New SaveFileDialog()
        Dim save_file_name As String

        save_file_dialog.Filter = "CSV Files (*.csv)|*.csv|All Files (*.*)|*.*"
        save_file_dialog.Title = "Choose Long-Term Data Log File Location"
        If save_file_dialog.ShowDialog() = DialogResult.OK Then
            If save_file_dialog.FileName.Substring(save_file_dialog.FileName.Length - ".csv".Length, ".csv".Length) = ".csv" Then
                save_file_name = save_file_dialog.FileName
            Else
                save_file_name = save_file_dialog.FileName + ".csv"
            End If
        Else
            Exit Sub
        End If

        Dim interval As Integer = Get_Time_In_Seconds(CInt(Data_Log_Interval_TextBox.Text), Data_Log_Interval_ComboBox.Text)
        Dim length As Integer = Get_Time_In_Seconds(CInt(Data_Log_Length_TextBox.Text), Data_Log_Length_ComboBox.Text)
        Data_Log.Start(save_file_name, interval, length)
        Data_Log_Timer.Interval = Data_Log.interval * MS_PER_SEC
        Data_Log_Timer.Start()

        Data_Log_CheckBox.Enabled = False
        Data_Log_Interval_TextBox.Enabled = False
        Data_Log_Interval_ComboBox.Enabled = False
        Data_Log_Length_TextBox.Enabled = False
        Data_Log_Length_ComboBox.Enabled = False

        Data_Log_Start_Button.Enabled = False
        Data_Log_Stop_ComboBox.Enabled = True

    End Sub

    Private Sub Data_Log_Timer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Data_Log_Timer.Tick

        ' Update the data log
        Data_Log.Add_Data()

        ' todo - this is gross, setting all of these Direct590.D33001 controls here.
        ' Update the message displaying how much data we have to yet to collect
        Dim time_remaining As Integer = CInt((Data_Log.num_datapoints - Data_Log.datapoint_count) * Data_Log.interval)
        Dim time_remaining_units As String = ""
        Get_Time_From_Seconds(time_remaining, time_remaining_units)

        NoteLabel.Text = "Long-Term Data Logging...Time Remaining: " + CStr(time_remaining) + " " + time_remaining_units
        If NoteLabel.Visible Then
            NoteLabel.Visible = False
        Else
            NoteLabel.Visible = True
        End If

        ' When no more data is to be taken, enable/disable the appropriate GUI controls
        If Data_Log.datapoint_count >= Data_Log.num_datapoints Then
            Data_Log.Stop_Log()
            Data_Log_Timer.Stop()

            Data_Log_CheckBox.Enabled = True
            Data_Log_Interval_TextBox.Enabled = True
            Data_Log_Interval_ComboBox.Enabled = True
            Data_Log_Length_TextBox.Enabled = True
            Data_Log_Length_ComboBox.Enabled = True

            Data_Log_Start_Button.Enabled = True
            Data_Log_Stop_ComboBox.Enabled = False
            NoteLabel.Visible = True
            NoteLabel.Text = "Long-Term Data Logging Finished."
        End If
    End Sub
#End Region

#Region "Calibration"
    Private Sub Calibration_Data_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Calibration_Data_Button.Click
        If DataInputPopup.Visible = False Then
            DataInputPopup.Location = Me.Location
            DataInputPopup.Cal_Data_Init()
            DataInputPopup.Show()
            GUI_Refresh_Calibration_Data()
        Else
            DataInputPopup.Select()
        End If
    End Sub

    Public Sub GUI_Refresh_Calibration_Data()

        If DataInputPopup.Visible = True Then

            RemoveHandler DataInputPopup.DataGrid.CellValueChanged, AddressOf DataInputPopup.DataGrid_CellValueChanged

            If numBoards = 0 Then
                For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                    DataInputPopup.DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Capacity).Value = ""
                    DataInputPopup.DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Charge_Current).Value = ""
                    DataInputPopup.DataGrid.Rows(D33001.MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Discharge_Current).Value = ""
                Next cell_num
            Else
                For cell_num As Integer = 0 To MAX_CELLS - 1
                    If DataInputPopup.Capacity_Changed = False Then
                        If (system_state = System_State_Type.Awake) Then
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Capacity).Value = EEPROM_Data(selectedBoard).Capacity(cell_num).ToString(D33001.CAP_FORMAT)
                        Else
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Capacity).Value = ""
                        End If
                        DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Capacity).Style.BackColor = ENABLED_COLOR
                    End If

                    If DataInputPopup.Currents_Changed = False Then
                        If (system_state = System_State_Type.Awake) Then
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Charge_Current).Value = EEPROM_Data(selectedBoard).Charge_Currents(cell_num).ToString(D33001.CURRENT_FORMAT)
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Discharge_Current).Value = EEPROM_Data(selectedBoard).Discharge_Currents(cell_num).ToString(D33001.CURRENT_FORMAT)
                        Else
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Charge_Current).Value = ""
                            DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Discharge_Current).Value = ""
                        End If
                        DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Charge_Current).Style.BackColor = ENABLED_COLOR
                        DataInputPopup.DataGrid.Rows(MAX_CELLS - 1 - cell_num).Cells(Calibration_Column.Discharge_Current).Style.BackColor = ENABLED_COLOR
                    End If
                Next cell_num
            End If

            AddHandler DataInputPopup.DataGrid.CellValueChanged, AddressOf DataInputPopup.DataGrid_CellValueChanged

        End If
    End Sub

#End Region

#Region "Board ID and FW Update"

    Private Sub FW_Rev_TextBox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FW_Rev_TextBox.TextChanged

        ' Only the board with the PIC contains FW to Upgrade.
        If (numBoards = 0) Or (selectedBoard <> DC2100A_PIC_BOARD_NUM) Then
            Exit Sub
        End If

        ' Only offer once when a new board is connected.
        If (FW_Update_Offered = True) Then
            Exit Sub
        End If
        FW_Update_Offered = True

        If (Firmware_Version_Connected.Is_Older_Than(Firmware_Version_Expected) = True) Then

            Dim popup_msg As String = "This board contains firmware (FW) that is obsolete for this GUI."
            popup_msg += ChrW(13) + ChrW(10) + ChrW(13) + ChrW(10)
            popup_msg += "Update " + Board_ID_Data(DC2100A_PIC_BOARD_NUM).Model
            popup_msg += " from "
            popup_msg += Board_ID_Data(DC2100A_PIC_BOARD_NUM).FW_Rev
            popup_msg += " to "
            popup_msg += Firmware_Version_Expected.Get_String()
            popup_msg += "?"

            Bootloader_Popup(popup_msg)
        End If
    End Sub

    Private Sub Enter_Bootloader_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Update_Firmware_Button.Click

        If numBoards <> 0 Then
            Dim popup_msg As String = "This will update the firmware (FW) in the "
            popup_msg += Board_ID_Data(DC2100A_PIC_BOARD_NUM).Model
            popup_msg += " from "
            popup_msg += Board_ID_Data(DC2100A_PIC_BOARD_NUM).FW_Rev
            popup_msg += " to "
            popup_msg += Firmware_Version_Expected.Get_String()
            popup_msg += "."

            popup_msg += ChrW(13) & ChrW(10) & _
                         ChrW(13) & ChrW(10) & "Do you want to proceed?"
            Bootloader_Popup(popup_msg)
        Else
            Bootloader_Process_Start()
        End If

    End Sub

    Private Sub Model_ComboBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Model_ComboBox.SelectedIndexChanged
        Enable_MfgControlsAndIndicators()
    End Sub

    Private Sub CapDemo_ComboBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CapDemo_ComboBox.SelectedIndexChanged
        Enable_MfgControlsAndIndicators()
    End Sub

    Private Sub GUI_Refresh_Board_ID_Data()
        Model_ComboBox.SelectedIndex = -1   ' todo - why this?
        Model_ComboBox.SelectedItem = Board_ID_Data(selectedBoard).Model
        Mfg_Model = Board_ID_Data(selectedBoard).Model
        SN_TextBox.Text = Board_ID_Data(selectedBoard).Serial_Number
        If Board_ID_Data(selectedBoard).Cap_Demo = True Then
            CapDemo_ComboBox.SelectedItem = "TRUE"
            DataInputPopup.Cap.HeaderText = "Capacity (F)"
        Else
            CapDemo_ComboBox.SelectedItem = "FALSE"
            DataInputPopup.Cap.HeaderText = "Capacity (Ah)"
        End If
        Mfg_Cap_Demo = CapDemo_ComboBox.Text

        Average_Charge_Current_12Cell_TextBox.Text = Board_ID_Data(selectedBoard).Average_Charge_Current_12Cell.ToString("0.00")
        Average_Discharge_Current_12Cell_TextBox.Text = Board_ID_Data(selectedBoard).Average_Discharge_Current_12Cell.ToString("0.00")
        Average_Charge_Current_6Cell_TextBox.Text = Board_ID_Data(selectedBoard).Average_Charge_Current_6Cell.ToString("0.00")
        Average_Discharge_Current_6Cell_TextBox.Text = Board_ID_Data(selectedBoard).Average_Discharge_Current_6Cell.ToString("0.00")
        FW_Rev_TextBox.Text = Board_ID_Data(selectedBoard).FW_Rev

        Enable_MfgControlsAndIndicators()
    End Sub

    Private Sub Bootloader_Popup(ByVal popup_msg As String)
        ' todo - need to use consistent popups?
        FW_Update_PopUp = True
        If MsgBox(popup_msg, MsgBoxStyle.OkCancel) = MsgBoxResult.Ok Then
            USB_Comm_List_Out.Add(USB_PARSER_BOOT_MODE_COMMAND + USB_PARSER_BOOTLOAD_STRING)
            Bootloader_Command_Sent = True
            Error_File.Add(Error_File.Error_Code.Message, "Bootload Command Sent")
        End If
        FW_Update_PopUp = False
    End Sub

    Private Sub Bootloader_Process_Start()
        ' Wait for PIC to unenumerate as a DC2100A device and re-enumerate as a bootloader.
        System.Threading.Thread.Sleep(Bootloader_Reboot_Delay)
        Try
            ' Start the FW Update Program
            Dim command_string As String = filePath
            Dim options_string As String
            command_string += Firmware_Update_Command
            options_string = Firmware_Update_Options + " " + """" + filePath + Firmware_Hex_File_Name + """"
            System.Diagnostics.Process.Start(command_string, options_string)
        Catch ex As Exception
            Handle_Exception(ex)
        End Try
    End Sub

#End Region

#Region "Manufacturing Support"

    Private Sub Write_MfgData_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Write_MfgData_Button.Click
        ' Writes the manufacturing data to selected board and writes the serial number back to MfgData.txt
        Dim sn_test As New Serial_Number(SN_TextBox.Text)
        Dim dataString As String = USB_PARSER_MFG_COMMAND + "W"

        If sn_test.valid = False Then
            SN_TextBox.Text = Mfg_File.Start_New_Board(Model_ComboBox.Text, CapDemo_ComboBox.Text)
        Else
            Mfg_File.Restart_Old_Board(SN_TextBox.Text, Model_ComboBox.Text, CapDemo_ComboBox.Text)
        End If
        Mfg_File.New_Line()

        Try
            dataString += selectedBoard.ToString("X2")
            dataString += Model_ComboBox.Text
            dataString += CapDemo_ComboBox.Text(0)
            dataString += SN_TextBox.Text
            USB_Comm_List_Out.Add(dataString)
            USB_Comm_List_Out.Add(LinearTechnology.DemoBoards.DC2100A.D33001.USB_PARSER_EEPROM_COMMAND + "R" + selectedBoard.ToString("X2") + "0")
            USB_Comm_List_Out.Add(LinearTechnology.DemoBoards.DC2100A.D33001.USB_PARSER_EEPROM_COMMAND + "R" + selectedBoard.ToString("X2") + "1")
        Catch ex As Exception
            ' todo - if manufacturing data write is attempted before data is selected, do not write anything since we only get to do this once.
            Handle_Exception(ex)

        End Try

    End Sub

    Private Sub Reset_Mfg_Data_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Reset_Mfg_Data_Button.Click
        ' Clears the EEPROM and the manufacturing data in the PIC flash - meant for test only
        Dim dataString As String = USB_PARSER_MFG_COMMAND + "D"

        Try
            dataString += selectedBoard.ToString("X2")
            dataString += "EEPROM_RESET"
            dataString += "system_reset"
            dataString += USB_PARSER_EEPROM_COMMAND + "R" + selectedBoard.ToString("X2") + "0"
            dataString += USB_PARSER_EEPROM_COMMAND + "R" + selectedBoard.ToString("X2") + "1"

            USB_Comm_List_Out.Add(dataString)
        Catch ex As Exception
            Handle_Exception(ex)

        End Try

    End Sub

    Private Sub Temperature_ADC_Test_IC1_Checkbox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Temperature_ADC_Test_IC1_Checkbox.CheckedChanged
        If (Temperature_ADC_Test_IC1_Checkbox.Checked = True) Then
            For adc_num As Integer = 0 To (NUM_TEMPS \ NUM_LTC3300) - 1
                Temperature_TextBoxes(adc_num).Text = ""
            Next adc_num
        End If
    End Sub

    Private Sub Temperature_ADC_Test_IC2_Checkbox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Temperature_ADC_Test_IC2_Checkbox.CheckedChanged
        If (Temperature_ADC_Test_IC2_Checkbox.Checked = True) Then
            For adc_num As Integer = (NUM_TEMPS \ NUM_LTC3300) To NUM_TEMPS - 1
                Temperature_TextBoxes(adc_num).Text = ""
            Next adc_num
        End If
    End Sub

    Private Sub Passive_Balancer_Test_IC1_Checkbox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Passive_Balancer_Test_IC1_Checkbox.CheckedChanged
        Dim dataString As String = USB_PARSER_PASSIVE_BALANCE_COMMAND + "W"

        If Passive_Balancer_Test_IC1_Checkbox.Checked Then
            Passive_Balancers(selectedBoard) = Passive_Balancers(selectedBoard) Or &H3F
        Else
            Passive_Balancers(selectedBoard) = Passive_Balancers(selectedBoard) And &HFFC0
        End If

        dataString += selectedBoard.ToString("X2")
        dataString += Passive_Balancers(selectedBoard).ToString("X4")

        USB_Comm_List_Out.Add(dataString)
    End Sub

    Private Sub Passive_Balancer_Test_IC2_Checkbox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Passive_Balancer_Test_IC2_Checkbox.CheckedChanged
        Dim dataString As String = USB_PARSER_PASSIVE_BALANCE_COMMAND + "W"

        If Passive_Balancer_Test_IC2_Checkbox.Checked Then
            Passive_Balancers(selectedBoard) = Passive_Balancers(selectedBoard) Or &HFC0
        Else
            Passive_Balancers(selectedBoard) = Passive_Balancers(selectedBoard) And &HF03F
        End If

        dataString += selectedBoard.ToString("X2")
        dataString += Passive_Balancers(selectedBoard).ToString("X4")

        USB_Comm_List_Out.Add(dataString)
    End Sub

    Private Sub Mfg_PipeTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Mfg_PipeTimer.Tick
        ' Run named pipe thread periodically to check for input from manufacturing program
        If Mfg_PipeWorker.IsBusy <> True Then
            Mfg_PipeWorker.RunWorkerAsync()
        End If
    End Sub

    Private Sub Mfg_PipeWorker_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles Mfg_PipeWorker.DoWork
        ' todo - handle Mfg Pipe State Machine here.
    End Sub

    Private Sub Mfg_PipeWorker_RunWorkerCompleted(ByVal sender As System.Object,
                                                     ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs
                                                     ) Handles AutoBulkReadWorker.RunWorkerCompleted
        ' todo - Translate Mfg Pipe commands into GUI control updates here.
    End Sub

    ' Enables controls and indicators depending upon whether a system is attached, a system with the cell powered is attached, or if a Manufacturing File is present
    Private Sub Enable_MfgControlsAndIndicators()

        ' Enable the debug textbox if debugging
        If DEBUG = True Then
            Me.Debug_TextBox.Visible = True
            Debug2_TextBox.Visible = True
        End If

        If DEBUG_LED = True Then
            Me.LED_Label.Visible = True
            Me.Status_LED_PictureBox.Visible = True
            Me.Comm_LED_PictureBox.Visible = True
        End If

        If Mfg_Enabled = True Then

            ' Enable the debug mfg buttons if debugging
            If DEBUG = True Then
                Me.Reset_Mfg_Data_Button.Visible = True
                Me.Advanced_Button.Visible = True
            End If

            ' If Manufacturing file present, make manufacturing controls and indicators visible and determine if they should be enabled
            Me.Write_MfgData_Button.Visible = True
            ' These buttons are for development only
            Me.Passive_Balancer_Test_IC1_Checkbox.Visible = True
            Me.Passive_Balancer_Test_IC2_Checkbox.Visible = True
            Me.Temperature_ADC_Test_IC1_Checkbox.Visible = True
            Me.Temperature_ADC_Test_IC2_Checkbox.Visible = True

            ' Disable setting Mfg and Calibration Data if no boards are present
            If numBoards = 0 Then

                Me.Write_MfgData_Button.Enabled = False
                Me.Model_ComboBox.Enabled = False
                Me.Model_ComboBox.BackColor = ENABLED_COLOR
                Me.CapDemo_ComboBox.Enabled = False
                Me.CapDemo_ComboBox.BackColor = ENABLED_COLOR

            Else

                ' If boards are present, then enable the Model selection and Cap Demo Buttons (for appropriate models)
                Me.Model_ComboBox.Enabled = True
                If Board_ID_Data(selectedBoard).Model = Model_ComboBox.Text Then
                    Me.Model_ComboBox.BackColor = ENABLED_COLOR
                Else
                    Me.Model_ComboBox.BackColor = CHANGED_COLOR
                End If

                ' Only allow Cap Boards to be defined for A and C models
                If (Model_ComboBox.Text = "DC2100A-B") Or (Model_ComboBox.Text = "DC2100A-D") Then
                    CapDemo_ComboBox.Enabled = False
                    Me.CapDemo_ComboBox.BackColor = ENABLED_COLOR   ' note that the ENABLED_COLOR is also the (Not CHANGED_COLOR)

                    If (Model_ComboBox.SelectedIndex = -1) Then
                        CapDemo_ComboBox.SelectedIndex = -1
                    Else
                        CapDemo_ComboBox.SelectedItem = "FALSE"
                    End If
                Else
                    CapDemo_ComboBox.Enabled = True
                    If ((Board_ID_Data(selectedBoard).Cap_Demo = False) And (CapDemo_ComboBox.Text = "FALSE")) Or
                        ((Board_ID_Data(selectedBoard).Cap_Demo = True) And (CapDemo_ComboBox.Text = "TRUE")) Then
                        Me.CapDemo_ComboBox.BackColor = ENABLED_COLOR
                    Else
                        Me.CapDemo_ComboBox.BackColor = CHANGED_COLOR
                    End If
                End If

                ' Display proper text for Write MfgData Button depending upon whether serial number is valid or not
                Dim sn_test As New Serial_Number(SN_TextBox.Text)
                If sn_test.valid = False Then
                    Me.Write_MfgData_Button.Text = "Checkout SN and Write Mfg Data"
                Else
                    Me.Write_MfgData_Button.Text = "Write Mfg Data"
                End If
                Me.Write_MfgData_Button.Enabled = False

                ' If model number and cap demo setting are valid, then enable Write MfgData Button
                If (Model_ComboBox.SelectedIndex <> -1) AndAlso (CapDemo_ComboBox.SelectedIndex <> -1) Then
                    Me.Write_MfgData_Button.Enabled = True
                Else
                    Me.Write_MfgData_Button.Enabled = False
                End If
            End If

            DataInputPopup.Calibration_Current_Button_1.Text = "Write Measured Balance Currents"
            DataInputPopup.Calibration_Current_Button_2.Text = "Reset to Nominal Balance Currents"
            DataInputPopup.Calibration_Cap_Button_1.Text = "Write Measured Capacities"
            DataInputPopup.Calibration_Cap_Button_2.Text = "Reset to Nominal Capacities"

        Else
            ' If Manufacturing file not present, disable or hide the manufacturing controls and indicators
            Me.Write_MfgData_Button.Visible = False
            Me.Reset_Mfg_Data_Button.Visible = False
            Me.Advanced_Button.Visible = False

            Me.Passive_Balancer_Test_IC1_Checkbox.Visible = False
            Me.Passive_Balancer_Test_IC2_Checkbox.Visible = False
            Me.Temperature_ADC_Test_IC1_Checkbox.Visible = False
            Me.Temperature_ADC_Test_IC2_Checkbox.Visible = False

            Me.Model_ComboBox.Enabled = False
            Me.CapDemo_ComboBox.Enabled = False

            If (Board_ID_Data(0).Cap_Demo = True) Then
                DataInputPopup.Calibration_Current_Button_1.Text = "Load Nominal Balance Currents"
                DataInputPopup.Calibration_Current_Button_2.Text = "Load Factory Balance Currents"
                DataInputPopup.Calibration_Cap_Button_1.Text = "Load Nominal Capacitances"
                DataInputPopup.Calibration_Cap_Button_2.Text = "Load Factory Capacitances"
            Else
                DataInputPopup.Calibration_Current_Button_1.Text = "Write Measured Balance Currents"
                DataInputPopup.Calibration_Current_Button_2.Text = "Reset to Factory Balance Currents"
                DataInputPopup.Calibration_Cap_Button_1.Text = "Write Measured Capacities"
                DataInputPopup.Calibration_Cap_Button_2.Text = "Reset to Factory Capacities"
            End If

        End If

        ' If Cap Demo Board, show the button for the Cap Board Demo
        ' If not Cap Demo Board, show the button for the Graph Data
        If (Board_ID_Data(0).Cap_Demo = True) Then
            Me.CapBoardBtn.Text = "Supercap Window"
        Else
            Me.CapBoardBtn.Text = "Graph Data"
        End If

        ' If a board is connected to its 6804 and configured with a model, then all the Calibration Data is enabled
        If (numBoards <> 0) AndAlso (Board_ID_Data(selectedBoard).Average_Charge_Current_6Cell <> 0) AndAlso (Board_ID_Data(selectedBoard).Average_Discharge_Current_6Cell <> 0) Then
            Calibration_Data_Button.Enabled = True
        Else
            Calibration_Data_Button.Enabled = False
        End If

    End Sub

#End Region

#Region "Utility Functions"
    ' cell_string must have the substring "Cell#" in it, where # can be a one or two digit number
    ' return MAX_CELLS is not valid
    Private Function Get_Cell_Number_From_String(ByVal cell_string As String) As Integer
        Dim cell_num_string_index As Integer
        Dim cell_num As Integer

        cell_num_string_index = cell_string.IndexOf("Cell")

        If cell_num_string_index = -1 Then
            cell_num = MAX_CELLS  ' return error is string not found
        Else
            ' First try parsing a 2 digit number
            Try
                cell_num = Integer.Parse(cell_string.Substring(cell_num_string_index + "Cell".Length, 2))
            Catch
                ' Try parsing a 1 digit number if that didn't work
                Try
                    cell_num = Integer.Parse(cell_string.Substring(cell_num_string_index + "Cell".Length, 1))
                Catch ex As Exception
                    Handle_Exception(ex)

                    cell_num = MAX_CELLS ' return error is the number failed to convert
                End Try
            End Try
        End If

        If cell_num > MAX_CELLS Then
            cell_num = MAX_CELLS ' return error is the number is too high
        Else
            cell_num = cell_num - 1 ' number found. convert to index to account for arrays being 0 indexed
        End If

        Return cell_num

    End Function

    Private Function Get_IC_From_Cell_Number(ByVal cell_number As Integer) As Integer
        Return cell_number \ LTC3300.NUM_CELLS
    End Function

    Private Function Get_Time_In_Seconds(ByVal value As Integer, ByVal units As String) As Integer
        If units = "Secs" Then
            value *= 1
        ElseIf units = "Mins" Then
            value *= SEC_PER_MIN
        ElseIf units = "Hours" Then
            value *= SEC_PER_HR
        ElseIf units = "Days" Then
            value *= SEC_PER_DAY
        ElseIf units = "Weeks" Then
            value *= SEC_PER_WK
        End If

        Return value
    End Function

    Public Function Get_Time_From_Seconds(ByRef value As Integer, ByRef units As String) As Integer

        If value >= SEC_PER_WK Then
            value = CInt(value / SEC_PER_WK) : units = "Weeks"
        ElseIf value >= SEC_PER_DAY Then
            value = CInt(value / SEC_PER_DAY) : units = "Days"
        ElseIf value >= SEC_PER_HR Then
            value = CInt(value / SEC_PER_HR) : units = "Hours"
        ElseIf value >= SEC_PER_MIN Then
            value = CInt(value / SEC_PER_MIN) : units = "Mins"
        Else
            units = "Secs"
        End If

        ' If only 1 left, unpluralize the units
        If value = 1 Then units.Remove(units.Length - 1, 1)

        Return value
    End Function

    Public Function Extract_Function_Name_From_String(ByVal function_string As String) As String
        Dim space_string_index As Integer
        Dim paren_string_index As Integer

        space_string_index = function_string.IndexOf(" ")
        paren_string_index = function_string.IndexOf("(")

        Return function_string.Substring(space_string_index + 1, paren_string_index - space_string_index - 1)

    End Function

    Public Sub Handle_Exception(ByVal ex As Exception)
        Error_File.Add(Error_File.Error_Code.Exception, ex.Message, ex.StackTrace)
    End Sub
#End Region

End Class
