﻿Imports Microsoft.VisualBasic
Imports LinearTechnology.DemoBoards.DC2100A

Public Class Config_File
    Public Const start_of_record_delimiter As String = "#"
    Public Const record_field_delimiter As String = ","
    Public Const comment_delimiter As String = ";"
    Public filename As String               ' The filename where the config data is stored
    Public num_configurations As Integer    ' The number of configurations stored
    Public Structure Config_Data_Type
        Public Num_Boards As Integer
        Public OV_Threshold As Single
        Public UV_Threshold As Single
        Public Cell_Present(,) As Boolean
        Public Balance_Times(,) As Single
        Public Balance_Actions(,) As Cell_Balancer.Balance_Action
    End Structure

    Public Sub New(ByVal filename As String)
        ' Try reading from the file and closing to see if it is allowed
        Dim reader As System.IO.StreamReader
        Dim writer As System.IO.StreamWriter
        Dim textline As String

        Try
            ' Start off assuming no configurations in the file.  Count them in file if found.
            Me.num_configurations = 0

            If My.Computer.FileSystem.FileExists(filename) Then
                ' Try loading config file
                reader = New System.IO.StreamReader(filename)

                If (reader.EndOfStream) Then
                    ' If error file exists and it's empty, try writing to it to see if it's possible.
                    reader.Close()
                    writer = New System.IO.StreamWriter(filename)
                    writer.WriteLine()
                    writer.Close()
                Else
                    ' If config file exists and has contents, it's safe to assume that it can be written.
                    While (Not reader.EndOfStream)
                        textline = reader.ReadLine()
                        If (textline.Length > 0) AndAlso (textline(0) = start_of_record_delimiter) Then
                            num_configurations += 1
                        End If
                    End While
                    reader.Close()
                End If

                ' Save the config file name.  It's a good file for us to use.
                Me.filename = filename
            Else
                Try
                    ' If config file doesn't exist, try creating it 
                    writer = New System.IO.StreamWriter(filename)
                    writer.WriteLine()
                    writer.Close()

                    ' Save the config file name.  It's a good file for us to use.
                    Me.filename = filename

                Catch ex2 As Exception
                    D33001.Handle_Exception(ex2)

                    ' Clear the error file name to flag that it is not valid file.
                    Me.filename = ""
                End Try
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)

            ' Clear the file name to flag that it is not valid file.
            Me.filename = ""
        End Try

    End Sub

    Public Function Load(ByVal num_boards As Integer, ByVal config_num As Integer, ByRef config_data As Config_Data_Type) As Boolean
        Dim success As Boolean = True

        Try

            If (Me.filename = "") Then
                MsgBox("No configurations exist.")
                success = False
            ElseIf (config_num > Me.num_configurations) Then
                MsgBox("This configuration does not exist.")
                success = False
            Else
                ' first find the configuration
                Dim reader As New System.IO.StreamReader(Me.filename)
                Dim textline As String = ""
                Dim config_count As Integer = 0

                ' Read out all of the file contents, and replace the configuration we wish to replace
                While (Not reader.EndOfStream)
                    textline = reader.ReadLine()
                    If (textline.Length > 0) AndAlso (textline(0) = start_of_record_delimiter) Then
                        config_count += 1
                        If (config_count = config_num) Then
                            ' This is the configuration to replace.
                            Exit While
                        End If
                    End If
                End While
                reader.Close()
                textline = textline.Remove(0, 1)    ' Throw away the start of record delimiter

                ' find out how many boards this configuration is for
                config_data.Num_Boards = Integer.Parse(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)

                If num_boards > config_data.Num_Boards Then
                    ' If there aren't enough boards in this configuration, then report an error
                    MsgBox("This configuration was only saved for " + config_data.Num_Boards.ToString() + " boards")
                    success = False
                Else
                    ' Otherwise, load the configuration data for this board.
                    success = True

                    config_data.OV_Threshold = Single.Parse(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                    textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)
                    config_data.UV_Threshold = Single.Parse(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                    textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)

                    For board_num As Integer = 0 To num_boards - 1
                        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                            config_data.Cell_Present(board_num, cell_num) = Boolean.Parse(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                            textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)
                        Next cell_num
                        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                            config_data.Balance_Times(board_num, cell_num) = Single.Parse(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                            textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)
                        Next cell_num
                        For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                            config_data.Balance_Actions(board_num, cell_num) = Get_Balance_Action_From_Text(textline.Substring(0, textline.IndexOf(record_field_delimiter)))
                            textline = textline.Remove(0, textline.IndexOf(record_field_delimiter) + 1)
                        Next cell_num
                    Next board_num

                End If

            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            success = False
        End Try

        Return success

    End Function

    Public Function Save(ByVal num_boards As Integer, ByVal config_num As Integer, ByVal config_data As Config_Data_Type) As Boolean
        Dim success As Boolean = True

        Try
            If (Me.filename = "") Then
                MsgBox("No configurations exist.")
                success = False
            ElseIf (config_num > Me.num_configurations + 1) Then
                MsgBox("This configuration does not exist.")
                success = False
            Else
                Dim writer As System.IO.StreamWriter
                Dim textline As String

                ' Create config data string to write to the file
                textline = start_of_record_delimiter
                textline += config_data.Num_Boards.ToString() + record_field_delimiter
                textline += config_data.OV_Threshold.ToString() + record_field_delimiter
                textline += config_data.UV_Threshold.ToString() + record_field_delimiter

                For board_num As Integer = 0 To num_boards - 1
                    For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                        textline += config_data.Cell_Present(board_num, cell_num).ToString() + record_field_delimiter
                    Next cell_num
                    For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                        textline += config_data.Balance_Times(board_num, cell_num).ToString() + record_field_delimiter
                    Next cell_num
                    For cell_num As Integer = 0 To D33001.MAX_CELLS - 1
                        textline += config_data.Balance_Actions(board_num, cell_num).ToString() + record_field_delimiter
                    Next cell_num
                Next board_num

                ' Write config data to the file
                If (config_num = Me.num_configurations + 1) Then
                    ' If writing a new configuration, append to end of file.
                    Try
                        writer = System.IO.File.AppendText(Me.filename)
                        writer.WriteLine(textline)
                        writer.Flush()
                        writer.Close()
                    Catch ex As Exception
                        D33001.Handle_Exception(ex)
                    End Try

                    ' Save the configuration data
                    num_configurations += 1
                Else
                    ' If replacing a configuration, read file, replace, and overwrite file.
                    Dim reader As New System.IO.StreamReader(Me.filename)
                    Dim fileline As String = ""
                    Dim filetext As String = ""
                    Dim config_count As Integer = 0

                    ' Read out all of the file contents, and replace the configuration we wish to replace
                    While (Not reader.EndOfStream)
                        fileline = reader.ReadLine()
                        If (fileline.Length > 0) AndAlso (fileline(0) = start_of_record_delimiter) Then
                            config_count += 1
                            If (config_count = config_num) Then
                                ' This is the configuration to replace.
                                filetext += textline
                            Else
                                ' This is not the configuration to replace.
                                filetext += fileline
                            End If
                        End If
                    End While
                    reader.Close()

                    ' Open the writer.  Overwrite old file.
                    writer = New System.IO.StreamWriter(Me.filename, False)

                    ' Write each new configuration on its own line
                    While (filetext.Length > 0) AndAlso (filetext(0) = start_of_record_delimiter)
                        Dim next_record_index As Integer = filetext.Substring(1, filetext.Length - 1).IndexOf(start_of_record_delimiter)
                        If (next_record_index > 0) Then
                            ' If this isn't the last record, write a line and remove this record from what's left to write.
                            writer.WriteLine(filetext.Substring(0, next_record_index + 1))
                            filetext = filetext.Remove(0, next_record_index + 1)
                        Else
                            ' If this is the last record, write everything that's left.
                            writer.WriteLine(filetext)
                            filetext = ""
                        End If
                    End While

                    ' Close the file
                    writer.Flush()
                    writer.Close()
                End If

                success = True
            End If
        Catch ex As Exception
            D33001.Handle_Exception(ex)
            success = False
        End Try

        Return success
    End Function

    Private Function Get_Balance_Action_From_Text(ByVal text As String) As Cell_Balancer.Balance_Action
        If text = "Charge" Then
            Return Cell_Balancer.Balance_Action.Charge
        ElseIf text = "Discharge" Then
            Return Cell_Balancer.Balance_Action.Discharge
        Else
            Return Cell_Balancer.Balance_Action.None
        End If
    End Function
End Class
