#ifndef __BOOT__
#define __BOOT__

#ifndef __PCH__
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  BootLoader.                                                             ;;
;;  Copyright (C) 2007 Diolan ( http://www.diolan.com )                     ;;
;;                                                                          ;;
;;  This program is free software: you can redistribute it and/or modify    ;;
;;  it under the terms of the GNU General Public License as published by    ;;
;;  the Free Software Foundation, either version 3 of the License, or       ;;
;;  (at your option) any later version.                                     ;;
;;                                                                          ;;
;;  This program is distributed in the hope that it will be useful,         ;;
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of          ;;
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           ;;
;;  GNU General Public License for more details.                            ;;
;;                                                                          ;;
;;  You should have received a copy of the GNU General Public License       ;;
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Main definitions
;-----------------------------------------------------------------------------
; Bootloader Version
#endif
#define BOOT_FW_VER_MAJOR       1
#define BOOT_FW_VER_MINOR       0
#define BOOT_FW_VER_SUB_MINOR   2
#define BOOT_FW_VER_CODE        ((BOOT_FW_VER_MAJOR << 8) | (BOOT_FW_VER_MINOR << 4) | (BOOT_FW_VER_SUB_MINOR))

#ifndef __PCH__
;-----------------------------------------------------------------------------
; These are the memory segments defined in the PIC, divided between the application and the bootloader
#endif
#define BOOT_RESET_VECTOR                   0x00
#define BOOT_HIGH_INTERRUPT_VECTOR          0x08
#define BOOT_LOW_INTERRUPT_VECTOR           0x18
#define BOOT_ROM_END                        0x7FF
#define APP_RESET_VECTOR                    0x800
#define APP_HIGH_INTERRUPT_VECTOR           0x808
#define APP_LOW_INTERRUPT_VECTOR            0x818
#define APP_FLASH_DATA                      0x1F800
#define APP_ROM_END                         0x1FBFF
#define PIC_LAST_PAGE                       0x1FC00
#define PIC_CONFIG_WORDS                    0x1FFF8;
#define PIC_ROM_END                         0x1FFFF;

#ifndef __PCH__
; Location and value of RAM key that indicates Application requested a bootload
#endif
#define BOOT_RAM_KEY_BYTE_0                 0xAB
#define BOOT_RAM_KEY_BYTE_1                 0xCD
#define BOOT_RAM_KEY_BYTE_2                 0xEF
#ifdef __PCH__
    #define BOOT_RAM_KEY_LOCATION           0x10            // Arbitrarily chosen location not reserved by the CCS compiler
    const int8 boot_ram_code[] =    {BOOT_RAM_KEY_BYTE_0, BOOT_RAM_KEY_BYTE_1, BOOT_RAM_KEY_BYTE_2};

    // This structure is used by the application to reboot in an organized way, and to set a special code for the bootloader to know
    // to enter bootloader mode upon reset. 
    typedef union
    {
        int8  _boot_ram_key[3];                     // Code to tell bootloader to enter bootload mode upon reboot
        int16 _app_reboot_flags;                    // Flags to indicate shutdown has been requested, and whether each task is ready for shutdown
    } BOOT_CONTROL_TYPE;
    #define BOOT_CONTROL_BOOTLOAD_REQUESTED ( 1 << 0 )  // Bit to indicate that a bootload has been requested 
    #define BOOT_CONTROL_DISALLOW_FLAGS     (~BOOT_CONTROL_BOOTLOAD_REQUESTED)  // Bit2 that allow processes to prevent a bootload until its safe to exit 
    #define BOOT_CONTROL_DISALLOW_TASK_1    ( 1 << 1 )  // Bit that allows task 1 to prevent a bootload until its safe to exit
    #define BOOT_CONTROL_DISALLOW_TASK_2    ( 1 << 2 )  // Bit that allows task 2 to prevent a bootload until its safe to exit
    #define BOOT_CONTROL_DISALLOW_TASK_3    ( 1 << 3 )  // Bit that allows task 3 to prevent a bootload until its safe to exit
#else
BOOT_RAM_KEY_LOCATION           EQU         H'0010'     ; Arbitrarily chosen location not reserved by the CCS compiler for the Application code
#endif

#ifndef __PCH__
; Location and value of ROM key that indicates Application is present.
#endif
#define APP_ROM_KEY_BYTE_0                  0x01
#define APP_ROM_KEY_BYTE_1                  0x23
#define APP_ROM_KEY_BYTE_2                  0x45
#define APP_ROM_KEY_BYTE_3                  0x67
#ifndef __PCH__
; This is the last item in program memory before the flash data storage space.
#endif
#define APP_ROM_KEY_LOCATION_UPPER_BYTE     0x01
#define APP_ROM_KEY_LOCATION_HIGH_BYTE      0xF7
#define APP_ROM_KEY_LOCATION_LOW_BYTE       0xFC
#ifdef __PCH__
    #define APP_ROM_KEY_LOCATION            ((APP_ROM_KEY_LOCATION_UPPER_BYTE << 16) + \
                                             (APP_ROM_KEY_LOCATION_HIGH_BYTE << 8) + \
                                             (APP_ROM_KEY_LOCATION_LOW_BYTE))
#endif

#ifndef __PCH__
; Location and value of Application revision.
; This is APP_ROM_KEY_LOCATION - sizeof(APP_FW_REV)
#endif
#define APP_FW_REV_LOCATION_UPPER_BYTE     0x01
#define APP_FW_REV_LOCATION_HIGH_BYTE      0xF7
#define APP_FW_REV_LOCATION_LOW_BYTE       0xF8
#ifdef __PCH__
    #define APP_FW_REV_LOCATION            ((APP_FW_REV_LOCATION_UPPER_BYTE << 16) + \
                                            (APP_FW_REV_LOCATION_HIGH_BYTE << 8) + \
                                            (APP_FW_REV_LOCATION_LOW_BYTE))
#endif

#endif