#ifndef __PIC18F47J53_REGISTERS_H__
#define __PIC18F47J53_REGISTERS_H__

#byte TOSU = 0xFFF
#word TOS = 0xFFE
#byte STKPTR = 0xFFC
#bit    STKPTR_SP0 = STKPTR.0
#bit    STKPTR_SP1 = STKPTR.1
#bit    STKPTR_SP2 = STKPTR.2
#bit    STKPTR_SP3 = STKPTR.3
#bit    STKPTR_SP4 = STKPTR.4
#bit    STKPTR_STKOVF = STKPTR.7
#byte STKPTR = 0xFFC
#bit    STKPTR_STKPTR0 = STKPTR.0
#bit    STKPTR_STKPTR1 = STKPTR.1
#bit    STKPTR_STKPTR2 = STKPTR.2
#bit    STKPTR_STKPTR3 = STKPTR.3
#bit    STKPTR_STKPTR4 = STKPTR.4
#bit    STKPTR_STKUNF = STKPTR.6
#bit    STKPTR_STKFUL = STKPTR.7
#byte PCLATU = 0xFFB
#byte PCLATH = 0xFFA
#byte PCL = 0xFF9
#byte TBLPTRU = 0xFF8
#bit    TBLPTRU_TBLPTRU0 = TBLPTRU.0
#bit    TBLPTRU_TBLPTRU1 = TBLPTRU.1
#bit    TBLPTRU_TBLPTRU2 = TBLPTRU.2
#bit    TBLPTRU_TBLPTRU3 = TBLPTRU.3
#bit    TBLPTRU_TBLPTRU4 = TBLPTRU.4
#bit    TBLPTRU_ACSS = TBLPTRU.5
#word TBLPTR = 0xFF7
#byte TABLAT = 0xFF5
#word PROD = 0xFF4
#byte INTCON = 0xFF2
#bit    INTCON_INT0F = INTCON.1
#bit    INTCON_T0IF = INTCON.2
#bit    INTCON_INT0E = INTCON.4
#bit    INTCON_T0IE = INTCON.5
#bit    INTCON_PEIE = INTCON.6
#bit    INTCON_GIE = INTCON.7
#byte INTCON = 0xFF2
#bit    INTCON_GIEL = INTCON.6
#bit    INTCON_GIEH = INTCON.7
#byte INTCON = 0xFF2
#bit    INTCON_RBIF = INTCON.0
#bit    INTCON_INT0IF = INTCON.1
#bit    INTCON_TMR0IF = INTCON.2
#bit    INTCON_RBIE = INTCON.3
#bit    INTCON_INT0IE = INTCON.4
#bit    INTCON_TMR0IE = INTCON.5
#bit    INTCON_PEIE_GIEL = INTCON.6
#bit    INTCON_GIE_GIEH = INTCON.7
#byte INTCON2 = 0xFF1
#bit    INTCON2_RBIP = INTCON2.0
#bit    INTCON2_INT3IP = INTCON2.1
#bit    INTCON2_TMR0IP = INTCON2.2
#bit    INTCON2_INTEDG3 = INTCON2.3
#bit    INTCON2_INTEDG2 = INTCON2.4
#bit    INTCON2_INTEDG1 = INTCON2.5
#bit    INTCON2_INTEDG0 = INTCON2.6
#bit    INTCON2_RBPU = INTCON2.7
#byte INTCON2 = 0xFF1
#bit    INTCON2_INT3P = INTCON2.1
#bit    INTCON2_T0IP = INTCON2.2
#byte INTCON3 = 0xFF0
#bit    INTCON3_INT1IF = INTCON3.0
#bit    INTCON3_INT2IF = INTCON3.1
#bit    INTCON3_INT3IF = INTCON3.2
#bit    INTCON3_INT1IE = INTCON3.3
#bit    INTCON3_INT2IE = INTCON3.4
#bit    INTCON3_INT3IE = INTCON3.5
#bit    INTCON3_INT1IP = INTCON3.6
#bit    INTCON3_INT2IP = INTCON3.7
#byte INTCON3 = 0xFF0
#bit    INTCON3_INT1F = INTCON3.0
#bit    INTCON3_INT2F = INTCON3.1
#bit    INTCON3_INT3F = INTCON3.2
#bit    INTCON3_INT1E = INTCON3.3
#bit    INTCON3_INT2E = INTCON3.4
#bit    INTCON3_INT3E = INTCON3.5
#bit    INTCON3_INT1P = INTCON3.6
#bit    INTCON3_INT2P = INTCON3.7
#byte INDF0 = 0xFEF
#byte POSTINC0 = 0xFEE
#byte POSTDEC0 = 0xFED
#byte PREINC0 = 0xFEC
#byte PLUSW0 = 0xFEB
#word FSR0 = 0xFEA
#byte WREG = 0xFE8
#byte INDF1 = 0xFE7
#byte POSTINC1 = 0xFE6
#byte POSTDEC1 = 0xFE5
#byte PREINC1 = 0xFE4
#byte PLUSW1 = 0xFE3
#word FSR1 = 0xFE2
#byte BSR = 0xFE0
#byte INDF2 = 0xFDF
#byte POSTINC2 = 0xFDE
#byte POSTDEC2 = 0xFDD
#byte PREINC2 = 0xFDC
#byte PLUSW2 = 0xFDB
#word FSR2 = 0xFDA
#byte STATUS = 0xFD8
#bit    STATUS_C = STATUS.0
#bit    STATUS_DC = STATUS.1
#bit    STATUS_Z = STATUS.2
#bit    STATUS_OV = STATUS.3
#bit    STATUS_N = STATUS.4
#word TMR0 = 0xFD7
#byte TMR0_H = 0xFD7
#byte TMR0_L = 0xFD6
#byte T0CON = 0xFD5
#bit    T0CON_T0PS0 = T0CON.0
#bit    T0CON_T0PS1 = T0CON.1
#bit    T0CON_T0PS2 = T0CON.2
#bit    T0CON_PSA = T0CON.3
#bit    T0CON_T0SE = T0CON.4
#bit    T0CON_T0CS = T0CON.5
#bit    T0CON_T08BIT = T0CON.6
#bit    T0CON_TMR0ON = T0CON.7
#byte OSCCON = 0xFD3
#bit    OSCCON_SCS0 = OSCCON.0
#bit    OSCCON_SCS1 = OSCCON.1
#bit    OSCCON_FLTS = OSCCON.2
#bit    OSCCON_OSTS = OSCCON.3
#bit    OSCCON_IRCF0 = OSCCON.4
#bit    OSCCON_IRCF1 = OSCCON.5
#bit    OSCCON_IRCF2 = OSCCON.6
#bit    OSCCON_IDLEN = OSCCON.7
#byte CM1CON = 0xFD2
#bit    CM1CON_CCH0 = CM1CON.0
#bit    CM1CON_CCH1 = CM1CON.1
#bit    CM1CON_CREF = CM1CON.2
#bit    CM1CON_EVPOL0 = CM1CON.3
#bit    CM1CON_EVPOL1 = CM1CON.4
#bit    CM1CON_CPOL = CM1CON.5
#bit    CM1CON_COE = CM1CON.6
#bit    CM1CON_CON = CM1CON.7
#byte CM2CON = 0xFD1
#bit    CM2CON_CCH0 = CM2CON.0
#bit    CM2CON_CCH1 = CM2CON.1
#bit    CM2CON_CREF = CM2CON.2
#bit    CM2CON_EVPOL0 = CM2CON.3
#bit    CM2CON_EVPOL1 = CM2CON.4
#bit    CM2CON_CPOL = CM2CON.5
#bit    CM2CON_COE = CM2CON.6
#bit    CM2CON_CON = CM2CON.7
#byte RCON = 0xFD0
#bit    RCON_BOR = RCON.0
#bit    RCON_POR = RCON.1
#bit    RCON_PD = RCON.2
#bit    RCON_TO = RCON.3
#bit    RCON_RI = RCON.4
#bit    RCON_CM = RCON.5
#bit    RCON_IPEN = RCON.7
#word TMR1 = 0xFCF
#byte TMR1_H = 0xFCF
#byte TMR1_L = 0xFCE
#byte T1CON = 0xFCD
#bit    T1CON_TMR1ON = T1CON.0
#bit    T1CON_RD16 = T1CON.1
#bit    T1CON_T1SYNC = T1CON.2
#bit    T1CON_T1OSCEN = T1CON.3
#bit    T1CON_T1CKPS0 = T1CON.4
#bit    T1CON_T1CKPS1 = T1CON.5
#bit    T1CON_TMR1CS0 = T1CON.6
#bit    T1CON_TMR1CS1 = T1CON.7
#byte TMR2 = 0xFCC
#byte PR2 = 0xFCB
#byte T2CON = 0xFCA
#bit    T2CON_T2CKPS0 = T2CON.0
#bit    T2CON_T2CKPS1 = T2CON.1
#bit    T2CON_TMR2ON = T2CON.2
#bit    T2CON_T2OUTPS0 = T2CON.3
#bit    T2CON_T2OUTPS1 = T2CON.4
#bit    T2CON_T2OUTPS2 = T2CON.5
#bit    T2CON_T2OUTPS3 = T2CON.6
#byte SSP1BUF = 0xFC9
#byte SSP1ADD = 0xFC8
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_W = SSP1STAT.2
#bit    SSP1STAT_A = SSP1STAT.5
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_WRITE = SSP1STAT.2
#bit    SSP1STAT_ADDRESS = SSP1STAT.5
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_READ_WRITE = SSP1STAT.2
#bit    SSP1STAT_I2C_START = SSP1STAT.3
#bit    SSP1STAT_I2C_STOP = SSP1STAT.4
#bit    SSP1STAT_DATA_ADDRESS = SSP1STAT.5
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_I2C_READ = SSP1STAT.2
#bit    SSP1STAT_I2C_DAT = SSP1STAT.5
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_R_W = SSP1STAT.2
#bit    SSP1STAT_D_A = SSP1STAT.5
#byte SSP1STAT = 0xFC7
#bit    SSP1STAT_BF = SSP1STAT.0
#bit    SSP1STAT_UA = SSP1STAT.1
#bit    SSP1STAT_R = SSP1STAT.2
#bit    SSP1STAT_S = SSP1STAT.3
#bit    SSP1STAT_P = SSP1STAT.4
#bit    SSP1STAT_D = SSP1STAT.5
#bit    SSP1STAT_CKE = SSP1STAT.6
#bit    SSP1STAT_SMP = SSP1STAT.7
#byte SSP1CON1 = 0xFC6
#bit    SSP1CON1_SSPM0 = SSP1CON1.0
#bit    SSP1CON1_SSPM1 = SSP1CON1.1
#bit    SSP1CON1_SSPM2 = SSP1CON1.2
#bit    SSP1CON1_SSPM3 = SSP1CON1.3
#bit    SSP1CON1_CKP = SSP1CON1.4
#bit    SSP1CON1_SSPEN = SSP1CON1.5
#bit    SSP1CON1_SSPOV = SSP1CON1.6
#bit    SSP1CON1_WCOL = SSP1CON1.7
#byte SSP1CON2 = 0xFC5
#bit    SSP1CON2_ADMSK1 = SSP1CON2.1
#bit    SSP1CON2_ADMSK2 = SSP1CON2.2
#bit    SSP1CON2_ADMSK3 = SSP1CON2.3
#bit    SSP1CON2_ADMSK4 = SSP1CON2.4
#bit    SSP1CON2_ADMSK5 = SSP1CON2.5
#byte SSP1CON2 = 0xFC5
#bit    SSP1CON2_SEN = SSP1CON2.0
#bit    SSP1CON2_RSEN = SSP1CON2.1
#bit    SSP1CON2_PEN = SSP1CON2.2
#bit    SSP1CON2_RCEN = SSP1CON2.3
#bit    SSP1CON2_ACKEN = SSP1CON2.4
#bit    SSP1CON2_ACKDT = SSP1CON2.5
#bit    SSP1CON2_ACKSTAT = SSP1CON2.6
#bit    SSP1CON2_GCEN = SSP1CON2.7
#word ADRES = 0xFC4
#byte ADRESH = 0xFC4
#byte ADRESL = 0xFC3
#byte ADCON0 = 0xFC2
#bit    ADCON0_GO_DONE = ADCON0.1
#byte ADCON0 = 0xFC2
#bit    ADCON0_ADON = ADCON0.0
#bit    ADCON0_GO = ADCON0.1
#bit    ADCON0_CHS0 = ADCON0.2
#bit    ADCON0_CHS1 = ADCON0.3
#bit    ADCON0_CHS2 = ADCON0.4
#bit    ADCON0_CHS3 = ADCON0.5
#bit    ADCON0_VCFG0 = ADCON0.6
#bit    ADCON0_VCFG1 = ADCON0.7
#byte ADCON0 = 0xFC2
#bit    ADCON0_DONE = ADCON0.1
#byte ADCON1 = 0xFC1
#bit    ADCON1_ADCS0 = ADCON1.0
#bit    ADCON1_ADCS1 = ADCON1.1
#bit    ADCON1_ADCS2 = ADCON1.2
#bit    ADCON1_ACQT0 = ADCON1.3
#bit    ADCON1_ACQT1 = ADCON1.4
#bit    ADCON1_ACQT2 = ADCON1.5
#bit    ADCON1_ADCAL = ADCON1.6
#bit    ADCON1_ADFM = ADCON1.7
#byte WDTCON = 0xFC0
#bit    WDTCON_SWDTE = WDTCON.0
#byte WDTCON = 0xFC0
#bit    WDTCON_SWDTEN = WDTCON.0
#bit    WDTCON_ULPSINK = WDTCON.1
#bit    WDTCON_ULPEN = WDTCON.2
#bit    WDTCON_DS = WDTCON.3
#bit    WDTCON_VBGOE = WDTCON.4
#bit    WDTCON_ULPLVL = WDTCON.5
#bit    WDTCON_LVDSTAT = WDTCON.6
#bit    WDTCON_REGSLP = WDTCON.7
#byte PSTR1CON = 0xFBF
#bit    PSTR1CON_STRA = PSTR1CON.0
#bit    PSTR1CON_STRB = PSTR1CON.1
#bit    PSTR1CON_STRC = PSTR1CON.2
#bit    PSTR1CON_STRD = PSTR1CON.3
#bit    PSTR1CON_STRSYNC = PSTR1CON.4
#bit    PSTR1CON_CMPL0 = PSTR1CON.6
#bit    PSTR1CON_CMPL1 = PSTR1CON.7
#byte ECCP1AS = 0xFBE
#bit    ECCP1AS_PSS1BD0 = ECCP1AS.0
#bit    ECCP1AS_PSS1BD1 = ECCP1AS.1
#bit    ECCP1AS_PSS1AC0 = ECCP1AS.2
#bit    ECCP1AS_PSS1AC1 = ECCP1AS.3
#bit    ECCP1AS_ECCP1AS0 = ECCP1AS.4
#bit    ECCP1AS_ECCP1AS1 = ECCP1AS.5
#bit    ECCP1AS_ECCP1AS2 = ECCP1AS.6
#bit    ECCP1AS_ECCP1ASE = ECCP1AS.7
#byte ECCP1DEL = 0xFBD
#bit    ECCP1DEL_P1DC0 = ECCP1DEL.0
#bit    ECCP1DEL_P1DC1 = ECCP1DEL.1
#bit    ECCP1DEL_P1DC2 = ECCP1DEL.2
#bit    ECCP1DEL_P1DC3 = ECCP1DEL.3
#bit    ECCP1DEL_P1DC4 = ECCP1DEL.4
#bit    ECCP1DEL_P1DC5 = ECCP1DEL.5
#bit    ECCP1DEL_P1DC6 = ECCP1DEL.6
#bit    ECCP1DEL_P1RSEN = ECCP1DEL.7
#word CCPR1 = 0xFBC
#byte CCP1CON = 0xFBA
#bit    CCP1CON_CCP1Y = CCP1CON.4
#bit    CCP1CON_CCP1X = CCP1CON.5
#byte CCP1CON = 0xFBA
#bit    CCP1CON_CCP1M0 = CCP1CON.0
#bit    CCP1CON_CCP1M1 = CCP1CON.1
#bit    CCP1CON_CCP1M2 = CCP1CON.2
#bit    CCP1CON_CCP1M3 = CCP1CON.3
#bit    CCP1CON_DC1B0 = CCP1CON.4
#bit    CCP1CON_DC1B1 = CCP1CON.5
#bit    CCP1CON_P1M0 = CCP1CON.6
#bit    CCP1CON_P1M1 = CCP1CON.7
#byte PSTR2CON = 0xFB9
#bit    PSTR2CON_STRA = PSTR2CON.0
#bit    PSTR2CON_STRB = PSTR2CON.1
#bit    PSTR2CON_STRC = PSTR2CON.2
#bit    PSTR2CON_STRD = PSTR2CON.3
#bit    PSTR2CON_STRSYNC = PSTR2CON.4
#bit    PSTR2CON_CMPL0 = PSTR2CON.6
#bit    PSTR2CON_CMPL1 = PSTR2CON.7
#byte ECCP2AS = 0xFB8
#bit    ECCP2AS_PSS2BD0 = ECCP2AS.0
#bit    ECCP2AS_PSS2BD1 = ECCP2AS.1
#bit    ECCP2AS_PSS2AC0 = ECCP2AS.2
#bit    ECCP2AS_PSS2AC1 = ECCP2AS.3
#bit    ECCP2AS_ECCP2AS0 = ECCP2AS.4
#bit    ECCP2AS_ECCP2AS1 = ECCP2AS.5
#bit    ECCP2AS_ECCP2AS2 = ECCP2AS.6
#bit    ECCP2AS_ECCP2ASE = ECCP2AS.7
#byte ECCP2DEL = 0xFB7
#bit    ECCP2DEL_P2DC0 = ECCP2DEL.0
#bit    ECCP2DEL_P2DC1 = ECCP2DEL.1
#bit    ECCP2DEL_P2DC2 = ECCP2DEL.2
#bit    ECCP2DEL_P2DC3 = ECCP2DEL.3
#bit    ECCP2DEL_P2DC4 = ECCP2DEL.4
#bit    ECCP2DEL_P2DC5 = ECCP2DEL.5
#bit    ECCP2DEL_P2DC6 = ECCP2DEL.6
#bit    ECCP2DEL_P2RSEN = ECCP2DEL.7
#word CCPR2 = 0xFB6
#byte CCP2CON = 0xFB4
#bit    CCP2CON_CCP2Y = CCP2CON.4
#bit    CCP2CON_CCP2X = CCP2CON.5
#byte CCP2CON = 0xFB4
#bit    CCP2CON_CCP2M0 = CCP2CON.0
#bit    CCP2CON_CCP2M1 = CCP2CON.1
#bit    CCP2CON_CCP2M2 = CCP2CON.2
#bit    CCP2CON_CCP2M3 = CCP2CON.3
#bit    CCP2CON_DC2B0 = CCP2CON.4
#bit    CCP2CON_DC2B1 = CCP2CON.5
#bit    CCP2CON_P2M0 = CCP2CON.6
#bit    CCP2CON_P2M1 = CCP2CON.7
#word CTMUCON = 0xFB3
#byte CTMUICON = 0xFB1
#bit    CTMUICON_IRNG0 = CTMUICON.0
#bit    CTMUICON_IRNG1 = CTMUICON.1
#bit    CTMUICON_ITRIM0 = CTMUICON.2
#bit    CTMUICON_ITRIM1 = CTMUICON.3
#bit    CTMUICON_ITRIM2 = CTMUICON.4
#bit    CTMUICON_ITRIM3 = CTMUICON.5
#bit    CTMUICON_ITRIM4 = CTMUICON.6
#bit    CTMUICON_ITRIM5 = CTMUICON.7
#byte SPBRG1 = 0xFB0
#byte RCREG1 = 0xFAF
#byte TXREG1 = 0xFAE
#byte TXSTA1 = 0xFAD
#bit    TXSTA1_TX9D1 = TXSTA1.0
#bit    TXSTA1_TRMT1 = TXSTA1.1
#bit    TXSTA1_BRGH1 = TXSTA1.2
#bit    TXSTA1_SENDB1 = TXSTA1.3
#bit    TXSTA1_SYNC1 = TXSTA1.4
#bit    TXSTA1_TXEN1 = TXSTA1.5
#bit    TXSTA1_TX8 = TXSTA1.6
#bit    TXSTA1_CSRC1 = TXSTA1.7
#byte TXSTA1 = 0xFAD
#bit    TXSTA1_TX9D = TXSTA1.0
#bit    TXSTA1_TRMT = TXSTA1.1
#bit    TXSTA1_BRGH = TXSTA1.2
#bit    TXSTA1_SENDB = TXSTA1.3
#bit    TXSTA1_SYNC = TXSTA1.4
#bit    TXSTA1_TXEN = TXSTA1.5
#bit    TXSTA1_TX9 = TXSTA1.6
#bit    TXSTA1_CSRC = TXSTA1.7
#byte TXSTA1 = 0xFAD
#bit    TXSTA1_TXD8 = TXSTA1.0
#bit    TXSTA1_TX8_9 = TXSTA1.6
#byte RCSTA1 = 0xFAC
#bit    RCSTA1_RC8 = RCSTA1.6
#byte RCSTA1 = 0xFAC
#bit    RCSTA1_RX9D1 = RCSTA1.0
#bit    RCSTA1_OERR1 = RCSTA1.1
#bit    RCSTA1_FERR1 = RCSTA1.2
#bit    RCSTA1_ADDEN1 = RCSTA1.3
#bit    RCSTA1_CREN1 = RCSTA1.4
#bit    RCSTA1_SREN1 = RCSTA1.5
#bit    RCSTA1_RC8_9 = RCSTA1.6
#bit    RCSTA1_SPEN1 = RCSTA1.7
#byte RCSTA1 = 0xFAC
#bit    RCSTA1_RCD8 = RCSTA1.0
#bit    RCSTA1_ADEN = RCSTA1.3
#bit    RCSTA1_RC9 = RCSTA1.6
#byte RCSTA1 = 0xFAC
#bit    RCSTA1_RX9D = RCSTA1.0
#bit    RCSTA1_OERR = RCSTA1.1
#bit    RCSTA1_FERR = RCSTA1.2
#bit    RCSTA1_ADDEN = RCSTA1.3
#bit    RCSTA1_CREN = RCSTA1.4
#bit    RCSTA1_SREN = RCSTA1.5
#bit    RCSTA1_RX9 = RCSTA1.6
#bit    RCSTA1_SPEN = RCSTA1.7
#byte SPBRG2 = 0xFAB
#byte RCREG2 = 0xFAA
#byte TXREG2 = 0xFA9
#byte TXSTA2 = 0xFA8
#bit    TXSTA2_TX9D2 = TXSTA2.0
#bit    TXSTA2_TRMT2 = TXSTA2.1
#bit    TXSTA2_BRGH2 = TXSTA2.2
#bit    TXSTA2_SENDB2 = TXSTA2.3
#bit    TXSTA2_SYNC2 = TXSTA2.4
#bit    TXSTA2_TXEN2 = TXSTA2.5
#bit    TXSTA2_TX92 = TXSTA2.6
#bit    TXSTA2_CSRC2 = TXSTA2.7
#byte TXSTA2 = 0xFA8
#bit    TXSTA2_TX9D = TXSTA2.0
#bit    TXSTA2_TRMT = TXSTA2.1
#bit    TXSTA2_BRGH = TXSTA2.2
#bit    TXSTA2_SENDB = TXSTA2.3
#bit    TXSTA2_SYNC = TXSTA2.4
#bit    TXSTA2_TXEN = TXSTA2.5
#bit    TXSTA2_TX9 = TXSTA2.6
#bit    TXSTA2_CSRC = TXSTA2.7
#byte EECON2 = 0xFA7
#byte EECON1 = 0xFA6
#bit    EECON1_WR = EECON1.1
#bit    EECON1_WREN = EECON1.2
#bit    EECON1_WRERR = EECON1.3
#bit    EECON1_FREE = EECON1.4
#bit    EECON1_WPROG = EECON1.5
#byte IPR3 = 0xFA5
#bit    IPR3_RTCCIP = IPR3.0
#bit    IPR3_TMR3GIP = IPR3.1
#bit    IPR3_CTMUIP = IPR3.2
#bit    IPR3_TMR4IP = IPR3.3
#bit    IPR3_TX2IP = IPR3.4
#bit    IPR3_RC2IP = IPR3.5
#bit    IPR3_BCL2IP = IPR3.6
#bit    IPR3_SSP2IP = IPR3.7
#byte PIR3 = 0xFA4
#bit    PIR3_RTCCIF = PIR3.0
#bit    PIR3_TMR3GIF = PIR3.1
#bit    PIR3_CTMUIF = PIR3.2
#bit    PIR3_TMR4IF = PIR3.3
#bit    PIR3_TX2IF = PIR3.4
#bit    PIR3_RC2IF = PIR3.5
#bit    PIR3_BCL2IF = PIR3.6
#bit    PIR3_SSP2IF = PIR3.7
#byte PIE3 = 0xFA3
#bit    PIE3_RTCCIE = PIE3.0
#bit    PIE3_TMR3GIE = PIE3.1
#bit    PIE3_CTMUIE = PIE3.2
#bit    PIE3_TMR4IE = PIE3.3
#bit    PIE3_TX2IE = PIE3.4
#bit    PIE3_RC2IE = PIE3.5
#bit    PIE3_BCL2IE = PIE3.6
#bit    PIE3_SSP2IE = PIE3.7
#byte IPR2 = 0xFA2
#bit    IPR2_CCP2IP = IPR2.0
#bit    IPR2_TMR3IP = IPR2.1
#bit    IPR2_LVDIP = IPR2.2
#bit    IPR2_BCL1IP = IPR2.3
#bit    IPR2_USBIP = IPR2.4
#bit    IPR2_CM1IP = IPR2.5
#bit    IPR2_CM2IP = IPR2.6
#bit    IPR2_OSCFIP = IPR2.7
#byte IPR2 = 0xFA2
#bit    IPR2_HLVDIP = IPR2.2
#bit    IPR2_BCLIP = IPR2.3
#byte PIR2 = 0xFA1
#bit    PIR2_CCP2IF = PIR2.0
#bit    PIR2_TMR3IF = PIR2.1
#bit    PIR2_LVDIF = PIR2.2
#bit    PIR2_BCL1IF = PIR2.3
#bit    PIR2_USBIF = PIR2.4
#bit    PIR2_CM1IF = PIR2.5
#bit    PIR2_CM2IF = PIR2.6
#bit    PIR2_OSCFIF = PIR2.7
#byte PIR2 = 0xFA1
#bit    PIR2_HLVDIF = PIR2.2
#bit    PIR2_BCLIF = PIR2.3
#byte PIE2 = 0xFA0
#bit    PIE2_HLVDIE = PIE2.2
#bit    PIE2_BCLIE = PIE2.3
#byte PIE2 = 0xFA0
#bit    PIE2_CCP2IE = PIE2.0
#bit    PIE2_TMR3IE = PIE2.1
#bit    PIE2_LVDIE = PIE2.2
#bit    PIE2_BCL1IE = PIE2.3
#bit    PIE2_USBIE = PIE2.4
#bit    PIE2_CM1IE = PIE2.5
#bit    PIE2_CM2IE = PIE2.6
#bit    PIE2_OSCFIE = PIE2.7
#byte IPR1 = 0xF9F
#bit    IPR1_SSPIP = IPR1.3
#bit    IPR1_TXIP = IPR1.4
#bit    IPR1_RCIP = IPR1.5
#byte IPR1 = 0xF9F
#bit    IPR1_TMR1IP = IPR1.0
#bit    IPR1_TMR2IP = IPR1.1
#bit    IPR1_CCP1IP = IPR1.2
#bit    IPR1_SSP1IP = IPR1.3
#bit    IPR1_TX1IP = IPR1.4
#bit    IPR1_RC1IP = IPR1.5
#bit    IPR1_ADIP = IPR1.6
#bit    IPR1_PMPIP = IPR1.7
#byte PIR1 = 0xF9E
#bit    PIR1_SSPIF = PIR1.3
#bit    PIR1_TXIF = PIR1.4
#bit    PIR1_RCIF = PIR1.5
#byte PIR1 = 0xF9E
#bit    PIR1_TMR1IF = PIR1.0
#bit    PIR1_TMR2IF = PIR1.1
#bit    PIR1_CCP1IF = PIR1.2
#bit    PIR1_SSP1IF = PIR1.3
#bit    PIR1_TX1IF = PIR1.4
#bit    PIR1_RC1IF = PIR1.5
#bit    PIR1_ADIF = PIR1.6
#bit    PIR1_PMPIF = PIR1.7
#byte PIE1 = 0xF9D
#bit    PIE1_TMR1IE = PIE1.0
#bit    PIE1_TMR2IE = PIE1.1
#bit    PIE1_CCP1IE = PIE1.2
#bit    PIE1_SSP1IE = PIE1.3
#bit    PIE1_TX1IE = PIE1.4
#bit    PIE1_RC1IE = PIE1.5
#bit    PIE1_ADIE = PIE1.6
#bit    PIE1_PMPIE = PIE1.7
#byte PIE1 = 0xF9D
#bit    PIE1_SSPIE = PIE1.3
#bit    PIE1_TXIE = PIE1.4
#bit    PIE1_RCIE = PIE1.5
#byte RCSTA2 = 0xF9C
#bit    RCSTA2_RX9D = RCSTA2.0
#bit    RCSTA2_OERR = RCSTA2.1
#bit    RCSTA2_FERR = RCSTA2.2
#bit    RCSTA2_ADDEN = RCSTA2.3
#bit    RCSTA2_CREN = RCSTA2.4
#bit    RCSTA2_SREN = RCSTA2.5
#bit    RCSTA2_RX9 = RCSTA2.6
#bit    RCSTA2_SPEN = RCSTA2.7
#byte RCSTA2 = 0xF9C
#bit    RCSTA2_RX9D2 = RCSTA2.0
#bit    RCSTA2_OERR2 = RCSTA2.1
#bit    RCSTA2_FERR2 = RCSTA2.2
#bit    RCSTA2_ADDEN2 = RCSTA2.3
#bit    RCSTA2_CREN2 = RCSTA2.4
#bit    RCSTA2_SREN2 = RCSTA2.5
#bit    RCSTA2_RX92 = RCSTA2.6
#bit    RCSTA2_SPEN2 = RCSTA2.7
#byte OSCTUNE = 0xF9B
#bit    OSCTUNE_TUN0 = OSCTUNE.0
#bit    OSCTUNE_TUN1 = OSCTUNE.1
#bit    OSCTUNE_TUN2 = OSCTUNE.2
#bit    OSCTUNE_TUN3 = OSCTUNE.3
#bit    OSCTUNE_TUN4 = OSCTUNE.4
#bit    OSCTUNE_TUN5 = OSCTUNE.5
#bit    OSCTUNE_PLLEN = OSCTUNE.6
#bit    OSCTUNE_INTSRC = OSCTUNE.7
#byte T1GCON = 0xF9A
#bit    T1GCON_T1DONE = T1GCON.3
#byte T1GCON = 0xF9A
#bit    T1GCON_T1GSS0 = T1GCON.0
#bit    T1GCON_T1GSS1 = T1GCON.1
#bit    T1GCON_T1GVAL = T1GCON.2
#bit    T1GCON_T1GGO = T1GCON.3
#bit    T1GCON_T1GSPM = T1GCON.4
#bit    T1GCON_T1GTM = T1GCON.5
#bit    T1GCON_T1GPOL = T1GCON.6
#bit    T1GCON_TMR1GE = T1GCON.7
#byte IPR5 = 0xF99
#bit    IPR5_TMR1GIP = IPR5.0
#bit    IPR5_TMR5GIP = IPR5.1
#bit    IPR5_TMR5IP = IPR5.2
#bit    IPR5_TMR6IP = IPR5.3
#bit    IPR5_TMR8IP = IPR5.4
#bit    IPR5_CM3IP = IPR5.5
#byte PIR5 = 0xF98
#bit    PIR5_TMR1GIF = PIR5.0
#bit    PIR5_TMR5GIF = PIR5.1
#bit    PIR5_TMR5IF = PIR5.2
#bit    PIR5_TMR6IF = PIR5.3
#bit    PIR5_TMR8IF = PIR5.4
#bit    PIR5_CM3IF = PIR5.5
#byte T3GCON = 0xF97
#bit    T3GCON_T3GGO = T3GCON.3
#byte T3GCON = 0xF97
#bit    T3GCON_T3DONE = T3GCON.3
#byte T3GCON = 0xF97
#bit    T3GCON_T3GSS0 = T3GCON.0
#bit    T3GCON_T3GSS1 = T3GCON.1
#bit    T3GCON_T3GVAL = T3GCON.2
#bit    T3GCON_T3GGO_T3DONE = T3GCON.3
#bit    T3GCON_T3GSPM = T3GCON.4
#bit    T3GCON_T3GTM = T3GCON.5
#bit    T3GCON_T3GPOL = T3GCON.6
#bit    T3GCON_TMR3GE = T3GCON.7
#byte TRISE = 0xF96
#bit    TRISE_TRISE0 = TRISE.0
#bit    TRISE_TRISE1 = TRISE.1
#bit    TRISE_TRISE2 = TRISE.2
#bit    TRISE_REPU = TRISE.6
#bit    TRISE_RDPU = TRISE.7
#byte TRISD = 0xF95
#bit    TRISD_TRISD0 = TRISD.0
#bit    TRISD_TRISD1 = TRISD.1
#bit    TRISD_TRISD2 = TRISD.2
#bit    TRISD_TRISD3 = TRISD.3
#bit    TRISD_TRISD4 = TRISD.4
#bit    TRISD_TRISD5 = TRISD.5
#bit    TRISD_TRISD6 = TRISD.6
#bit    TRISD_TRISD7 = TRISD.7
#byte TRISC = 0xF94
#bit    TRISC_TRISC0 = TRISC.0
#bit    TRISC_TRISC1 = TRISC.1
#bit    TRISC_TRISC2 = TRISC.2
#bit    TRISC_TRISC6 = TRISC.6
#bit    TRISC_TRISC7 = TRISC.7
#byte TRISB = 0xF93
#bit    TRISB_TRISB0 = TRISB.0
#bit    TRISB_TRISB1 = TRISB.1
#bit    TRISB_TRISB2 = TRISB.2
#bit    TRISB_TRISB4 = TRISB.4
#bit    TRISB_TRISB3 = TRISB.3
#bit    TRISB_TRISB5 = TRISB.5
#bit    TRISB_TRISB6 = TRISB.6
#bit    TRISB_TRISB7 = TRISB.7
#byte TRISA = 0xF92
#bit    TRISA_TRISA0 = TRISA.0
#bit    TRISA_TRISA1 = TRISA.1
#bit    TRISA_TRISA2 = TRISA.2
#bit    TRISA_TRISA3 = TRISA.3
#bit    TRISA_TRISA5 = TRISA.5
#bit    TRISA_TRISA6 = TRISA.6
#bit    TRISA_TRISA7 = TRISA.7
#byte PIE5 = 0xF91
#bit    PIE5_TMR1GIE = PIE5.0
#bit    PIE5_TMR5GIE = PIE5.1
#bit    PIE5_TMR5IE = PIE5.2
#bit    PIE5_TMR6IE = PIE5.3
#bit    PIE5_TMR8IE = PIE5.4
#bit    PIE5_CM3IE = PIE5.5
#byte IPR4 = 0xF90
#bit    IPR4_CCP3IP = IPR4.0
#bit    IPR4_CCP4IP = IPR4.1
#bit    IPR4_CCP5IP = IPR4.2
#bit    IPR4_CCP6IP = IPR4.3
#bit    IPR4_CCP7IP = IPR4.4
#bit    IPR4_CCP8IP = IPR4.5
#bit    IPR4_CCP9IP = IPR4.6
#bit    IPR4_CCP10IP = IPR4.7
#byte PIR4 = 0xF8F
#bit    PIR4_CCP3IF = PIR4.0
#bit    PIR4_CCP4IF = PIR4.1
#bit    PIR4_CCP5IF = PIR4.2
#bit    PIR4_CCP6IF = PIR4.3
#bit    PIR4_CCP7IF = PIR4.4
#bit    PIR4_CCP8IF = PIR4.5
#bit    PIR4_CCP9IF = PIR4.6
#bit    PIR4_CCP10IF = PIR4.7
#byte PIE4 = 0xF8E
#bit    PIE4_CCP3IE = PIE4.0
#bit    PIE4_CCP4IE = PIE4.1
#bit    PIE4_CCP5IE = PIE4.2
#bit    PIE4_CCP6IE = PIE4.3
#bit    PIE4_CCP7IE = PIE4.4
#bit    PIE4_CCP8IE = PIE4.5
#bit    PIE4_CCP9IE = PIE4.6
#bit    PIE4_CCP10IE = PIE4.7
#byte LATE = 0xF8D
#bit    LATE_LATE0 = LATE.0
#bit    LATE_LATE1 = LATE.1
#bit    LATE_LATE2 = LATE.2
#byte LATD = 0xF8C
#bit    LATD_LATD0 = LATD.0
#bit    LATD_LATD1 = LATD.1
#bit    LATD_LATD2 = LATD.2
#bit    LATD_LATD3 = LATD.3
#bit    LATD_LATD4 = LATD.4
#bit    LATD_LATD5 = LATD.5
#bit    LATD_LATD6 = LATD.6
#bit    LATD_LATD7 = LATD.7
#byte LATC = 0xF8B
#bit    LATC_LATC0 = LATC.0
#bit    LATC_LATC1 = LATC.1
#bit    LATC_LATC2 = LATC.2
#bit    LATC_LATC6 = LATC.6
#bit    LATC_LATC7 = LATC.7
#byte LATB = 0xF8A
#bit    LATB_LATB0 = LATB.0
#bit    LATB_LATB1 = LATB.1
#bit    LATB_LATB2 = LATB.2
#bit    LATB_LATB3 = LATB.3
#bit    LATB_LATB4 = LATB.4
#bit    LATB_LATB5 = LATB.5
#bit    LATB_LATB6 = LATB.6
#bit    LATB_LATB7 = LATB.7
#byte LATA = 0xF89
#bit    LATA_LATA0 = LATA.0
#bit    LATA_LATA1 = LATA.1
#bit    LATA_LATA2 = LATA.2
#bit    LATA_LATA3 = LATA.3
#bit    LATA_LATA5 = LATA.5
#bit    LATA_LATA6 = LATA.6
#bit    LATA_LATA7 = LATA.7
#byte DMACON1 = 0xF88
#bit    DMACON1_DMAEN = DMACON1.0
#bit    DMACON1_DLYINTEN = DMACON1.1
#bit    DMACON1_DUPLEX0 = DMACON1.2
#bit    DMACON1_DUPLEX1 = DMACON1.3
#bit    DMACON1_RXINC = DMACON1.4
#bit    DMACON1_TXINC = DMACON1.5
#bit    DMACON1_SSCON0 = DMACON1.6
#bit    DMACON1_SSCON1 = DMACON1.7
#byte OSCCON2 = 0xF87
#bit    OSCCON2_PRISD = OSCCON2.2
#bit    OSCCON2_SOSCGO = OSCCON2.3
#bit    OSCCON2_SOSCDRV = OSCCON2.4
#bit    OSCCON2_SOSCRUN = OSCCON2.6
#byte DMACON2 = 0xF86
#bit    DMACON2_INTLVL0 = DMACON2.0
#bit    DMACON2_INTLVL1 = DMACON2.1
#bit    DMACON2_INTLVL2 = DMACON2.2
#bit    DMACON2_INTLVL3 = DMACON2.3
#bit    DMACON2_DLYCYC0 = DMACON2.4
#bit    DMACON2_DLYCYC1 = DMACON2.5
#bit    DMACON2_DLYCYC2 = DMACON2.6
#bit    DMACON2_DLYCYC3 = DMACON2.7
#byte HLVDCON = 0xF85
#bit    HLVDCON_HLVDL0 = HLVDCON.0
#bit    HLVDCON_HLVDL1 = HLVDCON.1
#bit    HLVDCON_HLVDL2 = HLVDCON.2
#bit    HLVDCON_HLVDL3 = HLVDCON.3
#bit    HLVDCON_HLVDEN = HLVDCON.4
#bit    HLVDCON_IRVST = HLVDCON.5
#bit    HLVDCON_BGVST = HLVDCON.6
#bit    HLVDCON_VDIRMAG = HLVDCON.7
#byte PORTE = 0xF84
#byte PORTD = 0xF83
#bit    PORTD_RD0 = PORTD.0
#bit    PORTD_RD1 = PORTD.1
#bit    PORTD_RD2 = PORTD.2
#bit    PORTD_RD4 = PORTD.4
#bit    PORTD_RD5 = PORTD.5
#bit    PORTD_RD6 = PORTD.6
#bit    PORTD_RD7 = PORTD.7
#byte PORTC = 0xF82
#bit    PORTC_RC0 = PORTC.0
#bit    PORTC_RC1 = PORTC.1
#bit    PORTC_RC2 = PORTC.2
#bit    PORTC_RC4 = PORTC.4
#bit    PORTC_RC5 = PORTC.5
#bit    PORTC_RC6 = PORTC.6
#bit    PORTC_RC7 = PORTC.7
#byte PORTB = 0xF81
#byte PORTA = 0xF80
#bit    PORTA_RA0 = PORTA.0
#bit    PORTA_RA1 = PORTA.1
#bit    PORTA_RA2 = PORTA.2
#bit    PORTA_RA3 = PORTA.3
#bit    PORTA_RA5 = PORTA.5
#bit    PORTA_RA6 = PORTA.6
#bit    PORTA_RA7 = PORTA.7
#byte SPBRGH1 = 0xF7F
#byte BAUDCON1 = 0xF7E
#bit    BAUDCON1_ABDEN = BAUDCON1.0
#bit    BAUDCON1_WUE = BAUDCON1.1
#bit    BAUDCON1_BRG16 = BAUDCON1.3
#bit    BAUDCON1_TXCKP = BAUDCON1.4
#bit    BAUDCON1_RXDTP = BAUDCON1.5
#bit    BAUDCON1_RCIDL = BAUDCON1.6
#bit    BAUDCON1_ABDOVF = BAUDCON1.7
#byte SPBRGH2 = 0xF7D
#byte BAUDCON2 = 0xF7C
#bit    BAUDCON2_ABDEN = BAUDCON2.0
#bit    BAUDCON2_WUE = BAUDCON2.1
#bit    BAUDCON2_BRG16 = BAUDCON2.3
#bit    BAUDCON2_TXCKP = BAUDCON2.4
#bit    BAUDCON2_RXDTP = BAUDCON2.5
#bit    BAUDCON2_RCIDL = BAUDCON2.6
#bit    BAUDCON2_ABDOVF = BAUDCON2.7
#word TMR3 = 0xF7B
#byte T3CON = 0xF79
#bit    T3CON_TMR3ON = T3CON.0
#bit    T3CON_RD16 = T3CON.1
#bit    T3CON_T3SYNC = T3CON.2
#bit    T3CON_T3OSCEN = T3CON.3
#bit    T3CON_T3CKPS0 = T3CON.4
#bit    T3CON_T3CKPS1 = T3CON.5
#bit    T3CON_TMR3CS0 = T3CON.6
#bit    T3CON_TMR3CS1 = T3CON.7
#byte TMR4 = 0xF78
#byte PR4 = 0xF77
#byte T4CON = 0xF76
#bit    T4CON_T4CKPS0 = T4CON.0
#bit    T4CON_T4CKPS1 = T4CON.1
#bit    T4CON_TMR4ON = T4CON.2
#bit    T4CON_T4OUTPS0 = T4CON.3
#bit    T4CON_T4OUTPS1 = T4CON.4
#bit    T4CON_T4OUTPS2 = T4CON.5
#bit    T4CON_T4OUTPS3 = T4CON.6
#byte SSP2BUF = 0xF75
#byte SSP2ADD = 0xF74
#byte SSP2STAT = 0xF73
#bit    SSP2STAT_BF = SSP2STAT.0
#bit    SSP2STAT_UA = SSP2STAT.1
#bit    SSP2STAT_R = SSP2STAT.2
#bit    SSP2STAT_S = SSP2STAT.3
#bit    SSP2STAT_P = SSP2STAT.4
#bit    SSP2STAT_D = SSP2STAT.5
#bit    SSP2STAT_CKE = SSP2STAT.6
#bit    SSP2STAT_SMP = SSP2STAT.7
#byte SSP2CON1 = 0xF72
#bit    SSP2CON1_SSPM0 = SSP2CON1.0
#bit    SSP2CON1_SSPM1 = SSP2CON1.1
#bit    SSP2CON1_SSPM2 = SSP2CON1.2
#bit    SSP2CON1_SSPM3 = SSP2CON1.3
#bit    SSP2CON1_CKP = SSP2CON1.4
#bit    SSP2CON1_SSPEN = SSP2CON1.5
#bit    SSP2CON1_SSPOV = SSP2CON1.6
#bit    SSP2CON1_WCOL = SSP2CON1.7
#byte SSP2CON2 = 0xF71
#bit    SSP2CON2_ADMSK1 = SSP2CON2.1
#bit    SSP2CON2_ADMSK2 = SSP2CON2.2
#bit    SSP2CON2_ADMSK3 = SSP2CON2.3
#bit    SSP2CON2_ADMSK4 = SSP2CON2.4
#bit    SSP2CON2_ADMSK5 = SSP2CON2.5
#byte SSP2CON2 = 0xF71
#bit    SSP2CON2_SEN = SSP2CON2.0
#bit    SSP2CON2_RSEN = SSP2CON2.1
#bit    SSP2CON2_PEN = SSP2CON2.2
#bit    SSP2CON2_RCEN = SSP2CON2.3
#bit    SSP2CON2_ACKEN = SSP2CON2.4
#bit    SSP2CON2_ACKDT = SSP2CON2.5
#bit    SSP2CON2_ACKSTAT = SSP2CON2.6
#bit    SSP2CON2_GCEN = SSP2CON2.7
#byte CMSTAT = 0xF70
#bit    CMSTAT_COUT1 = CMSTAT.0
#bit    CMSTAT_COUT2 = CMSTAT.1
#bit    CMSTAT_COUT3 = CMSTAT.2
#word PMADDR = 0xF6F
#word PMDIN1 = 0xF6D
#byte TXADDRL = 0xF6B
#byte TXADDRH = 0xF6A
#byte RXADDRL = 0xF69
#byte RXADDRH = 0xF68
#byte DMABCL = 0xF67
#byte DMABCH = 0xF66

/*
#byte UCON = 0xF65
#bit    UCON_SUSPND = UCON.1
#bit    UCON_RESUME = UCON.2
#bit    UCON_USBEN = UCON.3
#bit    UCON_PKTDIS = UCON.4
#bit    UCON_SE0 = UCON.5
#bit    UCON_PPBRST = UCON.6
#byte USTAT = 0xF64
#bit    USTAT_PPBI = USTAT.1
#bit    USTAT_DIR = USTAT.2
#bit    USTAT_ENDP0 = USTAT.3
#bit    USTAT_ENDP1 = USTAT.4
#bit    USTAT_ENDP2 = USTAT.5
#bit    USTAT_ENDP3 = USTAT.6
#byte UEIR = 0xF63
#bit    UEIR_PIDEF = UEIR.0
#bit    UEIR_CRC5EF = UEIR.1
#bit    UEIR_CRC16EF = UEIR.2
#bit    UEIR_DFN8EF = UEIR.3
#bit    UEIR_BTOEF = UEIR.4
#bit    UEIR_BTSEF = UEIR.7
#byte UIR = 0xF62
#bit    UIR_URSTIF = UIR.0
#bit    UIR_UERRIF = UIR.1
#bit    UIR_ACTVIF = UIR.2
#bit    UIR_TRNIF = UIR.3
#bit    UIR_IDLEIF = UIR.4
#bit    UIR_STALLIF = UIR.5
#bit    UIR_SOFIF = UIR.6
*/

#word UFRM = 0xF61
#word PMCON = 0xF5F
#word PMMODE = 0xF5D
#word PMDOUT2 = 0xF5B
#word PMDIN2 = 0xF59
#word PME = 0xF57
#word PMSTAT = 0xF55
#byte CVRCON = 0xF53
#bit    CVRCON_CVR0 = CVRCON.0
#bit    CVRCON_CVR1 = CVRCON.1
#bit    CVRCON_CVR2 = CVRCON.2
#bit    CVRCON_CVR3 = CVRCON.3
#bit    CVRCON_CVRSS = CVRCON.4
#bit    CVRCON_CVRR = CVRCON.5
#bit    CVRCON_CVROE = CVRCON.6
#bit    CVRCON_CVREN = CVRCON.7
#byte CCPTMRS0 = 0xF52
#bit    CCPTMRS0_C1TSEL0 = CCPTMRS0.0
#bit    CCPTMRS0_C1TSEL1 = CCPTMRS0.1
#bit    CCPTMRS0_C1TSEL2 = CCPTMRS0.2
#bit    CCPTMRS0_C2TSEL0 = CCPTMRS0.3
#bit    CCPTMRS0_C2TSEL1 = CCPTMRS0.4
#bit    CCPTMRS0_C2TSEL2 = CCPTMRS0.5
#bit    CCPTMRS0_C3TSEL0 = CCPTMRS0.6
#bit    CCPTMRS0_C3TSEL1 = CCPTMRS0.7
#byte CCPTMRS1 = 0xF51
#bit    CCPTMRS1_C4TSEL0 = CCPTMRS1.0
#bit    CCPTMRS1_C4TSEL1 = CCPTMRS1.1
#bit    CCPTMRS1_C5TSEL0 = CCPTMRS1.2
#bit    CCPTMRS1_C6TSEL0 = CCPTMRS1.4
#bit    CCPTMRS1_C7TSEL0 = CCPTMRS1.6
#bit    CCPTMRS1_C7TSEL1 = CCPTMRS1.7
#byte CCPTMRS2 = 0xF50
#bit    CCPTMRS2_C8TSEL0 = CCPTMRS2.0
#bit    CCPTMRS2_C8TSEL1 = CCPTMRS2.1
#bit    CCPTMRS2_C9TSEL0 = CCPTMRS2.2
#bit    CCPTMRS2_C10TSEL0 = CCPTMRS2.4
#byte DSGPR1 = 0xF4F
#word DSCON = 0xF4D
#word DSWAKE = 0xF4B
#byte ANCON1 = 0xF49
#bit    ANCON1_PCFG8 = ANCON1.0
#bit    ANCON1_PCFG9 = ANCON1.1
#bit    ANCON1_PCFG10 = ANCON1.2
#bit    ANCON1_PCFG11 = ANCON1.3
#bit    ANCON1_PCFG12 = ANCON1.4
#bit    ANCON1_VBGEN = ANCON1.7
#byte ANCON0 = 0xF48
#byte ALRMCFG = 0xF47
#bit    ALRMCFG_ALRMPTR0 = ALRMCFG.0
#bit    ALRMCFG_ALRMPTR1 = ALRMCFG.1
#bit    ALRMCFG_AMASK0 = ALRMCFG.2
#bit    ALRMCFG_AMASK1 = ALRMCFG.3
#bit    ALRMCFG_AMASK2 = ALRMCFG.4
#bit    ALRMCFG_AMASK3 = ALRMCFG.5
#bit    ALRMCFG_CHIME = ALRMCFG.6
#bit    ALRMCFG_ALRMEN = ALRMCFG.7
#byte ALRMRPT = 0xF46
#word ALRMVAL = 0xF45
#byte ODCON1 = 0xF42
#bit    ODCON1_ECCP1OD = ODCON1.0
#bit    ODCON1_ECCP2OD = ODCON1.1
#bit    ODCON1_ECCP3OD = ODCON1.2
#bit    ODCON1_CCP4OD = ODCON1.3
#bit    ODCON1_CCP5OD = ODCON1.4
#bit    ODCON1_CCP6OD = ODCON1.5
#bit    ODCON1_CCP7OD = ODCON1.6
#bit    ODCON1_CCP8OD = ODCON1.7
#byte ODCON2 = 0xF41
#bit    ODCON2_U1OD = ODCON2.0
#bit    ODCON2_U2OD = ODCON2.1
#bit    ODCON2_CCP9OD = ODCON2.2
#bit    ODCON2_CCP10OD = ODCON2.3
#byte ODCON3 = 0xF40
#bit    ODCON3_SPI1OD = ODCON3.0
#bit    ODCON3_SPI2OD = ODCON3.1
#byte RTCCFG = 0xF3F
#bit    RTCCFG_RTCPTR0 = RTCCFG.0
#bit    RTCCFG_RTCPTR1 = RTCCFG.1
#bit    RTCCFG_RTCOE = RTCCFG.2
#bit    RTCCFG_HALFSEC = RTCCFG.3
#bit    RTCCFG_RTCSYNC = RTCCFG.4
#bit    RTCCFG_RTCWREN = RTCCFG.5
#bit    RTCCFG_RTCEN = RTCCFG.7
#byte RTCCAL = 0xF3E
#byte REFOCON = 0xF3D
#bit    REFOCON_RODIV0 = REFOCON.0
#bit    REFOCON_RODIV1 = REFOCON.1
#bit    REFOCON_RODIV2 = REFOCON.2
#bit    REFOCON_RODIV3 = REFOCON.3
#bit    REFOCON_ROSEL = REFOCON.4
#bit    REFOCON_ROSSLP = REFOCON.5
#bit    REFOCON_ROON = REFOCON.7
#byte PADCFG1 = 0xF3C
#bit    PADCFG1_PMPTTL = PADCFG1.0
#bit    PADCFG1_RTSECSEL0 = PADCFG1.1
#bit    PADCFG1_RTSECSEL1 = PADCFG1.2
#word RTCVAL = 0xF3B
#byte UCFG = 0xF39
#bit    UCFG_PPB0 = UCFG.0
#bit    UCFG_PPB1 = UCFG.1
#bit    UCFG_FSEN = UCFG.2
#bit    UCFG_UTRDIS = UCFG.3
#bit    UCFG_UPUEN = UCFG.4
#bit    UCFG_UOEMON = UCFG.6
#bit    UCFG_UTEYE = UCFG.7
#byte UADDR = 0xF38
#byte UEIE = 0xF37
#bit    UEIE_PIDEE = UEIE.0
#bit    UEIE_CRC5EE = UEIE.1
#bit    UEIE_CRC16EE = UEIE.2
#bit    UEIE_DFN8EE = UEIE.3
#bit    UEIE_BTOEE = UEIE.4
#bit    UEIE_BTSEE = UEIE.7
#byte UIE = 0xF36
#bit    UIE_URSTIE = UIE.0
#bit    UIE_UERRIE = UIE.1
#bit    UIE_ACTVIE = UIE.2
#bit    UIE_TRNIE = UIE.3
#bit    UIE_IDLEIE = UIE.4
#bit    UIE_STALLIE = UIE.5
#bit    UIE_SOFIE = UIE.6
#byte UEP15 = 0xF35
#bit    UEP15_EPSTALL = UEP15.0
#bit    UEP15_EPINEN = UEP15.1
#bit    UEP15_EPOUTEN = UEP15.2
#bit    UEP15_EPCONDIS = UEP15.3
#bit    UEP15_EPHSHK = UEP15.4
#byte UEP14 = 0xF34
#bit    UEP14_EPSTALL = UEP14.0
#bit    UEP14_EPINEN = UEP14.1
#bit    UEP14_EPOUTEN = UEP14.2
#bit    UEP14_EPCONDIS = UEP14.3
#bit    UEP14_EPHSHK = UEP14.4
#byte UEP13 = 0xF33
#bit    UEP13_EPSTALL = UEP13.0
#bit    UEP13_EPINEN = UEP13.1
#bit    UEP13_EPOUTEN = UEP13.2
#bit    UEP13_EPCONDIS = UEP13.3
#bit    UEP13_EPHSHK = UEP13.4
#byte UEP12 = 0xF32
#bit    UEP12_EPSTALL = UEP12.0
#bit    UEP12_EPINEN = UEP12.1
#bit    UEP12_EPOUTEN = UEP12.2
#bit    UEP12_EPCONDIS = UEP12.3
#bit    UEP12_EPHSHK = UEP12.4
#byte UEP11 = 0xF31
#bit    UEP11_EPSTALL = UEP11.0
#bit    UEP11_EPINEN = UEP11.1
#bit    UEP11_EPOUTEN = UEP11.2
#bit    UEP11_EPCONDIS = UEP11.3
#bit    UEP11_EPHSHK = UEP11.4
#byte UEP10 = 0xF30
#bit    UEP10_EPSTALL = UEP10.0
#bit    UEP10_EPINEN = UEP10.1
#bit    UEP10_EPOUTEN = UEP10.2
#bit    UEP10_EPCONDIS = UEP10.3
#bit    UEP10_EPHSHK = UEP10.4
#byte UEP9 = 0xF2F
#bit    UEP9_EPSTALL = UEP9.0
#bit    UEP9_EPINEN = UEP9.1
#bit    UEP9_EPOUTEN = UEP9.2
#bit    UEP9_EPCONDIS = UEP9.3
#bit    UEP9_EPHSHK = UEP9.4
#byte UEP8 = 0xF2E
#bit    UEP8_EPSTALL = UEP8.0
#bit    UEP8_EPINEN = UEP8.1
#bit    UEP8_EPOUTEN = UEP8.2
#bit    UEP8_EPCONDIS = UEP8.3
#bit    UEP8_EPHSHK = UEP8.4
#byte UEP7 = 0xF2D
#bit    UEP7_EPSTALL = UEP7.0
#bit    UEP7_EPINEN = UEP7.1
#bit    UEP7_EPOUTEN = UEP7.2
#bit    UEP7_EPCONDIS = UEP7.3
#bit    UEP7_EPHSHK = UEP7.4
#byte UEP6 = 0xF2C
#bit    UEP6_EPSTALL = UEP6.0
#bit    UEP6_EPINEN = UEP6.1
#bit    UEP6_EPOUTEN = UEP6.2
#bit    UEP6_EPCONDIS = UEP6.3
#bit    UEP6_EPHSHK = UEP6.4
#byte UEP5 = 0xF2B
#bit    UEP5_EPSTALL = UEP5.0
#bit    UEP5_EPINEN = UEP5.1
#bit    UEP5_EPOUTEN = UEP5.2
#bit    UEP5_EPCONDIS = UEP5.3
#bit    UEP5_EPHSHK = UEP5.4
#byte UEP4 = 0xF2A
#bit    UEP4_EPSTALL = UEP4.0
#bit    UEP4_EPINEN = UEP4.1
#bit    UEP4_EPOUTEN = UEP4.2
#bit    UEP4_EPCONDIS = UEP4.3
#bit    UEP4_EPHSHK = UEP4.4
#byte UEP3 = 0xF29
#bit    UEP3_EPSTALL = UEP3.0
#bit    UEP3_EPINEN = UEP3.1
#bit    UEP3_EPOUTEN = UEP3.2
#bit    UEP3_EPCONDIS = UEP3.3
#bit    UEP3_EPHSHK = UEP3.4
#byte UEP2 = 0xF28
#bit    UEP2_EPSTALL = UEP2.0
#bit    UEP2_EPINEN = UEP2.1
#bit    UEP2_EPOUTEN = UEP2.2
#bit    UEP2_EPCONDIS = UEP2.3
#bit    UEP2_EPHSHK = UEP2.4
#byte UEP1 = 0xF27
#bit    UEP1_EPSTALL = UEP1.0
#bit    UEP1_EPINEN = UEP1.1
#bit    UEP1_EPOUTEN = UEP1.2
#bit    UEP1_EPCONDIS = UEP1.3
#bit    UEP1_EPHSHK = UEP1.4
#byte UEP0 = 0xF26
#bit    UEP0_EPSTALL = UEP0.0
#bit    UEP0_EPINEN = UEP0.1
#bit    UEP0_EPOUTEN = UEP0.2
#bit    UEP0_EPCONDIS = UEP0.3
#bit    UEP0_EPHSHK = UEP0.4
#byte CM3CON = 0xF25
#bit    CM3CON_CCH0 = CM3CON.0
#bit    CM3CON_CCH1 = CM3CON.1
#bit    CM3CON_CREF = CM3CON.2
#bit    CM3CON_EVPOL0 = CM3CON.3
#bit    CM3CON_EVPOL1 = CM3CON.4
#bit    CM3CON_CPOL = CM3CON.5
#bit    CM3CON_COE = CM3CON.6
#bit    CM3CON_CON = CM3CON.7
#word TMR5 = 0xF24
#byte T5CON = 0xF22
#bit    T5CON_TMR5ON = T5CON.0
#bit    T5CON_RD16 = T5CON.1
#bit    T5CON_T5SYNC = T5CON.2
#bit    T5CON_T5OSCEN = T5CON.3
#bit    T5CON_T5CKPS0 = T5CON.4
#bit    T5CON_T5CKPS1 = T5CON.5
#bit    T5CON_TMR5CS0 = T5CON.6
#bit    T5CON_TMR5CS1 = T5CON.7
#byte T5GCON = 0xF21
#bit    T5GCON_T5GSS0 = T5GCON.0
#bit    T5GCON_T5GSS1 = T5GCON.1
#bit    T5GCON_T5GVAL = T5GCON.2
#bit    T5GCON_T5GGO = T5GCON.3
#bit    T5GCON_T5GSPM = T5GCON.4
#bit    T5GCON_T5GTM = T5GCON.5
#bit    T5GCON_T5GPOL = T5GCON.6
#bit    T5GCON_TMR5GE = T5GCON.7
#byte T5GCON = 0xF21
#bit    T5GCON_T5DONE = T5GCON.3
#byte TMR6 = 0xF20
#byte PR6 = 0xF1F
#byte T6CON = 0xF1E
#bit    T6CON_T6CKPS0 = T6CON.0
#bit    T6CON_T6CKPS1 = T6CON.1
#bit    T6CON_TMR6ON = T6CON.2
#bit    T6CON_T6OUTPS0 = T6CON.3
#bit    T6CON_T6OUTPS1 = T6CON.4
#bit    T6CON_T6OUTPS2 = T6CON.5
#bit    T6CON_T6OUTPS3 = T6CON.6
#byte TMR8 = 0xF1D
#byte PR8 = 0xF1C
#byte T8CON = 0xF1B
#bit    T8CON_T8CKPS0 = T8CON.0
#bit    T8CON_T8CKPS1 = T8CON.1
#bit    T8CON_TMR8ON = T8CON.2
#bit    T8CON_T8OUTPS0 = T8CON.3
#bit    T8CON_T8OUTPS1 = T8CON.4
#bit    T8CON_T8OUTPS2 = T8CON.5
#bit    T8CON_T8OUTPS3 = T8CON.6
#byte PSTR3CON = 0xF1A
#bit    PSTR3CON_STRA = PSTR3CON.0
#bit    PSTR3CON_STRB = PSTR3CON.1
#bit    PSTR3CON_STRC = PSTR3CON.2
#bit    PSTR3CON_STRD = PSTR3CON.3
#bit    PSTR3CON_STRSYNC = PSTR3CON.4
#bit    PSTR3CON_CMPL0 = PSTR3CON.6
#bit    PSTR3CON_CMPL1 = PSTR3CON.7
#byte ECCP3AS = 0xF19
#bit    ECCP3AS_PSS3BD0 = ECCP3AS.0
#bit    ECCP3AS_PSS3BD1 = ECCP3AS.1
#bit    ECCP3AS_PSS3AC0 = ECCP3AS.2
#bit    ECCP3AS_PSS3AC1 = ECCP3AS.3
#bit    ECCP3AS_ECCP3AS0 = ECCP3AS.4
#bit    ECCP3AS_ECCP3AS1 = ECCP3AS.5
#bit    ECCP3AS_ECCP3AS2 = ECCP3AS.6
#bit    ECCP3AS_ECCP3ASE = ECCP3AS.7
#byte ECCP3DEL = 0xF18
#bit    ECCP3DEL_P3DC0 = ECCP3DEL.0
#bit    ECCP3DEL_P3DC1 = ECCP3DEL.1
#bit    ECCP3DEL_P3DC2 = ECCP3DEL.2
#bit    ECCP3DEL_P3DC3 = ECCP3DEL.3
#bit    ECCP3DEL_P3DC4 = ECCP3DEL.4
#bit    ECCP3DEL_P3DC5 = ECCP3DEL.5
#bit    ECCP3DEL_P3DC6 = ECCP3DEL.6
#bit    ECCP3DEL_P3RSEN = ECCP3DEL.7
#word CCPR3 = 0xF17
#byte CCP3CON = 0xF15
#bit    CCP3CON_CCP3M0 = CCP3CON.0
#bit    CCP3CON_CCP3M1 = CCP3CON.1
#bit    CCP3CON_CCP3M2 = CCP3CON.2
#bit    CCP3CON_CCP3M3 = CCP3CON.3
#bit    CCP3CON_DC3B0 = CCP3CON.4
#bit    CCP3CON_DC3B1 = CCP3CON.5
#bit    CCP3CON_P3M0 = CCP3CON.6
#bit    CCP3CON_P3M1 = CCP3CON.7
#word CCPR4 = 0xF14
#byte CCP4CON = 0xF12
#bit    CCP4CON_CCP4M0 = CCP4CON.0
#bit    CCP4CON_CCP4M1 = CCP4CON.1
#bit    CCP4CON_CCP4M2 = CCP4CON.2
#bit    CCP4CON_CCP4M3 = CCP4CON.3
#bit    CCP4CON_DC4B0 = CCP4CON.4
#bit    CCP4CON_DC4B1 = CCP4CON.5
#word CCPR5 = 0xF11
#byte CCP5CON = 0xF0F
#bit    CCP5CON_CCP5M0 = CCP5CON.0
#bit    CCP5CON_CCP5M1 = CCP5CON.1
#bit    CCP5CON_CCP5M2 = CCP5CON.2
#bit    CCP5CON_CCP5M3 = CCP5CON.3
#bit    CCP5CON_DC5B0 = CCP5CON.4
#bit    CCP5CON_DC5B1 = CCP5CON.5
#word CCPR6 = 0xF0E
#byte CCP6CON = 0xF0C
#bit    CCP6CON_CCP6M0 = CCP6CON.0
#bit    CCP6CON_CCP6M1 = CCP6CON.1
#bit    CCP6CON_CCP6M2 = CCP6CON.2
#bit    CCP6CON_CCP6M3 = CCP6CON.3
#bit    CCP6CON_DC6B0 = CCP6CON.4
#bit    CCP6CON_DC6B1 = CCP6CON.5
#word CCPR7 = 0xF0B
#byte CCP7CON = 0xF09
#bit    CCP7CON_CCP7M0 = CCP7CON.0
#bit    CCP7CON_CCP7M1 = CCP7CON.1
#bit    CCP7CON_CCP7M2 = CCP7CON.2
#bit    CCP7CON_CCP7M3 = CCP7CON.3
#bit    CCP7CON_DC7B0 = CCP7CON.4
#bit    CCP7CON_DC7B1 = CCP7CON.5
#word CCPR8 = 0xF08
#byte CCP8CON = 0xF06
#bit    CCP8CON_CCP8M0 = CCP8CON.0
#bit    CCP8CON_CCP8M1 = CCP8CON.1
#bit    CCP8CON_CCP8M2 = CCP8CON.2
#bit    CCP8CON_CCP8M3 = CCP8CON.3
#bit    CCP8CON_DC8B0 = CCP8CON.4
#bit    CCP8CON_DC8B1 = CCP8CON.5
#word CCPR9 = 0xF05
#byte CCP9CON = 0xF03
#bit    CCP9CON_CCP9M0 = CCP9CON.0
#bit    CCP9CON_CCP9M1 = CCP9CON.1
#bit    CCP9CON_CCP9M2 = CCP9CON.2
#bit    CCP9CON_CCP9M3 = CCP9CON.3
#bit    CCP9CON_DC9B0 = CCP9CON.4
#bit    CCP9CON_DC9B1 = CCP9CON.5
#word CCPR10 = 0xF02
#byte CCP10CON = 0xF00
#bit    CCP10CON_CCP10M0 = CCP10CON.0
#bit    CCP10CON_CCP10M1 = CCP10CON.1
#bit    CCP10CON_CCP10M2 = CCP10CON.2
#bit    CCP10CON_CCP10M3 = CCP10CON.3
#bit    CCP10CON_DC10B0 = CCP10CON.4
#bit    CCP10CON_DC10B1 = CCP10CON.5
#byte RPINR24 = 0xEFF
#byte RPINR23 = 0xEFE
#byte RPINR22 = 0xEFD
#byte RPINR21 = 0xEFC
#byte RPINR17 = 0xEF8
#byte RPINR16 = 0xEF7
#byte RPINR14 = 0xEF4
#byte RPINR13 = 0xEF3
#byte RPINR12 = 0xEF2
#byte RPINR9 = 0xEEA
#byte RPINR8 = 0xEE9
#byte RPINR7 = 0xEE8
#byte RPINR15 = 0xEE7
#byte RPINR6 = 0xEE6
#byte RPINR4 = 0xEE4
#byte RPINR3 = 0xEE3
#byte RPINR2 = 0xEE2
#byte RPINR1 = 0xEE1
#byte RPOR24 = 0xED8
#byte RPOR23 = 0xED7
#byte RPOR22 = 0xED6
#byte RPOR21 = 0xED5
#byte RPOR20 = 0xED4
#byte RPOR19 = 0xED3
#byte RPOR18 = 0xED2
#byte RPOR17 = 0xED1
#byte RPOR13 = 0xECD
#byte RPOR12 = 0xECC
#byte RPOR11 = 0xECB
#byte RPOR10 = 0xECA
#byte RPOR9 = 0xEC9
#byte RPOR8 = 0xEC8
#byte RPOR7 = 0xEC7
#byte RPOR6 = 0xEC6
#byte RPOR5 = 0xEC5
#byte RPOR4 = 0xEC4
#byte RPOR3 = 0xEC3
#byte RPOR2 = 0xEC2
#byte RPOR1 = 0xEC1
#byte RPOR0 = 0xEC0
#byte PPSCON = 0xEBF
#bit    PPSCON_IOLOCK = PPSCON.0
#byte PMDIS3 = 0xEBC
#bit    PMDIS3_CCP4MD = PMDIS3.1
#bit    PMDIS3_CCP5MD = PMDIS3.2
#bit    PMDIS3_CCP6MD = PMDIS3.3
#bit    PMDIS3_CCP7MD = PMDIS3.4
#bit    PMDIS3_CCP8MD = PMDIS3.5
#bit    PMDIS3_CCP9MD = PMDIS3.6
#bit    PMDIS3_CCP10MD = PMDIS3.7
#byte PMDIS2 = 0xEBB
#bit    PMDIS2_CMP1MD = PMDIS2.0
#bit    PMDIS2_CMP2MD = PMDIS2.1
#bit    PMDIS2_CMP3MD = PMDIS2.2
#bit    PMDIS2_TMR5MD = PMDIS2.3
#bit    PMDIS2_TMR6MD = PMDIS2.4
#bit    PMDIS2_TMR8MD = PMDIS2.6
#byte PMDIS1 = 0xEBA
#bit    PMDIS1_TMR1MD = PMDIS1.1
#bit    PMDIS1_TMR2MD = PMDIS1.2
#bit    PMDIS1_TMR3MD = PMDIS1.3
#bit    PMDIS1_TMR4MD = PMDIS1.4
#bit    PMDIS1_RTCCMD = PMDIS1.5
#bit    PMDIS1_CTMUMD = PMDIS1.6
#bit    PMDIS1_PSPMD = PMDIS1.7
#byte PMDIS0 = 0xEB9
#bit    PMDIS0_PMDADC = PMDIS0.0
#bit    PMDIS0_PMDMSSP1 = PMDIS0.1
#bit    PMDIS0_PMDMSSP2 = PMDIS0.2
#bit    PMDIS0_PMDUART1 = PMDIS0.3
#bit    PMDIS0_PMDUART2 = PMDIS0.4
#bit    PMDIS0_PMDECCP1 = PMDIS0.5
#bit    PMDIS0_PMDECCP2 = PMDIS0.6
#bit    PMDIS0_PMDECCP3 = PMDIS0.7
#byte PMDIS0 = 0xEB9
#bit    PMDIS0_ADCMD = PMDIS0.0
#bit    PMDIS0_SPI1MD = PMDIS0.1
#bit    PMDIS0_SPI2MD = PMDIS0.2
#bit    PMDIS0_UART1MD = PMDIS0.3
#bit    PMDIS0_UART2MD = PMDIS0.4
#bit    PMDIS0_CCP1MD = PMDIS0.5
#bit    PMDIS0_CCP2MD = PMDIS0.6
#bit    PMDIS0_CCP3MD = PMDIS0.7
#byte ADCTRIG = 0xEB8

#endif
