/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Demo
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myTrace.h
*
* Description:    Trace buffer for debugging
*
* Revision History:
*
*   01/14/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#ifndef MYTRACE_H_
#define MYTRACE_H_

/* Set to 0 to remove the trace debugging capability */
#define TRACE_INCLUDE  0


#if TRACE_INCLUDE == 1

   #define TRACE_BUFF_SIZE  1024

   void TraceReset( void );
   void TraceByte( uint8_t Byte );
   void TraceWord( uint16_t Word );
   void TraceDWord( uint32_t DWord );

#else

   #define TRACE_BUFF_SIZE  0

   #define TraceReset()
   #define TraceByte( Byte )
   #define TraceWord( Word )
   #define TraceDWord( DWord )

#endif /* TRACE_INCLUDE */

#endif /* MYTRACE_H_ */
