/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Demo
*
* Copyright:      2012 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      I2C.h
*
* Description:    Use the I2C protocol to read and write registers on a device
*
* Revision History:
*
*   09/17/12  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

/* I2C Buses */
#define I2C_BUS_1   0
#define I2C_BUS_2   1

/* Return codes */
#define SUCCESS     0
#define FAILURE   (-1)
#define TRUE        1
#define FALSE       0

/* Prototypes */
void I2C_Init( void );
S8   I2C_ReadData(       U8 Bus, U8 Slave, U8 Register, U8 *Data, U8 DataLength );
S8   I2C_ReadDataWrite2( U8 Bus, U8 Slave, U8 Cmd0, U8 Cmd1, U8 *Data, U8 DataLength );
S8   I2C_WriteData(      U8 Bus, U8 Slave, U8 Register, U8 *Data, U8 DataLength );
S8   I2C_ReadByte(       U8 Bus, U8 Slave, U8 Register, U8 *Byte );
S8   I2C_WriteByte(      U8 Bus, U8 Slave, U8 Register, U8  Byte );
S8   I2C_SlavePresent(   U8 Bus, U8 Slave );

