/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myPacket.h
*
* Description:    Send and receive packets using the Data Logger Protocol
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#ifndef MYPACKET_H_
#define MYPACKET_H_


/* Requests */
#define REQ_GET_ID                       1
#define REQ_GET_VERSION                  2
#define REQ_GET_STATUS                   3
#define REQ_GET_TEMPERATURE              4
#define REQ_GET_HUMIDITY                 5
#define REQ_GET_TIME                     6
#define REQ_SET_TIME                     7
#define REQ_GET_TIME_ZONE                8
#define REQ_SET_TIME_ZONE                9
#define REQ_GET_SAMPLE_INTERVAL          10
#define REQ_SET_SAMPLE_INTERVAL          11
#define REQ_GET_HIGH_TEMP_THRESHOLD      12
#define REQ_SET_HIGH_TEMP_THRESHOLD      13
#define REQ_GET_LOW_TEMP_THRESHOLD       14
#define REQ_SET_LOW_TEMP_THRESHOLD       15
#define REQ_GET_HIGH_HUMIDITY_THRESHOLD  16
#define REQ_SET_HIGH_HUMIDITY_THRESHOLD  17
#define REQ_GET_LOW_HUMIDITY_THRESHOLD   18
#define REQ_SET_LOW_HUMIDITY_THRESHOLD   19
#define REQ_GET_LOGGING                  20
#define REQ_SET_LOGGING                  21
#define REQ_GET_SAMPLE_COUNT             22
#define REQ_GET_LOG                      23
#define REQ_ERASE_LOG                    24
#define REQ_SET_CONNECTED                25

/* Return codes */
#define PACKET_SUCCESS   0 
#define PACKET_FAILURE   1

#pragma pack(1)

/* Packet */
typedef struct
{
   uint8_t  Start;
   uint8_t  Request;
   uint16_t DataLength;
   int32_t  Parameter;
   uint8_t  Checksum;
} PACKET;

#pragma pack(0)

/* Prototypes */
int Packet_Receive( PACKET *pPacket );
int Packet_Send(    PACKET *pPacket );
int Packet_SendLog( PACKET *pPacket );


#endif /* MYPACKET_H_ */

