/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myI2C0.c
*
* Description:    Use the I2C protocol to read and write registers on a device
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#ifndef __MYI2C0_H__
#define __MYI2C0_H__

#include <stdbool.h>

// INCLUDE GENERATED CONTENT
#include "gI2C0.h"

/* I2C0 Buses */
#define I2C0_BUS_1   0
#define I2C0_BUS_2   1

/* I2C0 return codes */
#define I2C0_STATUS_SUCCESS      1
#define I2C0_STATUS_NONE         0
#define I2C0_STATUS_ADDR_NAK   (-1)
#define I2C0_STATUS_DATA_NAK   (-2)
#define I2C0_STATUS_TIMEOUT    (-3)
#define I2C0_STATUS_ARB_LOST   (-4)
#define I2C0_STATUS_BAD_LENGTH (-5)
#define I2C0_STATUS_BAD_BUS    (-6)

/* Read/write single-byte registers */
int  I2C0_ReadByte(  int Bus, uint8_t Slave, uint8_t Register, uint8_t *Byte );
int  I2C0_WriteByte( int Bus, uint8_t Slave, uint8_t Register, uint8_t  Byte );

/* Read/write multi-byte registers */
int  I2C0_ReadData(  int Bus, uint8_t Slave, uint8_t Register, uint8_t *Data, int DataLength );
int  I2C0_WriteData( int Bus, uint8_t Slave, uint8_t Register, uint8_t *Data, int DataLength );
int  I2C0_ReadDataWrite2( int Bus, uint8_t Slave, uint8_t Cmd0, uint8_t Cmd1, uint8_t *Data, int DataLength );

/* Generic read/write */
int  I2C0_Transfer(  int Bus, uint8_t Slave, uint8_t *Data, int WriteLength, int ReadLength );

/* Interrupt handlers */
void I2C0_tx_complete_handler(void);
void I2C0_rx_complete_handler(void);
void I2C0_ack_intr_handler(void);
void I2C0_stop_handler(void);
void I2C0_start_handler(void);
void I2C0_arb_lost_handler(void);
void I2C0_timer3_handler(void);

#endif //__MYI2C0_H__

