#include <LV8702_Lib.h>
#include <TimerOne.h>
#include <avr/wdt.h>
#define TIMER 50

// ---------------------------------------------------
// ======        Sample Sketch for GUI         =======
// ---------------------------------------------------

Lib_LV8702V lv8702v;
int wdCounter;

void setup()
{
  lv8702v.initLib();
  Serial.begin(lv8702v.DEFAULT_BAUDRATE);
  Timer1.initialize(TIMER); //micro Seconds
  Timer1.attachInterrupt(interrupt);
  wdt_enable(WDTO_8S);
}

void interrupt(){
  Timer1.initialize(lv8702v.timerFire());
}

void loop()
{
  wdCounter ++;
  if(wdCounter >= 5000){
    wdt_reset();
    wdCounter = 0;
  }
  lv8702v.guiSerialRead();
}

