/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2012 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      Progress.cs
*
* Description:    The Progress class displays the progress of getting log data
*
* Revision History:
*
*   10/08/12  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

using System;
using System.Windows.Forms;
using Silabs.DataLogger;    


namespace Silabs.DataLogger
{
    /* "Progress bar" dialog box */
    public partial class Progress : Form
    {
        DataLogger logger;

        /* Constructor */
        public Progress( DataLogger Logger )
        {
            InitializeComponent();
            logger = Logger;
        }

        /* The dialog box is shown */
        private void Progress_Shown(object sender, EventArgs e)
        {
            /* Get the log data from the Data Logger */
            logger.GetLog( progressBar1 );
            
            /* Close the dialog box */
            Close();
        }
    }
}

