/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myLog.h
*
* Description:    Save humidity and temperature samples in flash memory
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#ifndef MYLOG_H_
#define MYLOG_H_

#define MAX_SAMPLE_COUNT   8192
#define SAMPLE_SIZE        8        /* Number of 8-bit bytes in a sample */
#define PAGE_SIZE          512      /* Number of 16-bit half-words in a page */
#define LOG_ADDRESS        ((uint16_t*)0x00020000)

/* Where the next sample will be written */
extern uint16_t *pLog;

/* The number of samples in the log */
extern int SampleCount;

/* Prototypes */
uint32_t Log_Init( void );
void     Log_WriteSample( uint32_t Timestamp, int Temperature, int Humidity );
void     Log_Erase( void );
uint16_t Swap16( uint16_t HalfWord );
uint32_t Swap32( uint32_t Word );

#endif /* MYLOG_H_ */
