//-------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
//
//
// Original content and implementation provided by Silicon Laboratories
//-------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================

#include "gRTC0.h"
#include "gCPU.h"
#include <stdint.h>
#include <SI32_RTC_B_Type.h>
#include <si32_device.h>

//==============================================================================
// Configuration Functions
//==============================================================================

//==============================================================================
// 2nd Level Interrupt Handlers
//==============================================================================
extern void RTC0ALRM_alarm0_handler(void);

//==============================================================================
// 1st Level Interrupt Handlers
//==============================================================================
void RTC0ALRM_IRQHandler()
{
  if (SI32_RTC_B_is_alarm0_interrupt_pending(SI32_RTC_0))
  {
    RTC0ALRM_alarm0_handler();
  }
}

void RTC0_enter_default_mode()
{
  SI32_RTC_B_enable_high_speed_mode(SI32_RTC_0);

  // Crystal mode
  SI32_RTC_B_disable_auto_gain_control(SI32_RTC_0);
  SI32_RTC_B_enable_bias_doubler(SI32_RTC_0);
  SI32_RTC_B_enable_autostep(SI32_RTC_0);
  SI32_RTC_B_set_clock_source_rtc(SI32_RTC_0);
  SI32_RTC_B_enable_crystal_oscillator(SI32_RTC_0);
  SI32_RTC_B_enable_rtc_timer(SI32_RTC_0);

  // Wait at least 20 ms
  uint32_t now = get_msTicks();
  while (get_msTicks() <= now + 20);

  // Poll clock until stable
  while (!((SI32_RTC_B_is_external_oscillator_valid(SI32_RTC_0) == true)));

  // Poll load capacitance ready
  while (!((SI32_RTC_B_is_load_capacitance_ready(SI32_RTC_0) == true)));

  // (Recommended) Enable automatic gain control and disable bias doubling for maximum power savings
  SI32_RTC_B_enable_auto_gain_control(SI32_RTC_0);

  // (Recommended) Enable missing clock detector
  SI32_RTC_B_enable_missing_clock_detector(SI32_RTC_0);

  // Wait at least 2 ms
  now = get_msTicks();
  while (get_msTicks() <= now + 2);

  SI32_RTC_B_start_timer(SI32_RTC_0);
  SI32_RTC_B_enable_clock_out(SI32_RTC_0);
  SI32_RTC_B_enable_alarm0_auto_reset(SI32_RTC_0);
  SI32_RTC_B_write_alarm0(SI32_RTC_0, 32768);
  SI32_RTC_B_enable_alarm0(SI32_RTC_0);
  NVIC_ClearPendingIRQ(RTC0ALRM_IRQn);
  NVIC_EnableIRQ(RTC0ALRM_IRQn);
}


//==============================================================================
// Support Functions
//==============================================================================

