****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  TSB611 Spice macromodel subckt 
***
***   July 2015
****                      
************ CONNECTIONS: 
****                  NON-INVERTING INPUT
****                    |  INVERTING INPUT
****                    |   |     POSITIVE POWER SUPPLY
****                    |   |      |      NEGATIVE POWER SUPPLY
****                    |   |      |       |     OUTPUT  
****                    |   |      |       |      |     
****                    |   |      |       |      |  
.SUBCKT TSB611   VP  VM  VCCP VCCN  VS
    LOUT VZOUT 0 {LOUT}
    FIOUT 0 VZOUT VREADIO 1.0
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    M_NMOS1 VO_DIFF_PLUS NET0283 VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    VD_DN2 NET0266 0 DC 100.0m
    VD_DN1 NET0264 0 DC 100.0m
    V57 NET0242 NET0244 DC {VD_COMPENSAZIONE}
    VREADI_R1 VB NET386 DC 0
    V56 NET0280 NET0254 DC {VD_COMPENSAZIONE}
    VOS NET0283 NET0255 DC 0
    VPROT_IN_P_VCCP NET246 NET279 DC {V_DPROT}
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE}
    VREADIO NET0220 VS DC 0
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE}
    V_OUTVLIM_LOW NET256 NET257 DC {VD_COMPENSAZIONE}
    VPROT_IN_M_VCCN NET258 NET448 DC {V_DPROT}
    V_OUTVLIM_HIGH NET285 NET261 DC {VD_COMPENSAZIONE}
    VPROT_IN_P_VCCN NET262 NET263 DC {V_DPROT}
    VPROT_IN_M_VCCP NET434 NET269 DC {V_DPROT}
    DN2 NET0266 VN_MINUS DN
    DN1 NET0264 VN_PLUS DN
    D29 NET0244 VB DIODE_NOVd
    D28 VB NET0280 DIODE_NOVd
    DPROT_IN_M_VCCP VM NET269 DIODE_VLIM
    DPROT_IN_M_VCCN NET258 VM DIODE_VLIM
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    D_OUTVLIM_LOW NET257 VB_3 DIODE_NOVd
    DPROT_IN_P_VCCP NET0283 NET279 DIODE_VLIM
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    DPROT_IN_P_VCCN NET262 NET0283 DIODE_VLIM
    D_OUTVLIM_HIGH VB_3 NET285 DIODE_NOVd
    CZOUT_IOUT_COEFF VZOUT_IOUT_COEFF 0 1n
    COUT2 VZOUT 0 {COUT2}
    CIN_CM_VM VM VREF {CIN_CM_VM}
    CIN_CM_VP VP VREF {CIN_CM_VP}
    CIN_DIFF VM VP {CIN_DIFF}
    C_RO2_1 VB_2 VREF 30p
    COUT NET427 0 {COUT}
    CDIFF_PARASITIC VO_DIFF_PLUS VO_DIFF_MINUS 65p
    CCOMP VB VB_2 {CCOMP}
    EN NET0255 VP VN_PLUS VN_MINUS 1.0
    E60 NET0242 0 VALUE={V(Vref) - V(alpha_desat_time)*V(Vccp,Vccn) } 
    E62 NET0254 0 VALUE={V(Vref) + V(alpha_desat_time)*V(Vccp,Vccn) }
    EZOUT_VCC_COEFF VZOUT_VCC_COEFF 0 VALUE={1}
    EZOUT_IOUT_COEFF NET310 0 VALUE={IF( I(VreadIo)>=0 , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__source)) ) , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__sink)) ) )}
    EZOUT VB_3 NET0220
+VALUE={V(VZout)*V(VZout_Iout_coeff)*V(VZout_Vcc_coeff)}
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VALUE={V(Vout_diff)*(
+0.839716652136 + 0.006559260873777*V(Vccp,Vccn) +
+(-5.852626820368745E-5)*V(Vccp,Vccn)*V(Vccp,Vccn) )}
    E_ICCSAT_HIGH ICC_OUT_HIGH 0 POLY(1) VCCP VCCN 4.235513875784879E-4
+-3.5212826941669324E-7 7.086794584448001E-8 -6.422301618447638E-9
+1.7201507762271853E-10
    E_RO1_VOL RO1_VOL 0 POLY(1) VCCP VCCN 140.90155604866845
+-6.219465969756957 0.12417904849077162 -6.700057020016115E-4
    E_ICCSAT_LOW ICC_OUT_LOW 0 VALUE={0}
    E_READIO V_IO_VAL 0 VALUE={I(VreadIo)}
    E58 VB_2_VREF 0 VB_2 VREF 1.0
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E_RO1_VOH RO1_VOH 0 POLY(1) VCCP VCCN 91.83396244138251
+-3.9327188382931326 0.10964069439536264 -0.0010451663701980384
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    E66 VOH_NORL 0 VALUE={2m}
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={IF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ ( 121.88448125544897 +
+6.5406131938389995*V(Vccp,Vccn) -0.006054441538312483*PWR(V(Vccp,Vccn),2)
+) -5000*I(VreadIo)}
    EVLIM_LOW_VOUT NET256 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo) +
+V(VOL_noRL) }
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_source_filtered))}
    EVLIM_HIGH_VOUT NET261 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo) -
+V(VOH_noRL)}
    E64 ALPHA_DESAT_TIME 0 POLY(1) VCCP VCCN 0.21538652016522972
+-0.028012809487090496 0.001499177379172458 -3.565575247107336E-5
+3.147956177143193E-7
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={IF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E_R1 NET386 VREF VALUE={I(VreadI_R1)*( R1_sink
++(R1_source-R1_sink)*1/(1+exp(-alpha_switch*(V(v_Io_val)-Io_val_switch) )
+)) }
    E2_REF NET450 0 VCCN 0 1.0
    E_VREF VREF 0 NET444 0 1.0
    E_VOL_NORL VOL_NORL 0 VALUE={6.5m}
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_sink_filtered))}
    E1_REF NET410 0 VCCP 0 1.0
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ ( -74.94681778552744
+-9.325353579385839*V(Vccp,Vccn) + 0.08577125512609388*PWR(V(Vccp,Vccn),2)
+) -5000*I(VreadIo)}
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    RN2 VN_MINUS 0 R_NOISE {RN}
    RN1 VN_PLUS 0 R_NOISE {RN}
    RZOUT_IOUT_COEFF VZOUT_IOUT_COEFF NET310 R_NO_NOISE 50 
    RIN_CM_VP VREF VP R_NO_NOISE {RIN_CM_VP} 
    RIN_DIFF VP VM R_NO_NOISE {RIN_DIFF} 
    ROUT NET427 VZOUT R_NO_NOISE {ROUT} 
    R_ICCSAT_LOW ICC_OUT_LOW 0 R_NO_NOISE 1K 
    RO2_2 VB_3 VB_2 R_NO_NOISE {RO2_2} 
    RPROT_IN_P_VCCP NET246 VCCP R_NO_NOISE 100 
    RPROT_IN_M_VCCP VCCP NET434 R_NO_NOISE 100 
    RO2_1 VB_2 VREF R_NO_NOISE {RO2_1} 
    RD1 VCCP_ENHANCED VO_DIFF_PLUS R_NO_NOISE {RD} 
    RD2 VCCP_ENHANCED VO_DIFF_MINUS R_NO_NOISE {RD} 
    RIN_CM_VM VREF VM R_NO_NOISE {RIN_CM_VM} 
    R1_REF NET410 NET444 R_NO_NOISE 1Meg 
    R_ICCSAT_HIGH ICC_OUT_HIGH 0 R_NO_NOISE 1K 
    RPROT_IN_M_VCCN VCCN NET448 R_NO_NOISE 15K 
    R2_REF NET444 NET450 R_NO_NOISE 1Meg 
    RPROT_IN_P_VCCN NET263 VCCN R_NO_NOISE 15K 
    G_ICCSAT_OUTLOW VCCP VCCN VALUE={IF(I(V_OUTVLIM_LOW)>1u ,
+V(Icc_out_low) , 0)}
    G_I_VB VB_2 VREF VB_VREF 0 {GB}
    G_I_IO VB_2 VREF VALUE={V(VB_Vref)*GB*( 100*( 1 -
+exp(-abs(V(v_Io_val))/30m )) )  }
    G_IOUT_SOURCED VCCP 0 VALUE={IF(I(VreadIo)>0, I(VreadIo),0)}
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD}
    G_IIB_VM VREF VM VALUE={5n}
    G_ICC VCCP VCCN POLY(1) VCCP VCCN 8.026852659110722E-5
+6.646081565436386E-7 -8.637669927992474E-9
    G_ICCSAT_OUTHIGH VCCP VCCN VALUE={IF(I(V_OUTVLIM_HIGH)>1u ,
+V(Icc_out_high), 0)}
    G_IIB_VP VREF VP VALUE={5n}
    G_IOUT_SINKED VCCN 0 VALUE={IF(I(VreadIo)>0, 0, I(VreadIo))}


    
*******************************************************************************
*
* MODELS/SUBCKTS and PARAMS used by TSB611 subckt:
*
.PARAM VCC_MIN=1.5
.PARAM RINCM=1.7748E+10
.PARAM CINCM=7.6847E-13 
.PARAM RIN_CM_VM={2*RINCM}
.PARAM RIN_CM_VP={2*RINCM}
.PARAM CIN_CM_VM={CINCM/2}
.PARAM CIN_CM_VP={CINCM/2}
.PARAM RINDIFF=1.0350E+07 
.PARAM CINDIFF=9.2448E-13 
.PARAM RIN_DIFF={(2*RINCM*RINDIFF)/(2*RINCM - RINDIFF)}  
.PARAM CIN_DIFF={CINDIFF - CINCM/2}
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m 
.PARAM GB=4m  
.PARAM Ro = 3.0575E+06
.PARAM A0_source = 75.5e6
.PARAM A0_sink = 75.5e6
.PARAM alpha_switch = 1e6
.PARAM Io_val_switch = -7u
.PARAM Ccomp=55p 
.PARAM IEE=10u
.PARAM W=7.9u
.PARAM L=1u
.PARAM gm_mos=1.9895E-04
.PARAM Lout  = 5u
.PARAM Rout  = 1000    
.PARAM Cout  = 0.1n    
.PARAM Cout2 = 4p
.PARAM Zout_Iout_coeff_MIN= 1.0
.PARAM Iout_dc_tau__source = 0.1m 
.PARAM Iout_dc_tau__sink   = 0.1m 
.PARAM Ro2_2=1e-3 
.PARAM Ro2_1={ Ro - Ro2_2} 
.PARAM R1_sink={A0_sink/(gm_mos*GB*Ro2_1)}
.PARAM R1_source={A0_source/(gm_mos*GB*Ro2_1)}
.PARAM V_DPROT=150m
.PARAM Vd_compensazione=-788.4u
.PARAM RN=2.2e+04

.MODEL DN D AF=1 KF=3.5e-11
.MODEL R_NO_NOISE RES T_ABS=-273
.MODEL R_NOISE    RES T_ABS=+27
.MODEL MOS_N  NMOS LEVEL=1  VTO=+0.65  KP=500E-6  T_ABS=+27   
.MODEL DIODE_NOVd D LEVEL=1  IS=10E-15 N=0.001          
.MODEL DIODE_VLIM D LEVEL=1  IS=0.8E-15               
.MODEL DIODE_ILIM D LEVEL=1  IS=0.8E-15       
*
*******************************************************************************

.ENDS TSB611
*** End of subcircuit definition.
